/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.IRunner;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integration.di.ctx.DIContextParam;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integration.di.ctx.DIIntegrateContext;
import kd.fi.bcm.business.integration.di.service.AbstractDIIntegrateService;
import kd.fi.bcm.business.integration.di.service.DIIntegrationNewServiceHelper;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.CustOperationContexts;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.integration.CheckStatusEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.enums.integration.ExecuteOperationEnum;
import kd.fi.bcm.common.enums.integration.di.DIOperationEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.mq.MQCommonPublisher;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;

public class DIIntegrateDispatcher2 {
    private static final String SCHEDULELOGID = "scheduleLogId";
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(DIIntegrateDispatcher2.class);

    private static void execute(DIIIntegrateContext ctx, CountDownLatch downLatch) {
        IRunner runner = () -> {
            try {
                CustOperationContexts.setCustFormIdForIntegrate();
                DIIntegrationNewServiceHelper.execute(ctx);
            }
            finally {
                if (downLatch != null) {
                    downLatch.countDown();
                }
            }
        };
        ThreadPoolService.runInIntegrateThread(runner);
    }

    public static boolean submitTask2(IntegrateEntity intEntity, boolean isSync) {
        HashMap<String, DynamicObject> logSchemeMapping;
        CountDownLatch downLatch;
        HashMap schemeServicesMapping;
        Map<Long, DynamicObject> schemes;
        String serviceParam;
        Set<Long> orgSet;
        Pair<Long, String> currency;
        Pair<Long, String> period;
        Pair<Long, String> year;
        Pair<Long, String> scene;
        Pair<Long, String> model;
        block22: {
            DIIntegrateDispatcher2.handleOrgWritePermission(intEntity);
            DIIntegrateDispatcher2.handlePeriodManager(intEntity);
            DIIntegrateDispatcher2.handleMergeECFlowstatusOfOrgs(intEntity);
            DIIntegrateDispatcher2.handleEntVersion(intEntity);
            if (intEntity.getOrgSchemePairs().size() == 0) {
                return true;
            }
            model = intEntity.getModel();
            scene = intEntity.getScene();
            year = intEntity.getYear();
            period = intEntity.getPeriod();
            currency = intEntity.getCurrency();
            orgSet = intEntity.getOrgs();
            Set<Long> schemeSet = intEntity.getSchemes();
            serviceParam = (String)intEntity.getCustomParam(DIContextParam.SERVICE_PARAM);
            DynamicObject[] schemeArray = BusinessDataServiceHelper.load((Object[])schemeSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_isscheme"));
            schemes = Stream.of(schemeArray).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            schemeServicesMapping = new HashMap();
            schemes.values().forEach(scheme -> {
                List<Class<? extends AbstractDIIntegrateService>> integrateService = DIIntegrateDispatcher2.getDIIntegrateService(scheme);
                schemeServicesMapping.put(scheme.getLong("id"), integrateService);
            });
            downLatch = null;
            if (isSync) {
                int sizeCount = orgSet.size() == 1 ? schemeServicesMapping.values().stream().map(List::size).reduce(Integer::sum).orElse(0) : orgSet.size() * ((List)schemeServicesMapping.values().iterator().next()).size();
                downLatch = new CountDownLatch(sizeCount);
            }
            logSchemeMapping = new HashMap<String, DynamicObject>();
            DLock lock = DLock.create((String)("DIIntegrateDispatcher2." + (String)model.p2 + (String)scene.p2 + (String)year.p2 + (String)period.p2 + (String)currency.p2));
            try {
                if (lock.tryLock(1000L)) {
                    DynamicObject[] existLogs = DIIntegrateDispatcher2.getExecuteLogs(intEntity, true);
                    Stream.of(existLogs).forEach(v -> logSchemeMapping.put(v.getString("org.number") + v.getString("scheme.number"), (DynamicObject)v));
                    ArrayList<DynamicObject> saveObj = new ArrayList<DynamicObject>();
                    for (Pair<Pair<Long, String>, Pair<Long, String>> pair : intEntity.getOrgSchemePairs()) {
                        Pair schemePair = (Pair)pair.p2;
                        Pair org = (Pair)pair.p1;
                        String schemeKey = (String)org.p2 + (String)schemePair.p2;
                        DynamicObject dynamicObject = (DynamicObject)logSchemeMapping.get(schemeKey);
                        if (dynamicObject != null) continue;
                        DIIntegrateDispatcher2.setLogSchemeMapping((Long)model.p1, (Long)schemePair.p1, (Long)org.p1, (Long)scene.p1, (Long)year.p1, (Long)period.p1, (Long)currency.p1, saveObj, logSchemeMapping, schemeKey, (DIOperationEnum)intEntity.getCustomParam("operation"));
                    }
                    if (saveObj.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])saveObj.toArray(new DynamicObject[0]));
                    }
                    break block22;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6709\u5176\u5b83\u7528\u6237\u6b63\u5728\u96c6\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IntegrationNewServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                log.error("update executeLog fail:", e);
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6709\u5176\u5b83\u7528\u6237\u6b63\u5728\u96c6\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IntegrationNewServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        ConcurrentHashMap<String, Integer> schemeServices = new ConcurrentHashMap<String, Integer>(3);
        ConcurrentHashMap<String, Integer> schemeServicesFail = new ConcurrentHashMap<String, Integer>(3);
        ConcurrentHashMap<String, String> schemeServicesFailMsg = new ConcurrentHashMap<String, String>(3);
        ConcurrentHashMap insertCount = new ConcurrentHashMap(3);
        ConcurrentHashMap schemeServicesLockDim = new ConcurrentHashMap(16);
        Map<Long, Pair<Long, String>> currencys = DimensionServiceHelper.getCurrencyDynaByOrgIds((Long)model.p1, orgSet.toArray(new Long[0]));
        for (Pair pair : intEntity.getOrgSchemePairs()) {
            String serviceSchemeKeyLockDim;
            Map lockMap;
            String serviceSchemeKeyFailMsg;
            String serviceNumbFailMsg;
            String serviceSchemeKeyFail;
            Integer serviceNumbFail;
            DynamicObject scheme2 = schemes.get(((Pair)pair.p2).p1);
            Pair schemePair = (Pair)pair.p2;
            Pair org = (Pair)pair.p1;
            List services = (List)schemeServicesMapping.get(scheme2.getLong("id"));
            String schemeKey = (String)org.p2 + (String)schemePair.p2;
            DynamicObject logDyn = (DynamicObject)logSchemeMapping.get(schemeKey);
            String serviceSchemeKey = schemeKey + (String)currency.p2;
            Integer serviceNumb = (Integer)schemeServices.get(serviceSchemeKey);
            if (serviceNumb == null) {
                schemeServices.put(serviceSchemeKey, services.size());
            }
            if ((serviceNumbFail = (Integer)schemeServicesFail.get(serviceSchemeKeyFail = serviceSchemeKey + "fail")) == null) {
                schemeServicesFail.put(serviceSchemeKeyFail, 0);
            }
            if ((serviceNumbFailMsg = (String)schemeServicesFailMsg.get(serviceSchemeKeyFailMsg = serviceSchemeKeyFail + "Msg")) == null) {
                schemeServicesFailMsg.put(serviceSchemeKeyFailMsg, "");
            }
            if ((lockMap = (Map)schemeServicesLockDim.get(serviceSchemeKeyLockDim = serviceSchemeKey + "lockDim")) == null) {
                schemeServicesLockDim.put(serviceSchemeKeyLockDim, new ConcurrentHashMap(16));
            }
            for (Class as : services) {
                try {
                    DIIntegrateContext context = new DIIntegrateContext(model, (Pair<Long, String>)schemePair, currency, scene, year, period, (Pair<Long, String>)org, as);
                    context.putCustomParam("issrc", scheme2.getString("issrc.number"));
                    context.putCustomParam("orgCurrency", currencys.get(org.p1));
                    context.putCustomParam("log", logDyn.getLong("id"));
                    context.putCustomParam("servicenum", schemeServices);
                    context.putCustomParam("servicefailnum", schemeServicesFail);
                    context.putCustomParam("servicefailMsg", schemeServicesFailMsg);
                    context.putCustomParam("servicetotalnum", services.size());
                    context.putCustomParam("insertCount", insertCount);
                    context.putCustomParam("schemeServicesLockDim", schemeServicesLockDim);
                    context.putCustomParam(DIContextParam.SERVICE_PARAM, serviceParam);
                    context.putCustomParam("singlemetric", scheme2.getString("singlemetric"));
                    context.putCustomParam("textfield", scheme2.getString("textfield"));
                    context.putCustomParam("operation", intEntity.getCustomParam("operation"));
                    context.putCustomParam(DIContextParam.FIRST_TYPE, intEntity.getCustomParam(DIContextParam.FIRST_TYPE));
                    context.putCustomParam("executeId", logDyn.getLong("id"));
                    DIIntegrateDispatcher2.execute(context, downLatch);
                }
                catch (Exception e) {
                    throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)50));
                }
            }
        }
        if (isSync) {
            try {
                return downLatch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
        }
        return true;
    }

    private static void setLogSchemeMapping(Long modelId, Long schemeId, Long orgId, Long sceneId, Long yearId, Long periodId, Long currencyId, List<DynamicObject> saveObj, Map<String, DynamicObject> logSchemeMapping, String schemeKey, DIOperationEnum operation) {
        DynamicObject dynaObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemeexecuterec");
        dynaObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dynaObj.set("model", (Object)modelId);
        dynaObj.set("scheme", (Object)schemeId);
        dynaObj.set("org", (Object)orgId);
        dynaObj.set("scenario", (Object)sceneId);
        dynaObj.set("checkstatus", (Object)CheckStatusEnum.READY.getValue());
        dynaObj.set("step", (Object)DIIntegrateDispatcher2.getExecuteOperation(operation));
        dynaObj.set("collectstatus", (Object)CollectStatusEnum.LINEUP.getValue());
        dynaObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynaObj.set("optime", (Object)new Date());
        dynaObj.set("endtime", null);
        dynaObj.set("fy", (Object)yearId);
        dynaObj.set("period", (Object)periodId);
        dynaObj.set("currency", (Object)currencyId);
        dynaObj.set("paramjson", (Object)" ");
        saveObj.add(dynaObj);
        logSchemeMapping.put(schemeKey, dynaObj);
    }

    private static String getExecuteOperation(DIOperationEnum operation) {
        String executeOperation = ExecuteOperationEnum.ACTION_COLLECT.getValue();
        if (operation == null) {
            return executeOperation;
        }
        if (operation == DIOperationEnum.OpConvert) {
            executeOperation = ExecuteOperationEnum.TRANSFORMATION.getValue();
        } else if (operation == DIOperationEnum.OpExport) {
            executeOperation = ExecuteOperationEnum.EXPORT.getValue();
        } else if (operation == DIOperationEnum.OpImport) {
            executeOperation = ExecuteOperationEnum.IMPORT.getValue();
        }
        return executeOperation;
    }

    public static boolean submitTaskDistribute(IntegrateEntity intEntity, boolean isSync) {
        HashMap<String, DynamicObject> logSchemeMapping;
        block12: {
            if (isSync) {
                return DIIntegrateDispatcher2.submitTask2(intEntity, isSync);
            }
            DIIntegrateDispatcher2.handleOrgWritePermission(intEntity);
            DIIntegrateDispatcher2.handlePeriodManager(intEntity);
            DIIntegrateDispatcher2.handleMergeECFlowstatusOfOrgs(intEntity);
            DIIntegrateDispatcher2.handleEntVersion(intEntity);
            if (intEntity.getOrgSchemePairs().size() == 0) {
                return true;
            }
            Pair<Long, String> model = intEntity.getModel();
            Pair<Long, String> scene = intEntity.getScene();
            Pair<Long, String> year = intEntity.getYear();
            Pair<Long, String> period = intEntity.getPeriod();
            Pair<Long, String> currency = intEntity.getCurrency();
            logSchemeMapping = new HashMap<String, DynamicObject>();
            DLock lock = DLock.create((String)("DIIntegrateDispatcher2." + (String)model.p2 + (String)scene.p2 + (String)year.p2 + (String)period.p2 + (String)currency.p2));
            try {
                if (lock.tryLock(1000L)) {
                    DynamicObject[] existLogs = DIIntegrateDispatcher2.getExecuteLogs(intEntity, true);
                    Stream.of(existLogs).forEach(v -> logSchemeMapping.put(v.getString("org.number") + v.getString("scheme.number"), (DynamicObject)v));
                    ArrayList<DynamicObject> saveObj = new ArrayList<DynamicObject>();
                    for (Pair<Pair<Long, String>, Pair<Long, String>> pair : intEntity.getOrgSchemePairs()) {
                        Pair schemePair = (Pair)pair.p2;
                        Pair org = (Pair)pair.p1;
                        String schemeKey = (String)org.p2 + (String)schemePair.p2;
                        DynamicObject logDyn = (DynamicObject)logSchemeMapping.get(schemeKey);
                        if (logDyn != null) continue;
                        DIIntegrateDispatcher2.setLogSchemeMapping((Long)model.p1, (Long)schemePair.p1, (Long)org.p1, (Long)scene.p1, (Long)year.p1, (Long)period.p1, (Long)currency.p1, saveObj, logSchemeMapping, schemeKey, (DIOperationEnum)intEntity.getCustomParam("operation"));
                    }
                    if (saveObj.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])saveObj.toArray(new DynamicObject[0]));
                    }
                    break block12;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6709\u5176\u5b83\u7528\u6237\u6b63\u5728\u96c6\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IntegrationNewServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            catch (Throwable e) {
                log.error("update executeLog fail:", e);
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6709\u5176\u5b83\u7528\u6237\u6b63\u5728\u96c6\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IntegrationNewServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        Long scheduleLogId = (Long)intEntity.getCustomParam(SCHEDULELOGID);
        if (scheduleLogId != null) {
            DIIntegrateDispatcher2.createScheduleStatusLog(scheduleLogId, logSchemeMapping);
        }
        Map<Long, List<Pair>> pairMap = intEntity.getOrgSchemePairs().stream().collect(Collectors.groupingBy(l -> (Long)((Pair)l.p1).p1));
        pairMap.values().forEach(pairlist -> {
            intEntity.setOrgSchemePairs((List<Pair<Pair<Long, String>, Pair<Long, String>>>)pairlist);
            MQCommonPublisher.publishDIDataIntegration((String)ObjectSerialUtil.toByteSerialized((Object)intEntity), (boolean)ConfigServiceHelper.getGlobalBoolParam("isUseSpecialService"));
        });
        return true;
    }

    private static void createScheduleStatusLog(Long scheduleLogId, Map<String, DynamicObject> logSchemeMapping) {
        ArrayList logs = new ArrayList(logSchemeMapping.size());
        logSchemeMapping.values().forEach(schemeLog -> {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"bcm_schedule_statuslog");
            long schemeLogId = schemeLog.getLong("id");
            log.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            log.set("integrateexeclog", (Object)schemeLogId);
            log.set("schedulelog", (Object)scheduleLogId);
            log.set("status", (Object)CollectStatusEnum.LINEUP.getValue());
            logs.add(log);
        });
        if (!logs.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])logs.toArray(new DynamicObject[0]));
        }
    }

    private static void handleEntVersion(IntegrateEntity intEntity) {
        List<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairs = intEntity.getOrgSchemePairs();
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>();
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>();
        orgSchemePairs.forEach(p -> {
            boolean isEnver = MergeControlHelper.isQuoteLocked((Long)intEntity.getModel().p1, (Long)intEntity.getScene().p1, (Long)intEntity.getYear().p1, (Long)intEntity.getPeriod().p1, (Long)((Pair)p.p1).p1);
            if (isEnver) {
                orgSchemePairsNotNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
            } else {
                orgSchemePairsNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
            }
        });
        intEntity.setOrgSchemePairs(orgSchemePairsNeed);
        DIIntegrateDispatcher2.writeNotNeedExecuteData(intEntity, orgSchemePairsNotNeed, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u7248\u672c\u5316\uff0c\u4e0d\u80fd\u6267\u884c\u91c7\u96c6\u3002", (String)"IntegrateDispatcher2_6", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    public static boolean submitTaskConsume(IntegrateEntity intEntity) {
        Pair<Long, String> model = intEntity.getModel();
        Pair<Long, String> scene = intEntity.getScene();
        Pair<Long, String> year = intEntity.getYear();
        Pair<Long, String> period = intEntity.getPeriod();
        Pair<Long, String> currency = intEntity.getCurrency();
        Set<Long> orgSet = intEntity.getOrgs();
        Set<Long> schemeSet = intEntity.getSchemes();
        String serviceParam = (String)intEntity.getCustomParam(DIContextParam.SERVICE_PARAM);
        DynamicObject[] schemeArray = BusinessDataServiceHelper.load((Object[])schemeSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_isscheme"));
        Map<Long, DynamicObject> schemes = Stream.of(schemeArray).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        HashMap schemeServicesMapping = new HashMap();
        schemes.values().forEach(scheme -> {
            List<Class<? extends AbstractDIIntegrateService>> integrateService = DIIntegrateDispatcher2.getDIIntegrateService(scheme);
            schemeServicesMapping.put(scheme.getLong("id"), integrateService);
        });
        DynamicObject[] existLogs = DIIntegrateDispatcher2.getExecuteLogs(intEntity, false);
        HashMap logSchemeMapping = new HashMap();
        Stream.of(existLogs).forEach(v -> logSchemeMapping.put(v.getString("org.number") + v.getString("scheme.number"), v));
        Long scheduleLogId = (Long)intEntity.getCustomParam(SCHEDULELOGID);
        Map<Long, Long> scheduleStatusLogMap = DIIntegrateDispatcher2.queryScheduleStatusLog(scheduleLogId);
        ConcurrentHashMap<String, Integer> schemeServices = new ConcurrentHashMap<String, Integer>(3);
        ConcurrentHashMap<String, Integer> schemeServicesFail = new ConcurrentHashMap<String, Integer>(3);
        ConcurrentHashMap<String, String> schemeServicesFailMsg = new ConcurrentHashMap<String, String>(3);
        ConcurrentHashMap insertCount = new ConcurrentHashMap(3);
        ConcurrentHashMap schemeServicesLockDim = new ConcurrentHashMap(16);
        Map<Long, Pair<Long, String>> currencys = DimensionServiceHelper.getCurrencyDynaByOrgIds((Long)model.p1, orgSet.toArray(new Long[0]));
        for (Pair<Pair<Long, String>, Pair<Long, String>> pair : intEntity.getOrgSchemePairs()) {
            String serviceSchemeKeyLockDim;
            Map lockMap;
            String serviceSchemeKeyFailMsg;
            String serviceNumbFailMsg;
            String serviceSchemeKeyFail;
            Integer serviceNumbFail;
            DynamicObject scheme2 = schemes.get(((Pair)pair.p2).p1);
            Pair schemePair = (Pair)pair.p2;
            Pair org = (Pair)pair.p1;
            List services = (List)schemeServicesMapping.get(scheme2.getLong("id"));
            String schemeKey = (String)org.p2 + (String)schemePair.p2;
            DynamicObject logDyn = (DynamicObject)logSchemeMapping.get(schemeKey);
            String serviceSchemeKey = schemeKey + (String)currency.p2;
            Integer serviceNumb = (Integer)schemeServices.get(serviceSchemeKey);
            if (serviceNumb == null) {
                schemeServices.put(serviceSchemeKey, services.size());
            }
            if ((serviceNumbFail = (Integer)schemeServicesFail.get(serviceSchemeKeyFail = serviceSchemeKey + "fail")) == null) {
                schemeServicesFail.put(serviceSchemeKeyFail, 0);
            }
            if ((serviceNumbFailMsg = (String)schemeServicesFailMsg.get(serviceSchemeKeyFailMsg = serviceSchemeKeyFail + "Msg")) == null) {
                schemeServicesFailMsg.put(serviceSchemeKeyFailMsg, "");
            }
            if ((lockMap = (Map)schemeServicesLockDim.get(serviceSchemeKeyLockDim = serviceSchemeKey + "lockDim")) == null) {
                schemeServicesLockDim.put(serviceSchemeKeyLockDim, new ConcurrentHashMap(16));
            }
            for (Class as : services) {
                try {
                    DIIntegrateContext context = new DIIntegrateContext(model, (Pair<Long, String>)schemePair, currency, scene, year, period, (Pair<Long, String>)org, as);
                    context.putCustomParam("issrc", scheme2.getString("issrc.number"));
                    context.putCustomParam("orgCurrency", currencys.get(org.p1));
                    context.putCustomParam("log", logDyn.getLong("id"));
                    context.putCustomParam("servicenum", schemeServices);
                    context.putCustomParam("servicefailnum", schemeServicesFail);
                    context.putCustomParam("servicefailMsg", schemeServicesFailMsg);
                    context.putCustomParam("servicetotalnum", services.size());
                    context.putCustomParam("insertCount", insertCount);
                    context.putCustomParam("schemeServicesLockDim", schemeServicesLockDim);
                    context.putCustomParam(DIContextParam.SERVICE_PARAM, serviceParam);
                    context.putCustomParam("singlemetric", scheme2.getString("singlemetric"));
                    context.putCustomParam("textfield", scheme2.getString("textfield"));
                    context.putCustomParam("operation", intEntity.getCustomParam("operation"));
                    context.putCustomParam(DIContextParam.FIRST_TYPE, intEntity.getCustomParam(DIContextParam.FIRST_TYPE));
                    context.putCustomParam("executeId", logDyn.getLong("id"));
                    context.putCustomParam("consumer", null);
                    if (intEntity.getCustomParam(SCHEDULELOGID) != null) {
                        context.putCustomParam(SCHEDULELOGID, intEntity.getCustomParam(SCHEDULELOGID));
                    }
                    if (scheduleStatusLogMap.get(logDyn.getLong("id")) != null) {
                        context.putCustomParam("scheduleLog", scheduleStatusLogMap.get(logDyn.getLong("id")));
                    }
                    DIIntegrateDispatcher2.execute(context, null);
                }
                catch (Exception e) {
                    throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)50));
                }
            }
        }
        return true;
    }

    private static Map<Long, Long> queryScheduleStatusLog(Long scheduleLogId) {
        HashMap<Long, Long> scheduleLogMap = new HashMap<Long, Long>(16);
        if (scheduleLogId != null && 0L != scheduleLogId) {
            DynamicObject[] logs;
            QFBuilder builder = new QFBuilder("schedulelog", "=", (Object)scheduleLogId);
            for (DynamicObject log : logs = BusinessDataServiceHelper.load((String)"bcm_schedule_statuslog", (String)"id,integrateexeclog,status", (QFilter[])builder.toArray())) {
                scheduleLogMap.put(log.getLong("integrateexeclog.id"), log.getLong("id"));
            }
        }
        return scheduleLogMap;
    }

    private static void handleOrgWritePermission(IntegrateEntity intEntity) {
        Set<Long> modelIds = MemberPermHelper.getLimitedModelListByUser();
        if (modelIds.contains(intEntity.getModel().p1)) {
            return;
        }
        List<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairs = intEntity.getOrgSchemePairs();
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
        Long orgDimId = DimensionServiceHelper.getIdByNum("bcm_dimension", (Long)intEntity.getModel().p1, DimEntityNumEnum.ENTITY.getNumber());
        Set<Long> orgIds = orgSchemePairs.stream().map(p -> (Long)((Pair)p.p1).p1).collect(Collectors.toSet());
        Set<Long> writePermissionIds = PermissionServiceImpl.getInstance((Long)intEntity.getModel().p1).matchWritePermMembers(orgDimId, "bcm_entitymembertree", orgIds);
        orgSchemePairs.forEach(p -> {
            if (writePermissionIds.contains(((Pair)p.p1).p1)) {
                orgSchemePairsNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
            } else {
                orgSchemePairsNotNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
            }
        });
        intEntity.setOrgSchemePairs(orgSchemePairsNeed);
        DIIntegrateDispatcher2.writeNotNeedExecuteData(intEntity, orgSchemePairsNotNeed, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u6b64\u7ec4\u7ec7\u6570\u636e\u5199\u5165\u6743\u9650\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"IntegrateDispatcher2_0", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    private static void handlePeriodManager(IntegrateEntity intEntity) {
        boolean periodManage = ConfigServiceHelper.getBoolParam((Long)intEntity.getModel().p1, "CM012");
        if (periodManage) {
            List<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairs = intEntity.getOrgSchemePairs();
            ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
            ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>(10);
            Set<String> orgnumberset = orgSchemePairs.stream().map(x -> (String)((Pair)x.p1).p2).collect(Collectors.toSet());
            Set<String> periodOpenOrgSet = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)intEntity.getModel().p1, orgnumberset, (Long)intEntity.getScene().p1, (Long)intEntity.getYear().p1, (Long)intEntity.getPeriod().p1, "datastatus");
            orgSchemePairs.forEach(p -> {
                if (periodOpenOrgSet.contains(((Pair)p.p1).p2)) {
                    orgSchemePairsNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
                } else {
                    orgSchemePairsNotNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
                }
            });
            intEntity.setOrgSchemePairs(orgSchemePairsNeed);
            DIIntegrateDispatcher2.writeNotNeedExecuteData(intEntity, orgSchemePairsNotNeed, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u672a\u5f00\u542f\u6216\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"IntegrateDispatcher2_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private static void handleMergeECFlowstatusOfOrgs(IntegrateEntity intEntity) {
        Set<Long> orgSet = IntegrationUtil.getMergeECFlowstatusOfOrgs((Long)intEntity.getModel().p1, (Long)intEntity.getScene().p1, (Long)intEntity.getYear().p1, (Long)intEntity.getPeriod().p1, intEntity.getOrgs().toArray(new Long[0]));
        List<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairs = intEntity.getOrgSchemePairs();
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>();
        ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed = new ArrayList<Pair<Pair<Long, String>, Pair<Long, String>>>();
        String selectCurrency = (String)intEntity.getCurrency().p2;
        if ("EC".equals(selectCurrency) || "DC".equals(selectCurrency)) {
            orgSchemePairs.forEach(p -> {
                if (orgSet.contains(((Pair)p.p1).p1)) {
                    orgSchemePairsNotNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
                } else {
                    orgSchemePairsNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
                }
            });
        } else if (StringUtils.isNotEmpty((CharSequence)selectCurrency)) {
            Map<Long, Pair<Long, String>> org2EC = DimensionServiceHelper.getCurrencyDynaByOrgIds((Long)intEntity.getModel().p1, intEntity.getOrgs().toArray(new Long[0]));
            orgSchemePairs.forEach(p -> {
                if (orgSet.contains(((Pair)p.p1).p1) && selectCurrency.equals(((Pair)org2EC.get((Object)((Pair)p.p1).p1)).p2)) {
                    orgSchemePairsNotNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
                } else {
                    orgSchemePairsNeed.add(Pair.onePair((Object)Pair.onePair((Object)((Pair)p.p1).p1, (Object)((Pair)p.p1).p2), (Object)Pair.onePair((Object)((Pair)p.p2).p1, (Object)((Pair)p.p2).p2)));
                }
            });
        } else {
            orgSchemePairsNeed.addAll(orgSchemePairs);
        }
        intEntity.setOrgSchemePairs(orgSchemePairsNeed);
        DIIntegrateDispatcher2.writeNotNeedExecuteData(intEntity, orgSchemePairsNotNeed, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u62a5\u8868\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u5df2\u63d0\u4ea4\u6216\u5df2\u5f52\u6863\uff0c\u4e0d\u80fd\u6267\u884c\u91c7\u96c6\u3002", (String)"IntegrateDispatcher2_2", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    private static void writeNotNeedExecuteData(IntegrateEntity intEntity, List<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairsNotNeed, String errorMsg) {
        if (orgSchemePairsNotNeed.size() > 0) {
            Set orgs = orgSchemePairsNotNeed.stream().map(x -> (Long)((Pair)x.p1).p1).collect(Collectors.toSet());
            Set schemes = orgSchemePairsNotNeed.stream().map(x -> (Long)((Pair)x.p2).p1).collect(Collectors.toSet());
            QFBuilder filters = new QFBuilder();
            filters.add("model", "=", intEntity.getModel().p1);
            filters.add("scenario", "=", intEntity.getScene().p1);
            filters.add("fy", "=", intEntity.getYear().p1);
            filters.add("period", "=", intEntity.getPeriod().p1);
            filters.add("currency", "=", intEntity.getCurrency().p1);
            filters.add("scheme", "in", schemes);
            filters.add("org", "in", orgs);
            DynamicObject[] existRecs = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)"id, org, scheme, optime, collectstatus, modifydate, modifier, copyexe, paramjson, endtime", (QFilter[])filters.toArray());
            HashMap recSchemeMapping = new HashMap();
            Stream.of(existRecs).forEach(v -> recSchemeMapping.put(v.getString("org.number") + v.getString("scheme.number"), v));
            ArrayList<DynamicObject> newReclist = new ArrayList<DynamicObject>();
            for (Pair<Pair<Long, String>, Pair<Long, String>> pair : orgSchemePairsNotNeed) {
                Pair schemePair = (Pair)pair.p2;
                Pair org = (Pair)pair.p1;
                String schemeKey = (String)org.p2 + (String)schemePair.p2;
                DynamicObject recDyn = (DynamicObject)recSchemeMapping.get(schemeKey);
                if (recDyn == null) {
                    DynamicObject dynaObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemeexecuterec");
                    dynaObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                    dynaObj.set("model", intEntity.getModel().p1);
                    dynaObj.set("scheme", schemePair.p1);
                    dynaObj.set("org", org.p1);
                    dynaObj.set("scenario", intEntity.getScene().p1);
                    dynaObj.set("collectstatus", (Object)CollectStatusEnum.FAIL.getValue());
                    dynaObj.set("optime", (Object)DIIntegrateDispatcher2.getCurrentDate());
                    dynaObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    dynaObj.set("modifydate", (Object)DIIntegrateDispatcher2.getCurrentDate());
                    dynaObj.set("endtime", (Object)DIIntegrateDispatcher2.getCurrentDate());
                    dynaObj.set("fy", intEntity.getYear().p1);
                    dynaObj.set("period", intEntity.getPeriod().p1);
                    dynaObj.set("currency", intEntity.getCurrency().p1);
                    dynaObj.set("paramjson", (Object)" ");
                    recDyn = dynaObj;
                    newReclist.add(dynaObj);
                } else {
                    recDyn.set("optime", (Object)DIIntegrateDispatcher2.getCurrentDate());
                    recDyn.set("collectstatus", (Object)CollectStatusEnum.FAIL.getValue());
                    recDyn.set("modifydate", (Object)DIIntegrateDispatcher2.getCurrentDate());
                    recDyn.set("endtime", (Object)DIIntegrateDispatcher2.getCurrentDate());
                    recDyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
                }
                DIIntegrateDispatcher2.writeExecuteLogs(intEntity, recDyn, errorMsg);
            }
            SaveServiceHelper.save((DynamicObject[])newReclist.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])recSchemeMapping.values().toArray(new DynamicObject[0]));
        }
    }

    private static void writeExecuteLogs(IntegrateEntity intEntity, DynamicObject recDyn, String errorMsg) {
        DynamicObject dyObj = BusinessDataServiceHelper.newDynamicObject((String)"di_isschemecollectlog");
        dyObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dyObj.set("model", intEntity.getModel().p1);
        dyObj.set("fy", intEntity.getYear().p1);
        dyObj.set("scenario", intEntity.getScene().p1);
        dyObj.set("period", intEntity.getPeriod().p1);
        dyObj.set("currency", intEntity.getCurrency().p1);
        dyObj.set("org", (Object)(recDyn.getLong("org_id") == 0L ? recDyn.getLong("org") : recDyn.getLong("org_id")));
        dyObj.set("scheme", (Object)(recDyn.getLong("scheme_id") == 0L ? recDyn.getLong("scheme") : recDyn.getLong("scheme_id")));
        dyObj.set("error", (Object)errorMsg);
        dyObj.set("result", (Object)" ");
        dyObj.set("collector", (Object)RequestContext.get().getCurrUserId());
        dyObj.set("collectorstate", (Object)CollectStatusEnum.FAIL.getValue());
        dyObj.set("collecttime", (Object)TimeServiceHelper.now());
        dyObj.set("executerec", (Object)recDyn.getLong("id"));
        if (intEntity.getCustomParam("operation") != null && intEntity.getCustomParam("operation").toString() != null && (intEntity.getCustomParam("operation").toString().equals(DIOperationEnum.OpConvert.getNumber()) || intEntity.getCustomParam("operation").toString().equals(DIOperationEnum.OpExport.getNumber()) || intEntity.getCustomParam("operation").toString().equals(DIOperationEnum.OpExecuteAll.getNumber()))) {
            DIIntegrationNewServiceHelper.setDIParam(dyObj, intEntity.getCustomParam("operation").toString());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
    }

    private static Date getCurrentDate() {
        return Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
    }

    private static DynamicObject[] getExecuteLogs(IntegrateEntity intEntity, boolean updateStatus) {
        QFBuilder filters = new QFBuilder();
        filters.add("model", "=", intEntity.getModel().p1);
        filters.add("scenario", "=", intEntity.getScene().p1);
        filters.add("fy", "=", intEntity.getYear().p1);
        filters.add("period", "=", intEntity.getPeriod().p1);
        filters.add("currency", "=", intEntity.getCurrency().p1);
        filters.add("scheme", "in", intEntity.getSchemes());
        filters.add("org", "in", intEntity.getOrgs());
        DynamicObject[] existLogs = BusinessDataServiceHelper.load((String)"bcm_isschemeexecuterec", (String)"id, org, scheme, checkstatus, collectstatus,step, modifydate, modifier, copyexe, paramjson, endtime, optime,exeip", (QFilter[])filters.toArray());
        List<Pair<Pair<Long, String>, Pair<Long, String>>> orgSchemePairs = intEntity.getOrgSchemePairs();
        ArrayList<DynamicObject> needSave = new ArrayList<DynamicObject>(10);
        for (DynamicObject log : existLogs) {
            for (Pair<Pair<Long, String>, Pair<Long, String>> pair : orgSchemePairs) {
                if (log.getLong("org.id") != ((Long)((Pair)pair.p1).p1).longValue() || log.getLong("scheme.id") != ((Long)((Pair)pair.p2).p1).longValue()) continue;
                log.set("checkstatus", (Object)CheckStatusEnum.READY.getValue());
                log.set("collectstatus", (Object)CollectStatusEnum.LINEUP.getValue());
                log.set("step", (Object)DIIntegrateDispatcher2.getExecuteOperation((DIOperationEnum)intEntity.getCustomParam("operation")));
                log.set("optime", (Object)new Date());
                log.set("modifydate", null);
                log.set("endtime", null);
                log.set("modifier", (Object)RequestContext.get().getCurrUserId());
                needSave.add(log);
            }
        }
        DynamicObject[] needSaveLog = needSave.toArray(new DynamicObject[0]);
        if (updateStatus) {
            SaveServiceHelper.save((DynamicObject[])needSaveLog);
        }
        return needSaveLog;
    }

    private static List<Class<? extends AbstractDIIntegrateService>> getDIIntegrateService(DynamicObject schemeObj) {
        MappingContext context = new MappingContext(schemeObj);
        return context.getDIIntegrateService();
    }

    public static Pair<Integer, Map<Object, DynamicObject>> getMember(DynamicObject dimObj, List<Long> membIds) {
        QFilter[] qFilterArray;
        QFilter qf = new QFilter("id", "in", membIds);
        String memberform = dimObj.getString("memberform");
        Long dimId = dimObj.getLong("id");
        boolean isUserDefine = "bcm_userdefinedmembertree".equalsIgnoreCase(memberform);
        if (isUserDefine) {
            QFilter[] qFilterArray2 = new QFilter[2];
            qFilterArray2[0] = qf;
            qFilterArray = qFilterArray2;
            qFilterArray2[1] = new QFilter("dimension", "=", (Object)dimId);
        } else {
            qFilterArray = qf.toArray();
        }
        Map result = BusinessDataServiceHelper.loadFromCache((String)memberform, (String)"number,name", (QFilter[])qFilterArray);
        if (result.isEmpty()) {
            result = BusinessDataServiceHelper.loadFromCache((String)"bcm_definedpropertyvalue", (String)"number,name,parentid", (QFilter[])new QFilter[]{qf, new QFilter("dimension", "=", (Object)dimId)});
            return Pair.onePair((Object)2, (Object)result);
        }
        return Pair.onePair((Object)1, (Object)result);
    }
}

