/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.NetAddressUtils;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integration.di.service.AbstractDIIntegrateService;
import kd.fi.bcm.business.integration.di.service.DIDataHandleFactory;
import kd.fi.bcm.business.integrationnew.util.ISImportModeUtil;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.integration.CheckStatusEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.enums.integration.ExecuteOperationEnum;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.enums.integration.di.DIOperationEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ThrowableHelper;

public class DIIntegrationNewServiceHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(DIIntegrationNewServiceHelper.class);
    private static final int ctrlErrorLogOnlyOne = 666;
    private static final String STARTTIME = "startTime";
    private static final String ENDTIME = "endtime";

    public static Object execute(DIIIntegrateContext context) {
        log.startWatch();
        try {
            DIIntegrationNewServiceHelper.executeBefore(context);
            DIIntegrationNewServiceHelper.doExecute(context);
            DIIntegrationNewServiceHelper.executeAfter(context);
            log.warn("--execute--");
        }
        catch (Exception e) {
            String errorStr = e instanceof KDBizException ? e.getMessage() : ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30);
            log.error("--execute--\n" + e);
            DIIntegrationNewServiceHelper.writeErrorLog(context, errorStr);
        }
        return null;
    }

    private static void doExecute(DIIIntegrateContext context) {
        AbstractDIIntegrateService servive = null;
        try {
            servive = context.getServiceClass().getConstructor(DIIIntegrateContext.class).newInstance(context);
        }
        catch (Throwable e) {
            log.error("getServiceClass error", e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u670d\u52a1\uff1a%s\u3002", (String)"DIIntegrationNewServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), (String)context.getOrg().p2 + "--" + (String)context.getSchema().p2));
        }
        if (servive == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u670d\u52a1\uff1a%s\u3002", (String)"DIIntegrationNewServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), (String)context.getOrg().p2 + "--" + (String)context.getSchema().p2));
        }
        context.putCustomParam(STARTTIME, System.currentTimeMillis());
        servive.execute();
    }

    private static void executeAfter(DIIIntegrateContext ctx) {
        DIIntegrationNewServiceHelper.mutexLog(DIIntegrationNewServiceHelper::addSuccessLog, ctx);
    }

    private static DynamicObject addSuccessLog(DIIIntegrateContext ctx) {
        Long executeRecId = (Long)ctx.getCustomParam("log");
        DynamicObject schemeLog = DIIntegrationNewServiceHelper.getExecuteRec(executeRecId);
        int status = schemeLog.getInt("collectstatus");
        String serviceSchemeKey = (String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2;
        Map servicenums = (Map)ctx.getCustomParam("servicenum");
        int servicenum = (Integer)servicenums.get(serviceSchemeKey);
        if (CollectStatusEnum.FAIL.getValue() != status && servicenum > 0) {
            int count = ctx.getCustomParam("InsertOlapCount") == null ? 0 : (Integer)ctx.getCustomParam("InsertOlapCount");
            Map insertCount = (Map)ctx.getCustomParam("insertCount");
            Integer totalCount = insertCount.getOrDefault(serviceSchemeKey, 0);
            insertCount.put(serviceSchemeKey, totalCount + count);
        }
        DIIntegrationNewServiceHelper.addTraceId(serviceSchemeKey, ctx);
        servicenums.put(serviceSchemeKey, --servicenum);
        if (ctx.getCustomParam("reportList") != null && servicenum == 0) {
            DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"di_isschemecollectlog");
            DynamicObject dyObj = new DynamicObject(logObj.getDynamicObjectType());
            dyObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dyObj.set("model", ctx.getModel().p1);
            dyObj.set("fy", ctx.getFy().p1);
            dyObj.set("period", ctx.getPeriod().p1);
            dyObj.set("scenario", ctx.getScene().p1);
            dyObj.set("currency", ctx.getCurrency().p1);
            dyObj.set("org", ctx.getOrg().p1);
            dyObj.set("scheme", ctx.getSchema().p1);
            dyObj.set("error", (Object)String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u6620\u5c04\u6210\u5458\uff1a%s", (String)"DIIntegrationNewServiceHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), JSON.toJSONString(ctx.getCustomParam("reportList"))));
            dyObj.set("result", (Object)ResManager.loadKDString((String)"\u7a7a", (String)"DIIntegrationNewServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            dyObj.set("collector", (Object)RequestContext.get().getUserId());
            dyObj.set("collecttime", (Object)DIIntegrationNewServiceHelper.getCurrentDate());
            dyObj.set("executerec", (Object)schemeLog.getLong("id"));
            dyObj.set("importmode", (Object)ISImportModeUtil.getImportModeBySchemeDI((Long)ctx.getSchema().p1));
            logObj.set("impmodedimmem", (Object)ISImportModeUtil.getImportModeDimMem((Long)ctx.getSchema().p1));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
        }
        if (ctx.getCustomParam("reportList") == null && CollectStatusEnum.FAIL.getValue() != status && servicenum == 0) {
            schemeLog.set("checkstatus", (Object)CheckStatusEnum.SUCCESS.getValue());
            schemeLog.set("collectstatus", (Object)CollectStatusEnum.SUCCESS.getValue());
            schemeLog.set("modifydate", ctx.getCustomParam(STARTTIME));
            ctx.putCustomParam(ENDTIME, System.currentTimeMillis());
            schemeLog.set(ENDTIME, ctx.getCustomParam(ENDTIME));
            OperateOption op = OperateOption.create();
            op.setVariableValue("updateModifyDate", "false");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeLog}, (OperateOption)op);
            DIIntegrationNewServiceHelper.writeSuccessLog(ctx, schemeLog);
        }
        if (servicenum != 0) {
            Integer servicenumtotal = (Integer)ctx.getCustomParam("servicetotalnum");
            Map servicefailnum = (Map)ctx.getCustomParam("servicefailnum");
            String serviceSchemeKeyFail = serviceSchemeKey + "fail";
            Integer num = (Integer)servicefailnum.get(serviceSchemeKeyFail);
            if (servicenumtotal - num <= 1) {
                Map servicefailMsg = (Map)ctx.getCustomParam("servicefailMsg");
                String serviceSchemeKeyFailMsg = serviceSchemeKeyFail + "Msg";
                ctx.putCustomParam("InsertOlapCount", 0);
                DLock.forceUnlock((String[])new String[]{"fi.bcm.DIIntegrationNewServiceHelper." + (String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2 + "log"});
                DIIntegrationNewServiceHelper.writeErrorLog(ctx, (String)servicefailMsg.get(serviceSchemeKeyFailMsg));
            } else {
                num = num + 1;
                servicefailnum.put(serviceSchemeKeyFail, num);
            }
        }
        return schemeLog;
    }

    private static void addTraceId(String serviceSchemeKey, DIIIntegrateContext ctx) {
        String traceId = RequestContext.get().getTraceId();
        if (traceId == null) {
            return;
        }
        Map servicefailMsg = (Map)ctx.getCustomParam("servicefailMsg");
        String traceId2 = (String)servicefailMsg.get(serviceSchemeKey + "traceId");
        if (traceId2 == null) {
            servicefailMsg.put(serviceSchemeKey + "traceId", traceId);
        } else if (!traceId2.contains(traceId)) {
            servicefailMsg.put(serviceSchemeKey + "traceId", traceId2 + "," + traceId);
        }
    }

    private static void writeSuccessLog(DIIIntegrateContext ctx, DynamicObject schemeLog) {
        DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"di_isschemecollectlog");
        logObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        logObj.set("model", ctx.getModel().p1);
        logObj.set("fy", ctx.getFy().p1);
        logObj.set("period", ctx.getPeriod().p1);
        logObj.set("scenario", ctx.getScene().p1);
        logObj.set("currency", ctx.getCurrency().p1);
        logObj.set("org", ctx.getOrg().p1);
        logObj.set("scheme", ctx.getSchema().p1);
        String spendTimeMessage = ctx.getCustomParam("spendTimeMessage") == null ? "" : (String)ctx.getCustomParam("spendTimeMessage");
        String checkresult = ctx.getCustomParam("checkresult") == null ? "" : (String)ctx.getCustomParam("checkresult");
        Map insertCount = (Map)ctx.getCustomParam("insertCount");
        String serviceSchemeKey = (String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2;
        Integer totalCount = insertCount.getOrDefault(serviceSchemeKey, 0);
        String countStr = String.format(ResManager.loadKDString((String)"\u96c6\u6210\u6761\u6570\uff1a%s;", (String)"DIIntegrationNewServiceHelper_15", (String)"fi-bcm-business", (Object[])new Object[0]), totalCount);
        String msg = countStr.concat(spendTimeMessage).concat(checkresult);
        String traceMsg = DIIntegrationNewServiceHelper.getTraceIdMsg(serviceSchemeKey, ctx);
        String interfaceMsg = DIIntegrationNewServiceHelper.getInterfaceMsg(serviceSchemeKey, ctx);
        String clearDataScope = ctx.getCustomParam("clearDataScope") == null ? "" : (String)ctx.getCustomParam("clearDataScope");
        String lockDimMsg = DIIntegrationNewServiceHelper.getLockDimMsg(ctx);
        logObj.set("error", (Object)(msg + traceMsg + interfaceMsg + clearDataScope + lockDimMsg));
        logObj.set("result", (Object)ResManager.loadKDString((String)"\u91c7\u96c6\u6210\u529f", (String)"DIIntegrationNewServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]));
        logObj.set("collector", (Object)RequestContext.get().getUserId());
        logObj.set("collecttime", (Object)DIIntegrationNewServiceHelper.getCurrentDate());
        logObj.set("executerec", (Object)schemeLog.getLong("id"));
        logObj.set("collectorstate", (Object)CollectStatusEnum.SUCCESS.getValue());
        logObj.set("importmode", (Object)ISImportModeUtil.getImportModeBySchemeDI((Long)ctx.getSchema().p1));
        logObj.set("impmodedimmem", (Object)ISImportModeUtil.getImportModeDimMem((Long)ctx.getSchema().p1));
        Long spend = (Long)ctx.getCustomParam(ENDTIME) - (Long)ctx.getCustomParam(STARTTIME);
        StringBuilder sb = DIIntegrationNewServiceHelper.calculate(spend);
        StringBuilder spendString = new StringBuilder();
        log.info(spendString.append("cost and starttime endtime:").append(spend).append(",").append(schemeLog.getDate(ENDTIME).getTime()).append(",").append(schemeLog.getDate("modifydate").getTime()).append(",").append((CharSequence)sb).toString());
        logObj.set("spend", (Object)sb.toString());
        String operation = ctx.getCustomParam("operation").toString();
        DIIntegrationNewServiceHelper.setDIParam(logObj, operation);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
        DIIntegrationNewServiceHelper.updateScheduleLog(ctx, CollectStatusEnum.SUCCESS.getValue());
    }

    private static String getLockDimMsg(DIIIntegrateContext ctx) {
        String serviceSchemeKey;
        Map map;
        Map schemeServicesLockDim = (Map)ctx.getCustomParam("schemeServicesLockDim");
        if (schemeServicesLockDim != null && schemeServicesLockDim.size() > 0 && (map = (Map)schemeServicesLockDim.get(serviceSchemeKey = (String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2 + "lockDim")) != null && map.size() > 0) {
            Map<String, Map<String, List<String>>> msgMap = IntegrationUtil.getMsgMap(map);
            return String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6210\u5458\u56e0\u9501\u5b9a\u672a\u6210\u529f\u5165\u5e93:%1$s;", (String)"IntegrationNewServiceHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]), JSONObject.toJSONString(msgMap));
        }
        return "";
    }

    private static String getInterfaceMsg(String serviceSchemeKey, DIIIntegrateContext ctx) {
        Map servicefailMsg = (Map)ctx.getCustomParam("servicefailMsg");
        if (servicefailMsg == null) {
            return "";
        }
        String timeUserKey = serviceSchemeKey + "timeUser";
        return servicefailMsg.get(timeUserKey) == null ? "" : (String)servicefailMsg.get(timeUserKey);
    }

    public static void setDIParam(DynamicObject log, String operation) {
        if (operation != null && operation.equals(DIOperationEnum.OpConvert.getNumber())) {
            log.set("step", (Object)ExecuteOperationEnum.TRANSFORMATION.getValue());
        } else if (operation != null && operation.equals(DIOperationEnum.OpExport.getNumber())) {
            log.set("step", (Object)ExecuteOperationEnum.EXPORT.getValue());
        } else if (operation != null && operation.equals(DIOperationEnum.OpExecuteAll.getNumber())) {
            log.set("step", (Object)ExecuteOperationEnum.ACTION_COLLECT.getValue());
        }
    }

    public static StringBuilder calculate(Long spend) {
        long mi = spend % 1000L;
        long se = spend / 1000L % 60L;
        long min = spend / 1000L / 60L % 60L;
        long hour = spend / 1000L / 60L / 60L;
        StringBuilder sb = new StringBuilder();
        if (hour > 0L) {
            sb.append(hour).append(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"DIIntegrationNewServiceHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (min > 0L) {
            sb.append(min).append(ResManager.loadKDString((String)"\u5206\u949f", (String)"DIIntegrationNewServiceHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (se > 0L) {
            sb.append(se).append(ResManager.loadKDString((String)"\u79d2", (String)"DIIntegrationNewServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (mi > 0L) {
            sb.append(mi).append(ResManager.loadKDString((String)"\u6beb\u79d2", (String)"DIIntegrationNewServiceHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)sb.toString())) {
            sb.append(ResManager.loadKDString((String)"0\u79d2", (String)"DIIntegrationNewServiceHelper_14", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return sb;
    }

    private static void mutexLog(Consumer<DIIIntegrateContext> consumer, DIIIntegrateContext ctx) {
        block13: {
            try (DLock lock = DLock.create((String)("fi.bcm.DIIntegrationNewServiceHelper." + (String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2 + "log"));){
                if (lock.tryLock(10000L)) {
                    consumer.accept(ctx);
                    break block13;
                }
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u83b7\u53d6\u9501\u5931\u8d25", (String)"DIIntegrationNewServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
    }

    public static void writeErrorLog(DIIIntegrateContext context, String errorMsg) {
        Integer servicenumtotal = (Integer)context.getCustomParam("servicetotalnum");
        servicenumtotal = servicenumtotal == null ? Integer.valueOf(1) : servicenumtotal;
        int count = context.getCustomParam("InsertOlapCount") == null ? 0 : (Integer)context.getCustomParam("InsertOlapCount");
        DIIntegrationNewServiceHelper.markFail(context);
        String serviceSchemeKey = (String)context.getOrg().p2 + (String)context.getSchema().p2 + (String)context.getCurrency().p2;
        DIIntegrationNewServiceHelper.addTraceId(serviceSchemeKey, context);
        if (servicenumtotal > 1) {
            Map servicefailnum = (Map)context.getCustomParam("servicefailnum");
            String serviceSchemeKeyFail = serviceSchemeKey + "fail";
            Integer num = (Integer)servicefailnum.get(serviceSchemeKeyFail);
            Map insertCount = (Map)context.getCustomParam("insertCount");
            Integer totalCount = insertCount.getOrDefault(serviceSchemeKey, 0);
            if (servicenumtotal - num <= 1) {
                count = totalCount + count;
            } else {
                num = num + 1;
                servicefailnum.put(serviceSchemeKeyFail, num);
                insertCount.put(serviceSchemeKey, totalCount + count);
                Map servicefailMsg = (Map)context.getCustomParam("servicefailMsg");
                String serviceSchemeKeyFailMsg = serviceSchemeKeyFail + "Msg";
                servicefailMsg.put(serviceSchemeKeyFailMsg, errorMsg);
                return;
            }
        }
        Integer countFinal = count;
        DIIntegrationNewServiceHelper.mutexLog(ctx -> {
            String serviceSchemeKeyIn;
            Map servicenums = (Map)ctx.getCustomParam("servicenum");
            int servicenum = (Integer)servicenums.get(serviceSchemeKeyIn = (String)ctx.getOrg().p2 + (String)ctx.getSchema().p2 + (String)ctx.getCurrency().p2);
            if (servicenum == 666) {
                return;
            }
            servicenums.put(serviceSchemeKeyIn, 666);
            int failStatus = DIIntegrationNewServiceHelper.getFailStatus(ctx);
            Long schemeLogId = (Long)ctx.getCustomParam("log");
            DynamicObject schemeExecuteRec = DIIntegrationNewServiceHelper.getExecuteRec(schemeLogId);
            DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"di_isschemecollectlog");
            DynamicObject dyObj = new DynamicObject(logObj.getDynamicObjectType());
            dyObj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dyObj.set("model", ctx.getModel().p1);
            dyObj.set("fy", ctx.getFy().p1);
            dyObj.set("period", ctx.getPeriod().p1);
            dyObj.set("scenario", ctx.getScene().p1);
            Pair<Long, String> currency = ctx.getCurrency();
            dyObj.set("currency", currency.p1);
            dyObj.set("org", ctx.getOrg().p1);
            dyObj.set("scheme", ctx.getSchema().p1);
            String errorMsgTotal = String.format(ResManager.loadKDString((String)"\u96c6\u6210\u6761\u6570\uff1a%s;", (String)"DIIntegrationNewServiceHelper_15", (String)"fi-bcm-business", (Object[])new Object[0]), countFinal + ";");
            String traceMsg = DIIntegrationNewServiceHelper.getTraceIdMsg(serviceSchemeKeyIn, ctx);
            String interfaceMsg = DIIntegrationNewServiceHelper.getInterfaceMsg(serviceSchemeKey, ctx);
            String clearDataScope = ctx.getCustomParam("clearDataScope") == null ? "" : (String)ctx.getCustomParam("clearDataScope");
            String lockDimMsg = DIIntegrationNewServiceHelper.getLockDimMsg(ctx);
            dyObj.set("error", (Object)(errorMsgTotal + traceMsg + interfaceMsg + errorMsg + clearDataScope + lockDimMsg));
            dyObj.set("result", (Object)ResManager.loadKDString((String)"\u7a7a", (String)"DIIntegrationNewServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            dyObj.set("collector", (Object)RequestContext.get().getUserId());
            dyObj.set("collecttime", (Object)TimeServiceHelper.now());
            dyObj.set("executerec", (Object)schemeExecuteRec.getLong("id"));
            dyObj.set("collectorstate", (Object)failStatus);
            dyObj.set("importmode", (Object)ISImportModeUtil.getImportModeBySchemeDI((Long)ctx.getSchema().p1));
            dyObj.set("impmodedimmem", (Object)ISImportModeUtil.getImportModeDimMem((Long)ctx.getSchema().p1));
            schemeExecuteRec.set("collectstatus", (Object)failStatus);
            ctx.putCustomParam(ENDTIME, System.currentTimeMillis());
            schemeExecuteRec.set(ENDTIME, ctx.getCustomParam(ENDTIME));
            Long spend = (Long)ctx.getCustomParam(ENDTIME) - schemeExecuteRec.getDate("modifydate").getTime();
            StringBuilder sb = DIIntegrationNewServiceHelper.calculate(spend);
            dyObj.set("spend", (Object)sb.toString());
            OperateOption op = OperateOption.create();
            op.setVariableValue("updateModifyDate", "false");
            String operation = ctx.getCustomParam("operation").toString();
            DIIntegrationNewServiceHelper.setDIParam(dyObj, operation);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyObj});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeExecuteRec}, (OperateOption)op);
            DIIntegrationNewServiceHelper.updateScheduleLog(ctx, CollectStatusEnum.FAIL.getValue());
        }, context);
    }

    private static DynamicObject getExecuteRec(Long schemeLogId) {
        return BusinessDataServiceHelper.loadSingle((Object)schemeLogId, (String)"bcm_isschemeexecuterec");
    }

    private static String getTraceIdMsg(String serviceSchemeKey, DIIIntegrateContext ctx) {
        Map servicefailMsg = (Map)ctx.getCustomParam("servicefailMsg");
        if (servicefailMsg == null) {
            return "";
        }
        String traceIdMsg = servicefailMsg.get(serviceSchemeKey + "traceId") == null ? "" : (String)servicefailMsg.get(serviceSchemeKey + "traceId");
        return String.format(ResManager.loadKDString((String)"TraceId\u662f[%s];", (String)"DIIntegrationNewServiceHelper_17", (String)"fi-bcm-business", (Object[])new Object[0]), traceIdMsg);
    }

    private static int getFailStatus(DIIIntegrateContext context) {
        String serviceSchemeKey;
        String serviceSchemeKeyComplete;
        Map servicefailnum = (Map)context.getCustomParam("servicefailnum");
        Integer num = (Integer)servicefailnum.get(serviceSchemeKeyComplete = (serviceSchemeKey = (String)context.getOrg().p2 + (String)context.getSchema().p2 + (String)context.getCurrency().p2) + "complete");
        if (num != null && num == 1) {
            return CollectStatusEnum.COMPLETE.getValue();
        }
        return CollectStatusEnum.FAIL.getValue();
    }

    private static void markFail(DIIIntegrateContext context) {
        Map servicefailnum = (Map)context.getCustomParam("servicefailnum");
        String serviceSchemeKey = (String)context.getOrg().p2 + (String)context.getSchema().p2 + (String)context.getCurrency().p2;
        String serviceSchemeKeyComplete = serviceSchemeKey + "complete";
        if (servicefailnum == null) {
            return;
        }
        String failStatus = (String)context.getCustomParam("complete");
        if ("complete".equals(failStatus)) {
            servicefailnum.put(serviceSchemeKeyComplete, 1);
        }
    }

    private static void executeBefore(DIIIntegrateContext context) {
        DIIntegrationNewServiceHelper.mutexLog(ctx -> DIIntegrationNewServiceHelper.updateExeRec(ctx), context);
        DIDataHandleFactory.getDataHandleService(context.getSrcProduct().getNumber()).createPlan((Long)context.getSchema().p1, (Long)context.getFy().p1, (Long)context.getPeriod().p1);
    }

    private static void updateExeRec(DIIIntegrateContext ctx) {
        Long executeRecId = (Long)ctx.getCustomParam("log");
        DynamicObject existCol = DIIntegrationNewServiceHelper.getExecuteRec(executeRecId);
        if (existCol != null) {
            int status = existCol.getInt("collectstatus");
            if (CollectStatusEnum.READY.getValue() == status || CollectStatusEnum.ISCPROCESS.getValue() == status || CollectStatusEnum.LINEUP.getValue() == status) {
                existCol.set("modifier", (Object)RequestContext.get().getUserId());
                existCol.set("collectstatus", (Object)CollectStatusEnum.RUNNING.getValue());
                existCol.set("exeip", (Object)NetAddressUtils.getLocalIpAddress());
                if (CollectStatusEnum.ISCPROCESS.getValue() != status) {
                    existCol.set("modifydate", (Object)DIIntegrationNewServiceHelper.getCurrentDate());
                }
                existCol.set(ENDTIME, null);
                existCol.set("paramjson", (Object)" ");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{existCol});
            }
        }
    }

    private static Date getCurrentDate() {
        return Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String setImportmode(Object formatValue, Long schemeId) {
        if (Objects.isNull(formatValue) || ISImpModeEnum.MERGEIMPORT.getCode().equals(formatValue)) {
            return ISImpModeEnum.MERGEIMPORT.getName();
        }
        if (ISImpModeEnum.REPLACEIMPORT.getCode().equals(formatValue)) {
            return ISImpModeEnum.REPLACEIMPORT.getName() + "\uff1a" + ISImportModeUtil.getTarLackDimMemberDI(schemeId);
        }
        return "";
    }

    private static void updateScheduleLog(DIIIntegrateContext ctx, int status) {
        Long scheduleLog = (Long)ctx.getCustomParam("scheduleLog");
        if (scheduleLog == null) {
            return;
        }
        DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)scheduleLog, (String)"bcm_schedule_statuslog");
        log.set("status", (Object)status);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }
}

