/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integration.di.ctx.DICompare;
import kd.fi.bcm.business.integration.di.ctx.DIContextParam;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integration.di.ctx.DIMappedRow;
import kd.fi.bcm.business.integration.di.ctx.DIMappedRowSrc;
import kd.fi.bcm.business.integration.di.ctx.DIMappedRowTar;
import kd.fi.bcm.business.integration.di.output.DIIntegrateOutPut;
import kd.fi.bcm.business.integration.di.provider.DIDataProvider;
import kd.fi.bcm.business.integration.di.provider.DIImportDataFactory;
import kd.fi.bcm.business.integration.di.provider.IDIDataProvider;
import kd.fi.bcm.business.integration.di.service.AbstractDIIntegrateService;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integration.util.DataTypeCacheInfo;
import kd.fi.bcm.business.integration.util.DataTypeUtil;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.value.IValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdDataSet;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdRow;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.integration.di.DIOperationEnum;
import kd.fi.bcm.common.enums.integration.di.DiBatchEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.mq.MQCommonPublisher;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.lang3.time.StopWatch;

public class DIIntegrationService
extends AbstractDIIntegrateService {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DIIntegrationService.class);
    private static final String DATA_SET = "databaseset";
    private static final String ALL = "*";
    private static final String IGNORE = "IGNORE";
    private static final String S_SUFFIX = "_s";
    private static final String T_SUFFIX = "_t";
    private static final String FILED_SUM = "_sum";
    private static final List<String> notNeedMatch = Arrays.asList(DimEntityNumEnum.SCENARIO.getNumber(), DimEntityNumEnum.YEAR.getNumber(), DimEntityNumEnum.PERIOD.getNumber());
    private DIOperationEnum operation;
    private Long executeId;
    private String convertTable;
    private String importTable;
    private String singleMetric;
    private String textMetric;
    private String primaryKey;
    private List<String> allDim;
    private Map<Object, IRow> dsMap;
    private Set<String> tarDimFromComb;
    private List<DIMappedRow> mapRowsGroup;
    private List<DIMappedRow> mapRowsSpecial;
    private static final List<String> specialDim4Clear = Arrays.asList(DimEntityNumEnum.SCENARIO.getNumber(), DimEntityNumEnum.YEAR.getNumber(), DimEntityNumEnum.PERIOD.getNumber(), DimEntityNumEnum.ENTITY.getNumber(), DimEntityNumEnum.CURRENCY.getNumber(), DimEntityNumEnum.PROCESS.getNumber());
    private List<Object[]> obParamsMappingTable = new ArrayList<Object[]>(100);
    private List<Object[]> obParamsCheckTable = new ArrayList<Object[]>(100);
    private int insertSizeOnece = 50000;
    private Map<String, Integer> matchMap = new HashMap<String, Integer>(1000);
    private boolean isBreakWhenCombMatch = true;
    private boolean isNotUseIndexCode = false;
    private boolean starToDefault = false;
    private boolean isBatchDistribute = false;
    private Integer dataSize = 0;

    public DIIntegrationService(Long executeId, DIIIntegrateContext ctx) {
        super(executeId, ctx);
        this.executeId = executeId;
        this.dataSize = (Integer)ctx.getCustomParam("dataSize");
    }

    public DIIntegrationService(DIIIntegrateContext ctx) {
        super(ctx);
        Pair<Boolean, Pair<String, String>> levelTable = DIIntegrationUtil.getLevelTable((Long)this._ctx.getSchema().p1, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2);
        if (!((Boolean)levelTable.p1).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8f6c\u6362\u8868", (String)"DIIntegrationService_12", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        this.convertTable = (String)((Pair)levelTable.p2).p2;
        this.importTable = (String)((Pair)levelTable.p2).p1;
        this._ctx.putCustomParam("convertTable", this.convertTable);
        this.operation = this._ctx.getCustomParam("operation") == null ? DIOperationEnum.OpExecuteAll : (DIOperationEnum)this._ctx.getCustomParam("operation");
        this.executeId = (Long)this._ctx.getCustomParam("executeId");
        this.singleMetric = (String)this._ctx.getCustomParam("singlemetric");
        this.textMetric = (String)this._ctx.getCustomParam("textfield");
        this.allDim = this.getAllDimSpeOrder();
        this.tarDimFromComb = this._ctx.getTarDimFromComb();
        this.mapRowsGroup = this._ctx.getCombineMapping();
        DynamicObject schemeDyn = BusinessDataServiceHelper.loadSingle((Object)this._ctx.getSchema().p1, (String)"bcm_isscheme", (String)"specialmappingable,startodefault");
        boolean specialmappingable = schemeDyn.getBoolean("specialmappingable");
        this.starToDefault = schemeDyn.getBoolean("startodefault");
        this.mapRowsSpecial = specialmappingable ? this._ctx.getSpecialCombMapping() : new ArrayList(1);
        this.insertSizeOnece = this.getInsertSize();
        this.isBreakWhenCombMatch = ConfigServiceHelper.getGlobalBoolParam("IntegrationBreakMatch");
        this.isNotUseIndexCode = ConfigServiceHelper.getGlobalBoolParam("IntegrationUserIndexcode");
        this.isBatchDistribute = ConfigServiceHelper.getGlobalBoolParam("IsBatchDistribute");
    }

    private List<String> getAllDimSpeOrder() {
        ArrayList<String> res = new ArrayList<String>();
        res.add(DimEntityNumEnum.CHANGETYPE.getNumber());
        res.add(DimEntityNumEnum.ACCOUNT.getNumber());
        res.add(DimEntityNumEnum.INTERCOMPANY.getNumber());
        for (String number : DimensionServiceHelper.getAllDim((Long)this._ctx.getModel().p1)) {
            if (DimEntityNumEnum.ACCOUNT.getNumber().equals(number) || DimEntityNumEnum.INTERCOMPANY.getNumber().equals(number) || DimEntityNumEnum.CHANGETYPE.getNumber().equals(number)) continue;
            res.add(number);
        }
        return res;
    }

    private int getInsertSize() {
        String configSize = ConfigServiceHelper.getStringParamNoModel("IntegrationMaxSize");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)configSize) || Integer.parseInt(configSize) < 0) {
            return this.insertSizeOnece;
        }
        return Integer.parseInt(configSize);
    }

    @Override
    public void execute() {
        Integer firstType;
        Integer n = firstType = this._ctx.getCustomParam(DIContextParam.FIRST_TYPE) == null ? Integer.valueOf(2) : (Integer)this._ctx.getCustomParam(DIContextParam.FIRST_TYPE);
        if (1 == firstType) {
            this.dataSize = this.getDataCount();
            this.resourcesFirst(true);
        } else if (2 == firstType) {
            this.efficiencyFirst(true);
        } else {
            StringBuilder logMsg = new StringBuilder();
            StopWatch sw = new StopWatch();
            sw.start();
            this.beforeExecute();
            this.dataSize = this.getDataCount();
            this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u9884\u5904\u7406\u8017\u65f6:", (String)"DIIntegrationService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
            sw.stop();
            String outputSpend = this._ctx.getCustomParam("spendTimeMessage") == null ? "" : (String)this._ctx.getCustomParam("spendTimeMessage");
            this._ctx.putCustomParam("spendTimeMessage", logMsg.append(outputSpend).toString());
            if (this.dataSize >= this.insertSizeOnece) {
                this.resourcesFirst(false);
            } else {
                this.efficiencyFirst(false);
            }
        }
    }

    private void efficiencyFirst(boolean needImport) {
        log.startWatch();
        StringBuilder logMsg = new StringBuilder();
        StopWatch sw = new StopWatch();
        sw.start();
        if (this.operation == DIOperationEnum.OpExport) {
            this.exportOnly();
            log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u5bfc\u51fa\u8017\u65f6", (String)"DIIntegrationService_0", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
            this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u5bfc\u51fa\u8017\u65f6:", (String)"DIIntegrationService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            sw.stop();
            return;
        }
        if (needImport) {
            this.beforeExecute();
            log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u9884\u5904\u7406\u8017\u65f6", (String)"DIIntegrationService_2", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
            this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u9884\u5904\u7406\u8017\u65f6:", (String)"DIIntegrationService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        IDataSet ds = (IDataSet)this._provider.loadData();
        this.primaryKey = (String)this._ctx.getCustomParam("primaryKey");
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%1$s]\u67e5\u8be2\u6570\u636e\u8017\u65f6,\u6e90\u6570\u636e\u6761\u6570\u4e3a%2$s", (String)"DIIntegrationService_4", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2, ((StdMdDataSet)ds).getSize()));
        logMsg.append(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u6761\u6570\u4e3a:%s", (String)"DIIntegrationService_5", (String)"fi-bcm-business", (Object[])new Object[0]), ((StdMdDataSet)ds).getSize()));
        this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8017\u65f6:", (String)"DIIntegrationService_6", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.dsMap = ((StdMdDataSet)ds).getRows().stream().collect(Collectors.toMap(r -> r.get(this.primaryKey), r -> r));
        ds = null;
        this.dsMap.forEach((k, row) -> this.match(this.allDim, (IRow)row, 1));
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u5339\u914d\u8fc7\u7a0b\u8017\u65f6", (String)"DIIntegrationService_7", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u5339\u914d\u8fc7\u7a0b\u8017\u65f6:", (String)"DIIntegrationService_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.writeTables();
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u5199\u5165\u53cd\u5dee\u8868\u8017\u65f6", (String)"DIIntegrationService_9", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u5199\u5165\u6821\u9a8c\u8868\u8017\u65f6:", (String)"DIIntegrationService_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        if (this.operation == DIOperationEnum.OpExecuteAll) {
            this._output.output();
        }
        logMsg.append("match times:").append(JSONObject.toJSONString(this.matchMap)).append(";");
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u8f93\u51faolap\u8017\u65f6", (String)"DIIntegrationService_11", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.afterExecute();
        sw.stop();
        String outputSpend = this._ctx.getCustomParam("spendTimeMessage") == null ? "" : (String)this._ctx.getCustomParam("spendTimeMessage");
        this._ctx.putCustomParam("spendTimeMessage", logMsg.append(outputSpend).toString());
    }

    private void resourcesFirst(boolean needImport) {
        long startTime;
        log.startWatch();
        StringBuilder logMsg = new StringBuilder();
        StopWatch sw = new StopWatch();
        sw.start();
        if (needImport) {
            this.beforeExecute();
            this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u9884\u5904\u7406\u8017\u65f6:", (String)"DIIntegrationService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String mark = UUID.randomUUID().toString();
        if (this.isBatchDistribute) {
            this.batchDistribute(mark);
        }
        this.primaryKey = (String)this._ctx.getCustomParam("primaryKey");
        DataSet dataSet = this._provider.loadDataSet();
        this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8017\u65f6:", (String)"DIIntegrationService_6", (String)"fi-bcm-business", (Object[])new Object[0]));
        RowMeta rowMeta = dataSet.getRowMeta();
        StdMdRow mdRow = null;
        Row row = null;
        int loadSize = 0;
        long matchTime = 0L;
        long writeTime = 0L;
        while (dataSet.hasNext()) {
            if (this.isBatchDistribute && ++loadSize > this.insertSizeOnece) {
                --loadSize;
                break;
            }
            row = dataSet.next();
            startTime = System.currentTimeMillis();
            mdRow = this.getStdMdRow(row, rowMeta);
            List<Map<String, Object>> matchData = this.match(this.allDim, mdRow, 2);
            matchTime += System.currentTimeMillis() - startTime;
            startTime = System.currentTimeMillis();
            this.writeTables(matchData, mdRow);
            writeTime += System.currentTimeMillis() - startTime;
        }
        startTime = System.currentTimeMillis();
        this.writeTablesFinal();
        writeTime += System.currentTimeMillis() - startTime;
        Integer[] dataRes = new Integer[]{0, 0, 0};
        if (this.isBatchDistribute) {
            dataRes = this.getDataResArr(mark);
        }
        logMsg.append(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u6761\u6570\u4e3a:%s;", (String)"DIIntegrationService_20", (String)"fi-bcm-business", (Object[])new Object[0]), loadSize + dataRes[0]));
        if (this.isBatchDistribute) {
            this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u5339\u914d,\u5199\u5165\u6821\u9a8c\u8868\u5171\u8017\u65f6:", (String)"DIIntegrationService_19", (String)"fi-bcm-business", (Object[])new Object[0]));
        } else {
            logMsg.append(String.format(ResManager.loadKDString((String)"\u5339\u914d\u6210\u529f\uff0c\u5339\u914d\u8fc7\u7a0b\u8017\u65f6:%s\u3002", (String)"DIIntegrationService_13", (String)"fi-bcm-business", (Object[])new Object[0]), matchTime + (long)dataRes[1].intValue() + "ms"));
            logMsg.append(String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u8868\u5199\u5165\u8017\u65f6\uff1a%s\u3002", (String)"DIIntegrationService_14", (String)"fi-bcm-business", (Object[])new Object[0]), writeTime + (long)dataRes[2].intValue() + "ms"));
        }
        sw.stop();
        startTime = System.currentTimeMillis();
        this.handleSums();
        long sumTime = System.currentTimeMillis() - startTime;
        logMsg.append(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6c47\u603b\u8017\u65f6:%s;", (String)"DIIntegrationService_15", (String)"fi-bcm-business", (Object[])new Object[0]), sumTime + "ms"));
        startTime = System.currentTimeMillis();
        this.clearData();
        long clearTime = System.currentTimeMillis() - startTime;
        logMsg.append(String.format(ResManager.loadKDString((String)"\u6e05\u6570\u8017\u65f6:%s;", (String)"DIIntegrateOutPut_4", (String)"fi-bcm-business", (Object[])new Object[0]), clearTime + "ms"));
        startTime = System.currentTimeMillis();
        this.outputData();
        long outTime = System.currentTimeMillis() - startTime;
        logMsg.append(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u591a\u7ef4\u8017\u65f6\uff1a%s\u3002", (String)"DIIntegrateOutPut_3", (String)"fi-bcm-business", (Object[])new Object[0]), outTime + "ms"));
        logMsg.append("match times:").append(JSONObject.toJSONString(this.matchMap)).append(";");
        this.afterExecute();
        String outputSpend = this._ctx.getCustomParam("spendTimeMessage") == null ? "" : (String)this._ctx.getCustomParam("spendTimeMessage");
        this._ctx.putCustomParam("spendTimeMessage", logMsg.append(outputSpend).toString());
    }

    private Integer[] getDataResArr(String mark) {
        QFilter[] filters = new QFilter[]{new QFilter("executeid", "=", (Object)this.executeId), new QFilter("mark", "=", (Object)mark)};
        Integer[] res = new Integer[]{0, 0, 0};
        while (true) {
            DynamicObjectCollection data = QueryServiceHelper.query((String)"di_batchstatus", (String)"datasize,matchtime,savetime,status,msg", (QFilter[])filters);
            boolean isComplete = true;
            res = new Integer[]{0, 0, 0};
            for (DynamicObject obj : data) {
                String status = obj.getString("status");
                if (DiBatchEnum.START.getCode().equals(status)) {
                    isComplete = false;
                    break;
                }
                if (DiBatchEnum.SUCCESS.getCode().equals(status)) {
                    res[0] = res[0] + obj.getInt("datasize");
                    res[1] = res[1] + obj.getInt("matchtime");
                    res[2] = res[2] + obj.getInt("savetime");
                    continue;
                }
                if (!DiBatchEnum.FAIL.getCode().equals(status)) continue;
                throw new KDBizException(obj.getString("msg"));
            }
            if (isComplete) break;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error("DIIntegrationService InterruptedException", (Throwable)e);
                throw new KDBizException("Thread  InterruptedException");
            }
        }
        return res;
    }

    private void batchDistribute(String mark) {
        int times = this.dataSize / this.insertSizeOnece + 1;
        ArrayList mqMapList = new ArrayList(times);
        ArrayList<DynamicObject> batStatusList = new ArrayList<DynamicObject>(times);
        for (int i = 1; i < times; ++i) {
            HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>(3);
            Map<String, Object> contentMap = this.getContentMap();
            Map<String, Object> paramMap = this.getParamMap(i, mark);
            hashMap.put("paramMap", paramMap);
            hashMap.put("contentMap", contentMap);
            mqMapList.add(hashMap);
            DynamicObject batstatus = this.getBatStatus(mark, i);
            batStatusList.add(batstatus);
        }
        if (batStatusList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])batStatusList.toArray(new DynamicObject[0]));
        }
        if (mqMapList.size() > 0) {
            for (Map map : mqMapList) {
                MQCommonPublisher.publishDIDataIntegrationBat((String)ObjectSerialUtil.toByteSerialized((Object)map));
            }
        }
    }

    private DynamicObject getBatStatus(String mark, int batNumber) {
        DynamicObject batstatus = BusinessDataServiceHelper.newDynamicObject((String)"di_batchstatus");
        batstatus.set("executeid", (Object)this.executeId);
        batstatus.set("mark", (Object)mark);
        batstatus.set("batchnumber", (Object)batNumber);
        batstatus.set("createtime", (Object)new Date());
        batstatus.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        batstatus.set("status", (Object)DiBatchEnum.START.getCode());
        return batstatus;
    }

    private Map<String, Object> getParamMap(int index, String mark) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("singlemetric", this._ctx.getCustomParam("singlemetric"));
        paramMap.put("textfield", this._ctx.getCustomParam("textfield"));
        paramMap.put("executeId", this._ctx.getCustomParam("executeId"));
        paramMap.put("offset", index * this.insertSizeOnece);
        paramMap.put("batchNumber", index);
        paramMap.put("mark", mark);
        return paramMap;
    }

    private Map<String, Object> getContentMap() {
        HashMap<String, Object> contentMap = new HashMap<String, Object>();
        contentMap.put("modelId", this._ctx.getModel().p1);
        contentMap.put("modelName", this._ctx.getModel().p2);
        contentMap.put("schemeId", this._ctx.getSchema().p1);
        contentMap.put("schemeName", this._ctx.getSchema().p2);
        contentMap.put("currencyId", this._ctx.getCurrency().p1);
        contentMap.put("currencyName", this._ctx.getCurrency().p2);
        contentMap.put("sceneId", this._ctx.getScene().p1);
        contentMap.put("sceneName", this._ctx.getScene().p2);
        contentMap.put("fyId", this._ctx.getFy().p1);
        contentMap.put("fyName", this._ctx.getFy().p2);
        contentMap.put("periodId", this._ctx.getPeriod().p1);
        contentMap.put("periodName", this._ctx.getPeriod().p2);
        contentMap.put("orgId", this._ctx.getOrg().p1);
        contentMap.put("orgName", this._ctx.getOrg().p2);
        return contentMap;
    }

    public void dohand(int offset, String mark, int batchnumber) {
        this.primaryKey = (String)this._ctx.getCustomParam("primaryKey");
        int loadSize = 0;
        int theDataSize = 0;
        long matchTime = 0L;
        long writeTime = 0L;
        String msg = "";
        String status = DiBatchEnum.SUCCESS.getCode();
        try {
            long startTime;
            DataSet dataSet = this._provider.loadDataSet();
            RowMeta rowMeta = dataSet.getRowMeta();
            StdMdRow mdRow = null;
            Row row = null;
            int maxSize = offset + this.insertSizeOnece;
            while (dataSet.hasNext()) {
                row = dataSet.next();
                if (++loadSize > offset && loadSize <= maxSize) {
                    ++theDataSize;
                    startTime = System.currentTimeMillis();
                    mdRow = this.getStdMdRow(row, rowMeta);
                    List<Map<String, Object>> matchData = this.match(this.allDim, mdRow, 2);
                    matchTime += System.currentTimeMillis() - startTime;
                    startTime = System.currentTimeMillis();
                    this.writeTables(matchData, mdRow);
                    writeTime += System.currentTimeMillis() - startTime;
                    continue;
                }
                if (loadSize <= maxSize) continue;
            }
            startTime = System.currentTimeMillis();
            this.writeTablesFinal();
            writeTime += System.currentTimeMillis() - startTime;
        }
        catch (Exception e) {
            msg = ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30);
            if (msg.length() > 1910) {
                msg = msg.substring(0, 1900);
            }
            status = DiBatchEnum.FAIL.getCode();
        }
        this.updateBatSql(mark, batchnumber, theDataSize, matchTime, writeTime, msg, status);
    }

    private void updateBatSql(String mark, int batchnumber, Integer dataSize, long matchTime, long writeTime, String msg, String status) {
        StringBuilder sb = new StringBuilder();
        sb.append("update t_di_batchstatus set fdatasize = ");
        sb.append(dataSize);
        sb.append(", fmatchtime=");
        sb.append(matchTime);
        sb.append(", fsavetime=");
        sb.append(writeTime);
        sb.append(", fstatus='");
        sb.append(status);
        sb.append("', fmsg='");
        sb.append(msg);
        sb.append("' where fexecuteid = ");
        sb.append(this.executeId);
        sb.append(" and fmark = '");
        sb.append(mark);
        sb.append("' and fbatchnumber = ");
        sb.append(batchnumber);
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sb.toString());
    }

    private void writeTables() {
        if (this.operation == DIOperationEnum.OpExport) {
            return;
        }
        List rows = (List)this._ctx.getCustomParam(DATA_SET);
        if (ObjectUtils.isEmpty((Object)rows)) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                this.setIDnew(rows);
                if (!ConfigServiceHelper.getGlobalBoolParam("di_notWriteMappingTrace")) {
                    this.writeMappingTable(rows, this.executeId);
                }
                this.writeCheckTable(rows);
            }
            catch (Throwable t) {
                tx.markRollback();
                log.error("--doExecute--:\n" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)t, (int)30));
                throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)t, (int)30));
            }
        }
    }

    private List<Map<String, Object>> match(List<String> allDims, IRow row, int type) {
        List<Map<String, Object>> targets = this.matchGroupAndSpecialMapping(row);
        targets.forEach(t -> this.matchOtherMapping((Map<String, Object>)t, allDims, row, type));
        return targets;
    }

    private List<Map<String, Object>> matchGroupAndSpecialMapping(IRow row) {
        ArrayList<Map<String, Object>> targets = new ArrayList<Map<String, Object>>(10);
        targets.add(this.matchGroupMapping(row));
        targets.addAll(this.matchSpecialMapping(row));
        return targets;
    }

    private Map<String, Object> matchGroupMapping(IRow row) {
        HashMap<String, Object> targetMap = new HashMap<String, Object>(40);
        targetMap.put("matchingstatus", true);
        targetMap.put("impid", row.get(this.primaryKey));
        Pair<Boolean, Set<Long>> idSetRes = this.isNotUseIndexCode ? null : this.getConbineIdSet(row, "CombMapping");
        for (DIMappedRow maprow : this.mapRowsGroup) {
            if (!this.isNotUseIndexCode && idSetRes != null && ((Boolean)idSetRes.p1).booleanValue() && !((Set)idSetRes.p2).contains(maprow.getId())) continue;
            this.addMatchCount("combine");
            if (!this.matchRow(row, maprow, targetMap) || !this.isBreakWhenCombMatch && (this.isBreakWhenCombMatch || !this.tarDimFromComb.stream().allMatch(dim -> targetMap.containsKey(dim.toLowerCase() + T_SUFFIX)))) continue;
            break;
        }
        return targetMap;
    }

    private List<Map<String, Object>> matchSpecialMapping(IRow row) {
        ArrayList<Map<String, Object>> targets = new ArrayList<Map<String, Object>>(10);
        Pair<Boolean, Set<Long>> idSetRes = this.isNotUseIndexCode ? null : this.getConbineIdSet(row, "SpecialCombMapping");
        for (DIMappedRow maprow : this.mapRowsSpecial) {
            if (!this.isNotUseIndexCode && idSetRes != null && ((Boolean)idSetRes.p1).booleanValue() && !((Set)idSetRes.p2).contains(maprow.getId())) continue;
            HashMap<String, Object> targetMap = new HashMap<String, Object>(16);
            targetMap.put("matchingstatus", true);
            targetMap.put("impid", row.get(this.primaryKey));
            if (!this.matchRow(row, maprow, targetMap)) continue;
            targets.add(targetMap);
        }
        return targets;
    }

    private void matchOtherMapping(Map<String, Object> targetMap, List<String> allDims, IRow row, int type) {
        for (String dim : allDims) {
            if (notNeedMatch.contains(dim)) {
                targetMap.put(dim.toLowerCase() + T_SUFFIX, null);
            }
            if (targetMap.containsKey(dim.toLowerCase() + T_SUFFIX) || this._ctx.getSimpleMappingByKey(dim) == null) continue;
            Pair<Boolean, Set<Long>> idSetRes = this.isNotUseIndexCode ? null : this.getConbineIdSet(row, dim);
            for (DIMappedRow simpleRow : this._ctx.getSimpleMappingByKey(dim)) {
                if (!this.isNotUseIndexCode && ((Boolean)idSetRes.p1).booleanValue() && !((Set)idSetRes.p2).contains(simpleRow.getId())) continue;
                this.addMatchCount(dim);
                if (!this.matchRow(row, simpleRow, targetMap)) continue;
                break;
            }
            if (targetMap.containsKey(dim.toLowerCase() + T_SUFFIX) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((String)targetMap.get(dim.toLowerCase() + T_SUFFIX))) || !ObjectUtils.isEmpty(this._ctx.getDefMapping().get(dim))) continue;
            targetMap.put("matchingstatus", false);
            String msg = (String)targetMap.getOrDefault("msg", "");
            msg = msg + String.format(ResManager.loadKDString((String)"\u76ee\u6807\u201c%s\u7ef4\u5ea6\u201d\u5339\u914d\u5931\u8d25\uff0c\u5339\u914d\u5df2\u7ec8\u6b62\u3002", (String)"DIIntegrationService_18", (String)"fi-bcm-business", (Object[])new Object[0]), dim);
            targetMap.put("msg", msg.length() > 2000 ? msg.substring(0, 2000) : msg);
            if (type == 1) {
                this.setDataSet4Check(targetMap);
            }
            return;
        }
        for (String dim : allDims) {
            if (targetMap.containsKey(dim.toLowerCase() + T_SUFFIX)) continue;
            if (ObjectUtils.isEmpty(this._ctx.getDefMapping().get(dim))) {
                targetMap.put("matchingstatus", false);
                continue;
            }
            String tarMem = this._ctx.getDefMapping().get(dim).get(0);
            if (dim.equals(DimTypesEnum.PROCESS.getNumber()) && DimTypesEnum.PROCESS.getNumber().equals(tarMem)) {
                String orgNum = (String)targetMap.get(DimTypesEnum.ENTITY.getNumber().toLowerCase() + T_SUFFIX);
                tarMem = MemberReader.findEntityMemberByNum((String)((String)this._ctx.getModel().p2), (String)orgNum).isLeaf() ? "EIRpt" : "CSTE";
            }
            targetMap.put(dim.toLowerCase() + T_SUFFIX, tarMem);
        }
        this.repairTarget(targetMap);
        BigDecimal amount = (BigDecimal)row.get(this.singleMetric);
        String text = (String)row.get(this.textMetric);
        boolean matched = (Boolean)targetMap.get("matchingstatus");
        if (matched && amount != null) {
            Double weight = (Double)targetMap.get("weight");
            amount = amount.multiply(new BigDecimal(weight.toString()));
            amount = (Boolean)targetMap.get("isNegate") != false ? amount.negate() : amount;
        }
        targetMap.remove("weight");
        targetMap.remove("isNegate");
        targetMap.put(this.singleMetric + S_SUFFIX, amount);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.textMetric)) {
            targetMap.put(this.textMetric + S_SUFFIX, text);
        }
        if (type == 1) {
            this.setDataSet4Check(targetMap);
        }
    }

    private Pair<Boolean, Set<Long>> getConbineIdSet(IRow row, String dim) {
        Map<Long, String> dimIndex = this._ctx.getDimIndexByKey(dim);
        if (dimIndex == null) {
            return Pair.onePair((Object)false, null);
        }
        Map<Integer, Object> mappingIndex = this._ctx.getSimpleMappingIndexByKey(dim);
        Long key1 = null;
        String value1 = null;
        Integer key2 = null;
        String compValue = null;
        HashSet<Long> resSet = new HashSet<Long>();
        if (mappingIndex == null) {
            return Pair.onePair((Object)true, resSet);
        }
        for (Map.Entry<Long, String> map1 : dimIndex.entrySet()) {
            key1 = map1.getKey();
            value1 = map1.getValue();
            compValue = row.get(value1) == null ? ALL : row.get(value1).toString();
            for (Map.Entry<Integer, Object> map2 : mappingIndex.entrySet()) {
                Map map3;
                Iterator iterator;
                Object value;
                Map value2;
                key2 = map2.getKey();
                if (key2 == 1) {
                    value2 = (Map)map2.getValue();
                    value = (Map)value2.get(key1);
                    if (value == null) continue;
                    Set addSet = (Set)value.get(compValue);
                    Set addStarSet = (Set)value.get(ALL);
                    if (addSet != null) {
                        resSet.addAll(addSet);
                    }
                    if (addStarSet == null) continue;
                    resSet.addAll(addStarSet);
                    continue;
                }
                if (key2 == 5) {
                    value2 = (Map)map2.getValue();
                    value = (List)value2.get(key1);
                    if (value == null) continue;
                    iterator = value.iterator();
                    while (iterator.hasNext()) {
                        map3 = (Map)iterator.next();
                        String notEquelValue = (String)map3.get("key");
                        if (compValue.equals(notEquelValue)) continue;
                        resSet.add((Long)map3.get("value"));
                    }
                    continue;
                }
                if (key2 == 2 || key2 == 6) {
                    value2 = (Map)map2.getValue();
                    value = (List)value2.get(key1);
                    if (value == null) continue;
                    iterator = value.iterator();
                    while (iterator.hasNext()) {
                        map3 = (Map)iterator.next();
                        List betweenValue = (List)map3.get("key");
                        if ((key2 != 2 || !DICompare.compareBetween(betweenValue, compValue)) && (key2 != 6 || DICompare.compareBetween(betweenValue, compValue))) continue;
                        resSet.add((Long)map3.get("value"));
                    }
                    continue;
                }
                if (key2 == 3 || key2 == 7) {
                    value2 = (Map)map2.getValue();
                    value = (List)value2.get(key1);
                    if (value == null) continue;
                    iterator = value.iterator();
                    while (iterator.hasNext()) {
                        map3 = (Map)iterator.next();
                        String likeValue = (String)map3.get("key");
                        if ((key2 != 3 || !DICompare.compareLike(likeValue, compValue)) && (key2 != 7 || DICompare.compareLike(likeValue, compValue))) continue;
                        resSet.add((Long)map3.get("value"));
                    }
                    continue;
                }
                if (key2 != 8 || (value = (List)(value2 = (Map)map2.getValue()).get(key1)) == null) continue;
                iterator = value.iterator();
                while (iterator.hasNext()) {
                    map3 = (Map)iterator.next();
                    Set inValue = (Set)map3.get("key");
                    if (DICompare.compareInclude(inValue, compValue)) continue;
                    resSet.add((Long)map3.get("value"));
                }
            }
        }
        return Pair.onePair((Object)true, resSet);
    }

    private void addMatchCount(String key) {
        Integer count = this.matchMap.get(key);
        if (count == null) {
            count = 0;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.matchMap.put(key, count);
    }

    private void repairTarget(Map<String, Object> targetMap) {
        targetMap.put(SysDimensionEnum.Scenario.getNumber().toLowerCase() + T_SUFFIX, this._ctx.getScene().p2);
        targetMap.put(SysDimensionEnum.Year.getNumber().toLowerCase() + T_SUFFIX, this._ctx.getFy().p2);
        targetMap.put(SysDimensionEnum.Period.getNumber().toLowerCase() + T_SUFFIX, this._ctx.getPeriod().p2);
    }

    private boolean matchRow(IRow r, DIMappedRow mappedRow, Map<String, Object> targetMap) {
        String starTar = "";
        for (DIMappedRowSrc dIMappedRowSrc : mappedRow.getSrcMappedRow()) {
            String v;
            String srcKey = dIMappedRowSrc.getKey();
            String string = v = r.get(srcKey) == null ? "" : r.get(srcKey).toString();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)v)) {
                v = ALL;
            }
            if (!ALL.equals(dIMappedRowSrc.getValue().get(0)) && !ALL.equals(v)) {
                if (DICompare.isMatch(dIMappedRowSrc, v)) continue;
                return false;
            }
            if (!ALL.equals(dIMappedRowSrc.getValue().get(0)) && ALL.equals(v)) {
                return false;
            }
            starTar = ALL.equals(v) ? "" : v;
        }
        Long mappingId = 0L;
        for (DIMappedRowTar tar : mappedRow.getTarMappedRow()) {
            String dimNum = tar.getKey();
            String tarLowerNum = dimNum.toLowerCase() + T_SUFFIX;
            if (targetMap.get(tarLowerNum) != null) continue;
            mappingId = mappedRow.getId();
            String value = tar.getValue();
            if (ALL.equals(value)) {
                IDNumberTreeNode m = MemberReader.findMemberByNumber((String)((String)this._ctx.getModel().p2), (String)dimNum, (String)starTar);
                targetMap.put(tarLowerNum, m == null || "not found".equals(m.getNumber()) ? "" : m.getNumber());
                if (m == null || "not found".equals(m.getNumber())) {
                    if (this.starToDefault && !ObjectUtils.isEmpty(this._ctx.getDefMapping().get(dimNum))) {
                        targetMap.put(tarLowerNum, this._ctx.getDefMapping().get(dimNum).get(0));
                    } else {
                        String msg = (String)targetMap.getOrDefault("msg", "");
                        targetMap.put("msg", (msg = msg + String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u201c%1$s\u201d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u6210\u5458\u3002", (String)"DIIntegrationService_16", (String)"fi-bcm-business", (Object[])new Object[0]), dimNum, starTar)).length() > 2000 ? msg.substring(0, 2000) : msg);
                    }
                }
            } else {
                if (IGNORE.equalsIgnoreCase(value)) {
                    String msg = (String)targetMap.getOrDefault("msg", "");
                    targetMap.put("msg", (msg = msg + String.format(ResManager.loadKDString((String)"\u76ee\u6807\u201c%s\u7ef4\u5ea6\u201d\u6210\u5458\u4e3aIGNORE;", (String)"DIIntegrationService_17", (String)"fi-bcm-business", (Object[])new Object[0]), dimNum)).length() > 2000 ? msg.substring(0, 2000) : msg);
                }
                targetMap.put(tarLowerNum, value);
            }
            if (!SysDimensionEnum.Account.getNumber().equals(dimNum)) continue;
            targetMap.put("isNegate", mappedRow.isNegate());
            targetMap.put("weight", mappedRow.getWeight());
        }
        if (mappingId != 0L) {
            Set set = targetMap.getOrDefault("mappingid", new HashSet());
            set.add(mappingId);
            targetMap.put("mappingid", set);
        }
        return true;
    }

    private void setDataSet4Check(Map<String, Object> targetMap) {
        List<Map<String, Object>> rows = this._ctx.getCustomParam(DATA_SET) == null ? new ArrayList(10) : (List)this._ctx.getCustomParam(DATA_SET);
        rows.add(targetMap);
        this._ctx.putCustomParam(DATA_SET, rows);
    }

    @Override
    protected void beforeExecute() {
        super.beforeExecute();
        if (DIOperationEnum.OpExecuteAll == this.operation) {
            Map<String, Object> result = DIImportDataFactory.getImportDataService(this._ctx.getSrcProduct().getNumber()).importData((Long)this._ctx.getSchema().p1, this.executeId, (Long)this._ctx.getModel().p1, (Long)this._ctx.getScene().p1, (Long)this._ctx.getFy().p1, (Long)this._ctx.getPeriod().p1, (Long)this._ctx.getCurrency().p1, (Long)this._ctx.getOrg().p1, (String)this._ctx.getCustomParam(DIContextParam.SERVICE_PARAM));
            this.writeFilterLog2Ctx(result);
        }
        this.deleteConvertDataByExeId(this.executeId, this.convertTable);
        this.deleteMappingDataByExeId(this.executeId);
    }

    @Override
    protected void afterExecute() {
        this.releaseSpace();
    }

    private void releaseSpace() {
        this._ctx.putCustomParam(DATA_SET, null);
        this._ctx.clearAllMapping();
        this._ctx.setValueList(null);
    }

    private void writeCheckTable(List<Map<String, Object>> rows) {
        List<String> fields = this.getCheckTableField();
        int idx_olap = fields.size() - 1;
        ArrayList<String> allSrcDims = new ArrayList<String>(this._ctx.getAllSrcDim());
        ArrayList<Object[]> obParams = new ArrayList<Object[]>(rows.size());
        Recorder need = new Recorder((Object)true);
        rows.forEach(r -> {
            r.put("executeid", this.executeId);
            ArrayList<Boolean> l = new ArrayList<Boolean>(fields.size() * 2);
            fields.forEach(f -> {
                if (f.equalsIgnoreCase(this.singleMetric + FILED_SUM + S_SUFFIX) || f.equalsIgnoreCase(this.textMetric + FILED_SUM + S_SUFFIX) || f.equalsIgnoreCase("traceid") || f.equalsIgnoreCase("olapstatus")) {
                    l.add(null);
                } else if (f.equalsIgnoreCase(this.singleMetric + S_SUFFIX) || f.equalsIgnoreCase(this.textMetric + S_SUFFIX)) {
                    l.add((Boolean)r.get(f));
                } else {
                    Object obj = r.get(f);
                    if ((ObjectUtils.isEmpty(obj) || IGNORE.equalsIgnoreCase(obj.toString())) && f.endsWith(T_SUFFIX) || "matchingstatus".equals(f) && !((Boolean)obj).booleanValue()) {
                        need.setRecord((Object)false);
                    }
                    l.add((Boolean)obj);
                }
            });
            if (((Boolean)need.getRecord()).booleanValue()) {
                l.set(idx_olap, true);
            } else {
                l.set(idx_olap, false);
                need.setRecord((Object)true);
            }
            allSrcDims.forEach(f -> l.add((Boolean)this.dsMap.get(r.get("impid")).get(f.toLowerCase())));
            obParams.add(l.toArray());
        });
        fields.addAll(allSrcDims.stream().map(dim -> dim.toLowerCase() + S_SUFFIX).collect(Collectors.toList()));
        if (obParams.size() > 0 && this.operation == DIOperationEnum.OpExecuteAll) {
            this.handleSums(obParams, fields, idx_olap, false);
        }
        ArrayList<String> insertFields = new ArrayList<String>(fields.size());
        fields.forEach(f -> insertFields.add("f" + f));
        this.insertData(obParams, insertFields, this.convertTable);
    }

    private void handleSums(List<Object[]> obParams, List<String> fields, int idx_olap, boolean all4Olap) {
        ArrayList<Pair> tarDimIndex = new ArrayList<Pair>(10);
        HashMap<String, Integer> metricIndex = new HashMap<String, Integer>(10);
        for (int i = 0; i < fields.size(); ++i) {
            String f = fields.get(i);
            if (f.endsWith(T_SUFFIX)) {
                tarDimIndex.add(Pair.onePair((Object)f.replace(T_SUFFIX, ""), (Object)i));
                continue;
            }
            if (!f.equalsIgnoreCase(this.singleMetric + FILED_SUM + S_SUFFIX) && !f.equalsIgnoreCase(this.textMetric + FILED_SUM + S_SUFFIX) && !f.equalsIgnoreCase(this.singleMetric + S_SUFFIX) && !f.equalsIgnoreCase(this.textMetric + S_SUFFIX) && !f.equalsIgnoreCase("idnew") && !f.equalsIgnoreCase("traceid")) continue;
            metricIndex.put(f, i);
        }
        HashMap<String, Tuple> sumRows = new HashMap<String, Tuple>(16);
        obParams.forEach(params -> {
            if (all4Olap || Boolean.TRUE.equals(params[idx_olap])) {
                StringBuilder sbKey = new StringBuilder();
                tarDimIndex.forEach(p -> sbKey.append(params[(Integer)p.p2]).append(","));
                String key = sbKey.substring(0, sbKey.length() - 1);
                Long idnew = (Long)params[(Integer)metricIndex.get("idnew")];
                Tuple value = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.textMetric) ? new Tuple((Object)(params[(Integer)metricIndex.get(this.singleMetric + S_SUFFIX)] == null ? null : (BigDecimal)params[(Integer)metricIndex.get(this.singleMetric + S_SUFFIX)]), params[(Integer)metricIndex.get(this.textMetric + S_SUFFIX)] == null ? null : (String)params[(Integer)metricIndex.get(this.textMetric + S_SUFFIX)], (Object)idnew) : new Tuple(params[(Integer)metricIndex.get(this.singleMetric + S_SUFFIX)] == null ? null : (BigDecimal)params[(Integer)metricIndex.get(this.singleMetric + S_SUFFIX)], null, (Object)idnew);
                Tuple pair = (Tuple)sumRows.get(key);
                if (pair != null) {
                    value = value.p1 != null && pair.p1 != null ? new Tuple((Object)((BigDecimal)value.p1).add((BigDecimal)pair.p1), value.p2, pair.p3) : (value.p1 != null ? new Tuple(value.p1, value.p2, pair.p3) : (pair.p1 != null ? new Tuple(pair.p1, value.p2, pair.p3) : new Tuple(null, value.p2, pair.p3)));
                }
                params[((Integer)metricIndex.get((Object)"traceid")).intValue()] = value.p3;
                sumRows.put(key, value);
            }
        });
        ArrayList<String> tarDims = new ArrayList<String>(tarDimIndex.size());
        tarDimIndex.forEach(d -> {
            Optional<String> any = this.allDim.stream().filter(dim -> dim.equalsIgnoreCase((String)d.p1)).findAny();
            any.ifPresent(tarDims::add);
        });
        ValueList values = this._ctx.getValueList();
        Map<String, DataTypeEnum> typeEnumMap = this.getDataTypeEnumMap(sumRows.keySet(), tarDims, (Long)this._ctx.getModel().p1);
        Map<Long, Object[]> obParamsMap = this.getObParamsMap(obParams, (Integer)metricIndex.get("idnew"));
        sumRows.forEach((k, v) -> {
            Object[] params = (Object[])obParamsMap.get(v.p3);
            if (v.p3 == params[(Integer)metricIndex.get("idnew")]) {
                ValueItem valueItem = new ValueItem();
                String[] membs = k.split(",");
                for (int i = 0; i < membs.length; ++i) {
                    valueItem.setProperty((String)tarDims.get(i), membs[i]);
                }
                DataTypeEnum type = (DataTypeEnum)typeEnumMap.get(k);
                if (DataTypeEnum.CURRENCY == type || DataTypeEnum.DEFAULT == type || DataTypeEnum.UNCURRENCY == type || DataTypeEnum.PROPORTION == type) {
                    params[((Integer)metricIndex.get((Object)new StringBuilder().append((String)this.singleMetric).append((String)FILED_SUM).append((String)S_SUFFIX).toString())).intValue()] = v.p1;
                    valueItem.setValue(v.p1);
                } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.textMetric)) {
                    params[((Integer)metricIndex.get((Object)new StringBuilder().append((String)this.textMetric).append((String)FILED_SUM).append((String)S_SUFFIX).toString())).intValue()] = v.p2;
                    valueItem.setValue(v.p2);
                }
                valueItem.setProperty("idnew", v.p3);
                values.addValue(valueItem);
                this._ctx.setValueList(values);
            }
        });
    }

    protected Map<Long, Object[]> getObParamsMap(List<Object[]> obParams, Integer idnewInx) {
        return obParams.stream().collect(Collectors.toMap(p -> (Long)p[idnewInx], p -> p));
    }

    private Map<String, DataTypeEnum> getDataTypeEnumMap(Set<String> membersStr, List<String> tarDims, long modelId) {
        HashMap<String, DataTypeEnum> typeMap = new HashMap<String, DataTypeEnum>(membersStr.size());
        HashMap cachemap = new HashMap(16);
        membersStr.forEach(s -> {
            String[] members = s.split(",");
            HashMap<String, String> dim2Members = new HashMap<String, String>(16);
            for (int i = 0; i < tarDims.size(); ++i) {
                dim2Members.put((String)tarDims.get(i), members[i]);
            }
            typeMap.put((String)s, DataTypeUtil.getDataTypeThreadCache(modelId, dim2Members, cachemap));
        });
        return typeMap;
    }

    private void exportOnly() {
        String sql = this.getSql4OnlyExport(this.allDim, this.executeId);
        StdMdDataSet ds = this.queryCheckTable4Export(this.convertTable, sql);
        ArrayList<String> fields = new ArrayList<String>(10);
        this.allDim.forEach(d -> fields.add(d + T_SUFFIX));
        fields.add(this.singleMetric + S_SUFFIX);
        fields.add(this.singleMetric + FILED_SUM + S_SUFFIX);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.textMetric)) {
            fields.add(this.textMetric + S_SUFFIX);
            fields.add(this.textMetric + FILED_SUM + S_SUFFIX);
        }
        fields.add("traceid");
        fields.add("idnew");
        ArrayList<Object[]> obParams = new ArrayList<Object[]>(10);
        ds.forEach(r -> {
            ArrayList l = new ArrayList(fields.size());
            Recorder need = new Recorder((Object)true);
            this.allDim.forEach(d -> {
                Object obj = r.get((String)d);
                if (!ObjectUtils.isEmpty(obj) && !IGNORE.equalsIgnoreCase((String)r.get((String)d))) {
                    l.add(r.get((String)d));
                } else {
                    need.setRecord((Object)false);
                }
            });
            if (((Boolean)need.getRecord()).booleanValue()) {
                l.add(r.get(this.singleMetric + S_SUFFIX));
                l.add(null);
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.textMetric)) {
                    l.add(r.get(this.textMetric + S_SUFFIX));
                    l.add(null);
                }
                l.add(null);
                l.add(r.get("idnew"));
                obParams.add(l.toArray());
            }
        });
        try (TXHandle tx = TX.required();){
            try {
                this.handleSums(obParams, fields, -1, true);
                Pair<List<Object[]>, List<String>> updateParamsPair = this.handleUpdateParams(obParams, fields);
                this.updateData((List)updateParamsPair.p1, (List)updateParamsPair.p2, this.convertTable);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
        }
        this._output.output();
    }

    private String getSql4OnlyExport(List<String> dimNumbs, Long executeId) {
        StringBuilder sql = new StringBuilder();
        StringBuilder selector = new StringBuilder();
        selector.append("fidnew").append(",");
        dimNumbs.forEach(d -> selector.append("f").append((String)d).append(T_SUFFIX).append(","));
        selector.append("f").append(this.singleMetric).append(S_SUFFIX).append(",");
        selector.append("f").append(this.singleMetric).append(FILED_SUM).append(S_SUFFIX).append(",");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.textMetric)) {
            selector.append("f").append(this.textMetric).append(S_SUFFIX).append(",");
            selector.append("f").append(this.textMetric).append(FILED_SUM).append(S_SUFFIX).append(",");
        }
        selector.append("ftraceid");
        sql.append("SELECT ").append((CharSequence)selector);
        sql.append(" FROM ").append(this.convertTable);
        sql.append(" WHERE ").append("fexecuteid").append(" = ").append(executeId).append(" AND ").append("folapstatus = '1' ");
        sql.append(";");
        return sql.toString();
    }

    private StdMdDataSet queryCheckTable4Export(String table, String sql) {
        StdMdDataSet rowSet = new StdMdDataSet();
        try (DataSet dataSet = DB.queryDataSet((String)table, (DBRoute)BCMConstant.DBROUTE, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                StdMdRow mdRow = new StdMdRow();
                for (Field field : dataSet.getRowMeta().getFields()) {
                    Object v = row.get(field.getName());
                    if (v == null || !StringUtils.isNotEmpty((String)v.toString())) continue;
                    mdRow.put(field.getName().substring(1).replace(T_SUFFIX, ""), v);
                }
                rowSet.addRow(mdRow);
            }
        }
        return rowSet;
    }

    private Pair<List<Object[]>, List<String>> handleUpdateParams(List<Object[]> obParams, List<String> fields) {
        ArrayList<String> reFields = new ArrayList<String>(4);
        reFields.add(this.singleMetric + FILED_SUM + S_SUFFIX);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.textMetric)) {
            reFields.add(this.textMetric + FILED_SUM + S_SUFFIX);
        }
        reFields.add("traceid");
        reFields.add("idnew");
        ArrayList reParams = new ArrayList(10);
        obParams.forEach(params -> {
            ArrayList<Object> l = new ArrayList<Object>(reFields.size());
            for (int i = 0; i < fields.size(); ++i) {
                if (!reFields.contains(fields.get(i))) continue;
                l.add(params[i]);
            }
            reParams.add(l.toArray());
        });
        reFields.forEach(f -> {
            f = "f" + f;
        });
        return Pair.onePair(reParams, reFields);
    }

    private void updateData(List<Object[]> obParams, List<String> fieldList, String table) {
        if (obParams.isEmpty()) {
            return;
        }
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(table).append(" set ");
        StringBuilder sqlParam = new StringBuilder();
        fieldList.forEach(f -> {
            if (!("f" + f).equalsIgnoreCase("fidnew")) {
                sqlParam.append("f").append((String)f).append("=").append("?").append(",");
            } else {
                sqlParam.delete(sqlParam.length() - 1, sqlParam.length()).append(" where ").append("f").append((String)f).append("=").append("?");
            }
        });
        updateSql.append((CharSequence)sqlParam);
        DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)updateSql.toString(), obParams);
    }

    @Override
    protected IDIDataProvider<IDataSet<IRow>> getDataProvider() {
        return new DIDataProvider(this._ctx);
    }

    @Override
    protected IOutput getOutput() {
        return new DIIntegrateOutPut(this._ctx);
    }

    private StdMdRow getStdMdRow(Row row, RowMeta rowMeta) {
        StdMdRow mdRow = new StdMdRow();
        for (Field field : rowMeta.getFields()) {
            Object v = row.get(field.getName());
            if (v == null || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)v.toString())) continue;
            mdRow.put(field.getName().substring(1), v);
        }
        return mdRow;
    }

    private void writeTables(List<Map<String, Object>> matchDatas, StdMdRow mdRow) {
        matchDatas.forEach(d -> {
            d.put("idnew", GlobalIdUtil.genGlobalLongId());
            if (!ConfigServiceHelper.getGlobalBoolParam("di_notWriteMappingTrace")) {
                this.writeMappingTable((Map<String, Object>)d, this.executeId);
            }
            this.writeCheckTable((Map<String, Object>)d, mdRow);
        });
    }

    private void writeTablesFinal() {
        if (!ConfigServiceHelper.getGlobalBoolParam("di_notWriteMappingTrace")) {
            this.writeMappingTableFinal();
        }
        this.writeCheckTableFinal();
    }

    private void writeCheckTableFinal() {
        if (this.obParamsCheckTable.size() <= 0) {
            return;
        }
        List<String> fields = this.getCheckTableField();
        ArrayList<String> allSrcDims = new ArrayList<String>(this._ctx.getAllSrcDim());
        fields.addAll(allSrcDims.stream().map(dim -> dim.toLowerCase() + S_SUFFIX).collect(Collectors.toList()));
        ArrayList<String> insertFields = new ArrayList<String>(fields.size());
        fields.forEach(f -> insertFields.add("f" + f));
        this.insertData(this.obParamsCheckTable, insertFields, this.convertTable);
        this.obParamsCheckTable.clear();
    }

    private void writeMappingTableFinal() {
        if (this.obParamsMappingTable.size() <= 0) {
            return;
        }
        List<String> insertFields = Arrays.asList("fid", "fexeid", "fmatchdataid", "fmappingid", "fyearnum", "fperiodnum");
        this.insertData(this.obParamsMappingTable, insertFields, "t_di_mappingtrace");
        this.obParamsMappingTable.clear();
    }

    private void writeMappingTable(Map<String, Object> matchData, Long executeId) {
        if (!((Boolean)matchData.get("matchingstatus")).booleanValue()) {
            return;
        }
        long id = GlobalIdUtil.genGlobalLongId();
        List<String> fields = Arrays.asList("id", "exeid", "matchdataid", "mappingid", "yearnum", "periodnum");
        StringBuilder sbMappingId = new StringBuilder();
        ((Iterable)matchData.remove("mappingid")).forEach(mappingId -> sbMappingId.append(mappingId.toString()).append(";"));
        ArrayList<Object> l = new ArrayList<Object>(fields.size());
        l.add(id);
        l.add(executeId);
        l.add(matchData.get("idnew"));
        l.add(sbMappingId.substring(0, sbMappingId.length() - 1));
        l.add(this._ctx.getFy().p2);
        l.add(this._ctx.getPeriod().p2);
        this.obParamsMappingTable.add(l.toArray());
        if (this.obParamsMappingTable.size() < this.insertSizeOnece) {
            return;
        }
        ArrayList<String> insertFields = new ArrayList<String>(fields.size());
        fields.forEach(f -> insertFields.add("f" + f));
        this.insertData(this.obParamsMappingTable, insertFields, "t_di_mappingtrace");
        this.obParamsMappingTable.clear();
    }

    private List<String> getCheckTableField() {
        ArrayList<String> fields = new ArrayList<String>(20);
        this.allDim.forEach(dim -> fields.add(dim.toLowerCase() + T_SUFFIX));
        fields.add("idnew");
        fields.add("impid");
        fields.add("matchingstatus");
        fields.add("msg");
        fields.add("executeid");
        fields.add(this.singleMetric + S_SUFFIX);
        fields.add(this.singleMetric + FILED_SUM + S_SUFFIX);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.textMetric)) {
            fields.add(this.textMetric + S_SUFFIX);
            fields.add(this.textMetric + FILED_SUM + S_SUFFIX);
        }
        fields.add("traceid");
        fields.add("olapstatus");
        return fields;
    }

    private void writeCheckTable(Map<String, Object> matchData, StdMdRow mdRow) {
        List<String> fields = this.getCheckTableField();
        int idx_olap = fields.size() - 1;
        ArrayList<String> allSrcDims = new ArrayList<String>(this._ctx.getAllSrcDim());
        Recorder need = new Recorder((Object)true);
        matchData.put("executeid", this.executeId);
        ArrayList<Object> l = new ArrayList<Object>(fields.size() * 2);
        fields.forEach(f -> {
            if (f.equalsIgnoreCase("olapstatus")) {
                l.add(null);
            } else if (f.equalsIgnoreCase(this.singleMetric + FILED_SUM + S_SUFFIX)) {
                l.add(matchData.get(this.singleMetric + S_SUFFIX));
            } else if (f.equalsIgnoreCase(this.textMetric + FILED_SUM + S_SUFFIX)) {
                l.add(matchData.get(this.textMetric + S_SUFFIX));
            } else if (f.equalsIgnoreCase("traceid")) {
                if (((Boolean)matchData.get("matchingstatus")).booleanValue() && matchData.get("msg") == null) {
                    l.add(matchData.get("idnew"));
                } else {
                    l.add(null);
                }
            } else if (f.equalsIgnoreCase(this.singleMetric + S_SUFFIX) || f.equalsIgnoreCase(this.textMetric + S_SUFFIX)) {
                l.add(matchData.get(f));
            } else {
                Object obj = matchData.get(f);
                if ((ObjectUtils.isEmpty(obj) || IGNORE.equalsIgnoreCase(obj.toString())) && f.endsWith(T_SUFFIX) || "matchingstatus".equals(f) && !((Boolean)obj).booleanValue()) {
                    need.setRecord((Object)false);
                }
                l.add(obj);
            }
        });
        l.set(idx_olap, need.getRecord());
        allSrcDims.forEach(f -> l.add(mdRow.get(f.toLowerCase())));
        this.obParamsCheckTable.add(l.toArray());
        if (this.obParamsCheckTable.size() < this.insertSizeOnece) {
            return;
        }
        fields.addAll(allSrcDims.stream().map(dim -> dim.toLowerCase() + S_SUFFIX).collect(Collectors.toList()));
        ArrayList<String> insertFields = new ArrayList<String>(fields.size());
        fields.forEach(f -> insertFields.add("f" + f));
        this.insertData(this.obParamsCheckTable, insertFields, this.convertTable);
        this.obParamsCheckTable.clear();
    }

    private void handleSums() {
        String sumSql = this.buildSumSql();
        this.getSumDataSet(sumSql);
    }

    private void getSumDataSet(String sumSql) {
        Set<String> allTarDimLow = this.getAllTarDimLow();
        HashMap<String, Map<String, Object>> sumDataSet = new HashMap<String, Map<String, Object>>();
        try (DataSet dataSet = DB.queryDataSet((String)this.convertTable, (DBRoute)BCMConstant.DBROUTE, (String)sumSql);){
            StringBuilder sb = new StringBuilder();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, String> tempSumMap = new HashMap<String, String>();
                HashMap<String, Object> sumMap = new HashMap<String, Object>();
                for (Field field : dataSet.getRowMeta().getFields()) {
                    if ("summoney".equalsIgnoreCase(field.getName())) {
                        sumMap.put("summoney", row.get(field.getName()));
                        continue;
                    }
                    if ("maxtext".equalsIgnoreCase(field.getName())) {
                        sumMap.put("maxtext", row.get(field.getName()));
                        continue;
                    }
                    if ("maxfid".equalsIgnoreCase(field.getName())) {
                        sumMap.put("maxfid", row.get(field.getName()));
                        continue;
                    }
                    String fieldName = field.getName().substring(1, field.getName().length() - 2);
                    if (!allTarDimLow.contains(fieldName)) continue;
                    tempSumMap.put(fieldName.toLowerCase(), (String)row.get(field.getName()));
                }
                for (String dim : this.allDim) {
                    sb.append((String)tempSumMap.get(dim.toLowerCase()));
                }
                sumDataSet.put(sb.toString(), sumMap);
                sb.setLength(0);
                if (sumDataSet.size() <= 40000) continue;
                String dataSql = this.buildDataSql();
                this.setGroupids(sumDataSet, dataSql);
                this.updateSumData(sumDataSet);
                sumDataSet.clear();
            }
        }
        if (sumDataSet.size() > 0) {
            String dataSql = this.buildDataSql();
            this.setGroupids(sumDataSet, dataSql);
            this.updateSumData(sumDataSet);
            sumDataSet.clear();
        }
    }

    private String buildDataSql() {
        Set<String> allTarDim = this._ctx.getAllTarDim();
        StringBuilder sb = new StringBuilder();
        sb.append("select");
        for (String str : allTarDim) {
            sb.append(" f").append(str).append(T_SUFFIX).append(",");
        }
        sb.append(" fidnew");
        sb.append(" from ").append(this.convertTable);
        sb.append(" where fexecuteid = ").append(this.executeId);
        sb.append(" and fmatchingstatus = '1'");
        return sb.toString().toLowerCase();
    }

    private String buildSumSql() {
        Set<String> allTarDim = this._ctx.getAllTarDim();
        StringBuilder sb = new StringBuilder();
        sb.append("select max(fidnew) as maxfid,");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.singleMetric)) {
            sb.append(" sum(").append("f").append(this.singleMetric).append(S_SUFFIX).append(") as summoney,");
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.textMetric)) {
            sb.append(" max(").append("f").append(this.textMetric).append(S_SUFFIX).append(") as maxtext,");
        }
        for (String str : allTarDim) {
            sb.append(" f").append(str).append(T_SUFFIX).append(",");
        }
        sb.append(" count(*)");
        sb.append(" from ").append(this.convertTable);
        sb.append(" where fexecuteid = ").append(this.executeId);
        sb.append(" and fmatchingstatus = '1'");
        sb.append(" and fmsg is null ");
        sb.append(" group by ");
        int index = 0;
        for (String str : allTarDim) {
            if (++index == allTarDim.size()) {
                sb.append(" f").append(str).append(T_SUFFIX);
                continue;
            }
            sb.append(" f").append(str).append(T_SUFFIX).append(",");
        }
        sb.append(" having count(*) > 1");
        return sb.toString().toLowerCase();
    }

    private void setGroupids(Map<String, Map<String, Object>> dataMap, String dataSql) {
        Set<String> allTarDimLow = this.getAllTarDimLow();
        try (DataSet dataSet = DB.queryDataSet((String)this.convertTable, (DBRoute)BCMConstant.DBROUTE, (String)dataSql);){
            StringBuilder sb = new StringBuilder();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, String> tempSumMap = new HashMap<String, String>();
                Long idnew = 0L;
                for (Field field : dataSet.getRowMeta().getFields()) {
                    if ("fidnew".equalsIgnoreCase(field.getName())) {
                        idnew = (Long)row.get(field.getName());
                        continue;
                    }
                    String fieldName = field.getName().substring(1, field.getName().length() - 2).toLowerCase();
                    if (!allTarDimLow.contains(fieldName)) continue;
                    tempSumMap.put(fieldName.toLowerCase(), (String)row.get(field.getName()));
                }
                for (String dim : this.allDim) {
                    sb.append((String)tempSumMap.get(dim.toLowerCase()));
                }
                String key = sb.toString();
                sb.setLength(0);
                if (!dataMap.containsKey(key)) continue;
                dataMap.get(key).put("groupids", dataMap.get(key).get("groupids") == null ? "" + idnew : dataMap.get(key).get("groupids") + "," + idnew);
            }
        }
    }

    private Set<String> getAllTarDimLow() {
        Set<String> allTarDim = this._ctx.getAllTarDim();
        return allTarDim.stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    private void updateSumData(Map<String, Map<String, Object>> dataSet) {
        Iterator<Map.Entry<String, Map<String, Object>>> iterator = dataSet.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Map<String, Object>> next = iterator.next();
            Map<String, Object> value = next.getValue();
            String updateSql = this.buildUpdateSql(value);
            DB.execute((DBRoute)BCMConstant.DBROUTE, (String)updateSql);
            iterator.remove();
        }
    }

    private String buildUpdateSql(Map<String, Object> value) {
        BigDecimal summoney = (BigDecimal)value.get("summoney");
        String maxtext = (String)value.get("maxtext");
        Long maxfid = (Long)value.get("maxfid");
        String groupids = (String)value.get("groupids");
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(this.convertTable);
        sb.append(" set ftraceid").append(" = ").append(maxfid);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.singleMetric)) {
            sb.append(",f").append(this.singleMetric).append(FILED_SUM).append(S_SUFFIX).append(" = ").append(summoney.toPlainString());
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.textMetric)) {
            sb.append(",f").append(this.textMetric).append(FILED_SUM).append(S_SUFFIX).append(" = '").append(maxtext).append("'");
        }
        sb.append(" where fidnew in (").append(groupids).append(");");
        return sb.toString();
    }

    private void outputData() {
        String saveSql = this.buildSaveSql();
        this.prapara4Output(saveSql);
    }

    private void clearData() {
        List<Map<String, String>> specialDimMembers = this.getSpecialDimMembers();
        String clearDataScope = DIIntegrationUtil.clearDataByImportMode(this._ctx.getModel(), this._ctx.getSchema(), specialDimMembers);
        this._ctx.putCustomParam("clearDataScope", clearDataScope);
    }

    private List<Map<String, String>> getSpecialDimMembers() {
        String clearSql = this.buildClearSql();
        ArrayList<Map<String, String>> specialDimMembers = new ArrayList<Map<String, String>>();
        try (DataSet dataSet = DB.queryDataSet((String)this.convertTable, (DBRoute)BCMConstant.DBROUTE, (String)clearSql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, String> tempSumMap = new HashMap<String, String>(16);
                HashMap<String, String> specialMap = new HashMap<String, String>(16);
                for (Field field : dataSet.getRowMeta().getFields()) {
                    tempSumMap.put(field.getName().toLowerCase(), (String)row.get(field.getName()));
                }
                for (String dim : specialDim4Clear) {
                    specialMap.put(dim, (String)tempSumMap.get(("f" + dim + T_SUFFIX).toLowerCase()));
                }
                this.turnDcEc(specialMap);
                specialDimMembers.add(specialMap);
            }
        }
        return specialDimMembers;
    }

    private void turnDcEc(Map<String, String> specialMap) {
        String currency = specialMap.get(DimEntityNumEnum.CURRENCY.getNumber());
        if (CurrencyEnum.EC.getNumber().equals(currency) || CurrencyEnum.DC.getNumber().equals(currency)) {
            currency = MemberReader.findEntityMemberByNum((String)((String)this._ctx.getModel().p2), (String)((String)this._ctx.getOrg().p2)).getCurrency();
            specialMap.put(DimEntityNumEnum.CURRENCY.getNumber(), currency);
        }
    }

    private String buildClearSql() {
        return "select distinct fcurrency_t,fentity_t,fyear_t,fprocess_t,fperiod_t,fscenario_t from  " + this.convertTable + "  where fexecuteid = " + this.executeId + " and fmatchingstatus = '1' and fidnew = ftraceid";
    }

    private String buildSaveSql() {
        Set<String> allTarDim = this._ctx.getAllTarDim();
        StringBuilder sb = new StringBuilder();
        sb.append("select");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.singleMetric)) {
            sb.append(" f").append(this.singleMetric).append(FILED_SUM).append(S_SUFFIX).append(",");
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.textMetric)) {
            sb.append(" f").append(this.textMetric).append(FILED_SUM).append(S_SUFFIX).append(",");
        }
        for (String str : allTarDim) {
            sb.append(" f").append(str).append(T_SUFFIX).append(",");
        }
        sb.append(" fidnew");
        sb.append(" from ").append(this.convertTable);
        sb.append(" where fexecuteid = ").append(this.executeId);
        sb.append(" and fmatchingstatus = '1'");
        sb.append(" and fidnew = ftraceid");
        return sb.toString().toLowerCase();
    }

    private void prapara4Output(String saveSql) {
        ValueList valueList = this._ctx.getValueList();
        valueList.getValueList().clear();
        HashMap<String, DataTypeCacheInfo> cachemap = new HashMap<String, DataTypeCacheInfo>(16);
        try (DataSet dataSet = DB.queryDataSet((String)this.convertTable, (DBRoute)BCMConstant.DBROUTE, (String)saveSql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                valueList.addValue(this.getValueItem(dataSet, row, cachemap));
                if (valueList.getValueList().size() < this.insertSizeOnece) continue;
                this._ctx.setValueList(valueList);
                this._ctx.putCustomParam(DIContextParam.NOT_NEED_CLEARDATA, true);
                this._output.output();
                valueList.getValueList().clear();
            }
        }
        this._ctx.setValueList(valueList);
        this._ctx.putCustomParam(DIContextParam.NOT_NEED_CLEARDATA, true);
        this._output.output();
        valueList.getValueList().clear();
    }

    private IValueItem getValueItem(DataSet dataSet, Row row, HashMap<String, DataTypeCacheInfo> cachemap) {
        ValueItem valueItem = new ValueItem();
        HashMap<String, Object> tempSumMap = new HashMap<String, Object>(16);
        for (Field field : dataSet.getRowMeta().getFields()) {
            tempSumMap.put(field.getName().toLowerCase(), row.get(field.getName()));
        }
        HashMap<String, String> dim2Members = new HashMap<String, String>(16);
        for (String dim : this.allDim) {
            valueItem.setProperty(dim, tempSumMap.get(("f" + dim + T_SUFFIX).toLowerCase()));
            dim2Members.put(dim, tempSumMap.get(("f" + dim + T_SUFFIX).toLowerCase()).toString());
        }
        DataTypeEnum type = DataTypeUtil.getDataTypeThreadCache((Long)this._ctx.getModel().p1, dim2Members, cachemap);
        Object sumMoney = tempSumMap.get(("f" + this.singleMetric + FILED_SUM + S_SUFFIX).toLowerCase());
        Object sumText = tempSumMap.get(("f" + this.textMetric + FILED_SUM + S_SUFFIX).toLowerCase());
        Long traceId = (Long)tempSumMap.get("fidnew");
        if (DataTypeEnum.CURRENCY == type || DataTypeEnum.DEFAULT == type || DataTypeEnum.UNCURRENCY == type || DataTypeEnum.PROPORTION == type) {
            valueItem.setValue(sumMoney);
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.textMetric)) {
            valueItem.setValue(sumText);
        }
        valueItem.setProperty("idnew", traceId);
        return valueItem;
    }

    private Integer getDataCount() {
        String sqlCount = "select count(*) as c1 from " + this.importTable + " where fexecuteid = " + this.executeId;
        return (Integer)DB.query((DBRoute)BCMConstant.DBROUTE, (String)sqlCount, rs1 -> {
            while (rs1.next()) {
                if (rs1.getInt("C1") <= -1) continue;
                return rs1.getInt("C1");
            }
            return 0;
        });
    }
}

