/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.integration.di.service.IDIExportService;
import kd.fi.bcm.business.integration.mapping.Tuple;
import kd.fi.bcm.business.integration.model.MemMapExportColProperty;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DIMemberMapExportImp
implements IDIExportService {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DIMemberMapExportImp.class);
    protected static final String calculateNumber = "computeoprt";
    protected static final String weightNumber = "weight";
    protected static final String orderNumber = "order";
    protected static final String levelNumber = "level";
    protected static final String add = "+";
    protected static final String sub = "-";
    protected List<String> errorMsgCollection = new ArrayList<String>(16);

    public XSSFWorkbook exportData(Long diSchemeId, String modelNumber) {
        List<Long> dimMapIds = Arrays.stream(this.getDimMaps(diSchemeId)).map(x -> x.getLong("id")).collect(Collectors.toList());
        return this.exportData(diSchemeId, modelNumber, dimMapIds);
    }

    @Override
    public XSSFWorkbook exportData(Long diSchemeId, String modelNumber, List<Long> dimMapIds) {
        DynamicObject[] dimMappings;
        XSSFWorkbook workBook = new XSSFWorkbook();
        for (DynamicObject dimMapping : dimMappings = this.getDimMaps(diSchemeId)) {
            DynamicObject[] groupMapping;
            if (!dimMapIds.contains(dimMapping.getLong("id"))) continue;
            String dimName = dimMapping.getString("name");
            String sheetName = this.getDimmappingTypeCode(dimMapping.getInt("mappedtype")) + "|" + dimName;
            if (this.isExitsSheetName(workBook, sheetName)) {
                this.errorMsgCollection.add(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u201c%1$s\u201d\u7684\u540d\u79f0\u622a\u53d6\u540e\u5df2\u5b58\u5728\u4e8e\u5de5\u4f5c\u7c3f\u4e2d\uff0c\u5df2\u81ea\u52a8\u5ffd\u7565\u8be5\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"DIDimMemImpAndExpService21", (String)"fi-bcm-business", (Object[])new Object[0]), dimName));
                continue;
            }
            XSSFSheet sheet = workBook.createSheet(sheetName);
            HashMap<String, MemMapExportColProperty> colProperties = this.getColHeadMap(dimMapping);
            this.renderHead(colProperties, sheet);
            this.setAutoSizeColumn(sheet, 1);
            Integer dataStartIndex = 2;
            for (DynamicObject row : groupMapping = this.getMemberMapData(diSchemeId, dimMapping.getLong("id"))) {
                Integer n = dataStartIndex;
                Integer n2 = dataStartIndex = Integer.valueOf(dataStartIndex + 1);
                XSSFRow currentRow = sheet.createRow(n.intValue());
                Map<String, DynamicObject> targetEntryMap = row.getDynamicObjectCollection("isgrouptargmapentry").stream().collect(Collectors.toMap(x -> x.getString("tardimension"), x -> x, (v1, v2) -> v1));
                Map<String, List> srcEntryMap = row.getDynamicObjectCollection("isgroupsrcmapentry").stream().collect(Collectors.toMap(x -> x.getString("srcdimension"), x -> {
                    ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(1);
                    result.add((DynamicObject)x);
                    return result;
                }, (v1, v2) -> {
                    v1.addAll(v2);
                    return v1;
                }));
                for (Map.Entry<String, MemMapExportColProperty> colProperty : colProperties.entrySet()) {
                    XSSFCell cell = currentRow.createCell(Integer.parseInt(colProperty.getKey()));
                    if (colProperty.getValue().isNum()) {
                        cell.setCellType(CellType.NUMERIC);
                    }
                    if (colProperty.getValue().getFieldType() == 0) {
                        this.setCellValueByProperty(cell, row, colProperty.getValue());
                        continue;
                    }
                    if (colProperty.getValue().getFieldType() == 1) {
                        DynamicObject targetMem = targetEntryMap.get(colProperty.getValue().getDimId().toString());
                        this.setTarCellValueByProperty(cell, targetMem, colProperty.getValue());
                        continue;
                    }
                    if (colProperty.getValue().getFieldType() != 2) continue;
                    List srcgetMem = srcEntryMap.get(colProperty.getValue().getDimId().toString());
                    this.setSrcCellValueByProperty(cell, srcgetMem, colProperty.getValue());
                }
            }
        }
        return workBook;
    }

    @Override
    public XSSFWorkbook exportTemplate(Long diSchemeId) {
        DynamicObject[] dimMappings;
        XSSFWorkbook workBook = new XSSFWorkbook();
        for (DynamicObject dimMapping : dimMappings = this.getDimMaps(diSchemeId)) {
            XSSFSheet sheet = workBook.createSheet(dimMapping.getString("name"));
            HashMap<String, MemMapExportColProperty> colProperties = this.getColHeadMap(dimMapping);
            this.renderHead(colProperties, sheet);
            this.setAutoSizeColumn(sheet, 1);
        }
        return workBook;
    }

    protected String getDimmappingTypeCode(int type) {
        if (type == 4) {
            return "C";
        }
        if (type == 5) {
            return "S";
        }
        if (type == 6) {
            return "SP";
        }
        return "O";
    }

    protected void setCellValueByProperty(XSSFCell cell, DynamicObject source, MemMapExportColProperty colProperty) {
        if (colProperty.getNumber().equals(calculateNumber)) {
            String value = source.getString(colProperty.getNumber());
            value = value.equals("-1") ? sub : add;
            cell.setCellValue(value);
        } else if (colProperty.isNum()) {
            cell.setCellValue(source.getBigDecimal(colProperty.getNumber()).doubleValue());
        } else {
            cell.setCellValue(source.getString(colProperty.getNumber()));
        }
    }

    protected void setTarCellValueByProperty(XSSFCell cell, DynamicObject targetMem, MemMapExportColProperty colProperty) {
        if (null != targetMem) {
            if (colProperty.isNameCol()) {
                String memName = targetMem.getString("tarmembname");
                cell.setCellValue(memName);
            } else {
                String memNumber = targetMem.getString("tarmembnumber");
                cell.setCellValue(memNumber);
            }
        }
    }

    protected void setSrcCellValueByProperty(XSSFCell cell, List<DynamicObject> srcgetMem, MemMapExportColProperty colProperty) {
        if (null != srcgetMem && srcgetMem.size() > 0) {
            if (colProperty.isNameCol()) {
                Optional<String> SrcName = srcgetMem.stream().map(x -> x.getString("srcmembname")).findFirst();
                if (SrcName.isPresent()) {
                    cell.setCellValue(SrcName.get());
                }
            } else {
                List<String> SrcNumbers = srcgetMem.stream().map(x -> x.getString("srcmembnumber")).collect(Collectors.toList());
                cell.setCellValue(this.restoreSrcMember(SrcNumbers, MapScopeEnum.getEnumByindex((int)srcgetMem.get(0).getInt("scope"))));
            }
        }
    }

    protected void renderHead(HashMap<String, MemMapExportColProperty> colProperties, XSSFSheet sheet) {
        Integer rowStartIndex;
        Integer n = rowStartIndex = Integer.valueOf(0);
        Integer n2 = rowStartIndex = Integer.valueOf(rowStartIndex + 1);
        XSSFRow headRowMerge = sheet.createRow(n.intValue());
        n2 = rowStartIndex;
        Integer n3 = rowStartIndex = Integer.valueOf(rowStartIndex + 1);
        XSSFRow headRow = sheet.createRow(n2.intValue());
        CellStyle cellStyle = this.createHeaderCellStyle(sheet.getWorkbook());
        Tuple<Integer, Integer> tarMergeRange = new Tuple<Integer, Integer>(-1, -1);
        Tuple<Integer, Integer> srcMergeRange = new Tuple<Integer, Integer>(-1, -1);
        for (Map.Entry<String, MemMapExportColProperty> entry : colProperties.entrySet()) {
            int colIndex = Integer.parseInt(entry.getKey());
            XSSFCell mergeCell = headRowMerge.createCell(colIndex);
            mergeCell.setCellStyle(cellStyle);
            XSSFCell cell = headRow.createCell(colIndex);
            cell.setCellStyle(cellStyle);
            if (entry.getValue().getFieldType() == 0) {
                sheet.addMergedRegion(new CellRangeAddress(0, 1, colIndex, colIndex));
                mergeCell.setCellValue(entry.getValue().getName());
            } else if (entry.getValue().getFieldType() == 1) {
                if (tarMergeRange.getF() == -1 || colIndex < tarMergeRange.getF()) {
                    tarMergeRange.setF(colIndex);
                }
                if (tarMergeRange.getB() == -1 || colIndex > tarMergeRange.getB()) {
                    tarMergeRange.setB(colIndex);
                }
                cell.setCellValue(entry.getValue().getName());
            } else if (entry.getValue().getFieldType() == 2) {
                if (srcMergeRange.getF() == -1 || colIndex < srcMergeRange.getF()) {
                    srcMergeRange.setF(colIndex);
                }
                if (srcMergeRange.getB() == -1 || colIndex > srcMergeRange.getB()) {
                    srcMergeRange.setB(colIndex);
                }
                cell.setCellValue(entry.getValue().getName());
            }
            XSSFCellStyle cellDataStyle = sheet.getWorkbook().createCellStyle();
            XSSFDataFormat format = sheet.getWorkbook().createDataFormat();
            cellDataStyle.setDataFormat(format.getFormat(this.getDataFormate(entry.getValue())));
            sheet.setDefaultColumnStyle(colIndex, (CellStyle)cellDataStyle);
            if (!entry.getValue().getNumber().equals(calculateNumber)) continue;
            String[] calItems = new String[]{add, sub};
            XSSFDataValidationHelper helper = new XSSFDataValidationHelper(sheet);
            XSSFDataValidationConstraint constraint = (XSSFDataValidationConstraint)helper.createExplicitListConstraint(calItems);
            CellRangeAddressList regions = new CellRangeAddressList(2, 10000, colIndex, colIndex);
            XSSFDataValidation validation = (XSSFDataValidation)helper.createValidation((DataValidationConstraint)constraint, regions);
            validation.setSuppressDropDownArrow(true);
            validation.setShowErrorBox(true);
            sheet.addValidationData((DataValidation)validation);
        }
        if (tarMergeRange.getF() != tarMergeRange.getB()) {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, tarMergeRange.getF().intValue(), tarMergeRange.getB().intValue()));
        }
        headRowMerge.getCell(tarMergeRange.getF().intValue()).setCellValue(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf", (String)"DIDimMemImpAndExpService2", (String)"fi-bcm-business", (Object[])new Object[0]));
        if (srcMergeRange.getF() != tarMergeRange.getB()) {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, srcMergeRange.getF().intValue(), srcMergeRange.getB().intValue()));
        }
        headRowMerge.getCell(srcMergeRange.getF().intValue()).setCellValue(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf", (String)"DIDimMemImpAndExpService8", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    protected HashMap<String, MemMapExportColProperty> getColHeadMap(DynamicObject dimMapping) {
        HashMap<String, MemMapExportColProperty> colHeadMap = new HashMap<String, MemMapExportColProperty>(16);
        int cursor = 0;
        int mapType = dimMapping.getInt("mappedtype");
        if (mapType != 4 && mapType != 6) {
            colHeadMap.put(Integer.toString(cursor++), new MemMapExportColProperty(levelNumber, ResManager.loadKDString((String)"\u4f18\u5148\u7ea7", (String)"DIDimMemImpAndExpService9", (String)"fi-bcm-business", (Object[])new Object[0]), true));
        }
        if (mapType != 6) {
            colHeadMap.put(Integer.toString(cursor++), new MemMapExportColProperty(orderNumber, ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f", (String)"DIDimMemImpAndExpService10", (String)"fi-bcm-business", (Object[])new Object[0]), true));
        }
        DynamicObjectCollection tars = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
        boolean isExistAccountDim = false;
        for (DynamicObject tar : tars) {
            String tarName = tar.getDynamicObject("tagdimension").getString("name");
            String tarNumber = tar.getDynamicObject("tagdimension").getString("number");
            if (tarNumber.equals("Account")) {
                isExistAccountDim = true;
            }
            Long tarDimId = tar.getDynamicObject("tagdimension").getLong("id");
            colHeadMap.put(Integer.toString(cursor++), new MemMapExportColProperty(tarNumber, String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u7f16\u7801", (String)"DIDimMemImpAndExpService11", (String)"fi-bcm-business", (Object[])new Object[0]), tarName), 1, tarDimId, false));
            colHeadMap.put(Integer.toString(cursor++), new MemMapExportColProperty(tarNumber, String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u540d\u79f0", (String)"DIDimMemImpAndExpService12", (String)"fi-bcm-business", (Object[])new Object[0]), tarName), 1, tarDimId, true));
        }
        if (isExistAccountDim) {
            colHeadMap.put(Integer.toString(cursor++), new MemMapExportColProperty(calculateNumber, ResManager.loadKDString((String)"\u8ba1\u7b97\u5173\u7cfb", (String)"DIDimMemImpAndExpService13", (String)"fi-bcm-business", (Object[])new Object[0])));
            colHeadMap.put(Integer.toString(cursor++), new MemMapExportColProperty(weightNumber, ResManager.loadKDString((String)"\u6743\u91cd", (String)"DIDimMemImpAndExpService14", (String)"fi-bcm-business", (Object[])new Object[0]), true));
        }
        DynamicObjectCollection srcs = dimMapping.getDynamicObjectCollection("isdimmapsrcentry");
        for (DynamicObject src : srcs) {
            String srcName = src.getDynamicObject("srcdimension").getString("name");
            String srcNumber = src.getDynamicObject("srcdimension").getString("number");
            Long srcDimId = src.getDynamicObject("srcdimension").getLong("id");
            colHeadMap.put(Integer.toString(cursor++), new MemMapExportColProperty(srcNumber, String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u7f16\u7801", (String)"DIDimMemImpAndExpService11", (String)"fi-bcm-business", (Object[])new Object[0]), srcName), 2, srcDimId, false));
            colHeadMap.put(Integer.toString(cursor++), new MemMapExportColProperty(srcNumber, String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u540d\u79f0", (String)"DIDimMemImpAndExpService12", (String)"fi-bcm-business", (Object[])new Object[0]), srcName), 2, srcDimId, true));
        }
        return colHeadMap;
    }

    protected CellStyle createHeaderCellStyle(XSSFWorkbook workBook) {
        XSSFCellStyle headerStyle = workBook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerStyle.setBorderTop(BorderStyle.THIN);
        headerStyle.setBorderRight(BorderStyle.THIN);
        headerStyle.setBorderBottom(BorderStyle.THIN);
        headerStyle.setBorderLeft(BorderStyle.THIN);
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerStyle.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
        headerStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        headerStyle.setLocked(true);
        return headerStyle;
    }

    protected void setAutoSizeColumn(XSSFSheet sheet, int headRowIndex) {
        int lastCellNum = sheet.getRow(headRowIndex).getLastCellNum();
        for (int i = 0; i <= lastCellNum; ++i) {
            int maxColSize = sheet.getColumnWidth(i);
            XSSFCell cell = sheet.getRow(headRowIndex).getCell(i);
            if (cell == null) continue;
            int colSize = cell.getStringCellValue().getBytes().length * 256 + 512;
            if (colSize > maxColSize) {
                maxColSize = colSize;
            }
            if (maxColSize > 65280) {
                maxColSize = 65280;
            }
            sheet.setColumnWidth(i, maxColSize);
        }
    }

    public String restoreSrcMember(List<String> srcTexts, MapScopeEnum scopeType) {
        if (srcTexts.size() == 0) {
            return "";
        }
        String srcInnerText = String.join((CharSequence)",", srcTexts);
        if (scopeType.getNumber().equals(MapScopeEnum.EQUALS.getNumber())) {
            return srcInnerText;
        }
        if (scopeType.getNumber().equals(MapScopeEnum.RANGE.getNumber())) {
            return "between(" + srcInnerText + ")";
        }
        if (scopeType.getNumber().equals(MapScopeEnum.LIKE.getNumber())) {
            return "like(" + srcInnerText + ")";
        }
        if (scopeType.getNumber().equals(MapScopeEnum.INCLUDE.getNumber())) {
            return "in(" + srcInnerText + ")";
        }
        if (scopeType.getNumber().equals(MapScopeEnum.NOT_EQUALS.getNumber())) {
            return "notequals(" + srcInnerText + ")";
        }
        if (scopeType.getNumber().equals(MapScopeEnum.NOT_RANGE.getNumber())) {
            return "notbetween(" + srcInnerText + ")";
        }
        if (scopeType.getNumber().equals(MapScopeEnum.NOT_LIKE.getNumber())) {
            return "notlike(" + srcInnerText + ")";
        }
        if (scopeType.getNumber().equals(MapScopeEnum.NOT_INCLUDE.getNumber())) {
            return "notin(" + srcInnerText + ")";
        }
        return srcInnerText;
    }

    protected DynamicObject[] getDimMaps(Long schemeId) {
        String selectField = "id,name,number,sequence,mappedtype,isdimmaptargentry.tagdimension,isdimmaptargentry.tagdimtype,isdimmapsrcentry.srcdimension,isdimmapsrcentry.srcdimtype";
        QFilter qFilter = new QFilter("scheme.id", "=", (Object)LongUtil.toLong((Object)schemeId));
        qFilter.and(new QFilter("isdimmapsrcentry.id", "!=", null));
        return BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)selectField, (QFilter[])qFilter.toArray());
    }

    protected DynamicObject[] getMemberMapData(Long schemeId, Long dimMapId) {
        String dataSelectField = "srctype,level,order,weight,computeoprt,isgrouptargmapentry,isgrouptargmapentry.tardimension,isgrouptargmapentry.tarmember,isgrouptargmapentry.tarmembnumber,isgrouptargmapentry.tarmembname,isgroupsrcmapentry,isgroupsrcmapentry.seq,isgroupsrcmapentry.srcdimension,isgroupsrcmapentry.srcmember,isgroupsrcmapentry.srcmembnumber,isgroupsrcmapentry.scope,isgroupsrcmapentry.srcmembname";
        QFilter qf = new QFilter("schemeid", "=", (Object)schemeId);
        qf.and(new QFilter("dimmapid", "=", (Object)dimMapId));
        return BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)dataSelectField, (QFilter[])new QFilter[]{qf}, (String)"dseq asc,isgroupsrcmapentry.seq");
    }

    private String getDataFormate(MemMapExportColProperty colProperty) {
        String filedNumber = colProperty.getNumber();
        if (filedNumber.equals(levelNumber) || filedNumber.equals(weightNumber) || filedNumber.equals(orderNumber)) {
            return "0";
        }
        return "@";
    }

    private boolean isExitsSheetName(XSSFWorkbook book, String dimName) {
        String name = dimName;
        if (name.length() > 31) {
            name = name.substring(0, 31);
        }
        for (int i = 0; i < book.getNumberOfSheets(); ++i) {
            String ctName = book.getSheetAt(i).getSheetName();
            if (!ctName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public List<String> getErrors() {
        return this.errorMsgCollection;
    }
}

