/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.di.service.IDIImportService;
import kd.fi.bcm.business.integration.model.ImportFailData;
import kd.fi.bcm.business.integration.model.MemMapExportColProperty;
import kd.fi.bcm.business.integration.model.MembMapImportDTO;
import kd.fi.bcm.business.integration.model.MembMapImportRowDTO;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DIMemberMapImportImp
implements IDIImportService {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DIMemberMapImportImp.class);
    protected Integer successCount = 0;
    protected List<Object> errorMsgCollection = new ArrayList<Object>(16);
    protected static final String calculateNumber = "computeoprt";
    protected static final String weightNumber = "weight";
    protected static final String orderNumber = "order";
    protected static final String levelNumber = "level";
    protected static final String add = "+";
    protected static final String sub = "-";
    protected static final double defaultWeightValue = 1.0;

    @Override
    public void importData(String excelUrl, long schemeId, String modelNumber, List<Long> dimMapIds, boolean deleteBeforeSave) {
        if (dimMapIds.size() == 0) {
            return;
        }
        DynamicObject[] dimMappings = this.getDimMaps(schemeId);
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = service.getInputStream(excelUrl);){
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);
            for (int i = 0; i < xssfWorkbook.getNumberOfSheets(); ++i) {
                boolean isSimpleMap;
                XSSFSheet sheet = xssfWorkbook.getSheetAt(i);
                String mapName = sheet.getSheetName();
                List MapObjs = Arrays.stream(dimMappings).filter(x -> this.convertDimMapNameToSheetName(x.getString("name"), x.getInt("mappedtype")).equals(mapName)).collect(Collectors.toList());
                if (MapObjs.size() == 0) {
                    this.addErrorMsg(mapName, 0, ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u4fe1\u606f\u672a\u627e\u5230\u3002", (String)"DIDimMemImpAndExpService1", (String)"fi-bcm-business", (Object[])new Object[0]));
                    continue;
                }
                Optional<DynamicObject> MapObjOpt = MapObjs.stream().filter(x -> dimMapIds.contains(x.getLong("id"))).findFirst();
                if (!MapObjOpt.isPresent()) continue;
                DynamicObject dimMap = MapObjOpt.get();
                Long dimId = dimMap.getLong("id");
                Map<String, MemMapExportColProperty> colIndexPropertiesMap = this.getImportHeadProperties(sheet, dimMap);
                if (this.getErrorMsgs(sheet).size() > 0) continue;
                int mapType = dimMap.getInt("mappedtype");
                boolean isContainTar = false;
                List tarProps = colIndexPropertiesMap.values().stream().filter(x -> x.getFieldType() == 1 && !x.isNameCol()).collect(Collectors.toList());
                boolean bl = isSimpleMap = mapType == 5;
                if (isSimpleMap && (((MemMapExportColProperty)tarProps.get(0)).getNumber().equals("Period") || ((MemMapExportColProperty)tarProps.get(0)).getNumber().equals("Year"))) {
                    isContainTar = true;
                }
                List<Long> targetMembSortList = colIndexPropertiesMap.entrySet().stream().filter(k -> ((MemMapExportColProperty)k.getValue()).getFieldType() > 0 && !((MemMapExportColProperty)k.getValue()).isNameCol()).sorted((k, y) -> Integer.parseInt((String)k.getKey()) - Integer.parseInt((String)y.getKey())).map(k -> ((MemMapExportColProperty)k.getValue()).getDimId()).collect(Collectors.toList());
                LinkedHashMap<String, DynamicObject> checkedDataMap = new LinkedHashMap<String, DynamicObject>(16);
                HashMap<String, Integer> rowDataKeyRowIndexMap = new HashMap<String, Integer>(16);
                HashMap<String, Integer> rowDataLevelOrderIndexMap = new HashMap<String, Integer>(16);
                int maxRow = sheet.getLastRowNum();
                for (int rowIndex = 2; rowIndex <= maxRow; ++rowIndex) {
                    String key;
                    XSSFRow row = sheet.getRow(rowIndex);
                    if (this.isEmptyRow(row)) continue;
                    DynamicObject groupmap = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isgroupmap");
                    DynamicObjectCollection tarEntrys = groupmap.getDynamicObjectCollection("isgrouptargmapentry");
                    DynamicObjectCollection srcEntrys = groupmap.getDynamicObjectCollection("isgroupsrcmapentry");
                    groupmap.set("dimmapid", (Object)dimMap.getLong("id"));
                    groupmap.set("schemeid", (Object)schemeId);
                    groupmap.set("srctype", (Object)"1");
                    groupmap.set("creator", (Object)RequestContext.get().getUserId());
                    groupmap.set("createtime", (Object)new Date());
                    groupmap.set(calculateNumber, (Object)"1");
                    for (Map.Entry<String, MemMapExportColProperty> colPair : colIndexPropertiesMap.entrySet()) {
                        Integer colIndex = Integer.parseInt(colPair.getKey());
                        XSSFCell cell = row.getCell(colIndex.intValue());
                        if (colPair.getValue().getFieldType() == 0) {
                            if (null == cell && colPair.getValue().getNumber().equals(orderNumber)) {
                                this.addErrorMsg(mapName, rowIndex + 1, ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DIDimMemImpAndExpService18", (String)"fi-bcm-business", (Object[])new Object[0]));
                                continue;
                            }
                            this.writeValueByProperty(cell, groupmap, colPair.getValue());
                            continue;
                        }
                        if (colPair.getValue().getFieldType() == 1 && !colPair.getValue().isNameCol()) {
                            if (null == cell) {
                                if (!isSimpleMap) continue;
                                this.addErrorMsg(mapName, rowIndex + 1, String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u7ef4\u5ea6\u6210\u5458\u201c%1$s\u201d\u3002", (String)"DIDimMemImpAndExpService6", (String)"fi-bcm-business", (Object[])new Object[0]), colPair.getValue().getName()));
                                continue;
                            }
                            this.writeTarValueByProperty(cell, tarEntrys, colPair.getValue(), modelNumber, isSimpleMap, colIndexPropertiesMap);
                            continue;
                        }
                        if (colPair.getValue().getFieldType() != 2 || colPair.getValue().isNameCol()) continue;
                        this.writeSrcValueByProperty(cell, srcEntrys, colPair.getValue(), colIndexPropertiesMap);
                    }
                    if (this.getErrorMsgs(sheet, row).size() > 0) continue;
                    if (srcEntrys.size() == 0) {
                        this.addErrorMsg(mapName, rowIndex + 1, ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u6210\u5458\u4e0d\u53ef\u5168\u90e8\u4e3a\u7a7a\u3002", (String)"DIMemberMapImportImp4", (String)"fi-bcm-business", (Object[])new Object[0]));
                        continue;
                    }
                    if (tarEntrys.size() == 0) {
                        this.addErrorMsg(mapName, rowIndex + 1, ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u6210\u5458\u4e0d\u53ef\u5168\u90e8\u4e3a\u7a7a\u3002", (String)"DIMemberMapImportImp6", (String)"fi-bcm-business", (Object[])new Object[0]));
                        continue;
                    }
                    long srcStarSize = srcEntrys.stream().filter(x -> "*".equals(x.getString("srcmembnumber"))).count();
                    long tarStarSize = tarEntrys.stream().filter(x -> "*".equals(x.getString("tarmembnumber"))).count();
                    if (isSimpleMap) {
                        if (srcStarSize == 0L && tarStarSize > 0L) {
                            this.addErrorMsg(mapName, rowIndex + 1, ResManager.loadKDString((String)"\u7b80\u5355\u6620\u5c04\u6e90\u4e0d\u662f*\u7684\u65f6\u5019\uff0c\u76ee\u6807\u4e0d\u5141\u8bb8\u5199*\u3002", (String)"DIMemberMapImportImp7", (String)"fi-bcm-business", (Object[])new Object[0]));
                            continue;
                        }
                        if (tarStarSize > 0L && srcStarSize > 0L) {
                            String firstNumber = ((DynamicObject)srcEntrys.get(0)).getString("srcmembnumber");
                            if (srcStarSize > 1L || !"*".equals(firstNumber)) {
                                this.addErrorMsg(mapName, rowIndex + 1, ResManager.loadKDString((String)"\u53ea\u6709\u9996\u4e2a\u6e90\u53ef\u4ee5\u8bbe\u7f6e\u4e3a*\u3002", (String)"DIMemberMapImportImp8", (String)"fi-bcm-business", (Object[])new Object[0]));
                                continue;
                            }
                        }
                    } else if (tarStarSize > 0L) {
                        this.addErrorMsg(mapName, rowIndex + 1, ResManager.loadKDString((String)"\u7ec4\u5408\u6620\u5c04\u548c\u7279\u6b8a\u6620\u5c04\u76ee\u6807\u7ef4\u5ea6\u4e0d\u652f\u6301*\u3002", (String)"DIMemberMapImportImp9", (String)"fi-bcm-business", (Object[])new Object[0]));
                        continue;
                    }
                    if (dimMap.getInt("mappedtype") != 6) {
                        this.setGroupMapLevel(groupmap, isSimpleMap);
                    }
                    if (rowDataKeyRowIndexMap.containsKey(key = this.getMemberMapRowKey(groupmap, targetMembSortList, isContainTar)) && mapType != 6) {
                        this.addErrorMsg(mapName, rowIndex + 1, String.format(ResManager.loadKDString((String)"\u4e0e\u7b2c%1$s\u884c\u91cd\u590d\u3002", (String)"DIDimMemImpAndExpService7", (String)"fi-bcm-business", (Object[])new Object[0]), (Integer)rowDataKeyRowIndexMap.get(key) + 1));
                        continue;
                    }
                    rowDataKeyRowIndexMap.put(key, rowIndex);
                    if (dimMap.getInt("mappedtype") != 6) {
                        String level = groupmap.getString(levelNumber);
                        String order = groupmap.getString(orderNumber);
                        String indexKey = level + "|" + order;
                        if (rowDataLevelOrderIndexMap.containsKey(indexKey)) {
                            String errInfo = "";
                            errInfo = isSimpleMap ? String.format(ResManager.loadKDString((String)"\u4e0e\u7b2c%1$s\u884c\u4f18\u5148\u7ea7\u76f8\u540c\u4e14\u6267\u884c\u987a\u5e8f\u91cd\u590d\u3002", (String)"DIDimMemImpAndExpService17", (String)"fi-bcm-business", (Object[])new Object[0]), (Integer)rowDataLevelOrderIndexMap.get(indexKey) + 1) : String.format(ResManager.loadKDString((String)"\u4e0e\u7b2c%1$s\u884c\u6267\u884c\u987a\u5e8f\u91cd\u590d\u3002", (String)"DIDimMemImpAndExpService20", (String)"fi-bcm-business", (Object[])new Object[0]), (Integer)rowDataLevelOrderIndexMap.get(indexKey) + 1);
                            this.addErrorMsg(mapName, rowIndex + 1, errInfo);
                            continue;
                        }
                        rowDataLevelOrderIndexMap.put(indexKey, rowIndex);
                    }
                    checkedDataMap.put(String.valueOf(rowIndex), groupmap);
                }
                if (checkedDataMap.size() <= 0) continue;
                this.saveMembMap(checkedDataMap, schemeId, dimMap, targetMembSortList, mapName, isContainTar, deleteBeforeSave);
                this.clearMapJson(dimMap.getLong("id"));
                this.successCount = this.successCount + checkedDataMap.size();
            }
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"Excel\u6253\u5f00\u5931\u8d25\u3002", (String)"DIMemberMapImportImp2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25,\u8bf7\u68c0\u67e5\u6a21\u677f\u683c\u5f0f\u3002", (String)"DIMemberMapImportImp3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public void importData(MembMapImportDTO membImportDTO) {
        if (null == membImportDTO) {
            return;
        }
        String modelShowNumber = membImportDTO.getModel();
        DynamicObject model = DIMemberMapImportImp.getModel(modelShowNumber, "id,number");
        if (null == model) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u4f53\u7cfb\u7f16\u7801\u3002", (String)"DIDimMemImpAndExpService23", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String modelNumber = model.getString("number");
        String schemeNumber = membImportDTO.getScheme();
        DynamicObject scheme = this.getScheme(schemeNumber, model.getLong("id"));
        if (null == scheme) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u96c6\u6210\u65b9\u6848\u7f16\u7801\u3002", (String)"DIDimMemImpAndExpService24", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String status = scheme.getString("status");
        if (!"0".equals(status)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u72b6\u6001\u4e3a\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"DIDimMemImpAndExpService25", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Long schemeId = scheme.getLong("id");
        DynamicObject[] dimMappings = this.getDimMaps(schemeId);
        for (Map.Entry<String, List<MembMapImportRowDTO>> entry : membImportDTO.getData().entrySet()) {
            String dimMapNumber = entry.getKey();
            Optional<DynamicObject> MapObjOpt = Arrays.stream(dimMappings).filter(x -> x.getString("number").equals(dimMapNumber)).findFirst();
            if (!MapObjOpt.isPresent()) {
                this.addErrorMsg(dimMapNumber, 0, ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u4fe1\u606f\u672a\u627e\u5230\u3002", (String)"DIDimMemImpAndExpService1", (String)"fi-bcm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject dimMapping = MapObjOpt.get();
            String[] dimStrArr = dimMapNumber.split(sub);
            if (dimStrArr.length != 2) {
                this.addErrorMsg(dimMapNumber, 0, ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u7f16\u7801\u4e0d\u5408\u6cd5\u3002", (String)"DIDimMemImpAndExpService22", (String)"fi-bcm-business", (Object[])new Object[0]));
                continue;
            }
            List tarDimsSort = Arrays.stream(dimStrArr[0].split(",")).collect(Collectors.toList());
            List srcDimsSort = Arrays.stream(dimStrArr[1].split(",")).collect(Collectors.toList());
            List tars = dimMapping.getDynamicObjectCollection("isdimmaptargentry").stream().sorted((k, y) -> {
                String kItemNumber = k.getDynamicObject("tagdimension").getString("number");
                String yItemNumber = y.getDynamicObject("tagdimension").getString("number");
                return tarDimsSort.indexOf(kItemNumber) - tarDimsSort.indexOf(yItemNumber);
            }).collect(Collectors.toList());
            List srcs = dimMapping.getDynamicObjectCollection("isdimmapsrcentry").stream().sorted((k, y) -> {
                String kItemNumber = k.getDynamicObject("srcdimension").getString("number");
                String yItemNumber = y.getDynamicObject("srcdimension").getString("number");
                return srcDimsSort.indexOf(kItemNumber) - srcDimsSort.indexOf(yItemNumber);
            }).collect(Collectors.toList());
            List<Long> primaryKeySortList = tars.stream().map(x -> x.getDynamicObject("tagdimension").getLong("id")).collect(Collectors.toList());
            primaryKeySortList.addAll(srcs.stream().map(x -> x.getDynamicObject("srcdimension").getLong("id")).collect(Collectors.toList()));
            int mapType = dimMapping.getInt("mappedtype");
            boolean isSimpleMap = mapType == 5;
            boolean isContainTar = false;
            if (isSimpleMap && tars.stream().filter(x -> x.getDynamicObject("tagdimension").getString("number").equals("Period") || x.getDynamicObject("tagdimension").getString("number").equals("Year")).count() > 0L) {
                isContainTar = true;
            }
            HashMap<String, DynamicObject> checkedDataMap = new HashMap<String, DynamicObject>(16);
            HashMap<String, Integer> rowDataKeyRowIndexMap = new HashMap<String, Integer>(16);
            HashMap<String, Integer> rowDataLevelOrderIndexMap = new HashMap<String, Integer>(16);
            for (int rowIndex = 0; rowIndex < entry.getValue().size(); ++rowIndex) {
                String key;
                String memberName;
                String memberNumber;
                int i;
                MembMapImportRowDTO row = entry.getValue().get(rowIndex);
                DynamicObject groupmap = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isgroupmap");
                DynamicObjectCollection tarEntrys = groupmap.getDynamicObjectCollection("isgrouptargmapentry");
                DynamicObjectCollection srcEntrys = groupmap.getDynamicObjectCollection("isgroupsrcmapentry");
                groupmap.set("dimmapid", (Object)dimMapping.getLong("id"));
                groupmap.set("schemeid", (Object)schemeId);
                groupmap.set("srctype", (Object)"1");
                groupmap.set("creator", (Object)RequestContext.get().getUserId());
                groupmap.set("createtime", (Object)new Date());
                groupmap.set(calculateNumber, (Object)(row.getCalculate() == 1 ? "1" : "-1"));
                groupmap.set(weightNumber, (Object)row.getWeight());
                if (mapType != 6) {
                    groupmap.set(orderNumber, (Object)row.getOrder());
                }
                for (i = 0; i < row.getTargetValue().size(); ++i) {
                    DynamicObject tarEntry;
                    if (tars.size() <= i) continue;
                    DynamicObject tarDim = (DynamicObject)tars.get(i);
                    String dimNumber = tarDim.getDynamicObject("tagdimension").getString("number");
                    memberNumber = row.getTargetValue().get(i).getNumber();
                    memberName = row.getTargetValue().get(i).getName();
                    String string = memberName = memberName.length() > 100 ? memberName.substring(0, 49) : memberName;
                    if (kd.bos.util.StringUtils.isEmpty((String)memberNumber)) {
                        if (!isSimpleMap) continue;
                        this.addErrorMsg(entry.getKey(), rowIndex + 1, String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u7ef4\u5ea6\u6210\u5458\u201c%1$s\u201d\u3002", (String)"DIDimMemImpAndExpService6", (String)"fi-bcm-business", (Object[])new Object[0]), dimNumber));
                        continue;
                    }
                    IDNumberTreeNode member = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)memberNumber);
                    if (!IDNumberTreeNode.NotFoundTreeNode.equals(member)) {
                        tarEntry = tarEntrys.addNew();
                        tarEntry.set("tardimension", (Object)tarDim.getDynamicObject("tagdimension").getLong("id"));
                        tarEntry.set("tarmember", (Object)member.getId());
                        tarEntry.set("tarmembnumber", (Object)member.getNumber());
                        tarEntry.set("tarmembname", (Object)member.getName());
                        tarEntry.set("seq", (Object)i);
                        continue;
                    }
                    if ("*".equals(memberNumber) || "IGNORE".equalsIgnoreCase(memberNumber)) {
                        tarEntry = tarEntrys.addNew();
                        tarEntry.set("tardimension", (Object)tarDim.getDynamicObject("tagdimension").getLong("id"));
                        tarEntry.set("tarmembnumber", (Object)memberNumber);
                        tarEntry.set("tarmembname", (Object)memberName);
                        tarEntry.set("seq", (Object)i);
                        continue;
                    }
                    this.addErrorMsg(entry.getKey(), rowIndex + 1, String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u7ef4\u5ea6\u6210\u5458\u201c%1$s\u201d\u3002", (String)"DIDimMemImpAndExpService6", (String)"fi-bcm-business", (Object[])new Object[0]), dimNumber));
                }
                for (i = 0; i < row.getSourceValue().size(); ++i) {
                    DynamicObject srcDim = (DynamicObject)srcs.get(i);
                    Long dimId = srcDim.getDynamicObject("srcdimension").getLong("id");
                    memberNumber = row.getSourceValue().get(i).getNumber();
                    memberName = row.getSourceValue().get(i).getName();
                    String string = memberName = memberName.length() > 100 ? memberName.substring(0, 49) : memberName;
                    if (kd.bos.util.StringUtils.isEmpty((String)memberNumber)) continue;
                    Map<String, Object> analyseResult = this.analysisScope(memberNumber);
                    Collection items = (Collection)analyseResult.get("items");
                    for (String item : items) {
                        if (StringUtils.isEmpty((CharSequence)item)) continue;
                        DynamicObject srcEntry = srcEntrys.addNew();
                        srcEntry.set("srcdimension", (Object)dimId);
                        srcEntry.set("scope", analyseResult.get("scope"));
                        srcEntry.set("srcmembnumber", (Object)item);
                        srcEntry.set("srcmembname", (Object)memberName);
                        srcEntry.set("seq", (Object)i);
                    }
                }
                if (this.getErrorMsgs(entry.getKey(), rowIndex).size() > 0) continue;
                if (srcEntrys.size() == 0) {
                    this.addErrorMsg(entry.getKey(), rowIndex + 1, ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u6210\u5458\u4e0d\u53ef\u5168\u90e8\u4e3a\u7a7a\u3002", (String)"DIMemberMapImportImp4", (String)"fi-bcm-business", (Object[])new Object[0]));
                    continue;
                }
                if (tarEntrys.size() == 0) {
                    this.addErrorMsg(entry.getKey(), rowIndex + 1, ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u6210\u5458\u4e0d\u53ef\u5168\u90e8\u4e3a\u7a7a\u3002", (String)"DIMemberMapImportImp6", (String)"fi-bcm-business", (Object[])new Object[0]));
                    continue;
                }
                long srcStarSize = srcEntrys.stream().filter(x -> "*".equals(x.getString("srcmembnumber"))).count();
                long tarStarSize = tarEntrys.stream().filter(x -> "*".equals(x.getString("tarmembnumber"))).count();
                if (isSimpleMap) {
                    if (srcStarSize == 0L && tarStarSize > 0L) {
                        this.addErrorMsg(entry.getKey(), rowIndex + 1, ResManager.loadKDString((String)"\u7b80\u5355\u6620\u5c04\u6e90\u4e0d\u662f*\u7684\u65f6\u5019\uff0c\u76ee\u6807\u4e0d\u5141\u8bb8\u5199*\u3002", (String)"DIMemberMapImportImp7", (String)"fi-bcm-business", (Object[])new Object[0]));
                        continue;
                    }
                    if (tarStarSize > 0L && srcStarSize > 0L) {
                        String firstNumber = ((DynamicObject)srcEntrys.get(0)).getString("srcmembnumber");
                        if (srcStarSize > 1L || !"*".equals(firstNumber)) {
                            this.addErrorMsg(entry.getKey(), rowIndex + 1, ResManager.loadKDString((String)"\u53ea\u6709\u9996\u4e2a\u6e90\u53ef\u4ee5\u8bbe\u7f6e\u4e3a*\u3002", (String)"DIMemberMapImportImp8", (String)"fi-bcm-business", (Object[])new Object[0]));
                            continue;
                        }
                    }
                } else if (tarStarSize > 0L) {
                    this.addErrorMsg(entry.getKey(), rowIndex + 1, ResManager.loadKDString((String)"\u7ec4\u5408\u6620\u5c04\u548c\u7279\u6b8a\u6620\u5c04\u76ee\u6807\u7ef4\u5ea6\u4e0d\u652f\u6301*\u3002", (String)"DIMemberMapImportImp9", (String)"fi-bcm-business", (Object[])new Object[0]));
                    continue;
                }
                if (dimMapping.getInt("mappedtype") != 6) {
                    this.setGroupMapLevel(groupmap, isSimpleMap);
                }
                if (rowDataKeyRowIndexMap.containsKey(key = this.getMemberMapRowKey(groupmap, primaryKeySortList, isContainTar))) {
                    this.addErrorMsg(entry.getKey(), rowIndex + 1, String.format(ResManager.loadKDString((String)"\u4e0e\u7b2c%1$s\u884c\u91cd\u590d\u3002", (String)"DIDimMemImpAndExpService7", (String)"fi-bcm-business", (Object[])new Object[0]), (Integer)rowDataKeyRowIndexMap.get(key) + 1));
                    continue;
                }
                rowDataKeyRowIndexMap.put(key, rowIndex);
                if (dimMapping.getInt("mappedtype") != 6) {
                    String level = groupmap.getString(levelNumber);
                    String order = groupmap.getString(orderNumber);
                    String indexKey = level + "|" + order;
                    if (rowDataLevelOrderIndexMap.containsKey(indexKey)) {
                        String errInfo = "";
                        errInfo = isSimpleMap ? String.format(ResManager.loadKDString((String)"\u4e0e\u7b2c%1$s\u884c\u4f18\u5148\u7ea7\u76f8\u540c\u4e14\u6267\u884c\u987a\u5e8f\u91cd\u590d\u3002", (String)"DIDimMemImpAndExpService17", (String)"fi-bcm-business", (Object[])new Object[0]), (Integer)rowDataLevelOrderIndexMap.get(indexKey) + 1) : String.format(ResManager.loadKDString((String)"\u4e0e\u7b2c%1$s\u884c\u6267\u884c\u987a\u5e8f\u91cd\u590d\u3002", (String)"DIDimMemImpAndExpService20", (String)"fi-bcm-business", (Object[])new Object[0]), (Integer)rowDataLevelOrderIndexMap.get(indexKey) + 1);
                        this.addErrorMsg(entry.getKey(), rowIndex + 1, errInfo);
                        continue;
                    }
                    rowDataLevelOrderIndexMap.put(indexKey, rowIndex);
                }
                checkedDataMap.put(String.valueOf(rowIndex), groupmap);
            }
            if (checkedDataMap.size() <= 0) continue;
            this.saveMembMap(checkedDataMap, schemeId, dimMapping, primaryKeySortList, entry.getKey(), isContainTar, false);
            this.clearMapJson(dimMapping.getLong("id"));
            this.successCount = this.successCount + checkedDataMap.size();
        }
    }

    @Override
    public List<Object> getErrorMsgs() {
        return this.errorMsgCollection;
    }

    @Override
    public List<Object> getErrorMsgs(XSSFSheet sheet) {
        return this.errorMsgCollection.stream().filter(x -> ((ImportFailData)x).getSheetName().equals(sheet.getSheetName())).collect(Collectors.toList());
    }

    protected List<Object> getErrorMsgs(XSSFSheet sheet, XSSFRow row) {
        return this.errorMsgCollection.stream().filter(x -> ((ImportFailData)x).getRowNum() == row.getRowNum() + 1 && ((ImportFailData)x).getSheetName().equals(sheet.getSheetName())).collect(Collectors.toList());
    }

    protected List<Object> getErrorMsgs(String sheetName, int rowIndex) {
        return this.errorMsgCollection.stream().filter(x -> ((ImportFailData)x).getRowNum() == rowIndex + 1 && ((ImportFailData)x).getSheetName().equals(sheetName)).collect(Collectors.toList());
    }

    @Override
    public Integer getSuccessCount() {
        return this.successCount;
    }

    protected String getDimmappingTypeCode(int type) {
        if (type == 4) {
            return "C";
        }
        if (type == 5) {
            return "S";
        }
        if (type == 6) {
            return "SP";
        }
        return "O";
    }

    protected boolean isEmptyRow(XSSFRow row) {
        if (null == row) {
            return true;
        }
        boolean isEmpty = true;
        int maxCol = row.getLastCellNum();
        for (int i = 0; i < maxCol; ++i) {
            if (null == row.getCell(i) || !kd.bos.util.StringUtils.isNotEmpty((String)row.getCell(i).toString())) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    public static DynamicObject getModel(String modelNum, String selectFields) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("shownumber", "=", (Object)modelNum);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_model", (String)selectFields, (QFilter[])qfBuilder.toArray());
    }

    private DynamicObject getScheme(String schemeNumber, Long modelId) {
        QFilter qf = new QFilter("number", "=", (Object)schemeNumber);
        qf.and(new QFilter("model", "=", (Object)modelId));
        return BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id,number,name,extendstable,singlemetric,textfield,issrc,status", (QFilter[])new QFilter[]{qf});
    }

    protected int saveMembMap(Map<String, DynamicObject> checkedDataMap, long schemeId, DynamicObject dimMap, List<Long> targetMembSortList, String sheetName, boolean isContainTar, boolean deleteBeforeSave) {
        ArrayList<DynamicObject> needSaveDatas = new ArrayList();
        if (deleteBeforeSave) {
            this.deleteMembMapByDimMapId(dimMap.getLong("id"), schemeId);
            needSaveDatas = checkedDataMap.values().stream().collect(Collectors.toList());
        } else {
            ArrayList<Long> deletePkId = new ArrayList<Long>(16);
            DynamicObject[] memMapCollection = this.getMemberMapping(schemeId, dimMap.getLong("id"));
            boolean isContainTarFinal = isContainTar;
            Map<String, Long> memMaps = Arrays.stream(memMapCollection).collect(Collectors.toMap(x -> this.getMemberMapRowKey((DynamicObject)x, targetMembSortList, isContainTarFinal), x -> x.getLong("id"), (v1, v2) -> v1));
            Map<String, Integer> seqMaps = Arrays.stream(memMapCollection).collect(Collectors.toMap(x -> this.getMemberMapRowKey((DynamicObject)x, targetMembSortList, isContainTarFinal), x -> x.getInt("dseq"), (v1, v2) -> v1));
            Map<String, Long> levelOrderIdMap = Arrays.stream(memMapCollection).collect(Collectors.toMap(x -> x.getString(levelNumber) + "|" + x.getString(orderNumber), v -> v.getLong("id"), (v1, v2) -> v1));
            for (Map.Entry<String, DynamicObject> rowDataIndex : checkedDataMap.entrySet()) {
                String key = this.getMemberMapRowKey(rowDataIndex.getValue(), targetMembSortList, isContainTar);
                String levelOrderkey = rowDataIndex.getValue().getString(levelNumber) + "|" + rowDataIndex.getValue().getString(orderNumber);
                Long fid = memMaps.get(key);
                if (dimMap.getInt("mappedtype") != 6 && levelOrderIdMap.containsKey(levelOrderkey)) {
                    Long repetRowId = levelOrderIdMap.get(levelOrderkey);
                    if (null != fid && !fid.equals(repetRowId)) {
                        this.addErrorMsg(sheetName, Integer.parseInt(rowDataIndex.getKey()) + 1, ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u4f18\u5148\u7ea7\u548c\u6267\u884c\u987a\u5e8f\u7684\u8bb0\u5f55\u3002", (String)"DIMemberMapImportImp5", (String)"fi-bcm-business", (Object[])new Object[0]));
                        continue;
                    }
                }
                if (null != fid) {
                    deletePkId.add(fid);
                    rowDataIndex.getValue().set("dseq", (Object)seqMaps.get(key));
                }
                needSaveDatas.add(rowDataIndex.getValue());
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_isgroupmap"), (Object[])deletePkId.toArray());
        }
        this.fillDimMappingSeq(schemeId, dimMap.getLong("id"), needSaveDatas);
        Object[] result = SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_isgroupmap"), (Object[])needSaveDatas.toArray());
        return result.length;
    }

    private void fillDimMappingSeq(Long schemeId, Long dimMapId, List<DynamicObject> needSaveDatas) {
        Integer maxSeq = this.getMemberMappingMaxSeq(schemeId, dimMapId);
        for (DynamicObject obj : needSaveDatas) {
            int dseq = obj.getInt("dseq");
            if (dseq != 0) continue;
            maxSeq = maxSeq + 5;
            obj.set("dseq", (Object)maxSeq);
        }
    }

    private Integer getMemberMappingMaxSeq(Long schemeId, Long dimMapId) {
        String dataSelectField = "max(dseq)";
        QFilter qf = new QFilter("schemeid", "=", (Object)schemeId);
        qf.and(new QFilter("dimmapid", "=", (Object)dimMapId));
        DynamicObject object = QueryServiceHelper.queryOne((String)"bcm_isgroupmap", (String)dataSelectField, (QFilter[])qf.toArray());
        return object.getInt("max(dseq)");
    }

    protected void deleteMembMapByDimMapId(long dimMappingId, long schemeId) {
        String dataSelectField = "id";
        QFilter qf = new QFilter("schemeid", "=", (Object)schemeId);
        qf.and(new QFilter("dimmapid", "=", (Object)dimMappingId));
        DynamicObjectCollection iddys = QueryServiceHelper.query((String)"bcm_isgroupmap", (String)dataSelectField, (QFilter[])new QFilter[]{qf});
        List ids = iddys.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_isgroupmap"), (Object[])ids.toArray());
    }

    protected void writeValueByProperty(XSSFCell cell, DynamicObject groupmap, MemMapExportColProperty colProperty) {
        if (colProperty.getNumber().equals(levelNumber)) {
            return;
        }
        if (colProperty.getNumber().equals(calculateNumber)) {
            String value = "1";
            if (null != cell) {
                cell.setCellType(CellType.STRING);
                value = cell.getStringCellValue();
                value = value.equals(sub) ? "-1" : "1";
            }
            groupmap.set(colProperty.getNumber(), (Object)value);
        } else if (colProperty.getNumber().equals(weightNumber)) {
            double value = 1.0;
            if (null != cell) {
                cell.setCellType(CellType.NUMERIC);
                value = cell.getNumericCellValue();
                if (value == 0.0) {
                    value = 1.0;
                }
            }
            groupmap.set(weightNumber, (Object)value);
        } else if (colProperty.getNumber().equals(orderNumber)) {
            cell.setCellType(CellType.NUMERIC);
            int value = (int)cell.getNumericCellValue();
            if (value == 0) {
                this.addErrorMsg(cell.getSheet().getSheetName(), cell.getRowIndex() + 1, ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f\u4e0d\u80fd\u4e3a0\u3002", (String)"DIDimMemImpAndExpService19", (String)"fi-bcm-business", (Object[])new Object[0]));
                return;
            }
            groupmap.set(orderNumber, (Object)value);
        } else {
            if (cell == null) {
                return;
            }
            if (colProperty.isNum()) {
                cell.setCellType(CellType.NUMERIC);
                groupmap.set(colProperty.getNumber(), (Object)cell.getNumericCellValue());
            } else {
                groupmap.set(colProperty.getNumber(), (Object)cell.getStringCellValue());
            }
        }
    }

    protected void writeTarValueByProperty(XSSFCell cell, DynamicObjectCollection tarEntrys, MemMapExportColProperty colProperty, String modelNumber, boolean isSimpleMap, Map<String, MemMapExportColProperty> colIndexPropertiesMap) {
        cell.setCellType(CellType.STRING);
        String dimNumber = colProperty.getNumber();
        String memberNumber = cell.getStringCellValue();
        if (kd.bos.util.StringUtils.isEmpty((String)memberNumber)) {
            if (isSimpleMap) {
                this.addErrorMsg(cell.getSheet().getSheetName(), cell.getRowIndex() + 1, String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u7ef4\u5ea6\u6210\u5458\u201c%1$s\u201d\u3002", (String)"DIDimMemImpAndExpService6", (String)"fi-bcm-business", (Object[])new Object[0]), colProperty.getName()));
            }
            return;
        }
        IDNumberTreeNode member = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)memberNumber);
        if (!IDNumberTreeNode.NotFoundTreeNode.equals(member)) {
            DynamicObject tarEntry = tarEntrys.addNew();
            tarEntry.set("tardimension", (Object)colProperty.getDimId());
            tarEntry.set("tarmember", (Object)member.getId());
            tarEntry.set("tarmembnumber", (Object)member.getNumber());
            tarEntry.set("seq", (Object)colProperty.getSeq());
            Optional<String> nameColIndexOpt = colIndexPropertiesMap.entrySet().stream().filter(x -> colProperty.getDimId().equals(((MemMapExportColProperty)x.getValue()).getDimId()) && ((MemMapExportColProperty)x.getValue()).isNameCol()).map(x -> (String)x.getKey()).findFirst();
            if (nameColIndexOpt.isPresent()) {
                String nameText = "";
                Integer nameColIndex = Integer.valueOf(nameColIndexOpt.get());
                XSSFCell nameCell = cell.getRow().getCell(nameColIndex.intValue());
                if (null != nameCell) {
                    nameCell.setCellType(CellType.STRING);
                    String string = nameText = nameCell.getStringCellValue().length() > 100 ? nameCell.getStringCellValue().substring(0, 49) : nameCell.getStringCellValue();
                }
                if (kd.bos.util.StringUtils.isEmpty((String)nameText)) {
                    nameText = member.getName();
                }
                tarEntry.set("tarmembname", (Object)nameText);
            }
        } else if ("*".equals(memberNumber) || "IGNORE".equalsIgnoreCase(memberNumber)) {
            DynamicObject tarEntry = tarEntrys.addNew();
            tarEntry.set("tardimension", (Object)colProperty.getDimId());
            tarEntry.set("tarmembnumber", (Object)memberNumber);
            tarEntry.set("seq", (Object)colProperty.getSeq());
        } else {
            this.addErrorMsg(cell.getSheet().getSheetName(), cell.getRowIndex() + 1, String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u7ef4\u5ea6\u6210\u5458\u201c%1$s\u201d\u3002", (String)"DIDimMemImpAndExpService6", (String)"fi-bcm-business", (Object[])new Object[0]), colProperty.getName()));
        }
    }

    protected void writeSrcValueByProperty(XSSFCell cell, DynamicObjectCollection srcEntrys, MemMapExportColProperty colProperty, Map<String, MemMapExportColProperty> colIndexPropertiesMap) {
        if (null == cell) {
            return;
        }
        cell.setCellType(CellType.STRING);
        String memberNumber = cell.getStringCellValue();
        if (kd.bos.util.StringUtils.isEmpty((String)memberNumber)) {
            return;
        }
        String nameText = "";
        Optional<String> nameColIndexOpt = colIndexPropertiesMap.entrySet().stream().filter(x -> colProperty.getDimId().equals(((MemMapExportColProperty)x.getValue()).getDimId()) && ((MemMapExportColProperty)x.getValue()).isNameCol()).map(x -> (String)x.getKey()).findFirst();
        if (nameColIndexOpt.isPresent()) {
            Integer nameColIndex = Integer.valueOf(nameColIndexOpt.get());
            XSSFCell nameCell = cell.getRow().getCell(nameColIndex.intValue());
            if (null != nameCell) {
                nameCell.setCellType(CellType.STRING);
                nameText = nameCell.getStringCellValue().length() > 50 ? nameCell.getStringCellValue().substring(0, 49) : nameCell.getStringCellValue();
            }
        }
        Map<String, Object> analyseResult = this.analysisScope(memberNumber);
        Collection items = (Collection)analyseResult.get("items");
        for (String item : items) {
            if (StringUtils.isEmpty((CharSequence)item)) continue;
            DynamicObject srcEntry = srcEntrys.addNew();
            srcEntry.set("srcdimension", (Object)colProperty.getDimId());
            srcEntry.set("scope", analyseResult.get("scope"));
            srcEntry.set("srcmembnumber", (Object)item);
            srcEntry.set("srcmembname", (Object)nameText);
            srcEntry.set("seq", (Object)colProperty.getSeq());
        }
    }

    protected void setGroupMapLevel(DynamicObject groupMap, boolean isSimpleMap) {
        DynamicObjectCollection srcEntrys = groupMap.getDynamicObjectCollection("isgroupsrcmapentry");
        if (srcEntrys.size() == 0) {
            return;
        }
        DynamicObject firsrSrcEntry = (DynamicObject)srcEntrys.get(0);
        if (isSimpleMap && "*".equals(firsrSrcEntry.getString("srcmembnumber"))) {
            groupMap.set(levelNumber, (Object)9000);
            return;
        }
        Integer level = 0;
        Integer srcScope = firsrSrcEntry.getInt("scope");
        level = srcScope.intValue() == MapScopeEnum.EQUALS.getIndexNum() ? Integer.valueOf(1000) : (srcScope.intValue() == MapScopeEnum.INCLUDE.getIndexNum() ? Integer.valueOf(2000) : (srcScope.intValue() == MapScopeEnum.RANGE.getIndexNum() ? Integer.valueOf(3000) : (srcScope.intValue() == MapScopeEnum.LIKE.getIndexNum() ? Integer.valueOf(4000) : (srcScope.intValue() == MapScopeEnum.NOT_EQUALS.getIndexNum() ? Integer.valueOf(5000) : (srcScope.intValue() == MapScopeEnum.NOT_INCLUDE.getIndexNum() ? Integer.valueOf(6000) : (srcScope.intValue() == MapScopeEnum.NOT_RANGE.getIndexNum() ? Integer.valueOf(7000) : (srcScope.intValue() == MapScopeEnum.NOT_LIKE.getIndexNum() ? Integer.valueOf(8000) : Integer.valueOf(9000))))))));
        groupMap.set(levelNumber, (Object)level);
    }

    protected DynamicObject[] getMemberMapping(Long schemeId, Long dimMappingId) {
        String dataSelectField = "id,srctype,level,order,dseq,weight,computeoprt,isgrouptargmapentry,isgrouptargmapentry.tardimension,isgrouptargmapentry.tarmember,isgrouptargmapentry.tarmembnumber,isgroupsrcmapentry,isgroupsrcmapentry.seq,isgroupsrcmapentry.srcdimension,isgroupsrcmapentry.srcmember,isgroupsrcmapentry.srcmembnumber,isgroupsrcmapentry.scope";
        QFilter qf = new QFilter("schemeid", "=", (Object)schemeId);
        qf.and(new QFilter("dimmapid", "=", (Object)dimMappingId));
        return BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)dataSelectField, (QFilter[])new QFilter[]{qf}, (String)"dseq asc");
    }

    protected Map<String, MemMapExportColProperty> getImportHeadProperties(XSSFSheet sheet, DynamicObject dimMap) {
        List indexs;
        HashMap<String, MemMapExportColProperty> colIndexPropertiesMap = new HashMap<String, MemMapExportColProperty>(16);
        XSSFRow groupRow = sheet.getRow(0);
        XSSFRow headRow = sheet.getRow(1);
        int maxColNum = headRow.getPhysicalNumberOfCells();
        HashMap headNameIndexMap = new HashMap(16);
        HashMap groupNameIndexMap = new HashMap(16);
        for (int colIndex = 0; colIndex < maxColNum; ++colIndex) {
            XSSFCell headCell;
            CellRangeAddress mergeHeadCellAddress;
            XSSFCell groupCell = groupRow.getCell(colIndex);
            CellRangeAddress mergeGroupCellAddress = this.getMergeRange(sheet, groupCell);
            if (null != mergeGroupCellAddress) {
                groupCell = sheet.getRow(mergeGroupCellAddress.getFirstRow()).getCell(mergeGroupCellAddress.getFirstColumn());
            }
            if (null != groupCell) {
                if (groupNameIndexMap.containsKey(groupCell.getStringCellValue())) {
                    ((List)groupNameIndexMap.get(groupCell.getStringCellValue())).add(colIndex);
                } else {
                    ArrayList<Integer> indexs2 = new ArrayList<Integer>();
                    indexs2.add(colIndex);
                    groupNameIndexMap.put(groupCell.getStringCellValue(), indexs2);
                }
            }
            if (null != (mergeHeadCellAddress = this.getMergeRange(sheet, headCell = headRow.getCell(colIndex)))) {
                headCell = sheet.getRow(mergeHeadCellAddress.getFirstRow()).getCell(mergeHeadCellAddress.getFirstColumn());
            }
            if (null == headCell) continue;
            if (headNameIndexMap.containsKey(headCell.getStringCellValue())) {
                ((List)headNameIndexMap.get(headCell.getStringCellValue())).add(colIndex);
                continue;
            }
            indexs = new ArrayList<Integer>();
            indexs.add(colIndex);
            headNameIndexMap.put(headCell.getStringCellValue(), indexs);
        }
        List tarCellIndexs = (List)groupNameIndexMap.get(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf", (String)"DIDimMemImpAndExpService2", (String)"fi-bcm-business", (Object[])new Object[0]));
        List srcCellIndexs = (List)groupNameIndexMap.get(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf", (String)"DIDimMemImpAndExpService8", (String)"fi-bcm-business", (Object[])new Object[0]));
        if (null == tarCellIndexs || null == srcCellIndexs) {
            this.addErrorMsg(sheet.getSheetName(), 1, ResManager.loadKDString((String)"\u6a21\u677f\u683c\u5f0f\u9519\u8bef", (String)"DIMemberMapImportImp1", (String)"fi-bcm-business", (Object[])new Object[0]));
            return colIndexPropertiesMap;
        }
        List<MemMapExportColProperty> headProperties = this.getColHeadNamePropertyMap(dimMap);
        for (MemMapExportColProperty colProperty : headProperties) {
            Collection intersectIndex;
            if (!headNameIndexMap.containsKey(colProperty.getName())) {
                this.addErrorMsg(sheet.getSheetName(), 2, String.format(ResManager.loadKDString((String)"\u6a21\u677f\u7f3a\u5931\u5217\u5934\u201c%1$s\u201d\u3002", (String)"DIDimMemImpAndExpService3", (String)"fi-bcm-business", (Object[])new Object[0]), colProperty.getName()));
                continue;
            }
            indexs = (List)headNameIndexMap.get(colProperty.getName());
            if (colProperty.getFieldType() == 0) {
                colIndexPropertiesMap.put(((Integer)indexs.get(0)).toString(), colProperty);
                continue;
            }
            if (colProperty.getFieldType() == 1) {
                intersectIndex = CollectionUtils.intersection(indexs, (Collection)tarCellIndexs);
                if (intersectIndex.size() == 0) {
                    this.addErrorMsg(sheet.getSheetName(), 2, String.format(ResManager.loadKDString((String)"\u6a21\u677f\u201c\u76ee\u6807\u7cfb\u7edf\u201d\u4e2d\u7f3a\u5931\u5217\u5934\u201c%1$s\u201d\u3002", (String)"DIDimMemImpAndExpService4", (String)"fi-bcm-business", (Object[])new Object[0]), colProperty.getName()));
                    continue;
                }
                colIndexPropertiesMap.put(intersectIndex.toArray()[0].toString(), colProperty);
                continue;
            }
            if (colProperty.getFieldType() != 2) continue;
            intersectIndex = CollectionUtils.intersection(indexs, (Collection)srcCellIndexs);
            if (intersectIndex.size() == 0) {
                this.addErrorMsg(sheet.getSheetName(), 2, String.format(ResManager.loadKDString((String)"\u6a21\u677f\u201c\u6e90\u7cfb\u7edf\u201d\u4e2d\u7f3a\u5931\u5217\u5934\u201c%1$s\u201d\u3002", (String)"DIDimMemImpAndExpService5", (String)"fi-bcm-business", (Object[])new Object[0]), colProperty.getName()));
                continue;
            }
            colIndexPropertiesMap.put(intersectIndex.toArray()[0].toString(), colProperty);
        }
        return colIndexPropertiesMap;
    }

    protected String getMemberMapRowKey(DynamicObject DimMemberMapRow, final List<Long> sortIndexList, boolean isContainTar) {
        List<Object> membSorted = new ArrayList(16);
        if (isContainTar) {
            DynamicObjectCollection tarEntrys = DimMemberMapRow.getDynamicObjectCollection("isgrouptargmapentry");
            membSorted = tarEntrys.stream().sorted((k, y) -> sortIndexList.indexOf(k.getLong("tardimension.id")) - sortIndexList.indexOf(y.getLong("tardimension.id"))).map(k -> k.getString("tardimension") + "|" + k.getString("tarmembnumber")).collect(Collectors.toList());
        }
        DynamicObjectCollection srcEntrys = DimMemberMapRow.getDynamicObjectCollection("isgroupsrcmapentry");
        List srcMembSorted = srcEntrys.stream().sorted(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return sortIndexList.indexOf(o1.getLong("srcdimension")) - sortIndexList.indexOf(o2.getLong("srcdimension"));
            }
        }.thenComparing(x -> x.getString("srcmembnumber"))).map(k -> k.getString("srcdimension") + "|" + k.getString("srcmembnumber") + "|" + k.getString("scope")).collect(Collectors.toList());
        membSorted.addAll(srcMembSorted);
        return String.join((CharSequence)";", membSorted);
    }

    protected List<MemMapExportColProperty> getColHeadNamePropertyMap(DynamicObject dimMapping) {
        ArrayList<MemMapExportColProperty> colHeadList = new ArrayList<MemMapExportColProperty>(16);
        int mapType = dimMapping.getInt("mappedtype");
        if (mapType != 4 && mapType != 6) {
            colHeadList.add(new MemMapExportColProperty(levelNumber, ResManager.loadKDString((String)"\u4f18\u5148\u7ea7", (String)"DIDimMemImpAndExpService9", (String)"fi-bcm-business", (Object[])new Object[0]), true));
        }
        if (mapType != 6) {
            colHeadList.add(new MemMapExportColProperty(orderNumber, ResManager.loadKDString((String)"\u6267\u884c\u987a\u5e8f", (String)"DIDimMemImpAndExpService10", (String)"fi-bcm-business", (Object[])new Object[0]), true));
        }
        DynamicObjectCollection tars = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
        boolean isExistAccountDim = false;
        for (DynamicObject tar : tars) {
            String tarName = tar.getDynamicObject("tagdimension").getString("name");
            String tarNumber = tar.getDynamicObject("tagdimension").getString("number");
            int seq = tar.getInt("seq");
            if (tarNumber.equals("Account")) {
                isExistAccountDim = true;
            }
            Long tarDimId = tar.getDynamicObject("tagdimension").getLong("id");
            colHeadList.add(new MemMapExportColProperty(tarNumber, String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u7f16\u7801", (String)"DIDimMemImpAndExpService11", (String)"fi-bcm-business", (Object[])new Object[0]), tarName), 1, tarDimId, false, seq));
            colHeadList.add(new MemMapExportColProperty(tarNumber, String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u540d\u79f0", (String)"DIDimMemImpAndExpService12", (String)"fi-bcm-business", (Object[])new Object[0]), tarName), 1, tarDimId, true, seq));
        }
        if (isExistAccountDim) {
            colHeadList.add(new MemMapExportColProperty(calculateNumber, ResManager.loadKDString((String)"\u8ba1\u7b97\u5173\u7cfb", (String)"DIDimMemImpAndExpService13", (String)"fi-bcm-business", (Object[])new Object[0])));
            colHeadList.add(new MemMapExportColProperty(weightNumber, ResManager.loadKDString((String)"\u6743\u91cd", (String)"DIDimMemImpAndExpService14", (String)"fi-bcm-business", (Object[])new Object[0]), true));
        }
        DynamicObjectCollection srcs = dimMapping.getDynamicObjectCollection("isdimmapsrcentry");
        for (DynamicObject src : srcs) {
            String srcName = src.getDynamicObject("srcdimension").getString("name");
            String srcNumber = src.getDynamicObject("srcdimension").getString("number");
            Long srcDimId = src.getDynamicObject("srcdimension").getLong("id");
            int seq = src.getInt("seq");
            colHeadList.add(new MemMapExportColProperty(srcNumber, String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u7f16\u7801", (String)"DIDimMemImpAndExpService11", (String)"fi-bcm-business", (Object[])new Object[0]), srcName), 2, srcDimId, false, seq));
            colHeadList.add(new MemMapExportColProperty(srcNumber, String.format(ResManager.loadKDString((String)"%1$s\u6210\u5458\u540d\u79f0", (String)"DIDimMemImpAndExpService12", (String)"fi-bcm-business", (Object[])new Object[0]), srcName), 2, srcDimId, true, seq));
        }
        return colHeadList;
    }

    protected CellRangeAddress getMergeRange(XSSFSheet sheet, XSSFCell cell) {
        Optional<CellRangeAddress> mergeOpt = sheet.getMergedRegions().stream().filter(x -> x.getFirstRow() <= cell.getRowIndex() && x.getLastRow() >= cell.getRowIndex() && x.getFirstColumn() <= cell.getColumnIndex() && x.getLastColumn() >= cell.getColumnIndex()).findFirst();
        if (mergeOpt.isPresent()) {
            return mergeOpt.get();
        }
        return null;
    }

    protected void addErrorMsg(String sheetName, Integer rowNumber, String msg) {
        this.errorMsgCollection.add(new ImportFailData(sheetName, rowNumber, msg));
    }

    protected String convertDimMapNameToSheetName(String mapName, int dimMapType) {
        String sheetName = this.getDimmappingTypeCode(dimMapType) + "|" + mapName;
        if (sheetName.length() > 31) {
            String trimmedSheetname = sheetName.substring(0, 31);
            return trimmedSheetname;
        }
        return sheetName;
    }

    protected DynamicObject[] getDimMaps(Long schemeId) {
        String selectField = "id,name,number,sequence,mappedtype,isdimmaptargentry.tagdimension,isdimmaptargentry.tagdimtype,isdimmaptargentry.seq,isdimmapsrcentry.srcdimension,isdimmapsrcentry.srcdimtype,isdimmapsrcentry.seq";
        QFilter qFilter = new QFilter("scheme.id", "=", (Object)LongUtil.toLong((Object)schemeId));
        qFilter.and(new QFilter("isdimmapsrcentry.id", "!=", null));
        return BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)selectField, (QFilter[])qFilter.toArray());
    }

    protected Map<String, Object> analysisScope(Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (value != null && kd.bos.util.StringUtils.isNotEmpty((String)((String)value))) {
            String str = ((String)value).toUpperCase(Locale.ENGLISH).trim();
            Pattern pattern = Pattern.compile("(?<=\\()[^\\)]+");
            Matcher matcher = pattern.matcher((String)value);
            String content = "";
            while (matcher.find()) {
                content = matcher.group();
            }
            if (str.startsWith("BETWEEN(")) {
                result.put("scope", MapScopeEnum.RANGE.getIndex());
                result.put("items", Arrays.asList(content.split(",")));
                return result;
            }
            if (str.startsWith("NOTBETWEEN(")) {
                result.put("scope", MapScopeEnum.NOT_RANGE.getIndex());
                result.put("items", Arrays.asList(content.split(",")));
                return result;
            }
            if (str.startsWith("LIKE(")) {
                result.put("scope", MapScopeEnum.LIKE.getIndex());
                result.put("items", Arrays.asList(content.split(",")));
                return result;
            }
            if (str.startsWith("NOTLIKE(")) {
                result.put("scope", MapScopeEnum.NOT_LIKE.getIndex());
                result.put("items", Arrays.asList(content.split(",")));
                return result;
            }
            if (str.startsWith("IN(")) {
                result.put("scope", MapScopeEnum.INCLUDE.getIndex());
                result.put("items", Arrays.asList(content.split(",")));
                return result;
            }
            if (str.startsWith("NOTIN(")) {
                result.put("scope", MapScopeEnum.NOT_INCLUDE.getIndex());
                result.put("items", Arrays.asList(content.split(",")));
                return result;
            }
            if (str.startsWith("NOTEQUALS(")) {
                result.put("scope", MapScopeEnum.NOT_EQUALS.getIndex());
                result.put("items", Collections.singletonList(content));
            } else {
                result.put("scope", MapScopeEnum.EQUALS.getIndex());
                result.put("items", Collections.singletonList(value));
                return result;
            }
        }
        return result;
    }

    protected void clearMapJson(Long dimMapId) {
        String searchText = "id,dimmapid,type,spreadjson,data";
        QFilter qf = new QFilter("dimmapid", "=", (Object)dimMapId);
        DynamicObject[] mapJsonObjs = BusinessDataServiceHelper.load((String)"bcm_ismapjson", (String)searchText, (QFilter[])new QFilter[]{qf});
        if (mapJsonObjs.length == 0) {
            return;
        }
        DynamicObject mapJsonObj = mapJsonObjs[0];
        mapJsonObj.set("data", (Object)"");
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_ismapjson"), (Object[])new DynamicObject[]{mapJsonObj});
    }
}

