/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.integration.di.service.DIExtendDim4SchemeService;
import kd.fi.bcm.business.integration.di.service.DIMidDataHandleService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;

public class DIMidExDataHandleService
extends DIMidDataHandleService {
    @Override
    protected Pair<Set<String>, Collection<String>> getMappingDim(long id, long modelId) {
        QFilter schemeQf = new QFilter("scheme", "=", (Object)id);
        QFilter typeQf = new QFilter("mappedtype", "in", (Object)new String[]{"5", "2"});
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"number,name,mappedtype,isdimmaptargentry.tagdimension,isdimmapsrcentry.srcdimension", (QFilter[])new QFilter[]{schemeQf, typeQf}, (String)"mappedtype asc");
        HashSet<String> srcDim = new HashSet<String>(16);
        HashSet<String> targetDim = new HashSet<String>(16);
        Map dimNumMap = MemberReader.getDimensionShortNumber2NumberMap((String)this.modelNum);
        for (DynamicObject obj : load) {
            if (DimMappTypeEnum.TARGET_DEFAULT.getCode().equals(obj.getString("mappedtype"))) {
                String target = obj.getString("number");
                if (dimNumMap.containsValue(target)) {
                    targetDim.add(target);
                    continue;
                }
                this.extendMembers.add(target);
                continue;
            }
            if (!DimMappTypeEnum.SIMPLE.getCode().equals(obj.getString("mappedtype"))) continue;
            this.fillDimMap(obj.getString("number"), srcDim, targetDim, dimNumMap);
        }
        return Pair.onePair(srcDim, targetDim);
    }

    @Override
    protected Pair<String, String> getCopyTableDdl(String tableName, String singlemetric, String metricType, String textfield, String textType, Pair<Set<String>, Collection<String>> mappingDim) {
        StringBuilder sbCompare = new StringBuilder();
        this.appendCreate(sbCompare, tableName);
        this.buildSql(sbCompare, "fidnew", "bigint");
        for (String srcDim : (Set)mappingDim.p1) {
            this.buildSql(sbCompare, "f" + srcDim + "_s", "varchar(100)");
        }
        for (String targetDim : (Collection)mappingDim.p2) {
            this.buildSql(sbCompare, "f" + targetDim + "_t", "varchar(100)");
        }
        DIExtendDim4SchemeService service = new DIExtendDim4SchemeService(this.scheme);
        Map<String, Tuple<String, String, Long>> fieldNumber2Name_DT_ID = service.getFieldNumber2Name_DT_ID();
        for (Map.Entry<String, Tuple<String, String, Long>> entry : fieldNumber2Name_DT_ID.entrySet()) {
            String fileId = entry.getKey();
            if (!this.extendMembers.contains(fileId)) continue;
            String dataType = (String)entry.getValue().p2;
            if (dataType.equals(DataTypeEnum.TXT.getOIndex())) {
                this.buildSql(sbCompare, "f" + fileId + "_sum", "varchar(200)");
                continue;
            }
            if (dataType.equals(DataTypeEnum.CURRENCY.getOIndex()) || dataType.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || dataType.equals(DataTypeEnum.PROPORTION.getOIndex()) || dataType.equals(DataTypeEnum.DEFAULT.getOIndex())) {
                this.buildSql(sbCompare, "f" + fileId + "_sum", "decimal(34,15)");
                continue;
            }
            if (!dataType.equals(DataTypeEnum.DATETP.getOIndex())) continue;
            this.buildSql(sbCompare, "f" + fileId + "_sum", "datetime");
        }
        this.buildSql(sbCompare, "ftraceid", "bigint");
        this.buildSql(sbCompare, "fexecuteid", "bigint");
        this.buildSql(sbCompare, "fimpid", this.impTablePkType);
        this.buildSql(sbCompare, "fmsg", "nvarchar(2000)");
        this.buildSql(sbCompare, "fmatchingstatus", "char(1)");
        this.buildSql(sbCompare, "folapstatus", "char(1)");
        sbCompare.setCharAt(sbCompare.length() - 1, ')');
        sbCompare.append(";");
        String pkSql = this.buildPkSql(tableName, "fidnew");
        return Pair.onePair((Object)sbCompare.toString(), (Object)pkSql);
    }
}

