/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.di.service.DIAbstractDataHandleService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;

public class DIModelDataHandleService
extends DIAbstractDataHandleService {
    @Override
    protected void doCreate(Pair<String, String> table, DynamicObject scheme, String yearNum, String periodNum) {
        long schemeId = scheme.getLong("id");
        DynamicObject route = BusinessDataServiceHelper.newDynamicObject((String)"di_tableroute");
        String importTable = (String)table.p1;
        String compTable = (String)table.p2;
        int index = importTable.lastIndexOf("_");
        int order = Integer.parseInt(importTable.substring(index + 1));
        this.createTargetTable(scheme, importTable, compTable);
        route.set("order", (Object)order);
        route.set("scheme", (Object)schemeId);
        route.set("year", (Object)yearNum);
        route.set("period", (Object)periodNum);
        route.set("imptable", (Object)importTable);
        route.set("comptable", (Object)compTable);
        route.set("createtime", (Object)TimeServiceHelper.now());
        route.set("creator", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{route});
    }

    private void createTargetTable(DynamicObject scheme, String importTable, String compTable) {
        try (TXHandle tx = TX.required();){
            this.dropTable(importTable);
            this.dropTable(compTable);
            DeleteServiceHelper.delete((String)"di_tablelabel", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)scheme.getLong("id"))});
            this.createTable(importTable, compTable, scheme);
        }
    }

    private void createTable(String importTable, String compareTable, DynamicObject scheme) {
        long schemeId = scheme.getLong("id");
        long modelId = scheme.getLong("model.id");
        String singlemetric = scheme.getString("singlemetric");
        String textfield = scheme.getString("textfield");
        Pair<Set<String>, Collection<String>> mappingDim = this.getMappingDim(schemeId, modelId);
        List<String> baseEntList = this.getBaseEntList(schemeId);
        Pair<Pair<String, String>, List<DynamicObject>> ddlPair = this.getImportTableDdl(schemeId, importTable, baseEntList, singlemetric, textfield);
        Pair<String, String> ddlCompare = this.getCopyTableDdl(compareTable, singlemetric, "decimal(34,15)", textfield, "varchar(1800)", mappingDim);
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)((String)((Pair)ddlPair.p1).p1).toLowerCase(Locale.ENGLISH));
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)((String)((Pair)ddlPair.p1).p2).toLowerCase(Locale.ENGLISH));
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)((String)ddlCompare.p1).toLowerCase(Locale.ENGLISH));
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)((String)ddlCompare.p2).toLowerCase(Locale.ENGLISH));
        SaveServiceHelper.save((DynamicObject[])((List)ddlPair.p2).toArray(new DynamicObject[0]));
        this.createIndex(importTable, compareTable);
        this.createIndexByApply(schemeId, importTable, compareTable);
    }

    private List<String> getBaseEntList(long schemeId) {
        QFilter filter = new QFilter("scheme", "=", (Object)schemeId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"number", (QFilter[])new QFilter[]{filter});
        ArrayList<String> result = new ArrayList<String>(col.size());
        col.forEach(e -> result.add(e.getString("number")));
        return result;
    }

    protected Pair<Pair<String, String>, List<DynamicObject>> getImportTableDdl(long schemeId, String tableName, List<String> baseEntList, String singlemetric, String textfield) {
        ArrayList<String> primaryKey = new ArrayList<String>(10);
        primaryKey.add("fexecuteid");
        StringBuilder sb = new StringBuilder();
        this.appendCreate(sb, tableName);
        this.buildSql(sb, "fid", "bigint");
        this.impTablePkType = "bigint";
        primaryKey.add("fid");
        this.buildSql(sb, "fexecuteid", "bigint");
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(10);
        for (String baseEnt : baseEntList) {
            this.addTableLabelObj(objectList, schemeId, tableName, baseEnt, "varchar(200)");
            this.buildSql(sb, "f" + baseEnt, "varchar(200)");
        }
        this.buildSql(sb, "f" + singlemetric, "decimal(34,15)");
        this.buildSql(sb, "f" + textfield, "varchar(1800)");
        this.buildSql(sb, "fdatafrom", "char(1)");
        sb.setCharAt(sb.length() - 1, ')');
        sb.append(";");
        String pk = String.join((CharSequence)",", primaryKey);
        String pkSql = this.buildPkSql(tableName, pk);
        return Pair.onePair((Object)Pair.onePair((Object)sb.toString(), (Object)pkSql), objectList);
    }
}

