/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.integration.di.service.DIExtendDim4ModelIntegrateService;
import kd.fi.bcm.business.integration.di.service.DIExtendDim4SchemeService;
import kd.fi.bcm.business.integration.di.service.DIModelDataHandleService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;

public class DIModelExDataHandleService
extends DIModelDataHandleService {
    @Override
    protected Pair<Set<String>, Collection<String>> getMappingDim(long id, long modelId) {
        QFilter schemeQf = new QFilter("scheme", "=", (Object)id);
        QFilter typeQf = new QFilter("mappedtype", "in", (Object)new String[]{"5", "2"});
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"number,name,mappedtype,isdimmaptargentry.tagdimension,isdimmapsrcentry.srcdimension", (QFilter[])new QFilter[]{schemeQf, typeQf}, (String)"mappedtype asc");
        HashSet<String> srcDim = new HashSet<String>(16);
        HashSet<String> targetDim = new HashSet<String>(16);
        Map dimNumMap = MemberReader.getDimensionShortNumber2NumberMap((String)this.modelNum);
        for (DynamicObject obj : load) {
            if (DimMappTypeEnum.TARGET_DEFAULT.getCode().equals(obj.getString("mappedtype"))) {
                String target = obj.getString("number");
                if (dimNumMap.containsValue(target)) {
                    targetDim.add(target);
                    continue;
                }
                this.extendMembers.add(target);
                continue;
            }
            if (!DimMappTypeEnum.SIMPLE.getCode().equals(obj.getString("mappedtype"))) continue;
            this.fillDimMap(obj.getString("number"), srcDim, targetDim, dimNumMap);
        }
        return Pair.onePair(srcDim, targetDim);
    }

    @Override
    protected Pair<Pair<String, String>, List<DynamicObject>> getImportTableDdl(long schemeId, String tableName, List<String> baseEntList, String singlemetric, String textfield) {
        ArrayList<String> primaryKey = new ArrayList<String>(10);
        primaryKey.add("fexecuteid");
        StringBuilder sb = new StringBuilder();
        this.appendCreate(sb, tableName);
        this.buildSql(sb, "fid", "bigint");
        this.impTablePkType = "bigint";
        primaryKey.add("fid");
        this.buildSql(sb, "fexecuteid", "bigint");
        DIExtendDim4ModelIntegrateService service = new DIExtendDim4ModelIntegrateService(this.scheme);
        Map<String, Tuple<String, String, Long>> fieldNumber2Name_DT_ID = service.getFieldNumber2Name_DT_ID();
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(10);
        for (String baseEnt : baseEntList) {
            boolean isExtFiled = false;
            for (Map.Entry<String, Tuple<String, String, Long>> entry : fieldNumber2Name_DT_ID.entrySet()) {
                String fileId = entry.getKey();
                if (!service.changeNumber(fileId).equals(baseEnt)) continue;
                String dataType = (String)entry.getValue().p2;
                if (dataType.equals(DataTypeEnum.TXT.getOIndex())) {
                    this.buildSql(sb, "f" + baseEnt, "varchar(200)");
                } else if (dataType.equals(DataTypeEnum.CURRENCY.getOIndex()) || dataType.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || dataType.equals(DataTypeEnum.PROPORTION.getOIndex()) || dataType.equals(DataTypeEnum.DEFAULT.getOIndex())) {
                    this.buildSql(sb, "f" + baseEnt, "decimal(34,15)");
                } else if (dataType.equals(DataTypeEnum.DATETP.getOIndex())) {
                    this.buildSql(sb, "f" + baseEnt, "datetime");
                }
                isExtFiled = true;
                break;
            }
            if (isExtFiled) continue;
            this.addTableLabelObj(objectList, schemeId, tableName, baseEnt, "varchar(200)");
            this.buildSql(sb, "f" + baseEnt, "varchar(200)");
        }
        this.buildSql(sb, "fdatafrom", "char(1)");
        sb.setCharAt(sb.length() - 1, ')');
        sb.append(";");
        String pk = String.join((CharSequence)",", primaryKey);
        String pkSql = this.buildPkSql(tableName, pk);
        return Pair.onePair((Object)Pair.onePair((Object)sb.toString(), (Object)pkSql), objectList);
    }

    @Override
    protected Pair<String, String> getCopyTableDdl(String tableName, String singlemetric, String metricType, String textfield, String textType, Pair<Set<String>, Collection<String>> mappingDim) {
        StringBuilder sbCompare = new StringBuilder();
        this.appendCreate(sbCompare, tableName);
        this.buildSql(sbCompare, "fidnew", "bigint");
        for (String srcDim : (Set)mappingDim.p1) {
            this.buildSql(sbCompare, "f" + srcDim + "_s", "varchar(100)");
        }
        for (String targetDim : (Collection)mappingDim.p2) {
            this.buildSql(sbCompare, "f" + targetDim + "_t", "varchar(100)");
        }
        DIExtendDim4SchemeService service = new DIExtendDim4SchemeService(this.scheme);
        Map<String, Tuple<String, String, Long>> fieldNumber2Name_DT_ID = service.getFieldNumber2Name_DT_ID();
        for (Map.Entry<String, Tuple<String, String, Long>> entry : fieldNumber2Name_DT_ID.entrySet()) {
            String fileId = entry.getKey();
            if (!this.extendMembers.contains(fileId)) continue;
            String dataType = (String)entry.getValue().p2;
            if (dataType.equals(DataTypeEnum.TXT.getOIndex())) {
                this.buildSql(sbCompare, "f" + fileId + "_sum", "varchar(200)");
                continue;
            }
            if (dataType.equals(DataTypeEnum.CURRENCY.getOIndex()) || dataType.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || dataType.equals(DataTypeEnum.PROPORTION.getOIndex()) || dataType.equals(DataTypeEnum.DEFAULT.getOIndex())) {
                this.buildSql(sbCompare, "f" + fileId + "_sum", "decimal(34,15)");
                continue;
            }
            if (!dataType.equals(DataTypeEnum.DATETP.getOIndex())) continue;
            this.buildSql(sbCompare, "f" + fileId + "_sum", "datetime");
        }
        this.buildSql(sbCompare, "ftraceid", "bigint");
        this.buildSql(sbCompare, "fexecuteid", "bigint");
        this.buildSql(sbCompare, "fimpid", this.impTablePkType);
        this.buildSql(sbCompare, "fmsg", "nvarchar(2000)");
        this.buildSql(sbCompare, "fmatchingstatus", "char(1)");
        this.buildSql(sbCompare, "folapstatus", "char(1)");
        sbCompare.setCharAt(sbCompare.length() - 1, ')');
        sbCompare.append(";");
        String pkSql = this.buildPkSql(tableName, "fidnew");
        return Pair.onePair((Object)sbCompare.toString(), (Object)pkSql);
    }
}

