/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.bcm.business.integration.di.model.DimMappingFilter;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import org.apache.commons.lang3.time.StopWatch;

public class DIServiceFlowService {
    private static final int SLEEP_TIME = 5000;
    private static final Log log = LogFactory.getLog(DIServiceFlowService.class);
    private DynamicObject scheme;
    private Map<String, List<DimMappingFilter>> filterMap;
    private String serviceParam;

    public DIServiceFlowService(DynamicObject scheme, Map<String, List<DimMappingFilter>> filterMap, String serviceParam) {
        this.scheme = scheme;
        this.filterMap = filterMap;
        this.serviceParam = serviceParam;
    }

    public String callServiceFlow() {
        Map result;
        DynamicObject serviceFlow = this.scheme.getDynamicObject("serviceflow");
        if (serviceFlow == null) {
            return "";
        }
        String name = serviceFlow.getString("name");
        if (!serviceFlow.getBoolean("enable")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b[%s]\u672a\u542f\u7528", (String)"XExtendIntegrationService_0", (String)"fi-bcm-business", (Object[])new Object[]{name}));
        }
        ArrayList inputs = new ArrayList();
        DynamicObjectCollection methodParams = this.scheme.getDynamicObjectCollection("entryentity");
        if (methodParams != null && !methodParams.isEmpty()) {
            methodParams.removeIf(e -> e.getInt("flowparam") <= 0);
        }
        if (methodParams != null && !methodParams.isEmpty()) {
            LinkedHashMap<String, Object> defaultValue = new LinkedHashMap<String, Object>(16);
            methodParams.sort(Comparator.comparingInt(o -> o.getInt("flowparam")));
            for (DynamicObject methodParam : methodParams) {
                defaultValue.put(methodParam.getString("paramname"), methodParam.getString("defaultvalue"));
            }
            Map<String, Map<String, List<String>>> mappingParams = this.getMappingParams();
            defaultValue.forEach((paramName, v) -> {
                Map mappingParam = (Map)mappingParams.get(paramName);
                if (mappingParam == null) {
                    HashMap<String, ArrayList> item = new HashMap<String, ArrayList>(16);
                    item.put("in", Lists.newArrayList((Object[])new String[]{v.toString()}));
                    inputs.add(item);
                } else {
                    inputs.add(mappingParam);
                }
            });
        }
        if (this.serviceParam != null && ConfigServiceHelper.getGlobalBoolParam("isSendServiceParam")) {
            HashMap<String, ArrayList> item = new HashMap<String, ArrayList>(16);
            item.put("in", Lists.newArrayList((Object[])new String[]{this.serviceParam}));
            inputs.add(item);
        }
        StopWatch sw = new StopWatch();
        sw.start();
        long id = inputs.isEmpty() ? ((Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{serviceFlow.getString("number")})).longValue() : ((Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{serviceFlow.getString("number"), inputs})).longValue();
        log.info("DIImportDataService callServiceFlow: " + name + " param: " + inputs);
        while (true) {
            if (!(result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"getState", (Object[])new Object[]{id})).containsKey("state") || result.get("state") == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b[%1$s]\u6267\u884c\u5931\u8d25\uff1a%2$s", (String)"XExtendIntegrationService_2", (String)"fi-bcm-business", (Object[])new Object[0]), name, result));
            }
            String state = (String)result.get("state");
            if ("Failed".equals(state)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b[%1$s]\u6267\u884c\u5931\u8d25\uff1a%2$s", (String)"XExtendIntegrationService_2", (String)"fi-bcm-business", (Object[])new Object[0]), name, result.get("output")));
            }
            if ("Complete".equals(state)) break;
            if ("Terminated".equals(state)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u201c%s\u201d\u5df2\u64a4\u9500\u3002", (String)"XExtendIntegrationService_4", (String)"fi-bcm-business", (Object[])new Object[0]), name));
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e2) {
                throw new KDBizException(e2.getMessage());
            }
        }
        sw.split();
        String spendTime = String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u6267\u884c\u8017\u65f6:%1$s\uff0c\u4f20\u9012\u53c2\u6570\uff1a%2$s", (String)"XExtendIntegrationService_6", (String)"fi-bcm-business", (Object[])new Object[0]), sw.toSplitString(), SerializationUtils.toJsonString(inputs));
        String output = String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u6267\u884c\u7ed3\u679c\uff1a%s", (String)"XExtendIntegrationService_7", (String)"fi-bcm-business", (Object[])new Object[0]), result.get("output"));
        StringBuilder sb = new StringBuilder();
        sb.append(spendTime).append("\n").append(output);
        sw.stop();
        log.info("DIImportDataService callServiceFlow: " + name + " res: " + result);
        return sb.toString();
    }

    private Map<String, Map<String, List<String>>> getMappingParams() {
        HashMap<String, Map<String, List<String>>> result = new HashMap<String, Map<String, List<String>>>(16);
        this.filterMap.forEach((k, v) -> v.forEach(dimMappingFilter -> dimMappingFilter.getCellInfo().forEach(f -> {
            String targetDim = f.getTargetDim();
            result.computeIfAbsent(targetDim, m -> new HashMap());
            Map temp = (Map)result.get(targetDim);
            f.getOriginalValue().forEach((key, value) -> temp.merge(key, Lists.newArrayList((Object[])new String[]{value}), (v1, v2) -> {
                List cellValue = (List)temp.get(key);
                cellValue.add(value);
                return cellValue;
            }));
        })));
        return result;
    }
}

