/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.servicehelper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.integration.di.ctx.DIContextParam;
import kd.fi.bcm.business.integration.di.service.DIIntegrateDispatcher2;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.enums.integration.di.DIOperationEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class DIIntegrateServiceHelper {
    private static final String ALL = "*";

    public static Map<String, Object> doCollect(Long mark, Long modelId, List<Long> orgIds, Long scenarioId, Long yearId, Long periodId, Long currencyId, List<Long> schemeIds, Set<String> tarCollectStatus, String addParam) {
        tarCollectStatus.remove(" ");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode scenario = MemberReader.findScenaMemberById((String)modelNum, (Long)scenarioId);
        IDNumberTreeNode year = MemberReader.findFyMemberById((String)modelNum, (Long)yearId);
        IDNumberTreeNode period = MemberReader.findPeriodMemberById((String)modelNum, (Long)periodId);
        IDNumberTreeNode currency = MemberReader.findCurrencyMemberById((String)modelNum, (Long)currencyId);
        DynamicObject[] schemeAssigns = DIIntegrateServiceHelper.getSchemeAssignRecords(modelId, schemeIds);
        HashMap<String, Long> orgMap = new HashMap<String, Long>();
        orgIds.forEach(e -> {
            IDNumberTreeNode org = MemberReader.findEntityMemberById((String)modelNum, (Long)e);
            orgMap.put(org.getNumber(), (Long)e);
        });
        Table<Long, Long, DynamicObject> schemeOrgIdTable = DIIntegrateServiceHelper.getSchemeOrgIdTable(modelId, orgMap, schemeAssigns);
        ArrayList<Long> schemes = new ArrayList<Long>(schemeOrgIdTable.rowKeySet());
        DIIntegrationUtil.filterSchemeByScenarioAndDate(modelId, scenario.getNumber(), period.getNumber(), year.getNumber(), schemes, Boolean.TRUE);
        Pair<Set<Long>, Set<Long>> periodMemberPair = DIIntegrateServiceHelper.filterDim(modelId, schemes, period.getNumber(), "Period");
        Pair<Set<Long>, Set<Long>> fyMemberPair = DIIntegrateServiceHelper.filterDim(modelId, schemes, year.getNumber(), "Year");
        Pair<Set<Long>, Set<Long>> curMemberPair = DIIntegrateServiceHelper.filterDim(modelId, schemes, currency.getNumber(), "Currency");
        Pair<Set<Long>, Set<Long>> sceneMemberPair = DIIntegrateServiceHelper.filterDim(modelId, schemes, scenario.getNumber(), "Scenario");
        Map<String, String> recordStatusMap = DIIntegrateServiceHelper.collectRecordStatus(modelId, orgIds, scenarioId, yearId, periodId, currencyId, schemes);
        ArrayList needRemove = Lists.newArrayList();
        for (Table.Cell cell : schemeOrgIdTable.cellSet()) {
            String key = cell.getRowKey() + "_" + cell.getColumnKey();
            if (!schemeIds.contains(cell.getRowKey()) || !orgIds.contains(cell.getColumnKey())) {
                needRemove.add(key);
                continue;
            }
            if (tarCollectStatus.size() > 0 && tarCollectStatus.stream().noneMatch(status -> status.equals(recordStatusMap.getOrDefault(key, Integer.toString(CollectStatusEnum.READY.getValue()))))) {
                needRemove.add(key);
                continue;
            }
            if (!((Set)periodMemberPair.p1).contains(cell.getRowKey()) || ((Set)periodMemberPair.p2).contains(cell.getRowKey())) {
                needRemove.add(key);
                continue;
            }
            if (!((Set)fyMemberPair.p1).contains(cell.getRowKey()) || ((Set)fyMemberPair.p2).contains(cell.getRowKey())) {
                needRemove.add(key);
                continue;
            }
            if (!((Set)curMemberPair.p1).contains(cell.getRowKey()) || ((Set)curMemberPair.p2).contains(cell.getRowKey())) {
                needRemove.add(key);
                continue;
            }
            if (((Set)sceneMemberPair.p1).contains(cell.getRowKey()) && !((Set)sceneMemberPair.p2).contains(cell.getRowKey())) continue;
            needRemove.add(key);
        }
        for (Object s : needRemove) {
            String[] idArray = ((String)s).split("_");
            schemeOrgIdTable.remove((Object)Long.parseLong(idArray[0]), (Object)Long.parseLong(idArray[1]));
        }
        IntegrateEntity intEntity = new IntegrateEntity();
        intEntity.setModel(modelId, modelNum);
        intEntity.setScene(scenario.getId(), scenario.getNumber());
        intEntity.setYear(year.getId(), year.getNumber());
        intEntity.setPeriod(period.getId(), period.getNumber());
        intEntity.setCurrency(currency.getId(), currency.getNumber());
        intEntity.putCustomParam("scheduleLogId", mark);
        intEntity.putCustomParam("operation", DIOperationEnum.OpExecuteAll);
        if (addParam != null && !"-999".equals(addParam)) {
            intEntity.putCustomParam(DIContextParam.SERVICE_PARAM, addParam);
        }
        for (Table.Cell cell : schemeOrgIdTable.cellSet()) {
            Long orgId = (Long)cell.getColumnKey();
            Long schemeId = (Long)cell.getRowKey();
            String orgNum = MemberReader.findEntityMemberById((String)modelNum, (Long)orgId).getNumber();
            String schemeNum = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"bcm_isscheme").getString("number");
            intEntity.addOrgSchemePair(orgId, orgNum, schemeId, schemeNum);
        }
        DIIntegrateDispatcher2.submitTaskDistribute(intEntity, false);
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        ArrayList<String> resList = new ArrayList<String>(16);
        for (Map.Entry<String, String> map : recordStatusMap.entrySet()) {
            if (!(CollectStatusEnum.RUNNING.getValue() + "").equals(map.getValue()) && !(CollectStatusEnum.LINEUP.getValue() + "").equals(map.getValue())) continue;
            resList.add(map.getKey() + ":" + map.getValue());
        }
        resMap.put("unableRecord", resList);
        return resMap;
    }

    private static Pair<Set<Long>, Set<Long>> filterDim(Long modelId, List<Long> schemes, final String dimNumberNum, String dimNum) {
        Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
        Pair<Map<String, Set<Long>>, Map<String, Set<Long>>> periodPair = DIIntegrationUtil.getSimpleMapAndDefaultTar(dimId, schemes, (List<String>)new ArrayList<String>(){
            {
                this.add(dimNumberNum);
            }
        });
        return Pair.onePair(((Map)periodPair.p1).containsKey(dimNumberNum) ? (Set)((Map)periodPair.p1).get(dimNumberNum) : new HashSet(), ((Map)periodPair.p2).containsKey(dimNumberNum) ? (Set)((Map)periodPair.p2).get(dimNumberNum) : new HashSet());
    }

    private static Map<String, String> collectRecordStatus(Long modelId, List<Long> orgIds, Long scenarioId, Long yearId, Long periodId, Long currencyId, List<Long> schemeIds) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("scenario", "=", (Object)scenarioId);
        qf.add("fy", "=", (Object)yearId);
        qf.add("period", "=", (Object)periodId);
        qf.add("currency", "=", (Object)currencyId);
        qf.add("scheme", "in", schemeIds);
        qf.add("org.number", "in", (Object)MemberReader.change2MemberNumsById((long)modelId, (String)"bcm_entitymembertree", orgIds));
        HashMap<String, String> result = new HashMap<String, String>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_isschemeexecuterec", (String)"scheme,org,collectstatus", (QFilter[])qf.toArray(), null);){
            ds.forEachRemaining(row -> result.put(row.getString("scheme") + "_" + row.getString("org"), row.getString("collectstatus")));
        }
        return result;
    }

    private static DynamicObject[] getSchemeAssignRecords(Long modelId, List<Long> schemeIds) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        if (schemeIds != null) {
            qfBuilder.add("scheme", "in", schemeIds);
        }
        qfBuilder.add(QFilter.of((String)"scheme.enable = ?", (Object[])new Object[]{true}));
        qfBuilder.add(QFilter.of((String)"scheme.istarg.number = ?", (Object[])new Object[]{"NG"}));
        String selectProperties = "scheme,entity,property,propertyvalue,range";
        return BusinessDataServiceHelper.load((String)"bcm_isschemeassignentity", (String)selectProperties, (QFilter[])qfBuilder.toArray(), (String)"scheme desc");
    }

    private static Table<Long, Long, DynamicObject> getSchemeOrgIdTable(Long modelId, Map<String, Long> orgMap, DynamicObject[] assignRecords) {
        Long entityId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        ArrayList<Long> schemeIds = new ArrayList<Long>(10);
        for (DynamicObject schemeAssign : assignRecords) {
            schemeIds.add(schemeAssign.getDynamicObject("scheme").getLong("id"));
        }
        Pair<Map<String, Set<Long>>, Map<String, Set<Long>>> orgMember2Pair = DIIntegrationUtil.getSimpleMapAndDefaultTar(entityId, schemeIds, new ArrayList<String>(orgMap.keySet()));
        HashBasedTable schemeOrgIdMaps = HashBasedTable.create();
        for (DynamicObject schemeAssign : assignRecords) {
            String number;
            long id;
            DynamicObject entity = schemeAssign.getDynamicObject("entity");
            boolean isCustom = false;
            if (entity == null) {
                isCustom = true;
                DynamicObject propertyValue = schemeAssign.getDynamicObject("propertyvalue");
                if (ObjectUtils.isEmpty((Object)propertyValue)) continue;
                id = propertyValue.getLong("id");
                number = propertyValue.getString("number");
            } else {
                id = entity.getLong("id");
                number = entity.getString("number");
            }
            MembRangeItem rangItem = new MembRangeItem("bcm_entitymembertree", (Long)id, number, schemeAssign.getInt("range"), isCustom, (Object)modelId);
            rangItem.matchItems(arg_0 -> DIIntegrateServiceHelper.lambda$getSchemeOrgIdTable$3(orgMap, schemeAssign, orgMember2Pair, (Table)schemeOrgIdMaps, arg_0));
        }
        return schemeOrgIdMaps;
    }

    public static String getJsonStr(Object obj) {
        return JSONObject.toJSONString((Object)obj);
    }

    public static boolean checkOpPermission(long modelId, String entityNum, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        if (MemberPermHelper.ifUserHasRootPermByModel(userId, String.valueOf(modelId))) {
            return true;
        }
        int permission = PermissionServiceHelper.checkPermission((long)userId, (String)"bcm_model", (long)modelId, (String)AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.DI.getAppnum()).getId(), (String)entityNum, (String)permItemId);
        return permission != 0;
    }

    private static /* synthetic */ void lambda$getSchemeOrgIdTable$3(Map orgMap, DynamicObject schemeAssign, Pair orgMember2Pair, Table schemeOrgIdMaps, SimpleItem c) {
        DynamicObject scheme;
        if (orgMap.containsKey(c.number) && (scheme = schemeAssign.getDynamicObject("scheme")) != null) {
            Long schemeid = scheme.getLong("id");
            if ((((Map)orgMember2Pair.p1).get(c.number) != null && ((Set)((Map)orgMember2Pair.p1).get(c.number)).contains(schemeid) || ((Map)orgMember2Pair.p1).get(ALL) != null && ((Set)((Map)orgMember2Pair.p1).get(ALL)).contains(schemeid)) && (((Map)orgMember2Pair.p2).get(c.number) == null || !((Set)((Map)orgMember2Pair.p2).get(c.number)).contains(schemeid))) {
                schemeOrgIdMaps.put((Object)schemeid, orgMap.get(c.number), (Object)scheme);
            }
        }
    }
}

