/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.di.model.CellFilterInfo;
import kd.fi.bcm.business.integration.di.model.DimMappingFilter;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class DIImportDataUtil {
    private static final String PRE_PARAM = "param_";
    private static final String SCHEME_PARAM = "schemeparam";
    private static final String ALL = "*";

    public static Map<String, List<DimMappingFilter>> getParamMap(DynamicObject scheme, Long modelId, Long scenarioId, Long yearId, Long periodId, Long currencyId, Long orgId) {
        long schemeId = scheme.getLong("id");
        Map<String, String> inputParam = DIImportDataUtil.getNumberMap(modelId, scenarioId, yearId, periodId, currencyId, orgId);
        HashMap<String, List<DimMappingFilter>> result = new HashMap<String, List<DimMappingFilter>>(16);
        Map<String, List<Tuple<Long, Long, String>>> dimMap = DIImportDataUtil.getDimMap(inputParam, schemeId);
        HashMap<String, Integer> paramKeyIndex = new HashMap<String, Integer>(16);
        HashSet<String> existSrcDim = new HashSet<String>(16);
        for (Map.Entry<String, List<Tuple<Long, Long, String>>> entry : dimMap.entrySet()) {
            String targetDim = entry.getKey();
            if (entry.getValue() == null || !inputParam.containsKey(targetDim)) continue;
            ArrayList<DimMappingFilter> filters = new ArrayList<DimMappingFilter>(10);
            for (Tuple<Long, Long, String> tuple : entry.getValue()) {
                QFilter qf = new QFilter("schemeid", "=", (Object)schemeId);
                qf.and("dimmapid", "=", tuple.p1);
                DynamicObject[] memberMap = BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)"id,isgrouptargmapentry.tarmembnumber,isgroupsrcmapentry,isgroupsrcmapentry.scope,isgroupsrcmapentry.srcmembnumber,isgroupsrcmapentry.srcdimension", (QFilter[])new QFilter[]{qf});
                List<DynamicObject> memberMapList = DIImportDataUtil.turnListFromArray(memberMap);
                memberMapList = DIImportDataUtil.addInheritMemerMap(memberMapList, (Long)tuple.p1, (Long)tuple.p2);
                boolean haveAll = false;
                boolean haveFind = false;
                DimMappingFilter dimMappingFilter = new DimMappingFilter();
                for (DynamicObject dynamicObject : memberMapList) {
                    String targetNumber = ((DynamicObject)dynamicObject.getDynamicObjectCollection("isgrouptargmapentry").get(0)).getString("tarmembnumber");
                    DynamicObjectCollection srcMapEntry = DIImportDataUtil.getSrcMapEntry(dynamicObject, (Long)tuple.p2);
                    if (inputParam.get(targetDim).equals(targetNumber)) {
                        DIImportDataUtil.addParamMap(dimMappingFilter, paramKeyIndex, (String)tuple.p3, targetDim, srcMapEntry);
                        haveFind = true;
                        existSrcDim.add((String)tuple.p3);
                    }
                    if (!ALL.equals(targetNumber) || !ALL.equals(((DynamicObject)srcMapEntry.get(0)).getString("srcmembnumber"))) continue;
                    haveAll = true;
                }
                if (!haveFind && haveAll) {
                    DIImportDataUtil.addParamMap(dimMappingFilter, paramKeyIndex, (String)tuple.p3, targetDim, inputParam.get(targetDim));
                    existSrcDim.add((String)tuple.p3);
                }
                if (dimMappingFilter.isEmpty()) continue;
                filters.add(dimMappingFilter);
            }
            if (filters.isEmpty()) continue;
            result.put(targetDim, filters);
        }
        DIImportDataUtil.fillSchemeParams(existSrcDim, result, paramKeyIndex, scheme);
        return result;
    }

    private static List<DynamicObject> turnListFromArray(DynamicObject[] memberMap) {
        ArrayList<DynamicObject> memberMapList = new ArrayList<DynamicObject>(memberMap.length);
        for (DynamicObject obj : memberMap) {
            memberMapList.add(obj);
        }
        return memberMapList;
    }

    private static List<DynamicObject> addInheritMemerMap(List<DynamicObject> dimMappingList, Long dimmapid, Long baseId) {
        QFilter numberQf;
        DynamicObjectCollection dimMapping = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id, inheritancescheme.id, number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimmapid)});
        if (dimMapping == null || dimMapping.size() == 0) {
            return dimMappingList;
        }
        long inheritanceschemeId = ((DynamicObject)dimMapping.get(0)).getLong("inheritancescheme.id");
        if (inheritanceschemeId == 0L) {
            return dimMappingList;
        }
        String number = ((DynamicObject)dimMapping.get(0)).getString("number");
        QFilter schemeQf = new QFilter("scheme", "=", (Object)inheritanceschemeId);
        DynamicObjectCollection dimMappingInher = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id, inheritancescheme.id, number", (QFilter[])new QFilter[]{schemeQf, numberQf = new QFilter("number", "=", (Object)number)});
        if (CollectionUtil.isEmpty((Collection)dimMappingInher)) {
            return dimMappingList;
        }
        List ids = dimMappingInher.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        DynamicObject[] memberMap = BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)"id,isgrouptargmapentry.tarmembnumber,isgroupsrcmapentry,isgroupsrcmapentry.scope,isgroupsrcmapentry.srcmembnumber,isgroupsrcmapentry.srcdimension", (QFilter[])new QFilter[]{new QFilter("dimmapid", "in", ids)});
        DynamicObject baseObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_isbaseentlist", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)baseId)});
        String baseNumber = baseObj.getString("number");
        for (DynamicObject obj : memberMap) {
            DynamicObjectCollection srcCol = obj.getDynamicObjectCollection("isgroupsrcmapentry");
            for (DynamicObject srcObj : srcCol) {
                Long tempBaseId = srcObj.getLong("srcdimension");
                DynamicObject tempbaseObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_isbaseentlist", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tempBaseId)});
                if (!baseNumber.equals(tempbaseObj.getString("number"))) continue;
                srcObj.set("srcdimension", (Object)baseId);
            }
            dimMappingList.add(obj);
        }
        return dimMappingList;
    }

    public static Map<String, List<DimMappingFilter>> getOtherDimFilter(Long schemeId, Map<String, String> inputParam, long srcModelId) {
        HashMap<String, List<DimMappingFilter>> result = new HashMap<String, List<DimMappingFilter>>(16);
        Map<String, List<Tuple<Long, Long, String>>> srcdimMap = DIImportDataUtil.getSrcDimMap(inputParam, schemeId, srcModelId);
        for (Map.Entry<String, List<Tuple<Long, Long, String>>> entry : srcdimMap.entrySet()) {
            String srcDim = entry.getKey();
            if (entry.getValue() == null || !inputParam.containsKey(srcDim)) continue;
            ArrayList<DimMappingFilter> filters = new ArrayList<DimMappingFilter>(10);
            for (Tuple<Long, Long, String> tuple : entry.getValue()) {
                QFilter qf = new QFilter("schemeid", "=", (Object)schemeId);
                qf.and("dimmapid", "=", tuple.p1);
                DynamicObject[] memberMap = BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)"id,isgrouptargmapentry.tarmembnumber,isgroupsrcmapentry,isgroupsrcmapentry.scope,isgroupsrcmapentry.srcmembnumber,isgroupsrcmapentry.srcdimension", (QFilter[])new QFilter[]{qf});
                List<DynamicObject> memberMapList = DIImportDataUtil.turnListFromArray(memberMap);
                memberMapList = DIImportDataUtil.addInheritMemerMap(memberMapList, (Long)tuple.p1, (Long)tuple.p2);
                DimMappingFilter dimMappingFilter = new DimMappingFilter();
                for (DynamicObject dynamicObject : memberMapList) {
                    DynamicObjectCollection srcMapEntry = DIImportDataUtil.getSrcMapEntry(dynamicObject, (Long)tuple.p2);
                    if (inputParam.get(srcDim) != null) continue;
                    DIImportDataUtil.addBcmImportParamMap(dimMappingFilter, (String)tuple.p3, "", srcMapEntry);
                }
                if (dimMappingFilter.isEmpty()) continue;
                filters.add(dimMappingFilter);
            }
            if (filters.isEmpty()) continue;
            result.put(srcDim, filters);
        }
        return result;
    }

    private static Map<String, List<Tuple<Long, Long, String>>> getSrcDimMap(Map<String, String> inputParam, long schemeId, long srcModelId) {
        Map<String, String> lowercaseMap = DIImportDataUtil.getLowerCaseMap(srcModelId);
        QFilter qf = new QFilter("scheme", "=", (Object)schemeId);
        qf.and("mappedtype", "=", (Object)DimMappTypeEnum.SIMPLE.getCode());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id,isdimmaptargentry.tagdimension,isdimmapsrcentry.srcdimension", (QFilter[])new QFilter[]{qf});
        HashMap<String, List> dimMap = new HashMap<String, List>();
        inputParam.keySet().forEach(k -> {
            List cfr_ignored_0 = dimMap.put((String)k, (List)null);
        });
        for (DynamicObject dynamicObject : load) {
            DynamicObjectCollection srcentrys = dynamicObject.getDynamicObjectCollection("isdimmapsrcentry");
            String srcDim = DIIntegrationUtil.getBaseEntListNumberById(((DynamicObject)srcentrys.get(0)).getLong("srcdimension_id"));
            if (!dimMap.containsKey(srcDim = lowercaseMap.getOrDefault(srcDim, ""))) continue;
            srcentrys = dynamicObject.getDynamicObjectCollection("isdimmapsrcentry");
            long srcdimensionId = ((DynamicObject)srcentrys.get(0)).getLong("srcdimension_id");
            DynamicObject baseEnt = BusinessDataServiceHelper.loadSingle((Object)srcdimensionId, (String)"bcm_isbaseentlist", (String)"id,number");
            dimMap.computeIfAbsent(srcDim, l -> new ArrayList(10));
            List list = (List)dimMap.get(srcDim);
            list.add(Tuple.create((Object)dynamicObject.getLong("id"), (Object)srcdimensionId, (Object)baseEnt.getString("number")));
        }
        HashMap<String, List<Tuple<Long, Long, String>>> resDimMap = new HashMap<String, List<Tuple<Long, Long, String>>>();
        dimMap.forEach((k, v) -> {
            if (v != null) {
                resDimMap.put((String)k, (List<Tuple<Long, Long, String>>)v);
            }
        });
        return resDimMap;
    }

    public static Map<String, String> getLowerCaseMap(long modelId) {
        Map dimMap = MemberReader.getDimNumberMapNameById((long)modelId);
        HashMap<String, String> lowercaseMap = new HashMap<String, String>(dimMap.size());
        dimMap.forEach((key, value) -> lowercaseMap.put(key.toLowerCase(), (String)key));
        return lowercaseMap;
    }

    private static void addBcmImportParamMap(DimMappingFilter dimMappingFilter, String srcDim, String targetDim, DynamicObjectCollection srcMapEntry) {
        CellFilterInfo info = new CellFilterInfo();
        info.setSrcDim(srcDim);
        info.setTargetDim(targetDim);
        int scope = ((DynamicObject)srcMapEntry.get(0)).getInt("scope");
        String firstMember = ((DynamicObject)srcMapEntry.get(0)).getString("srcmembnumber");
        info.setType(scope);
        switch (scope) {
            case 1: {
                info.setSql(" = ?");
                info.addSqlParam(firstMember);
                break;
            }
            case 2: {
                info.setSql(" between ? and ?");
                info.addSqlParam(firstMember);
                info.addSqlParam(((DynamicObject)srcMapEntry.get(1)).getString("srcmembnumber"));
                break;
            }
            case 3: {
                info.setSql(" like ?");
                info.addSqlParam(firstMember);
                break;
            }
            case 4: {
                StringBuilder sb = new StringBuilder();
                StringBuilder sqlSb = new StringBuilder(" in(");
                for (DynamicObject object : srcMapEntry) {
                    sb.append("'").append(object.getString("srcmembnumber")).append("'").append(",");
                    sqlSb.append("?,");
                    info.addSqlParam(object.getString("srcmembnumber"));
                }
                sqlSb.setCharAt(sqlSb.length() - 1, ')');
                info.setSql(sqlSb.toString());
                break;
            }
            case 5: {
                info.setSql(" <> ?");
                info.addSqlParam(firstMember);
                break;
            }
            case 6: {
                info.setSql(" not between (? and ?)");
                info.addSqlParam(firstMember);
                info.addSqlParam(((DynamicObject)srcMapEntry.get(1)).getString("srcmembnumber"));
                break;
            }
            case 7: {
                info.setSql(" not like ?");
                info.addSqlParam(firstMember);
                break;
            }
            case 8: {
                StringBuilder sb = new StringBuilder();
                StringBuilder sqlSb = new StringBuilder(" not in(");
                for (DynamicObject object : srcMapEntry) {
                    sb.append("'").append(object.getString("srcmembnumber")).append("'").append(",");
                    sqlSb.append("?,");
                    info.addSqlParam(object.getString("srcmembnumber"));
                }
                sqlSb.setCharAt(sqlSb.length() - 1, ')');
                info.setSql(sqlSb.toString());
            }
        }
        dimMappingFilter.addCellInfo(info);
    }

    private static DynamicObjectCollection getSrcMapEntry(DynamicObject groupMapping, long srcDimId) {
        DynamicObjectCollection srcCol = groupMapping.getDynamicObjectCollection("isgroupsrcmapentry");
        srcCol.removeIf(src -> src.getLong("srcdimension") != srcDimId);
        return srcCol;
    }

    private static Map<String, List<Tuple<Long, Long, String>>> getDimMap(Map<String, String> inputParam, long schemeId) {
        QFilter qf = new QFilter("scheme", "=", (Object)schemeId);
        qf.and("mappedtype", "=", (Object)DimMappTypeEnum.SIMPLE.getCode());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id,isdimmaptargentry.tagdimension,isdimmapsrcentry.srcdimension", (QFilter[])new QFilter[]{qf});
        HashMap<String, List> dimMap = new HashMap<String, List>();
        inputParam.keySet().forEach(k -> {
            List cfr_ignored_0 = dimMap.put((String)k, (List)null);
        });
        for (DynamicObject dynamicObject : load) {
            DynamicObjectCollection targentrys = dynamicObject.getDynamicObjectCollection("isdimmaptargentry");
            String targetDim = MemberReader.getDimensionNumById((long)((DynamicObject)targentrys.get(0)).getLong("tagdimension_id"));
            if (!dimMap.containsKey(targetDim)) continue;
            DynamicObjectCollection srcentrys = dynamicObject.getDynamicObjectCollection("isdimmapsrcentry");
            long srcdimensionId = ((DynamicObject)srcentrys.get(0)).getLong("srcdimension_id");
            DynamicObject baseEnt = BusinessDataServiceHelper.loadSingle((Object)srcdimensionId, (String)"bcm_isbaseentlist", (String)"id,number");
            dimMap.computeIfAbsent(targetDim, l -> new ArrayList(10));
            List list = (List)dimMap.get(targetDim);
            list.add(Tuple.create((Object)dynamicObject.getLong("id"), (Object)srcdimensionId, (Object)baseEnt.getString("number")));
        }
        HashMap<String, List<Tuple<Long, Long, String>>> resDimMap = new HashMap<String, List<Tuple<Long, Long, String>>>();
        dimMap.forEach((k, v) -> {
            if (v == null) {
                if (DimTypesEnum.YEAR.getNumber().equals(k) || DimTypesEnum.PERIOD.getNumber().equals(k)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6%s\u7f3a\u5c11\u6210\u5458\u6620\u5c04", (String)"DIExecuteDetailPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), k));
                }
            } else {
                resDimMap.put((String)k, (List<Tuple<Long, Long, String>>)v);
            }
        });
        return resDimMap;
    }

    private static Map<String, String> getNumberMap(Long modelId, Long scenarioId, Long yearId, Long periodId, Long currencyId, Long orgId) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        HashMap<String, String> numberMap = new HashMap<String, String>();
        IDNumberTreeNode scenarioMember = MemberReader.findScenaMemberById((String)modelNumber, (Long)scenarioId);
        numberMap.put(scenarioMember.getDimNumber(), scenarioMember.getNumber());
        IDNumberTreeNode fyMember = MemberReader.findFyMemberById((String)modelNumber, (Long)yearId);
        numberMap.put(fyMember.getDimNumber(), fyMember.getNumber());
        IDNumberTreeNode periodMember = MemberReader.findPeriodMemberById((String)modelNumber, (Long)periodId);
        numberMap.put(periodMember.getDimNumber(), periodMember.getNumber());
        IDNumberTreeNode currencyMember = MemberReader.findCurrencyMemberById((String)modelNumber, (Long)currencyId);
        if (!IDNumberTreeNode.NotFoundTreeNode.equals(currencyMember)) {
            numberMap.put(currencyMember.getDimNumber(), currencyMember.getNumber());
        }
        IDNumberTreeNode entityMember = MemberReader.findEntityMemberById((String)modelNumber, (Long)orgId);
        numberMap.put(entityMember.getDimNumber(), entityMember.getNumber());
        return numberMap;
    }

    private static void fillSchemeParams(Set<String> existSrcDim, Map<String, List<DimMappingFilter>> paramMap, Map<String, Integer> paramKeyIndex, DynamicObject scheme) {
        String tableName = scheme.getString("extendstable");
        HashSet<String> unVarCharFields = new HashSet<String>(16);
        if (DB.exitsTable((DBRoute)BCMConstant.DBROUTE, (String)tableName)) {
            List fields = DB.getFieldInfo((DBRoute)BCMConstant.DBROUTE, (String)tableName);
            for (FieldInfo field : fields) {
                switch (field.getDataType()) {
                    case "decimal(19,0)": 
                    case "decimal(10,0)": 
                    case "decimal": 
                    case "numeric": {
                        unVarCharFields.add(field.getFieldName());
                    }
                }
            }
        }
        DynamicObjectCollection entryentity = scheme.getDynamicObjectCollection("entryentity");
        ArrayList<DimMappingFilter> filters = new ArrayList<DimMappingFilter>(10);
        for (DynamicObject obj : entryentity) {
            DimMappingFilter filter = new DimMappingFilter();
            String srcParamNumber = obj.getString("srcparamnumber");
            String defaultValue = obj.getString("defaultvalue");
            String paramName = obj.getString("paramname");
            if (existSrcDim.contains(srcParamNumber) || StringUtils.isEmpty((CharSequence)srcParamNumber) || StringUtils.isEmpty((CharSequence)defaultValue)) continue;
            Object value = defaultValue;
            if (unVarCharFields.contains(srcParamNumber)) {
                value = new BigDecimal(defaultValue);
            }
            DIImportDataUtil.addParamMap(filter, paramKeyIndex, srcParamNumber, paramName, value);
            filters.add(filter);
        }
        paramMap.put(SCHEME_PARAM, filters);
    }

    private static void addParamMap(DimMappingFilter dimMappingFilter, Map<String, Integer> paramKeyIndex, String srcDim, String targetDim, Object value) {
        paramKeyIndex.putIfAbsent(srcDim, 0);
        int index = paramKeyIndex.get(srcDim);
        CellFilterInfo info = new CellFilterInfo();
        info.setSrcDim(srcDim);
        info.setTargetDim(targetDim);
        info.setType(1);
        info.setMember(value.toString());
        info.setSymbol("=");
        info.setParamKey(PRE_PARAM + srcDim + index);
        info.setSql(" = ?");
        info.addSqlParam(value);
        HashMap<String, String> originalValue = new HashMap<String, String>(16);
        originalValue.put("in", value.toString());
        info.setOriginalValue(originalValue);
        paramKeyIndex.put(srcDim, ++index);
        dimMappingFilter.addCellInfo(info);
    }

    private static void addParamMap(DimMappingFilter dimMappingFilter, Map<String, Integer> paramKeyIndex, String srcDim, String targetDim, DynamicObjectCollection srcMapEntry) {
        CellFilterInfo info = new CellFilterInfo();
        info.setSrcDim(srcDim);
        info.setTargetDim(targetDim);
        int scope = ((DynamicObject)srcMapEntry.get(0)).getInt("scope");
        String firstMember = ((DynamicObject)srcMapEntry.get(0)).getString("srcmembnumber");
        if (ALL.equals(firstMember)) {
            return;
        }
        info.setType(scope);
        paramKeyIndex.putIfAbsent(srcDim, 0);
        int index = paramKeyIndex.get(srcDim);
        switch (scope) {
            case 1: {
                info.setMember(firstMember);
                info.setSymbol("=");
                info.setParamKey(PRE_PARAM + srcDim + index);
                info.setSql(" = ?");
                info.addSqlParam(firstMember);
                ++index;
                break;
            }
            case 2: {
                info.setMemberPair((Pair<String, String>)Pair.onePair((Object)firstMember, (Object)((DynamicObject)srcMapEntry.get(1)).getString("srcmembnumber")));
                info.setSymbolPair((Pair<String, String>)Pair.onePair((Object)">=", (Object)"<="));
                info.setParamKeyPair((Pair<String, String>)Pair.onePair((Object)(PRE_PARAM + srcDim + index), (Object)(PRE_PARAM + srcDim + (index + 1))));
                info.setSql(" between ? and ?");
                info.addSqlParam(firstMember);
                info.addSqlParam(((DynamicObject)srcMapEntry.get(1)).getString("srcmembnumber"));
                index += 2;
                break;
            }
            case 3: {
                info.setMember(firstMember.replace("%", ""));
                info.setSymbol(firstMember.indexOf("%") == 0 ? "ENDS_WITH" : "STARTS_WITH");
                info.setParamKey(PRE_PARAM + srcDim + index);
                info.setSql(" like ?");
                info.addSqlParam(firstMember);
                ++index;
                break;
            }
            case 4: {
                StringBuilder sb = new StringBuilder();
                StringBuilder sqlSb = new StringBuilder(" in(");
                for (DynamicObject object : srcMapEntry) {
                    sb.append("'").append(object.getString("srcmembnumber")).append("'").append(",");
                    sqlSb.append("?,");
                    info.addSqlParam(object.getString("srcmembnumber"));
                }
                info.setMember(sb.substring(0, sb.length() - 1));
                info.setSymbol("in");
                info.setParamKey(PRE_PARAM + srcDim + index);
                sqlSb.setCharAt(sqlSb.length() - 1, ')');
                info.setSql(sqlSb.toString());
                ++index;
                break;
            }
            case 5: {
                info.setMember(firstMember);
                info.setSymbol("<>");
                info.setParamKey(PRE_PARAM + srcDim + index);
                info.setSql(" <> ?");
                info.addSqlParam(firstMember);
                ++index;
                break;
            }
            case 6: {
                info.setMemberPair((Pair<String, String>)Pair.onePair((Object)firstMember, (Object)((DynamicObject)srcMapEntry.get(1)).getString("srcmembnumber")));
                info.setSymbolPair((Pair<String, String>)Pair.onePair((Object)"<", (Object)">"));
                info.setParamKeyPair((Pair<String, String>)Pair.onePair((Object)(PRE_PARAM + srcDim + index), (Object)(PRE_PARAM + srcDim + (index + 1))));
                info.setSql(" not between (? and ?)");
                info.addSqlParam(firstMember);
                info.addSqlParam(((DynamicObject)srcMapEntry.get(1)).getString("srcmembnumber"));
                index += 2;
                break;
            }
            case 7: {
                info.setMember(firstMember.replace("%", ""));
                info.setSymbol(firstMember.indexOf("%") == 0 ? "NOT_ENDS_WITH" : "NOT_STARTS_WITH");
                info.setParamKey(PRE_PARAM + srcDim + index);
                info.setSql(" not like ?");
                info.addSqlParam(firstMember);
                ++index;
                break;
            }
            case 8: {
                StringBuilder sb = new StringBuilder();
                StringBuilder sqlSb = new StringBuilder(" not in(");
                for (DynamicObject object : srcMapEntry) {
                    sb.append("'").append(object.getString("srcmembnumber")).append("'").append(",");
                    sqlSb.append("?,");
                    info.addSqlParam(object.getString("srcmembnumber"));
                }
                info.setMember(sb.substring(0, sb.length() - 1));
                info.setSymbol("not in");
                info.setParamKey(PRE_PARAM + srcDim + index);
                sqlSb.setCharAt(sqlSb.length() - 1, ')');
                info.setSql(sqlSb.toString());
                ++index;
            }
        }
        info.setOriginalValue(DIIntegrationUtil.getSrcNumber((List<DynamicObject>)srcMapEntry));
        paramKeyIndex.put(srcDim, index);
        dimMappingFilter.addCellInfo(info);
    }
}

