/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class DIIntegrationUtil {
    private static final Log log = LogFactory.getLog(DIIntegrationUtil.class);
    private static final String IGNORE = "IGNORE";
    private static final String ALL = "*";

    public static Pair<Map<String, Set<Long>>, Map<String, Set<Long>>> getSimpleMapAndDefaultTar(Long dimId, Collection<Long> schemeIds, List<String> tarMembs) {
        return DIIntegrationUtil.getSimpleMapAndDefaultTarQuery(dimId, schemeIds, tarMembs);
    }

    private static void handleInherit(Tuple<Long, Long, Long> schemeInherit, List<String> tarMembs, Long dimId, List<DynamicObject> addMappings) {
        QFilter filter = new QFilter("scheme", "=", schemeInherit.p3).and(new QFilter("isdimmaptargentry.tagdimension", "=", (Object)dimId)).and("mappedtype", "=", (Object)DimMappTypeEnum.SIMPLE.getCode());
        DynamicObject inHerDimMap = QueryServiceHelper.queryOne((String)"bcm_isdimmap", (String)"id,scheme", (QFilter[])filter.toArray());
        QFBuilder qfb = new QFBuilder();
        if (inHerDimMap != null && inHerDimMap.getLong("scheme") != 0L) {
            qfb.add("schemeid", "=", (Object)inHerDimMap.getLong("scheme"));
            qfb.add("isgrouptargmapentry.tarmembnumber", "in", tarMembs);
            qfb.and("dimmapid", "=", (Object)inHerDimMap.getLong("id"));
            DynamicObjectCollection groupMaps = QueryServiceHelper.query((String)"bcm_isgroupmap", (String)DIIntegrationUtil.getSelectField(), (QFilter[])qfb.toArray());
            for (DynamicObject groupMap : groupMaps) {
                if (groupMap == null) continue;
                groupMap.set("schemeid", schemeInherit.p2);
                addMappings.add(groupMap);
            }
        }
    }

    private static DynamicObject[] getGroupMapDynamicObject(Set<Long> extendsSchemeIds, List<String> tarMembs, Set<Long> dimMapId) {
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", extendsSchemeIds);
        qfb.add("isgrouptargmapentry.tarmembnumber", "in", tarMembs);
        qfb.and("dimmapid", "in", dimMapId);
        return BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)DIIntegrationUtil.getSelectField(), (QFilter[])qfb.toArray());
    }

    private static DynamicObjectCollection getDimDynamicObjectBySchemeId(Set<Long> schemeIds, Long dimId) {
        QFilter filter = new QFilter("scheme", "in", schemeIds).and(new QFilter("isdimmaptargentry.tagdimension", "=", (Object)dimId)).and("mappedtype", "=", (Object)DimMappTypeEnum.SIMPLE.getCode());
        return QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,inheritancescheme,scheme", (QFilter[])filter.toArray());
    }

    public static Pair<Map<String, Set<Long>>, Map<String, Set<Long>>> getSimpleMapAndDefaultTarQuery(Long dimId, Collection<Long> schemeIds, List<String> tarMembs) {
        HashSet<Long> scheme = new HashSet<Long>(schemeIds);
        DynamicObjectCollection dimmap = DIIntegrationUtil.getDimDynamicObjectBySchemeId(scheme, dimId);
        HashSet dimmapids = new HashSet(8);
        dimmap.forEach(d -> dimmapids.add(d.getLong("id")));
        dimmap.stream().forEach(d -> dimmapids.add(d.getLong("id")));
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", schemeIds);
        qfb.add("dimmapid", "in", dimmapids);
        qfb.add("isgrouptargmapentry.tardimension", "=", (Object)dimId);
        tarMembs.add(IGNORE);
        tarMembs.add(ALL);
        qfb.add("isgrouptargmapentry.tarmembnumber", "in", tarMembs);
        DynamicObjectCollection groupMaps = QueryServiceHelper.query((String)"bcm_isgroupmap", (String)DIIntegrationUtil.getSelectFieldQuery(), (QFilter[])qfb.toArray());
        ArrayList<DynamicObject> addMappings = new ArrayList<DynamicObject>(8);
        for (DynamicObject dimMap : dimmap) {
            if (dimMap.getLong("inheritancescheme") == 0L) continue;
            Tuple schemeInher = Tuple.create((Object)dimMap.getLong("id"), (Object)dimMap.getLong("scheme"), (Object)dimMap.getLong("inheritancescheme"));
            DIIntegrationUtil.handleInherit((Tuple<Long, Long, Long>)schemeInher, tarMembs, dimId, addMappings);
        }
        if (addMappings.size() > 0) {
            groupMaps.addAll(addMappings);
        }
        List<DynamicObject> ignoreDyns = groupMaps.stream().filter(d -> IGNORE.equals(d.getString("isgrouptargmapentry.tarmembnumber"))).collect(Collectors.toList());
        List<DynamicObject> otherDyns = groupMaps.stream().filter(d -> !IGNORE.equals(d.getString("isgrouptargmapentry.tarmembnumber"))).collect(Collectors.toList());
        HashMap result = new HashMap(tarMembs.size());
        otherDyns.forEach(l -> {
            Set schemes = result.getOrDefault(l.getString("isgrouptargmapentry.tarmembnumber"), new HashSet(10));
            schemes.add(l.getLong("schemeid"));
            result.put(l.getString("isgrouptargmapentry.tarmembnumber"), schemes);
        });
        HashMap resultIgnore = new HashMap(tarMembs.size());
        ignoreDyns.forEach(l -> {
            Set schemes = resultIgnore.getOrDefault(l.getString("isgrouptargmapentry.tarmembnumber"), new HashSet());
            schemes.add(l.getLong("schemeid"));
            resultIgnore.put(l.getString("isgrouptargmapentry.tarmembnumber"), schemes);
        });
        qfb.clear();
        qfb.add("scheme", "in", schemeIds);
        qfb.add("isdimmaptargentry.tagdimension", "=", (Object)dimId);
        qfb.add("isdimmaptargentry.isdimmaptargdefval.targetmemnum", "in", tarMembs);
        DynamicObjectCollection dimMaps = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,scheme.id,isdimmaptargentry.isdimmaptargdefval.targetmemnum", (QFilter[])qfb.toArray());
        HashMap<String, Set> schemes4Defval = new HashMap<String, Set>(tarMembs.size());
        dimMaps.stream().forEach(l -> {
            String tarMem = l.getString("isdimmaptargentry.isdimmaptargdefval.targetmemnum");
            Set schemes = schemes4Defval.getOrDefault(tarMem, new HashSet(10));
            schemes.add(l.getLong("scheme.id"));
            schemes4Defval.put(tarMem, schemes);
        });
        if (schemes4Defval.size() > 0) {
            schemes4Defval.forEach((k, v) -> {
                Set orDefault = result.getOrDefault(k, new HashSet(10));
                orDefault.addAll(v);
                result.put(k, orDefault);
            });
        }
        return Pair.onePair(result, resultIgnore);
    }

    private static String getSelectField() {
        ArrayList<String> fields = new ArrayList<String>(30);
        fields.add("id");
        fields.add("schemeid");
        fields.add("dimmapid");
        fields.add("isgrouptargmapentry.tarmember");
        fields.add("isgrouptargmapentry.id");
        fields.add("isgrouptargmapentry.tardimension");
        fields.add("isgrouptargmapentry.tarmembnumber");
        fields.add("isgroupsrcmapentry.priority");
        return String.join((CharSequence)",", fields);
    }

    private static String getSelectFieldQuery() {
        ArrayList<String> fields = new ArrayList<String>(30);
        fields.add("id");
        fields.add("schemeid");
        fields.add("dimmapid");
        fields.add("isgrouptargmapentry.tarmembnumber");
        return String.join((CharSequence)",", fields);
    }

    public static void filterSchemeByScenarioAndDate(long modelid, String scenarioNum, String periodNum, String yearNum, List<Long> schemeIds, Boolean isOnlyEnable) {
        Set<Long> scenarioSchemeIds = DIIntegrationUtil.filterSchemeByScenePeriod(modelid, scenarioNum, schemeIds);
        DIIntegrationUtil.filterSchemeByDate(modelid, periodNum, yearNum, scenarioSchemeIds, isOnlyEnable);
        schemeIds.clear();
        schemeIds.addAll(scenarioSchemeIds);
    }

    public static Set<Long> filterSchemeByScenePeriod(long modelid, String scenarioNum, List<Long> schemeIds) {
        HashSet<Long> scenarioSchemeIds = new HashSet<Long>(16);
        Map<String, List<String>> sceneperiods = DimensionServiceHelper.getScenePeriodMap(modelid);
        if (sceneperiods.size() == 0) {
            schemeIds.clear();
            return scenarioSchemeIds;
        }
        List<String> periods = sceneperiods.get(scenarioNum);
        periods.add(ALL);
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", schemeIds);
        qfb.add("isgrouptargmapentry.tarmembnumber", "in", periods);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_isgroupmap", (String)"schemeid.id", (QFilter[])qfb.toArray());
        dyns.forEach(dyn -> scenarioSchemeIds.add(dyn.getLong("schemeid.id")));
        Set<Long> absentMappingSchemes = schemeIds.stream().collect(Collectors.toSet());
        absentMappingSchemes.removeAll(scenarioSchemeIds);
        if (absentMappingSchemes.size() > 0) {
            Long periodId = MemberReader.getDimensionIdByNum((long)modelid, (String)"Period");
            scenarioSchemeIds.addAll(DIIntegrationUtil.addPeriodSchemeIdFromParent(absentMappingSchemes, periods, periodId));
        }
        Long dimId = MemberReader.getDimensionIdByNum((long)modelid, (String)DimTypesEnum.PERIOD.getNumber());
        qfb.clear();
        qfb.add("scheme", "in", schemeIds);
        qfb.add("isdimmaptargentry.tagdimension", "=", (Object)dimId);
        qfb.add("isdimmaptargentry.isdimmaptargdefval.targetmemnum", "in", periods);
        DynamicObjectCollection dimMaps = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,scheme.id", (QFilter[])qfb.toArray());
        dimMaps.forEach(dyn -> scenarioSchemeIds.add(dyn.getLong("scheme.id")));
        return scenarioSchemeIds;
    }

    private static Set<Long> addPeriodSchemeIdFromParent(Set<Long> absentMappingSchemes, List<String> periods, Long periodId) {
        DynamicObjectCollection dimMaps = DIIntegrationUtil.getDimDynamicObjectBySchemeId(absentMappingSchemes, periodId);
        ArrayList<Tuple> tableList = new ArrayList<Tuple>(dimMaps.size());
        for (Object dimMap : dimMaps) {
            if (dimMap.getLong("inheritancescheme") == 0L) continue;
            tableList.add(Tuple.create((Object)dimMap.getLong("id"), (Object)dimMap.getLong("scheme"), (Object)dimMap.getLong("inheritancescheme")));
        }
        HashSet<Long> extendsSchemeIds = new HashSet<Long>(8);
        for (Tuple longLongLongTuple : tableList) {
            extendsSchemeIds.add((Long)longLongLongTuple.p3);
        }
        DynamicObjectCollection parentDimMap = DIIntegrationUtil.getDimDynamicObjectBySchemeId(extendsSchemeIds, periodId);
        Set<Long> dimMapId = parentDimMap.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] parentGroupMap = DIIntegrationUtil.getGroupMapDynamicObject(extendsSchemeIds, periods, dimMapId);
        HashSet<Long> needAddScheme = new HashSet<Long>(8);
        for (Tuple longLongEntry : tableList) {
            for (DynamicObject pGroupMap : parentGroupMap) {
                if (!((Long)longLongEntry.p3).equals(pGroupMap.getLong("schemeid_id"))) continue;
                needAddScheme.add((Long)longLongEntry.p2);
            }
        }
        return needAddScheme;
    }

    public static void filterSchemeByDate(long modelid, String periodNum, String yearNum, Set<Long> schemeIds, Boolean isOnlyEnable) {
        QFBuilder qfbPeriod = new QFBuilder();
        qfbPeriod.add("model", "=", (Object)modelid);
        qfbPeriod.add("number", "=", (Object)periodNum);
        DynamicObject periodDate = BusinessDataServiceHelper.loadSingle((String)"bcm_periodmembertree", (String)"effdate, expdate", (QFilter[])qfbPeriod.toArray());
        String effdate = periodDate.getString("effdate");
        String expdate = periodDate.getString("expdate");
        String format = ResManager.getLocaleString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"IntegrationUtil_1", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        String year = ResManager.getLocaleString((String)"\u5e74", (String)"IntegrationUtil_2", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String yearSub = yearNum.substring(2);
        effdate = yearSub + year + effdate;
        expdate = yearSub + year + expdate;
        Date effDate = new Date();
        Date expDate = new Date();
        try {
            effDate = sdf.parse(effdate);
            expDate = sdf.parse(expdate);
        }
        catch (ParseException e) {
            log.error(e.getMessage());
        }
        ArrayList effectiveSchemeIds = Lists.newArrayList();
        QFBuilder qFBuilder = new QFBuilder();
        qFBuilder.add("id", "in", schemeIds);
        if (isOnlyEnable.booleanValue()) {
            qFBuilder.add("status", "=", (Object)"1");
        }
        DynamicObject[] dynamics = BusinessDataServiceHelper.load((String)"bcm_isscheme", (String)"id, number, effectivedate, expiringdate, versionnumber", (QFilter[])qFBuilder.toArray(), (String)"number asc, versionnumber desc");
        HashSet numberExist = Sets.newHashSet();
        for (DynamicObject dynamic : dynamics) {
            String number;
            if (dynamic.getDate("effectivedate").after(expDate) || dynamic.getDate("expiringdate") != null && dynamic.getDate("expiringdate").before(effDate) || !numberExist.add(number = dynamic.getString("number"))) continue;
            effectiveSchemeIds.add(dynamic.getLong("id"));
        }
        schemeIds.clear();
        schemeIds.addAll(effectiveSchemeIds);
    }

    public static Set<Long> filterByScenario(String modelNum, List<Long> schemeIds, String scenarioNum) {
        IDNumberTreeNode scenMember = MemberReader.findScenaMemberByNum((String)modelNum, (String)scenarioNum);
        HashSet<Long> result = new HashSet<Long>();
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", schemeIds);
        qfb.add("isgrouptargmapentry.tardimension", "=", (Object)scenMember.getDimId());
        qfb.add("isgrouptargmapentry.tarmembnumber", "in", (Object)new String[]{scenarioNum, ALL});
        DynamicObjectCollection singMaps = QueryServiceHelper.query((String)"bcm_isgroupmap", (String)"schemeid.id", (QFilter[])qfb.toArray());
        singMaps.forEach(item -> result.add(item.getLong("schemeid.id")));
        Set<Long> absentMappingSchemes = schemeIds.stream().collect(Collectors.toSet());
        absentMappingSchemes.removeAll(result);
        if (absentMappingSchemes.size() > 0) {
            Long scenceId = scenMember.getDimId();
            ArrayList<String> targMember = new ArrayList<String>(8);
            targMember.add(scenarioNum);
            targMember.add(ALL);
            result.addAll(DIIntegrationUtil.addPeriodSchemeIdFromParent(absentMappingSchemes, targMember, scenceId));
        }
        qfb.clear();
        qfb.add("scheme", "in", schemeIds);
        qfb.add("isdimmaptargentry.tagdimension", "=", (Object)scenMember.getDimId());
        qfb.add("isdimmaptargentry.isdimmaptargdefval.targetmemnum", "=", (Object)scenarioNum);
        DynamicObjectCollection dimMaps = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,scheme.id", (QFilter[])qfb.toArray());
        dimMaps.forEach(item -> result.add(item.getLong("scheme.id")));
        return result;
    }

    public static String clearDataByImportMode(Pair<Long, String> model, Pair<Long, String> schemePair, List<Map<String, String>> specialDimMembers) {
        Long replaceImportMode = DIIntegrationUtil.getReplaceImportMode((Long)schemePair.p1);
        if (!Objects.isNull(replaceImportMode)) {
            Map<String, Set<String>> dimMembers = DIIntegrationUtil.setMoreDimMembers(model, replaceImportMode);
            specialDimMembers.forEach(map -> {
                HashMap<String, Set<String>> members = new HashMap<String, Set<String>>(16);
                map.forEach((k, v) -> {
                    HashSet<String> mems = new HashSet<String>(2);
                    mems.add((String)v);
                    members.put((String)k, (Set<String>)mems);
                });
                members.putAll(dimMembers);
                boolean isHaveEmptyDim = DIIntegrationUtil.checkHaveEmptyDim(members);
                if (!isHaveEmptyDim) {
                    IntegrationUtil.clearOlapData((String)model.p2, members);
                }
            });
            return String.format(ResManager.loadKDString((String)"\u6e05\u6570\u8303\u56f4\u4e2d\u7ec4\u5408\u4e3a\uff1a%1$s ;\u6307\u5b9a\u8303\u56f4\u4e3a\uff1a%2$s", (String)"DIIntegrationUtil_0", (String)"fi-bcm-business", (Object[])new Object[0]), JSON.toJSONString(specialDimMembers), JSON.toJSONString(dimMembers));
        }
        return "";
    }

    public static Long getReplaceImportMode(Long schemeId) {
        QFilter qf = new QFilter("id", "=", (Object)schemeId);
        Long importModeId = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"importmodeid", (QFilter[])qf.toArray()).getLong("importmodeid");
        QFilter qFilterId = new QFilter("id", "=", (Object)importModeId);
        QFilter qFilterMode = new QFilter("importmode", "=", (Object)ISImpModeEnum.REPLACEIMPORT.getCode());
        return QueryServiceHelper.exists((String)"di_importmode", (QFilter[])new QFilter[]{qFilterId, qFilterMode}) ? importModeId : null;
    }

    private static boolean checkHaveEmptyDim(Map<String, Set<String>> dimMembers) {
        for (Map.Entry<String, Set<String>> map : dimMembers.entrySet()) {
            if (map.getValue() != null && !map.getValue().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Set<String>> setMoreDimMembers(Pair<Long, String> model, Long importModeId) {
        HashMap<String, Set<String>> dimMembers = new HashMap<String, Set<String>>(16);
        QFilter qf = new QFilter("importmode", "=", (Object)importModeId);
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"bcm_iscleardataconfig", (String)"dimmemberid,dimtype,membernumber,scope", (QFilter[])new QFilter[]{qf});
        if (configs == null || configs.length == 0) {
            return dimMembers;
        }
        HashMap<String, DynamicObject> dimTypeMap = new HashMap<String, DynamicObject>();
        DynamicObject dimObj = null;
        Set tempSet = null;
        for (DynamicObject dynamicObject : configs) {
            String dimtype = dynamicObject.getString("dimtype");
            long membId = dynamicObject.getLong("dimmemberid");
            int scope = dynamicObject.getInt("scope");
            String membernumber = dynamicObject.getString("membernumber");
            dimObj = (DynamicObject)dimTypeMap.get(dimtype);
            if (dimObj == null) {
                dimObj = IntegrationUtil.getDimPair((Long)model.p1, dimtype);
                dimTypeMap.put(dimtype, dimObj);
            }
            ArrayList<Long> membIds = new ArrayList<Long>();
            membIds.add(membId);
            if (dimObj == null) {
                throw new KDBizException("dimObj is null,dimtype is " + dimtype);
            }
            Pair<Integer, Map<Object, DynamicObject>> member = DIIntegrationUtil.getMember(dimObj, membIds);
            HashSet numbers = new HashSet();
            new MembRangeItem(dimObj.getString("memberform"), (Long)membId, membernumber, RangeEnum.getRangeByVal((int)scope), (Integer)member.p1 != 1, model.p1).matchItems(c -> numbers.add(c.number));
            tempSet = dimMembers.computeIfAbsent(dimtype, k -> new HashSet());
            tempSet.addAll(numbers);
        }
        return dimMembers;
    }

    public static Pair<Integer, Map<Object, DynamicObject>> getMember(DynamicObject dimObj, List<Long> membIds) {
        QFilter[] qFilterArray;
        QFilter qf = new QFilter("id", "in", membIds);
        String memberform = dimObj.getString("memberform");
        Long dimId = dimObj.getLong("id");
        boolean isUserDefine = "bcm_userdefinedmembertree".equalsIgnoreCase(memberform);
        if (isUserDefine) {
            QFilter[] qFilterArray2 = new QFilter[2];
            qFilterArray2[0] = qf;
            qFilterArray = qFilterArray2;
            qFilterArray2[1] = new QFilter("dimension", "=", (Object)dimId);
        } else {
            qFilterArray = qf.toArray();
        }
        Map result = BusinessDataServiceHelper.loadFromCache((String)memberform, (String)"number,name", (QFilter[])qFilterArray);
        if (result.isEmpty()) {
            result = BusinessDataServiceHelper.loadFromCache((String)"bcm_definedpropertyvalue", (String)"number,name,parentid", (QFilter[])new QFilter[]{qf, new QFilter("dimension", "=", (Object)dimId)});
            return Pair.onePair((Object)2, (Object)result);
        }
        return Pair.onePair((Object)1, (Object)result);
    }

    public static Pair<Boolean, Pair<String, String>> getLevelTable(Long schemeId, String yearNumber, String periodNumber) {
        QFilter schemeQf = new QFilter("scheme", "=", (Object)schemeId);
        QFilter yearNumberQf = new QFilter("year", "=", (Object)yearNumber);
        QFilter periodNumberQf = new QFilter("period", "=", (Object)periodNumber);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"di_tableroute", (String)"imptable, comptable", (QFilter[])new QFilter[]{schemeQf, yearNumberQf, periodNumberQf});
        if (query.size() > 0) {
            return Pair.onePair((Object)true, (Object)Pair.onePair((Object)((DynamicObject)query.get(0)).getString("imptable"), (Object)((DynamicObject)query.get(0)).getString("comptable")));
        }
        DynamicObjectCollection maxorder = QueryServiceHelper.query((String)"di_tableroute", (String)"max(order) as maxorder", (QFilter[])new QFilter[]{schemeQf});
        int max = 1;
        if (maxorder.size() > 0) {
            max = ((DynamicObject)maxorder.get(0)).getInt("maxorder") + 1;
        }
        return Pair.onePair((Object)false, (Object)Pair.onePair((Object)("t_di_" + schemeId + "_" + max), (Object)("t_di_" + schemeId + "_" + max + "_cp")));
    }

    public static void clearTableRoute(long schemeId) {
        QFilter schemeQf = new QFilter("scheme", "=", (Object)schemeId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"di_tableroute", (String)"imptable, comptable", (QFilter[])new QFilter[]{schemeQf});
        if (query.size() > 0) {
            for (DynamicObject obj : query) {
                DIIntegrationUtil.dropTable(obj.getString("imptable"));
                DIIntegrationUtil.dropTable(obj.getString("comptable"));
            }
        }
        BusinessDataWriter.delete((String)"di_tableroute", (QFilter[])new QFilter[]{schemeQf});
    }

    public static Boolean existTableRouteData(Long schemeId) {
        QFilter schemeQf = new QFilter("scheme", "=", (Object)schemeId);
        return QueryServiceHelper.exists((String)"di_tableroute", (QFilter[])schemeQf.toArray());
    }

    public static void dropTable(String tableName) {
        if (DB.exitsTable((DBRoute)BCMConstant.DBROUTE, (String)tableName)) {
            DB.execute((DBRoute)BCMConstant.DBROUTE, (String)("drop table " + tableName));
            log.warn("DIIntegrationUtil-drop table\uff1a" + tableName);
        }
    }

    public static Set<Long> filterSchemeAssignOrg(Long modelId, List<Long> schmeIds, String entityNumber) {
        DynamicObject[] schemeAssignEntitys;
        HashSet<Long> newIds = new HashSet<Long>();
        if (schmeIds.size() <= 0) {
            return newIds;
        }
        String selectProperties = "scheme,entity,property,propertyvalue,range";
        for (DynamicObject schemeAssign : schemeAssignEntitys = BusinessDataServiceHelper.load((String)"bcm_isschemeassignentity", (String)selectProperties, (QFilter[])new QFilter("scheme", "in", schmeIds).toArray())) {
            DynamicObject entity = schemeAssign.getDynamicObject("entity");
            DynamicObject schemeDyn = schemeAssign.getDynamicObject("scheme");
            if (schemeDyn == null) continue;
            Long mId = 0L;
            String mnumber = null;
            boolean isCustom = false;
            if (entity == null) {
                isCustom = true;
                DynamicObject propertyvalue = schemeAssign.getDynamicObject("propertyvalue");
                if (ObjectUtils.isEmpty((Object)propertyvalue)) continue;
                mId = propertyvalue.getLong("id");
                mnumber = propertyvalue.getString("number");
            } else {
                mId = entity.getLong("id");
                mnumber = entity.getString("number");
            }
            MembRangeItem rangItem = new MembRangeItem("bcm_entitymembertree", mId, mnumber, RangeEnum.getRangeByVal((int)schemeAssign.getInt("range")), isCustom, (Object)modelId);
            rangItem.matchItems(c -> {
                if (StringUtils.equals((CharSequence)entityNumber, (CharSequence)c.number)) {
                    newIds.add(schemeDyn.getLong("id"));
                }
            });
        }
        return newIds;
    }

    public static Set<Long> filterSchemeByDimNumberDef(String number, List<Long> schemeIds) {
        DynamicObject[] dimMapping;
        HashSet<Long> newchemeIds = new HashSet<Long>(16);
        QFilter schemeQf = new QFilter("scheme", "in", schemeIds);
        for (DynamicObject mapping : dimMapping = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id, number, tagdimension, tagdimtype, srcdimension, srcdimtype, mappedtype, targetmemnum, tagmemb,scheme.id", (QFilter[])new QFilter[]{schemeQf})) {
            if (mapping.getInt("mappedtype") != 2) continue;
            DynamicObjectCollection dimMappingItem = mapping.getDynamicObjectCollection("isdimmaptargentry");
            for (DynamicObject item : dimMappingItem) {
                DynamicObjectCollection itemValue = item.getDynamicObjectCollection("isdimmaptargdefval");
                for (DynamicObject itemObj : itemValue) {
                    if (!number.equals(itemObj.getString("targetmemnum"))) continue;
                    newchemeIds.add(mapping.getLong("scheme.id"));
                }
            }
        }
        return newchemeIds;
    }

    public static Set<Long> filterSchemeByDimNumber(Long dimensionId, String number, List<Long> schemeIds, String mappedNumber) {
        DynamicObject[] dyns;
        HashSet<Long> newchemeIds = new HashSet<Long>(16);
        QFilter schemeQf = new QFilter("scheme", "in", schemeIds);
        QFilter mappedType = new QFilter("mappedtype", "=", (Object)DimMappTypeEnum.SIMPLE.getCode());
        if (mappedNumber != null) {
            mappedType.and(new QFilter("number", "=", (Object)mappedNumber));
        }
        DynamicObjectCollection dimMapping = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id", (QFilter[])new QFilter[]{schemeQf, mappedType});
        ArrayList<String> numberList = new ArrayList<String>();
        numberList.add(number);
        numberList.add(ALL);
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", schemeIds);
        List dimMappingIds = dimMapping.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        qfb.add("dimmapid", "in", dimMappingIds);
        qfb.add("isgrouptargmapentry.tardimension", "=", (Object)dimensionId);
        qfb.add("isgrouptargmapentry.tarmembnumber", "in", numberList);
        for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)"schemeid.id", (QFilter[])qfb.toArray())) {
            newchemeIds.add(dyn.getLong("schemeid.id"));
        }
        return newchemeIds;
    }

    public static String getExtendsTable(String table, String year, String period) {
        if (DB.exitsTable((DBRoute)BCMConstant.DBROUTE, (String)(table + "$map"))) {
            String sql = "select fkey,findex from " + table + "$map";
            DataSet dataSet = DB.queryDataSet((String)table, (DBRoute)BCMConstant.DBROUTE, (String)sql);
            while (dataSet.hasNext()) {
                Row dataRow = dataSet.next();
                if (!dataRow.getString("fkey").equals(year + "#" + period)) continue;
                return table + "$" + dataRow.getInteger("findex");
            }
        } else {
            return table;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8d22\u5e74\u671f\u95f4\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u8868\u3002", (String)"DIIntegrationUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    public static Boolean getSpecialMappingStatus(Long schemeId) {
        if (!QueryServiceHelper.exists((String)"bcm_isscheme", (Object)schemeId)) {
            return Boolean.FALSE;
        }
        QFilter filter = new QFilter("id", "=", (Object)schemeId);
        return QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"specialmappingable", (QFilter[])filter.toArray()).getBoolean("specialmappingable");
    }

    public static Map<String, String> getSrcNumber(List<DynamicObject> members) {
        int scope = members.get(0).getInt("scope");
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> result = new HashMap<String, String>(16);
        String key = null;
        switch (MapScopeEnum.getEnumByindex((int)scope)) {
            case EQUALS: 
            case INCLUDE: {
                key = "in";
                break;
            }
            case RANGE: {
                key = "between";
                break;
            }
            case LIKE: {
                key = "like";
                break;
            }
            case NOT_EQUALS: 
            case NOT_INCLUDE: {
                key = "notin";
                break;
            }
            case NOT_RANGE: {
                key = "notbetween";
                break;
            }
            case NOT_LIKE: {
                key = "notlike";
            }
        }
        members.forEach(m -> sb.append(m.getString("srcmembnumber")).append(","));
        sb.deleteCharAt(sb.length() - 1);
        result.put(key, sb.toString());
        return result;
    }

    public static List<Long> getCurrentUserNoPermDIScheme(Long modelId, Long userId) {
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(userId, String.valueOf(modelId));
        if (adminUserBol) {
            return Collections.singletonList(0L);
        }
        List<Long> ids = PermClassEntityHelper.getPermissionMap("bcm_isscheme", String.valueOf(modelId), RequestContext.get().getUserId()).get((Object)DataTypeEnum.NO.getIndex());
        return CollectionUtils.isEmpty((Collection)ids) ? Collections.singletonList(0L) : ids;
    }

    public static List<Long> getCurrentUserNoPermDIScheme(Long modelId) {
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), String.valueOf(modelId));
        if (adminUserBol) {
            return Collections.singletonList(0L);
        }
        List<Long> ids = PermClassEntityHelper.getPermissionMap("bcm_isscheme", String.valueOf(modelId), RequestContext.get().getUserId()).get((Object)DataTypeEnum.NO.getIndex());
        return CollectionUtils.isEmpty((Collection)ids) ? Collections.singletonList(0L) : ids;
    }

    public static List<Long> getCurrentUserWritePermScheme(Long modelId) {
        List<Long> ids = PermClassEntityHelper.getPermissionMap("bcm_isscheme", String.valueOf(modelId), RequestContext.get().getUserId()).get((Object)DataTypeEnum.WRITEIN.getIndex());
        return CollectionUtils.isEmpty((Collection)ids) ? Collections.singletonList(0L) : ids;
    }

    public static List<Long> getCurrentUserReadAndNoPermAndDisableScheme(Long modelId) {
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), String.valueOf(modelId));
        if (adminUserBol) {
            return Collections.singletonList(0L);
        }
        List<Long> ids = DIIntegrationUtil.getCurrentUserReadPermScheme(modelId);
        QFilter filter = new QFilter("id", "in", ids);
        filter.and("status", "in", (Object)"0");
        List<Long> readAndDisablePermScheme = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id", (QFilter[])filter.toArray()).stream().map(scheme -> scheme.getLong("id")).collect(Collectors.toList());
        readAndDisablePermScheme.addAll(DIIntegrationUtil.getCurrentUserNoPermDIScheme(modelId));
        return CollectionUtils.isEmpty(readAndDisablePermScheme) ? Collections.singletonList(0L) : readAndDisablePermScheme;
    }

    public static List<Long> getCurrentUserReadPermScheme(Long modelId) {
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), String.valueOf(modelId));
        if (adminUserBol) {
            return Collections.singletonList(0L);
        }
        List<Long> ids = PermClassEntityHelper.getPermissionMap("bcm_isscheme", String.valueOf(modelId), RequestContext.get().getUserId()).get((Object)DataTypeEnum.READ.getIndex());
        return CollectionUtils.isEmpty((Collection)ids) ? Collections.singletonList(0L) : ids;
    }

    public static boolean isWriteSchemePerm(long schemeId, long modelId) {
        QFBuilder range = new QFBuilder("entityid", "in", (Object)schemeId);
        range.and("model", "=", (Object)modelId);
        if (!QueryServiceHelper.exists((String)"bcm_permclass_entity", (QFilter[])range.toArray())) {
            return true;
        }
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), String.valueOf(modelId));
        if (adminUserBol) {
            return true;
        }
        List<Long> writePrem = DIIntegrationUtil.getCurrentUserWritePermScheme(modelId);
        return writePrem.contains(schemeId);
    }

    public static String getBaseEntListNumberById(long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bcm_isbaseentlist", (String)"number", (QFilter[])filter.toArray()).getString("number");
    }
}

