/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.mapping.DefaultMappingVO;
import kd.fi.bcm.business.integration.mapping.DimMappingTypeStrategy;
import kd.fi.bcm.business.integration.mapping.EASACCProduct;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.business.integration.mapping.NGACCProduct;
import kd.fi.bcm.business.integration.mapping.NGACC_CProduct;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;

class CombineMapping
implements DimMappingTypeStrategy {
    private static final List<String> TARGETDIMENSION = Arrays.asList("Entity", "Year", "Period", "Scenario", "Currency");

    CombineMapping() {
    }

    @Override
    public void dimTypeChanged(IFormView formView, IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject scheme = dataEntity.getDynamicObject("scheme");
        if (scheme != null && IntegrateProductEnum.XExtendProduct.getNumber().equals(((DynamicObject)scheme.get("issrc")).getString("number"))) {
            formView.setVisible(Boolean.valueOf(true), new String[]{"tagdimension"});
        }
        formView.setVisible(Boolean.valueOf(true), new String[]{"tagadvconap", "srcadvconap"});
        formView.setVisible(Boolean.valueOf(false), new String[]{"tagdimdefvalue", "srcdimdefvalue", "srcmemnum", "field"});
    }

    @Override
    public void fillData(IDataModel model, DynamicObject src) {
    }

    @Override
    public boolean validateSave(IFormView formView, IDataModel model) {
        model.clearNoDataRow();
        int srcRowCount = model.getEntryRowCount("isdimmapsrcentry");
        int tagRowCount = model.getEntryRowCount("isdimmaptargentry");
        if (srcRowCount < 1 || tagRowCount < 1) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6570\u636e\u8f93\u5165\u6b63\u786e\uff0c\u7ec4\u5408\u7ef4\u5ea6\u6620\u5c04\u4e0d\u80fd\u6709\u4e3a\u7a7a\u7684\u7ef4\u5ea6\u3002", (String)"DimMappingTypeStrategy_7", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection targetDynCollection = dataEntity.getDynamicObjectCollection("isdimmaptargentry");
        for (String dimension : TARGETDIMENSION) {
            if (!this.checkTargetIsExist(targetDynCollection, dimension)) continue;
            formView.showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3001\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u3001\u5e01\u79cd\u7ef4\u5ea6\u7981\u6b62\u914d\u7f6e\u7ec4\u5408\u6620\u5c04\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_22", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        boolean check = this.checkDimRepet(formView, dataEntity);
        if (!check) {
            return false;
        }
        DynamicObject scheme = dataEntity.getDynamicObject("scheme");
        QFilter[] filters = new QFilter[]{new QFilter("scheme", "=", (Object)dataEntity.getDynamicObject("scheme").getLong("id")), new QFilter("mappedtype", "=", (Object)"4"), new QFilter("id", "!=", dataEntity.getPkValue())};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id, name", (QFilter[])filters);
        if (query.size() >= 1) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u591a\u7ef4\u5ea6\u7ec4\u5408\u6620\u5c04\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_18", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection srcDynCollection = dataEntity.getDynamicObjectCollection("isdimmapsrcentry");
        MappingContext context = new MappingContext(scheme);
        boolean existAccount = context.isSrcNg() ? this.checkSrcIsExist(srcDynCollection, "Account") : this.checkTargetIsExist(targetDynCollection, "Account");
        if (!existAccount) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u4e2d\u672a\u5f55\u5165\u201c\u79d1\u76ee\u201d\u7ef4\u5ea6\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_11", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        String name = ResManager.loadKDString((String)"\u79d1\u76ee\u7ec4\u5408\u6620\u5c04", (String)"DimMappingTypeStrategy_9", (String)"fi-bcm-business", (Object[])new Object[0]);
        if (context.getSource() instanceof NGACCProduct) {
            if (!this.checkSrcIsExist(srcDynCollection, "AccountBookType")) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u672a\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingTypeStrategy_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            if (!this.checkSrcIsExist(srcDynCollection, "ChangeType")) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u672a\u9009\u62e9\u53d6\u6570\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingTypeStrategy_21", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
        } else if (context.getSource() instanceof NGACC_CProduct) {
            if (!this.checkSrcIsExist(srcDynCollection, "AccountBookType")) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u672a\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingTypeStrategy_20", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            if (!this.checkSrcIsExist(srcDynCollection, "ChangeType")) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u672a\u9009\u62e9\u53d6\u6570\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingTypeStrategy_21", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            if (!this.checkSrcIsExist(srcDynCollection, "OrgView")) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u672a\u9009\u62e9\u6838\u7b97\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingTypeStrategy_25", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            if (!this.checkSrcIsExist(srcDynCollection, "AccountTable")) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u672a\u9009\u62e9\u79d1\u76ee\u8868\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingTypeStrategy_26", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            if (!this.checkSrcIsExist(srcDynCollection, "ReClassParam")) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u672a\u9009\u62e9\u91cd\u5206\u7c7b\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingTypeStrategy_27", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
        } else if (context.getSource() instanceof EASACCProduct && !this.checkSrcIsExist(srcDynCollection, "AccessType")) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u672a\u9009\u62e9\u53d6\u6570\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingTypeStrategy_21", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        for (DynamicObject d : query) {
            if (!name.equalsIgnoreCase(d.getString("name").trim())) continue;
            formView.showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimMappingTypeStrategy_12", (String)"fi-bcm-business", (Object[])new Object[0]), name));
            return false;
        }
        model.setValue("name", (Object)name);
        return true;
    }

    protected boolean checkDimRepet(IFormView formView, DynamicObject dataEntity) {
        Object target22;
        DynamicObjectCollection srcDynCollection = dataEntity.getDynamicObjectCollection("isdimmapsrcentry");
        DynamicObjectCollection tagDynCollection = dataEntity.getDynamicObjectCollection("isdimmaptargentry");
        HashMap<Long, String> targetIds = new HashMap<Long, String>();
        HashMap<Long, String> srcIds = new HashMap<Long, String>();
        ArrayList<Integer> deleteBlankRowTag = new ArrayList<Integer>();
        ArrayList<Integer> deleteBlankRowSrc = new ArrayList<Integer>();
        int indexTag = 0;
        for (Object target22 : tagDynCollection) {
            DynamicObject targDim = target22.getDynamicObject("tagdimension");
            if (targDim == null) {
                deleteBlankRowTag.add(indexTag);
                ++indexTag;
                continue;
            }
            ++indexTag;
            long targid = targDim.getLong("id");
            if (targetIds.containsKey(targid)) {
                formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u5217\u8868\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u76ee\u6807\u7ef4\u5ea6%s\u8bbe\u7f6e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_1", (String)"fi-bcm-business", (Object[])new Object[0]), targDim.getString("name")));
                return false;
            }
            targetIds.put(targid, targDim.getString("name"));
        }
        int indexSrc = 0;
        for (DynamicObject src : srcDynCollection) {
            DynamicObject srcDim = src.getDynamicObject("srcdimension");
            if (srcDim == null) {
                deleteBlankRowSrc.add(indexSrc);
                ++indexSrc;
                continue;
            }
            ++indexSrc;
            long srcid = srcDim.getLong("id");
            if (srcIds.containsKey(srcid)) {
                formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u5217\u8868\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u6e90\u7ef4\u5ea6%s\u8bbe\u7f6e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_3", (String)"fi-bcm-business", (Object[])new Object[0]), srcDim.getString("name")));
                return false;
            }
            srcIds.put(srcid, srcDim.getString("name"));
        }
        target22 = deleteBlankRowSrc.iterator();
        while (target22.hasNext()) {
            int srcIndex = (Integer)target22.next();
            srcDynCollection.remove(srcIndex);
        }
        target22 = deleteBlankRowTag.iterator();
        while (target22.hasNext()) {
            int tagIndex = (Integer)target22.next();
            tagDynCollection.remove(tagIndex);
        }
        DynamicObject scheme = dataEntity.getDynamicObject("scheme");
        HashMap src2tarIdMap = new HashMap();
        ArrayListMultimap tar2srcIdMap = ArrayListMultimap.create();
        Throwable throwable = null;
        try (DataSet singleDimmapping = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bcm_isdimmap", (String)"isdimmapsrcentry.srcdimension, isdimmaptargentry.tagdimension", (QFilter[])QFilter.of((String)"scheme = ? and mappedtype = ?", (Object[])new Object[]{scheme.getPkValue(), "1"}).toArray(), null);){
            singleDimmapping.forEach(row -> {
                src2tarIdMap.put(row.getLong(0), row.getLong(1));
                tar2srcIdMap.put((Object)row.getLong(1), (Object)row.getLong(0));
            });
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Long l : targetIds.keySet()) {
            if (tar2srcIdMap.get((Object)l) == null || tar2srcIdMap.get((Object)l).size() <= 0 || srcIds.keySet().stream().anyMatch(srcId -> tar2srcIdMap.get((Object)targId).contains(srcId))) continue;
            formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u4e2d\u7f3a\u5c11\u4e0e\u76ee\u6807\u7ef4\u5ea6\uff08%s\uff09\u5bf9\u5e94\u7684\u5355\u4e00\u6620\u5c04\u7ef4\u5ea6\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_14", (String)"fi-bcm-business", (Object[])new Object[0]), targetIds.get(l)));
            return false;
        }
        for (Map.Entry entry : srcIds.entrySet()) {
            Long srcId2 = (Long)entry.getKey();
            if (src2tarIdMap.get(srcId2) == null || targetIds.containsKey(src2tarIdMap.get(srcId2))) continue;
            formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u4e2d\u7f3a\u5c11\u4e0e\u6e90\u7ef4\u5ea6\uff08%s\uff09\u5bf9\u5e94\u7684\u5355\u4e00\u6620\u5c04\u7ef4\u5ea6\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_16", (String)"fi-bcm-business", (Object[])new Object[0]), entry.getValue()));
            return false;
        }
        if (scheme.getString("issrc.number").equalsIgnoreCase(IntegrateProductEnum.DIProduct.getNumber())) {
            for (Map.Entry entry : srcIds.entrySet()) {
                Long srcId2 = (Long)entry.getKey();
                if (src2tarIdMap.get(srcId2) != null) continue;
                formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\uff08%s\uff09\u7f3a\u5c11\u5bf9\u5e94\u7684\u5355\u4e00\u6620\u5c04\u7ef4\u5ea6\u6620\u5c04\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_28", (String)"fi-bcm-business", (Object[])new Object[0]), entry.getValue()));
                return false;
            }
        }
        return true;
    }

    private boolean checkTargetIsExist(DynamicObjectCollection dynamicObjectCollection, String dimension) {
        for (DynamicObject dyn : dynamicObjectCollection) {
            if (dyn.getDynamicObject("tagdimension") == null || !dimension.equals(dyn.getDynamicObject("tagdimension").getString("number"))) continue;
            return true;
        }
        return false;
    }

    private boolean checkSrcIsExist(DynamicObjectCollection dynamicObjectCollection, String dimension) {
        for (DynamicObject dyn : dynamicObjectCollection) {
            if (!dimension.equals(dyn.getDynamicObject("srcdimension").getString("number"))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void closeCallBack(IFormView formView, IDataModel model, ClosedCallBackEvent closedCallBackEvent) {
    }

    @Override
    public List<DefaultMappingVO> generateVO(DynamicObject dataEntity, Boolean isExtendsTable) {
        DynamicObjectCollection srcDynCollection = dataEntity.getDynamicObjectCollection("isdimmapsrcentry");
        DynamicObjectCollection tagDynCollection = dataEntity.getDynamicObjectCollection("isdimmaptargentry");
        ArrayList<DefaultMappingVO> returnData = new ArrayList<DefaultMappingVO>();
        DefaultMappingVO dvo = new DefaultMappingVO();
        String srcname = this.getDimName(srcDynCollection, "srcdimension");
        String tagname = this.getDimName(tagDynCollection, "tagdimension");
        dvo.setSourceName(srcname);
        dvo.setTargetName(tagname);
        dvo.setMappingid(dataEntity.getLong("id"));
        dvo.setTargetDef("");
        dvo.setSourceDef("");
        returnData.add(dvo);
        return returnData;
    }

    private String getDimName(DynamicObjectCollection srcDynCollection, String columnName) {
        String srcname = "";
        int size = srcDynCollection.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject src = (DynamicObject)srcDynCollection.get(i);
            DynamicObject dynamicObject = src.getDynamicObject(columnName);
            if (dynamicObject == null) continue;
            String name = dynamicObject.getString("name");
            srcname = i == 0 ? name : srcname + "\u3001" + name;
        }
        return srcname;
    }

    @Override
    public MemAndComVO generateMemAndComVO(DynamicObject mappingDyn) {
        MemAndComVO result = DimMappingTypeStrategy.super.generateMemAndComVO(mappingDyn);
        result.setType(MemAndComVO.VOEnum.C1);
        return result;
    }
}

