/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.mapping.DefaultMappingVO;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;

public interface DimMappingTypeStrategy {
    public void dimTypeChanged(IFormView var1, IDataModel var2);

    public List<DefaultMappingVO> generateVO(DynamicObject var1, Boolean var2);

    public void fillData(IDataModel var1, DynamicObject var2);

    public boolean validateSave(IFormView var1, IDataModel var2);

    public void closeCallBack(IFormView var1, IDataModel var2, ClosedCallBackEvent var3);

    default public void closePage(IFormView formView, IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject scheme = dataEntity.getDynamicObject("scheme");
        scheme = BusinessDataServiceHelper.loadSingle((String)"bcm_isscheme", (String)"id, modifier, modifytime", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{scheme.getLong("id")}).toArray());
        scheme.set("modifier", (Object)RequestContext.get().getUserId());
        scheme.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
        List<DefaultMappingVO> returnData = this.generateVO(dataEntity, Boolean.FALSE);
        formView.returnDataToParent(returnData);
    }

    default public MemAndComVO generateMemAndComVO(DynamicObject mappingDyn) {
        DynamicObjectCollection srcDynCollection = mappingDyn.getDynamicObjectCollection("isdimmapsrcentry");
        DynamicObjectCollection tagDynCollection = mappingDyn.getDynamicObjectCollection("isdimmaptargentry");
        MemAndComVO result = new MemAndComVO(srcDynCollection.size(), tagDynCollection.size(), MemAndComVO.VOEnum.M);
        this.addNode(srcDynCollection, result, true);
        this.addNode(tagDynCollection, result, false);
        result.setDimMapId(mappingDyn.getLong("id"));
        return result;
    }

    default public void addNode(DynamicObjectCollection srcDynCollection, MemAndComVO result, boolean isSource) {
        String byFromField;
        int size = srcDynCollection.size();
        String byFrom = "";
        String dynField = "";
        if (isSource) {
            byFromField = "srcbyfrom";
            dynField = "srcdimension";
        } else {
            byFromField = "tagbyfrom";
            dynField = "tagdimension";
        }
        ArrayList<Long> ids = new ArrayList<Long>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject src = (DynamicObject)srcDynCollection.get(i);
            if (!isSource && "bcm_structofextend".equals(src.getString("tagdimtype"))) continue;
            byFrom = src.getString(byFromField);
            ids.add(src.getDynamicObject(dynField).getLong("id"));
        }
        DynamicObjectCollection query = null;
        query = "1".equals(byFrom) ? QueryServiceHelper.query((String)"bcm_dimension", (String)"id, name, number, memberform as entitynumber", (QFilter[])new QFilter("id", "in", ids).toArray()) : QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"id, name, number, entitynumber", (QFilter[])new QFilter("id", "in", ids).toArray());
        if (query != null && query.size() > 0) {
            Map<Long, DynamicObject> idDynMapping = query.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
            for (Long id : ids) {
                DynamicObject d = idDynMapping.get(id);
                if (d == null) continue;
                if (isSource) {
                    result.addSource(d.getString("number"), d.getString("name"), d.getString("entitynumber"), d.getLong("id"));
                    continue;
                }
                result.addTarget(d.getString("number"), d.getString("name"), d.getString("entitynumber"), d.getLong("id"));
            }
        }
    }

    default public Boolean isXExtendProduct(Long schemeId) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme", (String)"issrc.number");
        if (IntegrateProductEnum.XExtendProduct.getNumber().equals(scheme.getString("issrc.number"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    default public boolean existTargDimSingle(Long targId, Long schemeId, Long dimId) {
        QFilter[] filters = new QFilter[]{new QFilter("scheme", "=", (Object)schemeId), new QFilter("mappedtype", "!=", (Object)"4"), new QFilter("isdimmaptargentry.tagdimension", "=", (Object)targId), QFilter.of((String)"id != ?", (Object[])new Object[]{dimId})};
        return QueryServiceHelper.exists((String)"bcm_isdimmap", (QFilter[])filters);
    }
}

