/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.mapping.AbstractOutProduct;
import kd.fi.bcm.common.util.GlobalIdUtil;

class EASACCProduct
extends AbstractOutProduct {
    EASACCProduct() {
    }

    @Override
    public boolean isMulti(String entityName) {
        return "".contains(entityName);
    }

    @Override
    protected String[][] initPreData() {
        return new String[][]{{"Entity", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"IProduct_1", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_orgunit"}, {"Account", ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee", (String)"IProduct_2", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_account"}, {"Year", ResManager.loadKDString((String)"\u5e74\u5ea6", (String)"IProduct_3", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_fiscalyear"}, {"Period", ResManager.loadKDString((String)"\u671f\u95f4", (String)"IProduct_4", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_fiscalperiod"}, {"Currency", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"IProduct_5", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_currency"}, {"AccessType", ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b", (String)"IProduct_6", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_changetype"}};
    }

    @Override
    public String[][] getCombineSeq() {
        return new String[][]{{"ds_account", ResManager.loadKDString((String)"\u79d1\u76ee", (String)"IProduct_0", (String)"fi-bcm-business", (Object[])new Object[0])}, {"ds_changetype", ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b", (String)"IProduct_6", (String)"fi-bcm-business", (Object[])new Object[0])}};
    }

    @Override
    protected void afterPreBaseEntityData(DynamicObject scheme) {
        this.addAssitGRP(scheme);
        DynamicObject dynamicObject = scheme.getDynamicObject("isscheme");
        Long ssid = this.addCustomer(dynamicObject);
        this.addAccessType(dynamicObject);
        this.addSupplier(ssid);
    }

    private void addAccessType(DynamicObject dynamicObject) {
        Long ssid = dynamicObject.getLong("id");
        if (!QueryServiceHelper.exists((String)"ds_changetype", (QFilter[])QFilter.of((String)"ssid = ? and number = ?", (Object[])new Object[]{ssid, "*"}).toArray())) {
            DynamicObject accessType = BusinessDataServiceHelper.newDynamicObject((String)"ds_changetype");
            accessType.set("ssid", (Object)ssid);
            accessType.set("soid", (Object)GlobalIdUtil.genStringId());
            accessType.set("number", (Object)"*");
            accessType.set("name", (Object)"*");
            accessType.set("id", (Object)String.valueOf(GlobalIdUtil.genGlobalLongId()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{accessType});
        }
    }

    private void addSupplier(Long ssid) {
        if (!QueryServiceHelper.exists((String)"ds_supplier", (QFilter[])QFilter.of((String)"ssid = ? and number = ?", (Object[])new Object[]{ssid, "InternalCompanyDefaultAll"}).toArray())) {
            DynamicObject supplier = BusinessDataServiceHelper.newDynamicObject((String)"ds_supplier");
            supplier.set("ssid", (Object)ssid);
            supplier.set("soid", (Object)GlobalIdUtil.genStringId());
            supplier.set("number", (Object)"InternalCompanyDefaultAll");
            supplier.set("name", (Object)ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5f80\u6765\u7ec4\u7ec7\u6620\u5c04", (String)"IProduct_7", (String)"fi-bcm-business", (Object[])new Object[0]));
            supplier.set("id", (Object)String.valueOf(GlobalIdUtil.genGlobalLongId()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplier});
        }
    }

    private Long addCustomer(DynamicObject dynamicObject) {
        Long ssid = dynamicObject.getLong("id");
        if (!QueryServiceHelper.exists((String)"ds_customer", (QFilter[])QFilter.of((String)"ssid = ? and number = ?", (Object[])new Object[]{ssid, "InternalCompanyDefaultAll"}).toArray())) {
            DynamicObject customer = BusinessDataServiceHelper.newDynamicObject((String)"ds_customer");
            customer.set("ssid", (Object)ssid);
            customer.set("soid", (Object)GlobalIdUtil.genStringId());
            customer.set("number", (Object)"InternalCompanyDefaultAll");
            customer.set("name", (Object)ResManager.loadKDString((String)"\u5ba2\u6237\u5f80\u6765\u7ec4\u7ec7\u6620\u5c04", (String)"IProduct_8", (String)"fi-bcm-business", (Object[])new Object[0]));
            customer.set("id", (Object)String.valueOf(GlobalIdUtil.genGlobalLongId()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{customer});
        }
        return ssid;
    }

    private void addAssitGRP(DynamicObject scheme) {
        DynamicObjectCollection asstactitems = QueryServiceHelper.query((String)"ds_asstacttype", (String)"id,number,name,ssid,soid,entity", (QFilter[])new QFilter[]{new QFilter("ssid", "=", (Object)scheme.getDynamicObject("isscheme").getLong("id"))});
        ArrayList waitSave = new ArrayList();
        asstactitems.forEach(as -> {
            if (StringUtils.isNotEmpty((CharSequence)as.getString("entity"))) {
                String entity = as.getString("entity");
                if ("T_BD_GeneralAsstActType".equalsIgnoreCase(entity)) {
                    this.newBaseDyn(scheme, waitSave, (DynamicObject)as, "ds_asstact");
                } else if (entity.toUpperCase(Locale.ENGLISH).startsWith("T_BD")) {
                    entity = entity.replace("T_BD", "ds").toLowerCase(Locale.ENGLISH);
                    this.newBaseDyn(scheme, waitSave, (DynamicObject)as, entity);
                } else if (entity.toUpperCase(Locale.ENGLISH).startsWith("T_ORG")) {
                    entity = entity.replace("T_ORG", "ds").toLowerCase(Locale.ENGLISH);
                    this.newBaseDyn(scheme, waitSave, (DynamicObject)as, entity);
                } else if (entity.toUpperCase(Locale.ENGLISH).startsWith("T_FS")) {
                    entity = entity.replace("T_FS", "ds").toLowerCase(Locale.ENGLISH);
                    this.newBaseDyn(scheme, waitSave, (DynamicObject)as, entity);
                }
            }
        });
        if (waitSave.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])waitSave.toArray(new DynamicObject[0]));
        }
    }

    private void newBaseDyn(DynamicObject scheme, List<DynamicObject> waitSave, DynamicObject as, String entity) {
        boolean isTrue = true;
        DynamicObject basedataList = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbaseentlist");
        basedataList.set("number", (Object)as.getString("number"));
        basedataList.set("name", (Object)new LocaleString(as.getString("name")));
        basedataList.set("entitynumber", (Object)entity);
        basedataList.set("scheme", (Object)scheme);
        basedataList.set("issys", (Object)isTrue);
        basedataList.set("creator", (Object)RequestContext.get().getUserId());
        basedataList.set("createtime", (Object)new Date());
        waitSave.add(basedataList);
    }

    @Override
    public boolean hasExpr() {
        return true;
    }
}

