/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.fel.common.StringUtils;

public class ExtendDim4ISSchemeService {
    private static final List<String> fixedDimension = Arrays.asList("Entity", "Year", "Period", "Scenario", "Process", "Currency", "AuditTrail");
    Map<String, String> dimNumber2Name = new LinkedHashMap<String, String>();
    Map<String, Tuple<String, String, Long>> fieldNumber2Name_DT_ID = new LinkedHashMap<String, Tuple<String, String, Long>>();
    Map<String, Object> baseEntryNumber2Id = new HashMap<String, Object>();
    DynamicObject schemeDy;

    public ExtendDim4ISSchemeService(DynamicObject schemeDy) {
        this.schemeDy = schemeDy;
    }

    public void insertDimPerData() {
        String table = this.schemeDy.getString("extendstable");
        if (DB.exitsTable((DBRoute)new DBRoute("bcm"), (String)table) || DB.exitsTable((DBRoute)BCMConstant.DBROUTE, (String)(table + "$map"))) {
            return;
        }
        Object id = this.schemeDy.get("id");
        Long modelId = this.schemeDy.getLong("model.id");
        this.schemeDy.set("enable", (Object)true);
        this.initExtendFieldData(modelId, this.schemeDy.getLong("extendsmodel.id"));
        try (TXHandle tx = TX.required();){
            try {
                this.createTable(table);
                this.createBaseEntryList(id);
                this.createDimMapping(id, modelId);
                this.createImportModel(id, modelId);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void initExtendFieldData(Long modelId, Long extendsmodelId) {
        BusinessDataServiceHelper.loadFromCache((String)"bcm_extmodeldim", (String)"id,dimension.number,dimension.name", (QFilter[])new QFilter("extmodelid", "=", (Object)extendsmodelId).toArray(), (String)"sequence").values().forEach(f -> this.dimNumber2Name.put(f.getString("dimension.number"), f.getString("dimension.name")));
        BusinessDataServiceHelper.loadFromCache((String)"bcm_extmodelfield", (String)"id,extfield.number,extfield.name,extfield.datatype, extfield.id", (QFilter[])new QFilter("extmodelid", "=", (Object)extendsmodelId).toArray(), (String)"sequence").values().forEach(f -> this.fieldNumber2Name_DT_ID.put(f.getString("extfield.number"), (Tuple<String, String, Long>)Tuple.create((Object)f.getString("extfield.name"), (Object)f.getString("extfield.datatype"), (Object)f.getLong("extfield.id"))));
        ArrayList<Object> enumFields = new ArrayList<Object>(4);
        for (Tuple<String, String, Long> entry : this.fieldNumber2Name_DT_ID.values()) {
            if (!((String)entry.p2).equals(DataTypeEnum.ENUMTP.getOIndex())) continue;
            enumFields.add(entry.p3);
        }
        if (enumFields.isEmpty()) {
            return;
        }
        BusinessDataServiceHelper.loadFromCache((String)"bcm_structofextend", (String)"number, enumitem", (QFilter[])new QFilter("id", "in", enumFields).toArray()).values().forEach(e -> {
            DynamicObject enumitem = e.getDynamicObject("enumitem");
            String field = e.getString("number");
            Tuple<String, String, Long> tuple = this.fieldNumber2Name_DT_ID.get(field);
            if (enumitem != null) {
                this.fieldNumber2Name_DT_ID.put(field, (Tuple<String, String, Long>)Tuple.create((Object)tuple.p1, (Object)enumitem.getString("datatype"), (Object)tuple.p3));
            } else {
                this.fieldNumber2Name_DT_ID.put(field, (Tuple<String, String, Long>)Tuple.create((Object)tuple.p1, (Object)DataTypeEnum.TXT.getOIndex(), (Object)tuple.p3));
            }
        });
    }

    private void createTable(String table) {
        String cont = "VARCHAR(50) ";
        String textCont = "VARCHAR(200) ";
        String fMoneyCont = "decimal(34,15) ";
        String dateCont = "DATETIME";
        StringBuilder sbDDL = new StringBuilder();
        sbDDL.append("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '").append(table).append("')   CREATE TABLE ").append(table).append(" (FID BIGINT DEFAULT 0 NOT NULL,").append(" FSSID BIGINT DEFAULT 0 NOT NULL,").append(" FSOID VARCHAR(100) DEFAULT '' NOT NULL,");
        for (String string : fixedDimension) {
            sbDDL.append("F").append(string).append(" ").append(cont).append(",");
        }
        for (String string : this.dimNumber2Name.keySet()) {
            sbDDL.append("F").append(string).append(" ").append(cont).append(",");
        }
        for (Map.Entry entry : this.fieldNumber2Name_DT_ID.entrySet()) {
            String fileId = (String)entry.getKey();
            String dataType = (String)((Tuple)entry.getValue()).p2;
            if (dataType.equals(DataTypeEnum.TXT.getOIndex())) {
                sbDDL.append("F").append(fileId.toUpperCase(Locale.ENGLISH)).append(" ").append(textCont).append(",");
                continue;
            }
            if (dataType.equals(DataTypeEnum.CURRENCY.getOIndex()) || dataType.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || dataType.equals(DataTypeEnum.PROPORTION.getOIndex()) || dataType.equals(DataTypeEnum.DEFAULT.getOIndex())) {
                sbDDL.append("F").append(fileId.toUpperCase(Locale.ENGLISH)).append(" ").append(fMoneyCont).append(",");
                continue;
            }
            if (!dataType.equals(DataTypeEnum.DATETP.getOIndex())) continue;
            sbDDL.append("F").append(fileId.toUpperCase(Locale.ENGLISH)).append(" ").append(dateCont).append(",");
        }
        DB.execute((DBRoute)new DBRoute("bcm"), (String)(sbDDL.substring(0, sbDDL.length() - 1) + ");"));
        DB.execute((DBRoute)new DBRoute("bcm"), (String)("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'PK_" + table + "') ALTER  TABLE " + table + " ADD CONSTRAINT PK_" + table + " PRIMARY KEY( FID );"));
        DB.execute((DBRoute)new DBRoute("bcm"), (String)("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_" + table + "') CREATE INDEX IDX_" + table + " ON " + table + " ( FENTITY,FYEAR,FPERIOD,FCURRENCY );"));
    }

    private void createBaseEntryList(Object schemeId) {
        DynamicObject baseEntry;
        boolean isFalse = false;
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(16);
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<String> allDim = new ArrayList<String>(fixedDimension.size());
        allDim.addAll(fixedDimension);
        allDim.addAll(this.dimNumber2Name.keySet());
        for (String string : allDim) {
            baseEntry = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbaseentlist");
            baseEntry.set("number", (Object)this.changeNumber(string));
            String name = DimEntityNumEnum.getNameByNumber((String)string);
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = this.dimNumber2Name.get(string);
            }
            baseEntry.set("name", (Object)name);
            baseEntry.set("entitynumber", (Object)DimEntityNumEnum.getEntieyNumByNumber((String)string));
            baseEntry.set("scheme", schemeId);
            baseEntry.set("issys", (Object)isFalse);
            baseEntry.set("creator", (Object)currUserId);
            baseEntry.set("createtime", (Object)date);
            dyList.add(baseEntry);
        }
        for (Map.Entry entry : this.fieldNumber2Name_DT_ID.entrySet()) {
            baseEntry = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbaseentlist");
            baseEntry.set("number", (Object)this.changeNumber((String)entry.getKey()));
            baseEntry.set("name", ((Tuple)entry.getValue()).p1);
            baseEntry.set("entitynumber", (Object)"bcm_structofextend");
            baseEntry.set("scheme", schemeId);
            baseEntry.set("issys", (Object)isFalse);
            baseEntry.set("creator", (Object)currUserId);
            baseEntry.set("createtime", (Object)date);
            dyList.add(baseEntry);
        }
        SaveServiceHelper.save((DynamicObject[])dyList.toArray(new DynamicObject[0]));
        dyList.forEach(dy -> this.baseEntryNumber2Id.put(dy.getString("number"), dy.get("id")));
    }

    private String changeNumber(String number) {
        return "f" + number.toLowerCase(Locale.ENGLISH);
    }

    private void createImportModel(Object schemeId, Long modelId) {
        DynamicObject importModelDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isimportmode");
        QFilter atQf = new QFilter("model", "=", (Object)modelId);
        atQf.and("number", "=", (Object)"AuditTrail");
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        DynamicObject atDimension = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)"id", (QFilter[])atQf.toArray());
        importModelDy.set("scheme", schemeId);
        importModelDy.set("importmode", (Object)ISImpModeEnum.REPLACEIMPORT.getCode());
        importModelDy.set("dimension", (Object)atDimension);
        importModelDy.set("creator", (Object)currUserId);
        importModelDy.set("createdate", (Object)date);
        importModelDy.set("modifier", (Object)currUserId);
        importModelDy.set("modifydate", (Object)date);
        importModelDy.set("model", (Object)modelId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{importModelDy});
        this.schemeDy.set("importmodeid", (Object)importModelDy);
    }

    private void createDimMapping(Object schemeId, Long modelId) {
        DynamicObject EIRptDy;
        ArrayList<String> allDim = new ArrayList<String>(10);
        allDim.addAll(fixedDimension);
        allDim.addAll(this.dimNumber2Name.keySet());
        allDim.addAll(this.fieldNumber2Name_DT_ID.keySet());
        Map<String, Object> dimNumber2Id = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,id", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray()).stream().collect(Collectors.toMap(f -> f.getString("number"), f -> f.get("id")));
        QFilter qfModel = new QFilter("model", "=", (Object)modelId);
        QFilter noShareNode = new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        DynamicObject MRptDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_scenemembertree", (String)"id, name, number", (QFilter[])new QFilter("number", "=", (Object)"MRpt").and(qfModel).and(noShareNode).toArray());
        if (MRptDy == null) {
            DynamicObjectCollection scenarios = QueryServiceHelper.query((String)"bcm_scenemembertree", (String)"id, name, number", (QFilter[])new QFilter("isleaf", "=", (Object)"1").and(qfModel).toArray(), (String)"dseq");
            if (scenarios != null && scenarios.size() > 0) {
                MRptDy = (DynamicObject)scenarios.get(0);
            } else {
                throw new KDBizException("Missing Scenario dimension member.");
            }
        }
        if ((EIRptDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_processmembertree", (String)"id, name, number", (QFilter[])new QFilter("number", "=", (Object)"EIRpt").and(qfModel).and(noShareNode).toArray())) == null) {
            throw new KDBizException("Missing Process dimension member: EIRpt.");
        }
        DynamicObject EntityInputDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_audittrialmembertree", (String)"id, name, number", (QFilter[])new QFilter("number", "=", (Object)"EntityInput").and(qfModel).and(noShareNode).toArray());
        if (EntityInputDy == null) {
            throw new KDBizException("Missing AuditTrial dimension member: EntityInput.");
        }
        HashMap<String, DynamicObject> targDefDim = new HashMap<String, DynamicObject>(3);
        targDefDim.put("Scenario", MRptDy);
        targDefDim.put("Process", EIRptDy);
        targDefDim.put("AuditTrail", EntityInputDy);
        int seq = 1;
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<DynamicObject> dimMappings = new ArrayList<DynamicObject>(allDim.size());
        for (String dimNumber : allDim) {
            DynamicObject dimMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdimmap");
            dimMapping.set("scheme", schemeId);
            dimMapping.set("sequence", (Object)seq++);
            dimMapping.set("creator", (Object)currUserId);
            dimMapping.set("createtime", (Object)date);
            DynamicObjectCollection targCollections = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
            DynamicObject dimMappingtarg = targCollections.addNew();
            dimMappingtarg.set("tagbyfrom", (Object)"1");
            if (this.fieldNumber2Name_DT_ID.containsKey(dimNumber)) {
                dimMappingtarg.set("tagdimtype", (Object)"bcm_structofextend");
                dimMappingtarg.set("tagdimension", this.fieldNumber2Name_DT_ID.get((Object)dimNumber).p3);
                dimMapping.set("datatype", this.fieldNumber2Name_DT_ID.get((Object)dimNumber).p2);
            } else {
                dimMappingtarg.set("tagdimtype", (Object)"bcm_dimension");
                dimMappingtarg.set("tagdimension", dimNumber2Id.get(dimNumber));
            }
            dimMappingtarg.set("seq", (Object)1);
            String name = fixedDimension.contains(dimNumber) ? DimEntityNumEnum.getNameByNumber((String)dimNumber) : (this.dimNumber2Name.containsKey(dimNumber) ? this.dimNumber2Name.get(dimNumber) : (String)this.fieldNumber2Name_DT_ID.get((Object)dimNumber).p1);
            if (targDefDim.containsKey(dimNumber)) {
                dimMapping.set("number", (Object)dimNumber);
                dimMapping.set("name", (Object)name);
                dimMapping.set("mappedtype", (Object)"2");
                DynamicObjectCollection tagDefaultCollections = dimMappingtarg.getDynamicObjectCollection("isdimmaptargdefval");
                DynamicObject dimMappingDefaultTag = tagDefaultCollections.addNew();
                DynamicObject defDy = (DynamicObject)targDefDim.get(dimNumber);
                dimMappingDefaultTag.set("tagmemname", defDy.get("name"));
                dimMappingDefaultTag.set("tagmemb", defDy.get("id"));
                dimMappingDefaultTag.set("targetmemnum", defDy.get("number"));
                dimMappingDefaultTag.set("seq", (Object)1);
            } else {
                dimMapping.set("number", (Object)(dimNumber + "-" + this.changeNumber(dimNumber)));
                dimMapping.set("name", (Object)(name + "-" + name));
                dimMapping.set("mappedtype", (Object)"1");
                DynamicObjectCollection srcCollections = dimMapping.getDynamicObjectCollection("isdimmapsrcentry");
                DynamicObject dimMappingsrc = srcCollections.addNew();
                dimMappingsrc.set("srcbyfrom", (Object)"2");
                dimMappingsrc.set("srcdimension", this.baseEntryNumber2Id.get(this.changeNumber(dimNumber)));
                dimMappingsrc.set("srcdimtype", (Object)"bcm_isbaseentlist");
                dimMappingsrc.set("seq", (Object)1);
            }
            dimMappings.add(dimMapping);
        }
        SaveServiceHelper.save((DynamicObject[])dimMappings.toArray(new DynamicObject[0]));
    }
}

