/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.mapping.IProduct;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integration.mapping.MappingProperty;
import kd.fi.bcm.business.integration.mapping.Tuple;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class MappingBuilder {
    private MappingProperty property = null;
    private DynamicObject scheme = null;
    private String srcEntity;
    private String targetEntity;
    private int seq = 1;
    private int sourceColumnIndex = 0;
    private int targetColumnIndex = 0;
    private Map<String, DynamicObject> srcDynDim;
    private Map<String, DynamicObject> targetDynDim;

    private MappingBuilder(MappingContext context) {
        this.property = context.getProperty();
        this.scheme = context.getScheme();
        Class<? extends IProduct> fromClass = this.property.getFromClass();
        if (fromClass != null) {
            this.srcEntity = context.getSource().getDimEntity();
            this.targetEntity = context.getTarget().getDimEntity();
            if (fromClass.isInstance(context.getSource())) {
                this.sourceColumnIndex = 1;
            } else {
                this.targetColumnIndex = 1;
                String[][] temp = this.property.getDefaultsrcmappings();
                this.property.setDefaultsrcmappings(this.property.getDefaulttargetmappings());
                this.property.setDefaulttargetmappings(temp);
            }
            this.seq = this.property.getSeq();
        }
    }

    public static MappingBuilder getInstance(MappingContext context) {
        return new MappingBuilder(context);
    }

    public final DynamicObject[] buildPreData() {
        DynamicObject[] result;
        ArrayList<DynamicObject> dimmappings = new ArrayList<DynamicObject>();
        Tuple<Set<String>, Set<String>> tupleNumbers = this.getTupleNumber();
        if (tupleNumbers.getF().size() > 0 || tupleNumbers.getB().size() > 0) {
            this.srcDynDim = this.queryDim(tupleNumbers.getF(), this.srcEntity);
            this.targetDynDim = this.queryDim(tupleNumbers.getB(), this.targetEntity);
            this.buildOneMapping(dimmappings);
            this.buildSrcMapping(dimmappings);
            this.buildTargMapping(dimmappings);
            this.buildCombineMapping(dimmappings);
        }
        if ((result = dimmappings.toArray(new DynamicObject[dimmappings.size()])).length > 0) {
            SaveServiceHelper.save((DynamicObject[])result);
        }
        this.property = null;
        this.scheme = null;
        return result;
    }

    private String getByFrom(String entity) {
        if ("bcm_dimension".equals(entity)) {
            return "1";
        }
        return "2";
    }

    private void buildCombineMapping(List<DynamicObject> dimmappings) {
        String[][] combinemappings = this.property.getCombinemappings();
        if (combinemappings != null && combinemappings.length > 1) {
            DynamicObject dimMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdimmap");
            String[] srcNumbers = combinemappings[this.sourceColumnIndex];
            String[] targetNumbers = combinemappings[this.targetColumnIndex];
            String name = ResManager.loadKDString((String)"\u79d1\u76ee\u7ec4\u5408\u7ef4\u5ea6\u6620\u5c04", (String)"MappingBuilder_0", (String)"fi-bcm-business", (Object[])new Object[0]);
            dimMapping.set("name", (Object)name);
            dimMapping.set("scheme", (Object)this.scheme);
            dimMapping.set("sequence", (Object)100000);
            dimMapping.set("mappedtype", (Object)"4");
            dimMapping.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
            dimMapping.set("createtime", (Object)new Date());
            DynamicObjectCollection srcCollections = dimMapping.getDynamicObjectCollection("isdimmapsrcentry");
            int index = 1;
            for (String srcnumber : srcNumbers) {
                DynamicObject dimMappingsrc = srcCollections.addNew();
                DynamicObject srcDimDyn = this.srcDynDim.get(srcnumber);
                if (srcDimDyn == null) {
                    return;
                }
                dimMappingsrc.set("srcbyfrom", (Object)this.getByFrom(this.srcEntity));
                dimMappingsrc.set("srcdimension", srcDimDyn.get("id"));
                dimMappingsrc.set("srcdimtype", (Object)this.srcEntity);
                dimMappingsrc.set("seq", (Object)index++);
            }
            index = 1;
            DynamicObjectCollection targCollections = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
            for (String targnumber : targetNumbers) {
                DynamicObject dimMappingtarg = targCollections.addNew();
                DynamicObject targDimDyn = this.targetDynDim.get(targnumber);
                if (targDimDyn == null) {
                    return;
                }
                dimMappingtarg.set("tagbyfrom", (Object)this.getByFrom(this.targetEntity));
                dimMappingtarg.set("tagdimension", targDimDyn.get("id"));
                dimMappingtarg.set("tagdimtype", (Object)this.targetEntity);
                dimMappingtarg.set("seq", (Object)index++);
            }
            dimmappings.add(dimMapping);
        }
    }

    private void buildTargMapping(List<DynamicObject> dimmappings) {
        for (String[] out : this.property.getDefaulttargetmappings()) {
            String tagNumber = out[0];
            DynamicObject tagDimDyn = this.targetDynDim.get(tagNumber);
            if (tagDimDyn == null) {
                return;
            }
            String[] tagDefaultNumbers = out[1].split("@");
            String name = "";
            DynamicObject dimMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdimmap");
            dimMapping.set("name", (Object)name);
            dimMapping.set("scheme", (Object)this.scheme);
            dimMapping.set("sequence", (Object)this.seq++);
            dimMapping.set("mappedtype", (Object)"2");
            dimMapping.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
            dimMapping.set("createtime", (Object)new Date());
            DynamicObjectCollection tagCollections = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
            DynamicObject dimMappingtag = tagCollections.addNew();
            dimMappingtag.set("tagbyfrom", (Object)this.getByFrom(this.targetEntity));
            dimMappingtag.set("tagdimension", tagDimDyn.get("id"));
            dimMappingtag.set("tagdimtype", (Object)this.targetEntity);
            dimMappingtag.set("seq", (Object)"1");
            String entityName = tagDimDyn.getString("entitynumber");
            QFilter[] filters = new QFilter[]{this.getDetailQFilter(this.targetEntity, entityName), new QFilter("number", "in", Arrays.asList(tagDefaultNumbers)), new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index)};
            DynamicObjectCollection targdefaultDyns = QueryServiceHelper.query((String)entityName, (String)"id, number, name", (QFilter[])filters);
            DynamicObjectCollection tagDefaultCollections = dimMappingtag.getDynamicObjectCollection("isdimmaptargdefval");
            int index = 1;
            for (DynamicObject targdefaultDyn : targdefaultDyns) {
                DynamicObject dimMappingDefaultTag = tagDefaultCollections.addNew();
                dimMappingDefaultTag.set("tagmemname", targdefaultDyn.get("name"));
                dimMappingDefaultTag.set("tagmemb", targdefaultDyn.get("id"));
                dimMappingDefaultTag.set("targetmemnum", targdefaultDyn.get("number"));
                dimMappingDefaultTag.set("seq", (Object)index++);
            }
            dimmappings.add(dimMapping);
        }
    }

    private void buildSrcMapping(List<DynamicObject> dimmappings) {
        for (String[] out : this.property.getDefaultsrcmappings()) {
            String srcNumber = out[0];
            DynamicObject srcDimDyn = this.srcDynDim.get(srcNumber);
            if (srcDimDyn == null) {
                return;
            }
            String[] srcDefaultNumbers = out[1].split("@");
            DynamicObject dimMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdimmap");
            String name = "";
            dimMapping.set("name", (Object)name);
            dimMapping.set("scheme", (Object)this.scheme);
            dimMapping.set("sequence", (Object)this.seq++);
            dimMapping.set("mappedtype", (Object)"3");
            dimMapping.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
            dimMapping.set("createtime", (Object)new Date());
            DynamicObjectCollection srcCollections = dimMapping.getDynamicObjectCollection("isdimmapsrcentry");
            DynamicObject dimMappingsrc = srcCollections.addNew();
            dimMappingsrc.set("srcbyfrom", (Object)this.getByFrom(this.srcEntity));
            dimMappingsrc.set("srcdimension", srcDimDyn.get("id"));
            dimMappingsrc.set("srcdimtype", (Object)this.srcEntity);
            dimMappingsrc.set("seq", (Object)"1");
            String entityName = srcDimDyn.getString("entitynumber");
            if (this.isNGBGMODELAndDifUserTypeAndDataSource()) {
                DynamicObjectCollection srcDefaultCollections = dimMappingsrc.getDynamicObjectCollection("isdimmapsrcdefval");
                DynamicObject dimMappingDefaultSrc = srcDefaultCollections.addNew();
                dimMappingDefaultSrc.set("srcmemname", (Object)srcDefaultNumbers[0]);
                dimMappingDefaultSrc.set("soucememnum", (Object)srcDefaultNumbers[0]);
                dimMappingDefaultSrc.set("srcmemb", (Object)0L);
                dimMappingDefaultSrc.set("seq", (Object)1);
            } else {
                DynamicObjectCollection srcdefaultDyns = QueryServiceHelper.query((String)entityName, (String)"id, number, name", (QFilter[])new QFilter[]{this.getDetailQFilter(this.srcEntity, entityName), new QFilter("number", "in", Arrays.asList(srcDefaultNumbers))});
                DynamicObjectCollection srcDefaultCollections = dimMappingsrc.getDynamicObjectCollection("isdimmapsrcdefval");
                int index = 1;
                for (DynamicObject srcdefaultDyn : srcdefaultDyns) {
                    DynamicObject dimMappingDefaultSrc = srcDefaultCollections.addNew();
                    dimMappingDefaultSrc.set("srcmemname", srcdefaultDyn.get("name"));
                    dimMappingDefaultSrc.set("soucememnum", srcdefaultDyn.get("number"));
                    dimMappingDefaultSrc.set("srcmemb", srcdefaultDyn.get("id"));
                    dimMappingDefaultSrc.set("seq", (Object)index++);
                }
            }
            dimmappings.add(dimMapping);
        }
    }

    private QFilter getDetailQFilter(String entityName, String type) {
        if ("bcm_dimension".equals(entityName)) {
            DynamicObject model = this.scheme.getDynamicObject("model");
            return new QFilter("model", "=", model.get("id"));
        }
        if ("epm".equals(type.substring(0, 3))) {
            long srcModelId = this.scheme.getLong("issrcmodel.id");
            DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_isngmodel", (String)"id,modelsource,tdpdatacenterid", (QFilter[])new QFilter("id", "=", (Object)srcModelId).toArray());
            Long modelSourceId = model.getLong("modelsource");
            QFilter id = new QFilter("id", "=", (Object)modelSourceId);
            QFilter[] fId = new QFilter[]{id};
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"model", (QFilter[])fId);
            Long modelId = dyn.getLong("model");
            return new QFilter("model", "=", (Object)modelId);
        }
        DynamicObject isScheme = this.scheme.getDynamicObject("isscheme");
        return new QFilter("ssid", "=", isScheme.get("id"));
    }

    private void buildOneMapping(List<DynamicObject> dimmappings) {
        for (String[] out : this.property.getOnemappings()) {
            DynamicObject dimMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdimmap");
            String[] srcNumbers = out[this.sourceColumnIndex].split("@");
            String[] targetNumbers = out[this.targetColumnIndex].split("@");
            String number = Stream.of(targetNumbers).collect(Collectors.joining("+")) + "-" + Stream.of(srcNumbers).collect(Collectors.joining("+"));
            dimMapping.set("number", (Object)number);
            dimMapping.set("scheme", (Object)this.scheme);
            dimMapping.set("sequence", (Object)this.seq++);
            dimMapping.set("mappedtype", (Object)"1");
            dimMapping.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
            dimMapping.set("createtime", (Object)new Date());
            DynamicObjectCollection srcCollections = dimMapping.getDynamicObjectCollection("isdimmapsrcentry");
            int index = 1;
            String srcname = "";
            for (String srcnumber : srcNumbers) {
                DynamicObject dimMappingsrc = srcCollections.addNew();
                DynamicObject srcDimDyn = this.srcDynDim.get(srcnumber);
                if (srcDimDyn == null) {
                    return;
                }
                dimMappingsrc.set("srcbyfrom", (Object)this.getByFrom(this.srcEntity));
                dimMappingsrc.set("srcdimension", srcDimDyn.get("id"));
                dimMappingsrc.set("srcdimtype", (Object)this.srcEntity);
                srcname = index == 1 ? srcDimDyn.getString("name") : srcname + "+" + srcDimDyn.getString("name");
                dimMappingsrc.set("seq", (Object)index++);
            }
            index = 1;
            String targname = "";
            DynamicObjectCollection targCollections = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
            for (String targnumber : targetNumbers) {
                DynamicObject dimMappingtarg = targCollections.addNew();
                DynamicObject targDimDyn = this.targetDynDim.get(targnumber);
                if (targDimDyn == null) {
                    return;
                }
                dimMappingtarg.set("tagbyfrom", (Object)this.getByFrom(this.targetEntity));
                dimMappingtarg.set("tagdimension", targDimDyn.get("id"));
                dimMappingtarg.set("tagdimtype", (Object)this.targetEntity);
                targname = index == 1 ? targDimDyn.getString("name") : targname + "+" + targDimDyn.getString("name");
                dimMappingtarg.set("seq", (Object)index++);
            }
            dimMapping.set("name", (Object)(targname + "-" + srcname));
            dimmappings.add(dimMapping);
        }
    }

    private QFilter getQFilter(String entityName) {
        if ("bcm_dimension".equals(entityName)) {
            DynamicObject model = this.scheme.getDynamicObject("model");
            return new QFilter("model", "=", model.get("id"));
        }
        return new QFilter("scheme", "=", this.scheme.get("id"));
    }

    private Tuple<Set<String>, Set<String>> getTupleNumber() {
        HashSet<String> srcNumbers = new HashSet<String>(16);
        HashSet<String> targetNumbers = new HashSet<String>(16);
        for (String[] out : this.property.getOnemappings()) {
            srcNumbers.addAll(Arrays.asList(out[this.sourceColumnIndex].split("@")));
            targetNumbers.addAll(Arrays.asList(out[this.targetColumnIndex].split("@")));
        }
        for (String[] out : this.property.getDefaultsrcmappings()) {
            srcNumbers.add(out[0]);
        }
        for (String[] out : this.property.getDefaulttargetmappings()) {
            targetNumbers.add(out[0]);
        }
        if (this.property.getCombinemappings().length > 0) {
            srcNumbers.addAll(Arrays.asList(this.property.getCombinemappings()[this.sourceColumnIndex]));
            targetNumbers.addAll(Arrays.asList(this.property.getCombinemappings()[this.targetColumnIndex]));
        }
        return new Tuple<Set<String>, Set<String>>(srcNumbers, targetNumbers);
    }

    private Map<String, DynamicObject> queryDim(Set<String> numbers, String entityName) {
        String selectFields = "";
        selectFields = "bcm_dimension".equals(entityName) ? "id, name, number, membermodel as entitynumber" : "id, name, number, entitynumber";
        DynamicObjectCollection result = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("number", "in", numbers), this.getQFilter(entityName)});
        return result.stream().collect(Collectors.toMap(v -> v.getString("number"), v -> v));
    }

    private boolean isNGBGMODELAndDifUserTypeAndDataSource() {
        long srcModelId;
        DynamicObject model;
        String product = this.scheme.getString("issrc.number");
        return !ObjectUtils.isEmpty((Object)product) && product.equals("NGBGMODEL") && (!"1".equalsIgnoreCase((model = QueryServiceHelper.queryOne((String)"bcm_isngmodel", (String)"usertype,datasource,tdpdatacenterid", (QFilter[])new QFilter("id", "=", (Object)(srcModelId = this.scheme.getLong("issrcmodel.id"))).toArray())).getString("usertype")) || !RequestContext.get().getAccountId().equalsIgnoreCase(model.getString("datasource")));
    }
}

