/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.integration.di.service.AbstractDIIntegrateService;
import kd.fi.bcm.business.integration.mapping.IProduct;
import kd.fi.bcm.business.integration.mapping.MappingProperty;
import kd.fi.bcm.business.integration.mapping.MappingPropertyFactory;
import kd.fi.bcm.business.integration.mapping.NGBGModelProduct;
import kd.fi.bcm.business.integration.mapping.NGCMModelProduct;
import kd.fi.bcm.business.integration.mapping.NGFRModelProduct;
import kd.fi.bcm.business.integration.mapping.NGProduct;
import kd.fi.bcm.business.integration.mapping.ProductFactory;
import kd.fi.bcm.business.integrationnew.service.AbstractIntegrateService;

public class MappingContext {
    private IProduct source;
    private IProduct target;
    private DynamicObject scheme;
    private MappingProperty property;

    public MappingContext(IProduct source, IProduct target) {
        this.source = source;
        this.target = target;
    }

    public MappingContext(DynamicObject scheme) {
        String srcProNumber = scheme.getDynamicObject("issrc").getString("number");
        String targProNumber = scheme.getDynamicObject("istarg").getString("number");
        this.source = ProductFactory.getInstance(srcProNumber);
        this.target = ProductFactory.getInstance(targProNumber);
        this.scheme = scheme;
    }

    public MappingContext(DynamicObject scheme, MappingProperty property) {
        this(scheme);
        this.property = property;
    }

    public MappingContext(DynamicObject scheme, boolean initProperty) {
        this(scheme);
        if (initProperty) {
            this.property = MappingPropertyFactory.getInstance(this.source, this.target);
        }
    }

    public boolean isSrcNg() {
        return this.source instanceof NGProduct;
    }

    public boolean isSrcFRModel() {
        return this.source instanceof NGFRModelProduct;
    }

    public boolean isSrcCMModel() {
        return this.source instanceof NGCMModelProduct;
    }

    public boolean isSrcBGModel() {
        return this.source instanceof NGBGModelProduct;
    }

    public IProduct getSource() {
        return this.source;
    }

    public IProduct getTarget() {
        return this.target;
    }

    public IProduct getNGProduct() {
        if (this.isSrcNg()) {
            return this.source;
        }
        return this.target;
    }

    public DynamicObject getScheme() {
        return this.scheme;
    }

    public MappingProperty getProperty() {
        return this.property;
    }

    public List<Class<? extends AbstractIntegrateService>> getIntegrateService() {
        return MappingPropertyFactory.getInstance(this.source, this.target).getIntegrateService(this);
    }

    public List<Class<? extends AbstractDIIntegrateService>> getDIIntegrateService() {
        return MappingPropertyFactory.getInstance(this.source, this.target).getDIIntegrateService(this);
    }
}

