/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.mapping.DefaultMappingVO;
import kd.fi.bcm.business.integration.mapping.DimMappingTypeStrategy;
import kd.fi.bcm.business.integration.mapping.DimMappingTypeStrategyFactory;
import kd.fi.bcm.business.integration.mapping.IProduct;
import kd.fi.bcm.business.integration.mapping.MappingBuilder;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integration.mapping.MappingProperty;
import kd.fi.bcm.business.integration.mapping.MappingPropertyFactory;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.lang3.StringUtils;

public class MappingService {
    private static final String GlCurrency = "Currency";
    private MappingContext context;
    private Map<String, String> baseEntMap;
    private Map<String, String> dimMap;

    public MappingService() {
    }

    public MappingService(DynamicObject scheme) {
        this.context = new MappingContext(scheme);
    }

    public MappingService(DynamicObject scheme, boolean initPre) {
        this.context = new MappingContext(scheme, initPre);
    }

    public MappingService(MappingContext context) {
        this.context = context;
    }

    public void checkEnableDimAndAdd() {
        this.checkContext();
        DynamicObject scheme = this.context.getScheme();
        IProduct sourceProduct = this.context.getSource();
        Map<String, DynamicObject> srcMissCheckDim = sourceProduct.checkEnableMissDim(scheme);
        IProduct targProduct = this.context.getTarget();
        Map<String, DynamicObject> targMissCheckDim = targProduct.checkEnableMissDim(scheme);
        QFilter[] filters = null;
        filters = new QFilter[]{new QFilter("scheme", "=", scheme.getPkValue())};
        DynamicObject[] dimmappings = MappingService.queryDimmapping(filters);
        if (MappingService.isDimNotEmpty(dimmappings)) {
            for (DynamicObject dimmapping : dimmappings) {
                this.checkExist(srcMissCheckDim, dimmapping, "isdimmapsrcentry", "srcdimension");
                this.checkExist(targMissCheckDim, dimmapping, "isdimmaptargentry", "tagdimension");
            }
        }
        String[][] missSrcDim = sourceProduct.getMissDim(srcMissCheckDim);
        String[][] missTargetDim = targProduct.getMissDim(targMissCheckDim);
        if (missSrcDim.length > 0 || missTargetDim.length > 0) {
            MappingProperty property = new MappingProperty(sourceProduct.getClass(), targProduct.getClass());
            property.setDefaultsrcmappings(missSrcDim);
            property.setDefaulttargetmappings(missTargetDim);
            property.setSeq(500);
            MappingBuilder.getInstance(new MappingContext(scheme, property)).buildPreData();
        }
    }

    private void checkExist(Map<String, DynamicObject> checkDimNumbers, DynamicObject dimmapping, String entry, String field) {
        DynamicObjectCollection collection;
        if (checkDimNumbers.size() > 0 && (collection = dimmapping.getDynamicObjectCollection(entry)) != null) {
            for (DynamicObject dim : collection) {
                String number = dim.getDynamicObject(field).getString("number");
                if (!checkDimNumbers.containsKey(number)) continue;
                checkDimNumbers.remove(number);
            }
        }
    }

    private void checkExistScenario(Map<String, DynamicObject> checkDimNumbers, DynamicObject dimmapping, String entry, String field) {
        DynamicObjectCollection collection;
        if (checkDimNumbers.size() > 0 && (collection = dimmapping.getDynamicObjectCollection(entry)) != null) {
            for (DynamicObject dim : collection) {
                String number = dim.getDynamicObject(field).getString("number");
                if (!"Scenario".equals(number) || !checkDimNumbers.containsKey(number)) continue;
                checkDimNumbers.remove(number);
                break;
            }
        }
    }

    public DynamicObject[] insertDimPreData() {
        this.checkContext();
        MappingBuilder mappingBuilder = MappingBuilder.getInstance(this.context);
        return mappingBuilder.buildPreData();
    }

    private void checkContext() {
        if (this.context == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"context \u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MappingService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public Collection<? extends DefaultMappingVO> generateVO(DynamicObject dimmapping, String dimType, Boolean isExtendsTable) {
        DimMappingTypeStrategy instance = DimMappingTypeStrategyFactory.getInstance(dimType);
        return instance.generateVO(dimmapping, isExtendsTable);
    }

    public static MemAndComVO generateMemAndComVO(Long mappingId) {
        DynamicObject queryDimmapping = BusinessDataServiceHelper.loadSingle((Object)mappingId, (String)"bcm_isdimmap", (String)"id, tagdimension, tagdimtype, tagbyfrom, srcdimension, srcdimtype, srcbyfrom, mappedtype, srcmemname, tagmemname");
        if (queryDimmapping != null) {
            DimMappingTypeStrategy instance = DimMappingTypeStrategyFactory.getInstance(queryDimmapping.getString("mappedtype"));
            return instance.generateMemAndComVO(queryDimmapping);
        }
        return null;
    }

    protected boolean isFromJQ() {
        DynamicObject scheme = this.context.getScheme();
        DynamicObject issrc = scheme.getDynamicObject("issrc");
        return "JQ".equals(issrc.getString("number")) || "JQONLINE".equals(issrc.getString("number"));
    }

    protected boolean isFromNGBGModel() {
        DynamicObject scheme = this.context.getScheme();
        DynamicObject issrc = scheme.getDynamicObject("issrc");
        return "NGBGMODEL".equals(issrc.getString("number"));
    }

    protected boolean isFromNGFRModel() {
        DynamicObject scheme = this.context.getScheme();
        DynamicObject issrc = scheme.getDynamicObject("issrc");
        return "NGFRMODEL".equals(issrc.getString("number"));
    }

    protected boolean isFromNGCMModel() {
        DynamicObject scheme = this.context.getScheme();
        DynamicObject issrc = scheme.getDynamicObject("issrc");
        return "NGCMMODEL".equals(issrc.getString("number"));
    }

    public boolean isFromMidLib() {
        DynamicObject scheme = this.context.getScheme();
        DynamicObject issrc = scheme.getDynamicObject("issrc");
        return "MIDLIB".equals(issrc.getString("number"));
    }

    protected boolean isFromEASREP() {
        DynamicObject scheme = this.context.getScheme();
        DynamicObject issrc = scheme.getDynamicObject("issrc");
        return IntegrateProductEnum.EASREPProduct.getNumber().equals(issrc.getString("number"));
    }

    protected boolean isFromXExtend() {
        DynamicObject scheme = this.context.getScheme();
        DynamicObject issrc = scheme.getDynamicObject("issrc");
        return IntegrateProductEnum.XExtendProduct.getNumber().equals(issrc.getString("number"));
    }

    public boolean isMultiCurrency() {
        DynamicObject scheme = this.context.getScheme();
        DynamicObject issrc = scheme.getDynamicObject("issrc");
        return (IntegrateProductEnum.NGACCProduct.getNumber().equals(issrc.getString("number")) || IntegrateProductEnum.MIDLIBProduct.getNumber().equals(issrc.getString("number"))) && scheme.getBoolean("multicurrency");
    }

    /*
     * WARNING - void declaration
     */
    public List<String> checkDim() {
        boolean fromNGModel;
        void var17_20;
        ArrayList<String> error = new ArrayList<String>(2);
        this.checkContext();
        DynamicObject scheme = this.context.getScheme();
        QFilter[] filters = new QFilter[]{new QFilter("scheme", "=", scheme.getPkValue())};
        DynamicObject[] dimmappings = MappingService.queryDimmapping(filters);
        if (this.isFromJQ()) {
            return this.checkJqMapping(dimmappings, error);
        }
        boolean isMultiCurrency = this.isMultiCurrency();
        int multiCurrencyNum = 0;
        MappingContext context = new MappingContext(scheme);
        Map<String, String> fixMap = this.getFixMap();
        boolean srcNg = context.isSrcNg();
        HashMap<Long, Long> src2tarIdMap = new HashMap<Long, Long>();
        ArrayListMultimap tar2srcIdMap = ArrayListMultimap.create();
        HashMap<Long, String> targetIds = new HashMap<Long, String>();
        HashMap<Long, String> srcIds = new HashMap<Long, String>();
        boolean hasCombine = false;
        DynamicObject[] dynamicObjectArray = dimmappings;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var17_20 < n) {
            DynamicObject dimmapping = dynamicObjectArray[var17_20];
            String mappedType = dimmapping.getString("mappedtype");
            DynamicObjectCollection srcDynamicObjectCollection = dimmapping.getDynamicObjectCollection("isdimmapsrcentry");
            DynamicObjectCollection targDynamicObjectCollection = dimmapping.getDynamicObjectCollection("isdimmaptargentry");
            if ("1".equals(mappedType)) {
                DynamicObject srcDynamicObject = ((DynamicObject)srcDynamicObjectCollection.get(0)).getDynamicObject("srcdimension");
                DynamicObject targDynamicObject = ((DynamicObject)targDynamicObjectCollection.get(0)).getDynamicObject("tagdimension");
                src2tarIdMap.put(srcDynamicObject.getLong("id"), targDynamicObject.getLong("id"));
                tar2srcIdMap.put((Object)targDynamicObject.getLong("id"), (Object)srcDynamicObject.getLong("id"));
                String dimnumber = srcNg ? srcDynamicObject.getString("number") : targDynamicObject.getString("number");
                fixMap.remove(dimnumber);
                if (isMultiCurrency && !this.isFromMidLib() && GlCurrency.equals(srcDynamicObject.getString("number")) && !GlCurrency.equals(targDynamicObject.getString("number"))) {
                    ++multiCurrencyNum;
                }
            } else if ("4".equals(mappedType)) {
                hasCombine = true;
                for (DynamicObject src : srcDynamicObjectCollection) {
                    DynamicObject srcDynamicObject = src.getDynamicObject("srcdimension");
                    srcIds.put(srcDynamicObject.getLong("id"), srcDynamicObject.getString("name"));
                }
                for (DynamicObject targ : targDynamicObjectCollection) {
                    DynamicObject targDynamicObject = targ.getDynamicObject("tagdimension");
                    targetIds.put(targDynamicObject.getLong("id"), targDynamicObject.getString("name"));
                }
            }
            ++var17_20;
        }
        boolean bl2 = fromNGModel = this.isFromNGBGModel() || this.isFromNGFRModel() || this.isFromNGCMModel() || this.isFromEASREP() || this.isFromXExtend();
        if (this.isFromMidLib()) {
            if (hasCombine) {
                fromNGModel = Boolean.FALSE;
            } else {
                hasCombine = Boolean.TRUE;
                fromNGModel = Boolean.TRUE;
            }
        }
        if (!fromNGModel && !hasCombine) {
            error.add(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u7ec4\u5408\u7ef4\u5ea6\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MappingService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            return error;
        }
        if (!this.isFromXExtend() && fixMap.size() > 0) {
            error.add(String.format(ResManager.loadKDString((String)"\u7f3a\u5c11\u91d1\u8776\u4e91\u00b7\u661f\u701a\u5355\u4e00\u7ef4\u5ea6\u6620\u5c04\uff1a%s\u3002", (String)"MappingService_2", (String)"fi-bcm-business", (Object[])new Object[0]), fixMap.values()));
            return error;
        }
        if (isMultiCurrency && multiCurrencyNum != 1 && !this.isFromMidLib()) {
            if (multiCurrencyNum == 0) {
                error.add(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u96c6\u6210\u539f\u5e01\u7684\u5355\u4e00\u7ef4\u5ea6\u6620\u5c04\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"MappingService_16", (String)"fi-bcm-business", (Object[])new Object[0]));
            } else {
                error.add(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u96c6\u6210\u539f\u5e01\u7684\u5355\u4e00\u7ef4\u5ea6\u6620\u5c04\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"MappingService_17", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            return error;
        }
        for (Long l : targetIds.keySet()) {
            if (tar2srcIdMap.get((Object)l) == null || tar2srcIdMap.get((Object)l).size() <= 0 || srcIds.keySet().stream().anyMatch(srcId -> tar2srcIdMap.get((Object)targId).contains(srcId))) continue;
            error.add(String.format(ResManager.loadKDString((String)"\u7ec4\u5408\u6620\u5c04\u6e90\u7ef4\u5ea6\u7f3a\u5c11\u76ee\u6807\u7ef4\u5ea6\uff1a%s\u6620\u5c04\u3002", (String)"MappingService_3", (String)"fi-bcm-business", (Object[])new Object[0]), targetIds.get(l)));
            return error;
        }
        for (Map.Entry entry : srcIds.entrySet()) {
            DynamicObject[] srcId2 = (DynamicObject[])entry.getKey();
            if (src2tarIdMap.get(srcId2) == null || targetIds.containsKey(src2tarIdMap.get(srcId2))) continue;
            error.add(String.format(ResManager.loadKDString((String)"\u7ec4\u5408\u6620\u5c04\u76ee\u6807\u7ef4\u5ea6\u7f3a\u5c11\u6e90\u7ef4\u5ea6\uff1a%s\u6620\u5c04\u3002", (String)"MappingService_5", (String)"fi-bcm-business", (Object[])new Object[0]), entry.getValue()));
            return error;
        }
        Map<String, DynamicObject> srcCheckDimNumbers = context.getSource().checkDimNumbers(scheme);
        Map<String, DynamicObject> map = context.getTarget().checkDimNumbers(scheme);
        if (MappingService.isDimNotEmpty(dimmappings)) {
            for (DynamicObject dimmapping : dimmappings) {
                if (!"1".equalsIgnoreCase(dimmapping.getString("mappedtype")) || fromNGModel) {
                    this.checkExist(srcCheckDimNumbers, dimmapping, "isdimmapsrcentry", "srcdimension");
                    this.checkExist(map, dimmapping, "isdimmaptargentry", "tagdimension");
                }
                if (!"1".equalsIgnoreCase(dimmapping.getString("mappedtype"))) continue;
                this.checkExistScenario(map, dimmapping, "isdimmaptargentry", "tagdimension");
            }
        }
        MappingProperty mappingProperty = MappingPropertyFactory.getInstance(context.getSource(), context.getTarget());
        Stream.of(mappingProperty.onemappings).forEach(v -> {
            if (srcNg) {
                srcCheckDimNumbers.remove(v[0]);
            } else {
                tagCheckDimNumbers.remove(v[0]);
            }
        });
        if (srcNg) {
            this.getFixMap().forEach((k, v) -> srcCheckDimNumbers.remove(k));
        } else {
            this.getFixMap().forEach((k, v) -> tagCheckDimNumbers.remove(k));
        }
        if (srcCheckDimNumbers.size() > 0) {
            error.add(String.format(ResManager.loadKDString((String)"\u6e90-\u7ec4\u5408\u6216\u7f3a\u7701\u7ef4\u5ea6\u4e2d\uff1a%s \u7ef4\u5ea6\u7f3a\u5931\u3002", (String)"MappingService_14", (String)"fi-bcm-business", (Object[])new Object[0]), srcCheckDimNumbers.values().stream().map(v -> v.getString("name")).collect(Collectors.toList())));
        }
        if (!this.isFromXExtend() && map.size() > 0) {
            error.add(String.format(ResManager.loadKDString((String)"\u76ee\u6807-\u7ec4\u5408\u6216\u7f3a\u7701\u7ef4\u5ea6\u4e2d\uff1a%s \u7ef4\u5ea6\u7f3a\u5931\u3002", (String)"MappingService_8", (String)"fi-bcm-business", (Object[])new Object[0]), map.values().stream().map(v -> v.getString("name")).collect(Collectors.toList())));
        }
        if (this.isFromXExtend()) {
            this.checkXExtDim(dimmappings, error, scheme.getLong("model.id"), fixMap, scheme.getLong("id"));
        }
        if (this.isFromMidLib()) {
            this.checkComInSingle(dimmappings, error);
        }
        return error;
    }

    private void checkComInSingle(DynamicObject[] dimmappings, List<String> error) {
        HashSet<Long> singleDimNumerSet = new HashSet<Long>(16);
        HashSet<Long> comDimNumerSet = new HashSet<Long>(16);
        for (DynamicObject dimmapping : dimmappings) {
            String mappedType = dimmapping.getString("mappedtype");
            DynamicObjectCollection srcDynamicObjectCollection = dimmapping.getDynamicObjectCollection("isdimmapsrcentry");
            if ("1".equals(mappedType)) {
                DynamicObject srcDynamicObject = ((DynamicObject)srcDynamicObjectCollection.get(0)).getDynamicObject("srcdimension");
                singleDimNumerSet.add(srcDynamicObject.getLong("id"));
                continue;
            }
            if (!"4".equals(mappedType)) continue;
            for (DynamicObject src : srcDynamicObjectCollection) {
                DynamicObject srcDynamicObject = src.getDynamicObject("srcdimension");
                comDimNumerSet.add(srcDynamicObject.getLong("id"));
            }
        }
        if (!singleDimNumerSet.containsAll(comDimNumerSet)) {
            error.add(ResManager.loadKDString((String)"\u7ec4\u5408\u6620\u5c04\u91cc\u7684\u6e90\u7ef4\u5ea6\u9700\u8981\u914d\u7f6e\u5355\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"MappingService_25", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private Boolean checkXExtendFixMap(Map<String, String> fixMap, List<String> error) {
        fixMap.remove("Account");
        if (fixMap.size() > 0) {
            error.add(String.format(ResManager.loadKDString((String)"\u7f3a\u5c11\u91d1\u8776\u4e91\u00b7\u661f\u701a\u5355\u4e00\u7ef4\u5ea6\u6620\u5c04\uff1a%s\u3002", (String)"MappingService_2", (String)"fi-bcm-business", (Object[])new Object[0]), fixMap.values()));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void checkXExtDim(DynamicObject[] dimmappings, List<String> error, final Long modelId, Map<String, String> fixMap, Long schemeId) {
        if (this.checkXExtendFixMap(fixMap, error).booleanValue()) {
            return;
        }
        HashMap<String, Long> MustDimMap = new HashMap<String, Long>(){
            {
                this.put("Process", MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"EIRpt").getId());
            }
        };
        HashMap<String, String> mustTagDimMap = new HashMap<String, String>(2);
        mustTagDimMap.put(DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.SCENARIO.getName());
        mustTagDimMap.put(DimTypesEnum.AUDITTRIAL.getNumber(), DimTypesEnum.AUDITTRIAL.getName());
        if (MappingService.isDimNotEmpty(dimmappings)) {
            for (DynamicObject dimmapping : dimmappings) {
                if (!"2".equalsIgnoreCase(dimmapping.getString("mappedtype"))) continue;
                DynamicObjectCollection targs = (DynamicObjectCollection)dimmapping.get("isdimmaptargentry");
                for (DynamicObject targ : targs) {
                    if (targ != null && MustDimMap.containsKey(targ.getString("tagdimension.number")) && ((Long)MustDimMap.get(targ.getString("tagdimension.number"))).equals(((DynamicObject)((DynamicObjectCollection)targ.get("isdimmaptargdefval")).get(0)).getLong("tagmemb"))) {
                        MustDimMap.remove(targ.getString("tagdimension.number"));
                    }
                    if (targ == null || !mustTagDimMap.containsKey(targ.getString("tagdimension.number"))) continue;
                    mustTagDimMap.remove(targ.getString("tagdimension.number"));
                }
            }
        }
        if (MustDimMap.size() > 0) {
            HashMap<String, String> errorInfo = new HashMap<String, String>(3);
            MustDimMap.forEach((k, v) -> {
                if ("Process".equals(k)) {
                    errorInfo.put(MemberReader.getDimensionDynById((long)MemberReader.getDimensionIdByNum((long)modelId, (String)"Process")).getString("name"), MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"EIRpt").getName());
                }
            });
            if (errorInfo.size() > 0) {
                error.add(this.getErrorInfo(errorInfo));
            }
        }
        if (mustTagDimMap.size() > 0) {
            error.add(this.getTagErrorInfo(mustTagDimMap));
        }
        this.checkOneByOneMapping(error, dimmappings, modelId, schemeId);
    }

    private String getTagErrorInfo(Map<String, String> errorInfo) {
        StringBuilder names = new StringBuilder();
        errorInfo.forEach((k, v) -> names.append((String)v).append("\u3001"));
        return String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u96c6\u6210\u5fc5\u987b\u5305\u542b%1s\u7684\u76ee\u6807\u7f3a\u7701\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"MappingService_24", (String)"fi-bcm-business", (Object[])new Object[0]), names.substring(0, names.length() - 1));
    }

    private void checkOneByOneMapping(List<String> error, DynamicObject[] dimmappings, Long modelId, Long schemeId) {
        Long extendsModelId = this.getExtendsModelId(schemeId);
        Set<Long> uniqueFieldList = this.getExtendsUniqueField(extendsModelId);
        if (MappingService.isDimNotEmpty(dimmappings)) {
            for (DynamicObject dimmapping : dimmappings) {
                if (!"1".equalsIgnoreCase(dimmapping.getString("mappedtype")) || uniqueFieldList.size() <= 0) continue;
                DynamicObjectCollection targs = (DynamicObjectCollection)dimmapping.get("isdimmaptargentry");
                for (DynamicObject targ : targs) {
                    if (targ == null || !uniqueFieldList.contains(targ.getLong("tagdimension.id"))) continue;
                    uniqueFieldList.remove(targ.getLong("tagdimension.id"));
                }
            }
        }
        if (uniqueFieldList.size() > 0) {
            Set<String> names = this.getExtDimNames(uniqueFieldList, modelId);
            error.add(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u552f\u4e00\u6027\u5b57\u6bb5\uff1a%s\u9700\u8bbe\u7f6e\u5355\u4e00\u6620\u5c04\u3002", (String)"MappingService_23", (String)"fi-bcm-business", (Object[])new Object[0]), StringUtils.join((Object[])names.toArray(), (String)",")));
        }
    }

    private Set<String> getExtDimNames(Set<Long> uniqueFieldList, Long modelId) {
        HashSet<String> names = new HashSet<String>(uniqueFieldList.size());
        QFBuilder qfBuilderDim = new QFBuilder("id", "in", uniqueFieldList).add("model", "=", (Object)modelId);
        names.addAll(QueryServiceHelper.query((String)"bcm_dimension", (String)"name", (QFilter[])qfBuilderDim.toArray()).stream().map(d -> d.getString("name")).collect(Collectors.toSet()));
        names.addAll(QueryServiceHelper.query((String)"bcm_structofextend", (String)"name", (QFilter[])qfBuilderDim.toArray()).stream().map(d -> d.getString("name")).collect(Collectors.toSet()));
        return names;
    }

    private Set<Long> getExtendsUniqueField(Long extendsModelId) {
        HashSet<Long> uniqueExtDim = new HashSet<Long>(8);
        QFBuilder qfBuilder = new QFBuilder("extmodelid", "=", (Object)extendsModelId).add("uniquecheck", "=", (Object)"1");
        DynamicObjectCollection dynDims = QueryServiceHelper.query((String)"bcm_extmodeldim", (String)"dimension", (QFilter[])qfBuilder.toArray());
        uniqueExtDim.addAll(dynDims.stream().map(dyn -> dyn.getLong("dimension")).collect(Collectors.toSet()));
        DynamicObjectCollection dynExts = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"extfield", (QFilter[])qfBuilder.toArray());
        uniqueExtDim.addAll(dynExts.stream().map(dyn -> dyn.getLong("extfield")).collect(Collectors.toSet()));
        return uniqueExtDim;
    }

    private Long getExtendsModelId(Long schemeId) {
        QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)schemeId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"extendsmodel", (QFilter[])qfBuilder.toArray());
        return dyn.getLong("extendsmodel");
    }

    private String getErrorInfo(Map<String, String> errorInfo) {
        StringBuilder dims = new StringBuilder();
        StringBuilder members = new StringBuilder();
        errorInfo.forEach((k, v) -> {
            dims.append((String)k).append("\u3001");
            members.append((String)v).append("\u3001");
        });
        if (errorInfo.size() == 1) {
            return String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u96c6\u6210\u5fc5\u987b\u5305\u542b%1s\u7ef4\u5ea6\u6620\u5c04\uff0c\u76ee\u6807\u7f3a\u7701\u503c\u4e3a\uff1a%2s\u3002", (String)"MappingService_21", (String)"fi-bcm-business", (Object[])new Object[0]), dims.substring(0, dims.length() - 1), members.substring(0, members.length() - 1));
        }
        return String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u96c6\u6210\u5fc5\u987b\u5305\u542b%1s\u7ef4\u5ea6\u6620\u5c04\uff0c\u76ee\u6807\u7f3a\u7701\u503c\u5206\u522b\u4e3a\uff1a%2s\u3002", (String)"MappingService_22", (String)"fi-bcm-business", (Object[])new Object[0]), dims.substring(0, dims.length() - 1), members.substring(0, members.length() - 1));
    }

    private List<String> checkJqMapping(DynamicObject[] dimmappings, List<String> error) {
        if (dimmappings.length == 0 || dimmappings.length > 1 || 1 != dimmappings[0].getInt("mappedtype")) {
            error.add(ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u201c\u7ec4\u7ec7-\u7ec4\u7ec7\u201d\u7684\u5355\u4e00\u6620\u5c04\u3002", (String)"MappingService_15", (String)"fi-bcm-business", (Object[])new Object[0]));
            return error;
        }
        DynamicObjectCollection srcDynamicObjectCollection = dimmappings[0].getDynamicObjectCollection("isdimmapsrcentry");
        DynamicObjectCollection targDynamicObjectCollection = dimmappings[0].getDynamicObjectCollection("isdimmaptargentry");
        DynamicObject srcDynamicObject = ((DynamicObject)srcDynamicObjectCollection.get(0)).getDynamicObject("srcdimension");
        DynamicObject targDynamicObject = ((DynamicObject)targDynamicObjectCollection.get(0)).getDynamicObject("tagdimension");
        String srcDimnumber = srcDynamicObject.getString("number");
        String tarDimnumber = targDynamicObject.getString("number");
        if (!"Entity".equals(srcDimnumber) || !"Entity".equals(tarDimnumber)) {
            error.add(ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u201c\u7ec4\u7ec7-\u7ec4\u7ec7\u201d\u7684\u5355\u4e00\u6620\u5c04\u3002", (String)"MappingService_15", (String)"fi-bcm-business", (Object[])new Object[0]));
            return error;
        }
        return error;
    }

    private Map<String, String> getFixMap() {
        HashMap<String, String> fixMap = new HashMap<String, String>();
        fixMap.put("Entity", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"MappingService_9", (String)"fi-bcm-business", (Object[])new Object[0]));
        fixMap.put("Account", ResManager.loadKDString((String)"\u79d1\u76ee", (String)"MappingService_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        fixMap.put("Year", ResManager.loadKDString((String)"\u8d22\u5e74", (String)"MappingService_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        fixMap.put("Period", ResManager.loadKDString((String)"\u671f\u95f4", (String)"MappingService_12", (String)"fi-bcm-business", (Object[])new Object[0]));
        fixMap.put(GlCurrency, ResManager.loadKDString((String)"\u5e01\u79cd", (String)"MappingService_13", (String)"fi-bcm-business", (Object[])new Object[0]));
        return fixMap;
    }

    public static DynamicObject[] queryDimmapping(QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id, pubmappingid, tagdimension, tagdimtype, tagbyfrom, srcdimension, srcdimtype, srcbyfrom, mappedtype, srcmemname, tagmemname, mappedtype, tagmemb,datatype", (QFilter[])filters, (String)"sequence asc");
    }

    public static DynamicObject[] queryDimMappingExtendsTable(QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id, pubmappingid, tagdimension, tagdimtype, tagbyfrom, srcdimension, srcdimtype, srcbyfrom, mappedtype, srcmemname, tagmemname, mappedtype,inheritancescheme,datafiltercondition,filtervalue,reservedfield,tagmemb,datatype", (QFilter[])filters, (String)"sequence asc");
    }

    public DynamicObject[] querySimpleDimmapping() {
        this.checkContext();
        QFilter filters = new QFilter("scheme", "=", this.context.getScheme().getPkValue());
        filters.and("isdimmaptargentry.tagdimtype", "!=", (Object)"bcm_structofextend");
        return BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id, name, number, mappedtype,isdimmaptargentry,isdimmapsrcentry", (QFilter[])filters.toArray(), (String)"sequence asc");
    }

    private Map<String, String> queryBaseEntMap() {
        this.checkContext();
        QFilter filters = new QFilter("scheme", "=", this.context.getScheme().getPkValue());
        DynamicObject[] baseEnts = BusinessDataServiceHelper.load((String)"bcm_isbaseentlist", (String)"number,name", (QFilter[])filters.toArray());
        HashMap<String, String> result = new HashMap<String, String>(baseEnts.length);
        for (DynamicObject dot : baseEnts) {
            result.put(dot.getString("number"), dot.getString("name"));
        }
        return result;
    }

    public String getDimMappingName(String number) {
        int index;
        if (this.baseEntMap == null) {
            this.baseEntMap = this.queryBaseEntMap();
            QFilter filter = new QFilter("model", "=", (Object)this.context.getScheme().getLong("model.id"));
            DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,name", (QFilter[])filter.toArray());
            this.dimMap = new HashMap<String, String>(dims.size());
            dims.forEach(e -> this.dimMap.put(e.getString("number"), e.getString("name")));
        }
        if ((index = number.indexOf("-")) > 0) {
            String target = number.substring(0, index);
            for (Map.Entry<String, String> entry : this.dimMap.entrySet()) {
                target = target.replace(entry.getKey(), entry.getValue());
            }
            String src = number.substring(index + 1);
            for (Map.Entry<String, String> entry : this.baseEntMap.entrySet()) {
                src = src.replace(entry.getKey(), entry.getValue());
            }
            return target + "<-" + src;
        }
        return number;
    }

    public static boolean isDimNotEmpty(DynamicObject[] dimmappings) {
        return dimmappings != null && dimmappings.length > 0;
    }
}

