/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.encrypt.impl.KAESEncrypter;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.fi.bcm.business.integration.mapping.IProduct;
import kd.fi.bcm.business.integration.util.DimMappingHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

class NGBGModelProduct
implements IProduct {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(NGBGModelProduct.class);

    NGBGModelProduct() {
    }

    @Override
    public String getDimEntity() {
        return "bcm_isbaseentlist";
    }

    @Override
    public boolean isMulti(String entityName) {
        return false;
    }

    @Override
    public String getDimEntityName(Long id) {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bcm_isbaseentlist", (String)"id, entitynumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (queryOne != null) {
            return queryOne.getString("entitynumber");
        }
        return null;
    }

    @Override
    public QFilter getDimQFilter(IDataModel dataModel, IFormView formView) {
        DynamicObject scheme = (DynamicObject)dataModel.getValue("scheme");
        return new QFilter("scheme", "=", (Object)scheme.getLong("id"));
    }

    @Override
    public QFilter getDimDetailQFilter(IDataModel dataModel, IFormView formView) {
        DynamicObject dim;
        String number;
        DynamicObject scheme = (DynamicObject)dataModel.getValue("scheme");
        long srcModelId = scheme.getLong("issrcmodel.id");
        DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_isngmodel", (String)"id,modelsource,tdpdatacenterid", (QFilter[])new QFilter("id", "=", (Object)srcModelId).toArray());
        Long modelSourceId = model.getLong("modelsource");
        QFilter id = new QFilter("id", "=", (Object)modelSourceId);
        QFilter[] fId = new QFilter[]{id};
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"model", (QFilter[])fId);
        Long modelId = dyn.getLong("model");
        DynamicObject dimension = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id", (QFilter[])new QFilter("model", "=", (Object)modelId).and(new QFilter("number", "=", (Object)(number = (dim = (DynamicObject)formView.getFormShowParameter().getCustomParam("dimDyn")).getString("number")))).toArray());
        if (dimension != null) {
            return QFilter.of((String)"model = ? and dimension = ? ", (Object[])new Object[]{modelId, dimension.getLong("id")});
        }
        return QFilter.of((String)"model = ? and dimension = ? ", (Object[])new Object[]{modelId, 0L});
    }

    @Override
    public void preOutEntityData(DynamicObject scheme) {
        Long ngModelId;
        DynamicObject model;
        boolean isTrue = true;
        boolean exists = QueryServiceHelper.exists((String)"bcm_isbaseentlist", (QFilter[])new QFilter[]{new QFilter("scheme", "=", scheme.get("id"))});
        if (!exists && (model = QueryServiceHelper.queryOne((String)"bcm_isngmodel", (String)"id,modelsource,usertype,datasource,number,apptype,phonenumber,userurl,password,modelsourcenum,tdpdatacenterid", (QFilter[])new QFilter("id", "=", (Object)(ngModelId = Long.valueOf(scheme.getLong("issrcmodel.id")))).toArray())) != null) {
            if ("1".equalsIgnoreCase(model.getString("usertype")) && RequestContext.get().getAccountId().equalsIgnoreCase(model.getString("datasource"))) {
                this.sameUserTypeAndDataSource(scheme, model, isTrue);
            } else {
                this.differentUserTypeAndDataSource(scheme, model, isTrue);
            }
        }
    }

    private void differentUserTypeAndDataSource(DynamicObject scheme, DynamicObject model, boolean isTrue) {
        String phoneNumber = model.getString("phonenumber");
        KAESEncrypter ken = new KAESEncrypter();
        String password = ken.decode(model.getString("password"));
        Long tdpdatacenterId = null;
        Object tdpdatacenterObj = model.get("tdpdatacenterid");
        if (tdpdatacenterObj instanceof DynamicObject) {
            tdpdatacenterId = ((DynamicObject)tdpdatacenterObj).getLong("id");
        } else if (tdpdatacenterObj instanceof Long) {
            tdpdatacenterId = (Long)tdpdatacenterObj;
        }
        DynamicObject tdpdatacenter = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"appid, password, address, datasource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tdpdatacenterId)});
        String userUrl = tdpdatacenter.getString("address");
        String loginToken = DimMappingHelper.getLoginTokenWithPass(phoneNumber, password, tdpdatacenter);
        HashMap<String, String> requestHeader = new HashMap<String, String>(4);
        requestHeader.put("accessToken", loginToken);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("modelNumber", model.getString("modelsourcenum"));
        params.put("dataSetNumber", model.getString("number"));
        try {
            String fullUrl = userUrl + "/kapi/app/bgm/modelMemberQuery";
            String paramStr = JSONObject.toJSONString(params);
            String response = HttpClientUtils.postjson((String)fullUrl, requestHeader, (String)paramStr, (int)1000, (int)1800000);
            ApiResult res = (ApiResult)JSONObject.parseObject((String)response, ApiResult.class);
            if (!res.getSuccess()) {
                String error = String.format("get baseEntList error url:%s,errorMessage:%s", fullUrl, res.getMessage());
                log.error(error);
                throw new KDBizException(error);
            }
            List data = (List)res.getData();
            if (data != null && data.size() > 0) {
                DynamicObject[] waitSave = new DynamicObject[data.size()];
                int i = 0;
                for (Map datum : data) {
                    DynamicObject basedataList = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbaseentlist");
                    basedataList.set("number", datum.get("number"));
                    basedataList.set("name", datum.get("name"));
                    basedataList.set("entitynumber", datum.get("membermodel"));
                    basedataList.set("scheme", (Object)scheme);
                    basedataList.set("issys", (Object)isTrue);
                    basedataList.set("creator", (Object)RequestContext.get().getUserId());
                    basedataList.set("createtime", (Object)new Date());
                    waitSave[i] = basedataList;
                    ++i;
                }
                SaveServiceHelper.save((DynamicObject[])waitSave);
            }
        }
        catch (Exception e) {
            throw new KDException(e.getMessage());
        }
    }

    private void sameUserTypeAndDataSource(DynamicObject scheme, DynamicObject model, boolean isTrue) {
        Long modelSourceId = model.getLong("modelsource");
        QFilter modelId = new QFilter("id", "=", (Object)modelSourceId);
        QFilter[] filterModel = new QFilter[]{modelId};
        DynamicObjectCollection dimDyns = QueryServiceHelper.query((String)"eb_dataset", (String)"model,entryentity.datasetdim.id", (QFilter[])filterModel);
        HashSet<Long> dims = new HashSet<Long>(16);
        for (DynamicObject obj : dimDyns) {
            Long membermodel = obj.getLong("entryentity.datasetdim.id");
            dims.add(membermodel);
        }
        long srcModelId = ((DynamicObject)dimDyns.get(0)).getLong("model");
        DynamicObjectCollection dynamicDims = QueryServiceHelper.query((String)"epm_dimension", (String)"membermodel,number,name", (QFilter[])new QFilter("id", "in", dims).and(new QFilter("model", "=", (Object)srcModelId)).or(new QFilter("number", "=", (Object)"Account").and(new QFilter("model", "=", (Object)srcModelId))).toArray());
        DynamicObject[] waitSave = new DynamicObject[dynamicDims.size()];
        for (int i = 0; i < dynamicDims.size(); ++i) {
            DynamicObject basedataList = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbaseentlist");
            basedataList.set("number", (Object)((DynamicObject)dynamicDims.get(i)).getString("number"));
            basedataList.set("name", (Object)((DynamicObject)dynamicDims.get(i)).getString("name"));
            basedataList.set("entitynumber", (Object)((DynamicObject)dynamicDims.get(i)).getString("membermodel"));
            basedataList.set("scheme", (Object)scheme);
            basedataList.set("issys", (Object)isTrue);
            basedataList.set("creator", (Object)RequestContext.get().getUserId());
            basedataList.set("createtime", (Object)new Date());
            waitSave[i] = basedataList;
        }
        SaveServiceHelper.save((DynamicObject[])waitSave);
    }

    @Override
    public Map<String, DynamicObject> checkDimNumbers(DynamicObject scheme) {
        long schemeId;
        Map dimensions;
        if (scheme != null && (dimensions = BusinessDataServiceHelper.loadFromCache((String)"bcm_isbaseentlist", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)(schemeId = scheme.getLong("id")))})) != null && dimensions.size() > 0) {
            return dimensions.values().stream().collect(Collectors.toMap(v -> v.getString("number"), v -> v));
        }
        return new HashMap<String, DynamicObject>();
    }

    @Override
    public Map<String, DynamicObject> checkEnableMissDim(DynamicObject scheme) {
        return new HashMap<String, DynamicObject>();
    }

    @Override
    public String[][] getMissDim(Map<String, DynamicObject> targMissCheckDim) {
        return new String[0][];
    }

    @Override
    public String byFrom() {
        return null;
    }

    @Override
    public String[][] getCombineSeq() {
        return new String[0][];
    }
}

