/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.encrypt.impl.KAESEncrypter;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.fi.bcm.business.integration.mapping.IProduct;
import kd.fi.bcm.business.integration.util.DimMappingHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

class NGFRModelProduct
implements IProduct {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(NGFRModelProduct.class);

    NGFRModelProduct() {
    }

    @Override
    public String getDimEntity() {
        return "bcm_isbaseentlist";
    }

    @Override
    public boolean isMulti(String entityName) {
        return false;
    }

    @Override
    public String getDimEntityName(Long id) {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bcm_isbaseentlist", (String)"id, entitynumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (queryOne != null) {
            return queryOne.getString("entitynumber");
        }
        return null;
    }

    @Override
    public QFilter getDimQFilter(IDataModel dataModel, IFormView formView) {
        DynamicObject scheme = (DynamicObject)dataModel.getValue("scheme");
        return new QFilter("scheme", "=", (Object)scheme.getLong("id"));
    }

    @Override
    public QFilter getDimDetailQFilter(IDataModel dataModel, IFormView formView) {
        DynamicObject scheme = (DynamicObject)dataModel.getValue("scheme");
        long srcModelId = scheme.getLong("issrcmodel.id");
        DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_isngmodel", (String)"id,modelsource,tdpdatacenterid", (QFilter[])new QFilter("id", "=", (Object)srcModelId).toArray());
        Long modelSourceId = model.getLong("modelsource");
        DynamicObject dim = (DynamicObject)formView.getFormShowParameter().getCustomParam("dimDyn");
        String entityName = (String)formView.getFormShowParameter().getCustomParam("entityName");
        if (entityName != null && "bcm_userdefinedmembertree".equalsIgnoreCase(entityName)) {
            long dimensionId = 0L;
            try {
                dimensionId = MemberReader.getDimensionIdByNum((long)modelSourceId, (String)dim.getString("number"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return QFilter.of((String)"model = ?  and dimension = ?  and storagetype <> ?", (Object[])new Object[]{modelSourceId, dimensionId, StorageTypeEnum.SHARE.index});
        }
        return QFilter.of((String)"model = ?  and storagetype <> ?", (Object[])new Object[]{modelSourceId, StorageTypeEnum.SHARE.index});
    }

    @Override
    public void preOutEntityData(DynamicObject scheme) {
        Long ngModelId;
        DynamicObject model;
        boolean isTrue = true;
        boolean exists = QueryServiceHelper.exists((String)"bcm_isbaseentlist", (QFilter[])new QFilter[]{new QFilter("scheme", "=", scheme.get("id"))});
        if (!exists && (model = QueryServiceHelper.queryOne((String)"bcm_isngmodel", (String)"id,modelsource,usertype,datasource,number,apptype,phonenumber,userurl,password,tdpdatacenterid", (QFilter[])new QFilter("id", "=", (Object)(ngModelId = Long.valueOf(scheme.getLong("issrcmodel.id")))).toArray())) != null) {
            if ("1".equalsIgnoreCase(model.getString("usertype")) && RequestContext.get().getAccountId().equalsIgnoreCase(model.getString("datasource"))) {
                this.sameUserTypeAndDataSource(scheme, model, isTrue);
            } else {
                this.differentUserTypeAndDataSource(scheme, model, isTrue);
            }
        }
    }

    private void differentUserTypeAndDataSource(DynamicObject scheme, DynamicObject model, boolean isTrue) {
        String phoneNumber = model.getString("phonenumber");
        KAESEncrypter ken = new KAESEncrypter();
        String password = ken.decode(model.getString("password"));
        Long tdpdatacenterId = null;
        Object tdpdatacenterObj = model.get("tdpdatacenterid");
        if (tdpdatacenterObj instanceof DynamicObject) {
            tdpdatacenterId = ((DynamicObject)tdpdatacenterObj).getLong("id");
        } else if (tdpdatacenterObj instanceof Long) {
            tdpdatacenterId = (Long)tdpdatacenterObj;
        }
        DynamicObject tdpdatacenter = QueryServiceHelper.queryOne((String)"bcm_tdp_datacenter", (String)"appid, password, address, datasource", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tdpdatacenterId)});
        String userUrl = tdpdatacenter.getString("address");
        String loginToken = DimMappingHelper.getLoginTokenWithPass(phoneNumber, password, tdpdatacenter);
        HashMap<String, String> requestHeader = new HashMap<String, String>(4);
        requestHeader.put("accessToken", loginToken);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("number", model.getString("number"));
        params.put("reportType", ApplicationTypeEnum.RPT.index);
        try {
            String fullUrl = userUrl + "/kapi/app/cm/dimensionInfo";
            String paramStr = JSONObject.toJSONString(params);
            String response = HttpClientUtils.postjson((String)fullUrl, requestHeader, (String)paramStr, (int)1000, (int)1800000);
            ApiResult res = (ApiResult)JSONObject.parseObject((String)response, ApiResult.class);
            if (!res.getSuccess()) {
                String error = String.format("get baseEntList error url:%s,errorMessage:%s", fullUrl, res.getMessage());
                log.error(error);
                throw new KDBizException(error);
            }
            List data = (List)res.getData();
            if (data != null && data.size() > 0) {
                DynamicObject[] waitSave = new DynamicObject[data.size()];
                int i = 0;
                for (Map datum : data) {
                    DynamicObject basedataList = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbaseentlist");
                    basedataList.set("number", datum.get("number"));
                    basedataList.set("name", datum.get("name"));
                    basedataList.set("entitynumber", datum.get("membermodel"));
                    basedataList.set("scheme", (Object)scheme);
                    basedataList.set("issys", (Object)isTrue);
                    basedataList.set("creator", (Object)RequestContext.get().getUserId());
                    basedataList.set("createtime", (Object)new Date());
                    waitSave[i] = basedataList;
                    ++i;
                }
                SaveServiceHelper.save((DynamicObject[])waitSave);
            }
        }
        catch (Exception e) {
            throw new KDException(e.getMessage());
        }
    }

    private void sameUserTypeAndDataSource(DynamicObject scheme, DynamicObject model, boolean isTrue) {
        Long modelSourceId = model.getLong("modelsource");
        QFilter modelId = new QFilter("model", "=", (Object)modelSourceId);
        DynamicObjectCollection dimDyns = QueryServiceHelper.query((String)"bcm_dimension", (String)"membermodel,number,name", (QFilter[])modelId.toArray());
        DynamicObject[] waitSave = new DynamicObject[dimDyns.size()];
        for (int i = 0; i < dimDyns.size(); ++i) {
            DynamicObject basedataList = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbaseentlist");
            basedataList.set("number", (Object)((DynamicObject)dimDyns.get(i)).getString("number"));
            basedataList.set("name", (Object)((DynamicObject)dimDyns.get(i)).getString("name"));
            basedataList.set("entitynumber", (Object)((DynamicObject)dimDyns.get(i)).getString("membermodel"));
            basedataList.set("scheme", (Object)scheme);
            basedataList.set("issys", (Object)isTrue);
            basedataList.set("creator", (Object)RequestContext.get().getUserId());
            basedataList.set("createtime", (Object)new Date());
            waitSave[i] = basedataList;
        }
        SaveServiceHelper.save((DynamicObject[])waitSave);
    }

    @Override
    public Map<String, DynamicObject> checkDimNumbers(DynamicObject scheme) {
        long schemeId;
        Map dimensions;
        if (scheme != null && (dimensions = BusinessDataServiceHelper.loadFromCache((String)"bcm_isbaseentlist", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)(schemeId = scheme.getLong("id")))})) != null && dimensions.size() > 0) {
            return dimensions.values().stream().collect(Collectors.toMap(v -> v.getString("number"), v -> v));
        }
        return new HashMap<String, DynamicObject>();
    }

    @Override
    public Map<String, DynamicObject> checkEnableMissDim(DynamicObject scheme) {
        return new HashMap<String, DynamicObject>();
    }

    @Override
    public String[][] getMissDim(Map<String, DynamicObject> targMissCheckDim) {
        return new String[0][];
    }

    @Override
    public String byFrom() {
        return null;
    }

    @Override
    public String[][] getCombineSeq() {
        return new String[0][];
    }
}

