/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.mapping.IProduct;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;

class NGProduct
implements IProduct {
    NGProduct() {
    }

    @Override
    public String getDimEntity() {
        return "bcm_dimension";
    }

    @Override
    public QFilter getDimQFilter(IDataModel dataModel, IFormView formView) {
        DynamicObject scheme = (DynamicObject)dataModel.getValue("scheme");
        DynamicObject model = scheme.getDynamicObject("model");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"extendsmodel,model,id,issrc.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)scheme.getLong("id"))});
        if (IntegrateProductEnum.XExtendProduct.getNumber().equals(dyn.getString("issrc.number"))) {
            QFilter ids = new QFilter("id", "in", this.getModelDimIds(dyn.getLong("extendsmodel"), dyn.getLong("model")));
            return new QFilter("model", "=", (Object)model.getLong("id")).and(ids);
        }
        return new QFilter("model", "=", (Object)model.getLong("id"));
    }

    private Set<Long> getModelDimIds(Long id, Long modelId) {
        DynamicObjectCollection extModelDim = QueryServiceHelper.query((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)id)}, (String)"sequence");
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject object : extModelDim) {
            ids.add(object.getLong("dimension"));
        }
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        List<String> fixedDimension = Arrays.asList("Entity", "Year", "Period", "Scenario", "Process", "Currency", "AuditTrail");
        QFilter fixedQF = new QFilter("number", "in", fixedDimension);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{modelQf, fixedQF});
        for (DynamicObject dim : dims) {
            ids.add(dim.getLong("id"));
        }
        return ids;
    }

    @Override
    public QFilter getDimDetailQFilter(IDataModel dataModel, IFormView formView) {
        DynamicObject scheme = (DynamicObject)dataModel.getValue("scheme");
        DynamicObject model = scheme.getDynamicObject("model");
        DynamicObject dim = (DynamicObject)formView.getFormShowParameter().getCustomParam("dimDyn");
        if (DimEntityNumEnum.AUDITTRIAL.getNumber().equalsIgnoreCase(dim.getString("number"))) {
            return QFilter.of((String)"model = ? and dimension = ? and storagetype <> ? and (datasource = '1' or number = 'ATTotal')", (Object[])new Object[]{model.getLong("id"), dim.getLong("id"), StorageTypeEnum.SHARE.index});
        }
        if (DimEntityNumEnum.PROCESS.getNumber().equalsIgnoreCase(dim.getString("number"))) {
            return QFilter.of((String)"model = ? and dimension = ? and storagetype <> ? and number in ('IRpt','ERpt','EIRpt','CSTE','Process')", (Object[])new Object[]{model.getLong("id"), dim.getLong("id"), StorageTypeEnum.SHARE.index});
        }
        return QFilter.of((String)"model = ? and dimension = ? and storagetype <> ?", (Object[])new Object[]{model.getLong("id"), dim.getLong("id"), StorageTypeEnum.SHARE.index});
    }

    @Override
    public void preOutEntityData(DynamicObject scheme) {
    }

    @Override
    public String getDimEntityName(Long id) {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id, membermodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (queryOne != null) {
            return queryOne.getString("membermodel");
        }
        return null;
    }

    @Override
    public boolean isMulti(String entityName) {
        return "bcm_scenemembertree".contains(entityName);
    }

    @Override
    public Map<String, DynamicObject> checkDimNumbers(DynamicObject scheme) {
        DynamicObject model;
        Map dimensions;
        if (scheme != null && (dimensions = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (QFilter[])new QFilter[]{new QFilter("model", "=", (model = scheme.getDynamicObject("model")).get("id"))})) != null && dimensions.size() > 0) {
            return dimensions.values().stream().collect(Collectors.toMap(v -> v.getString("number"), v -> v));
        }
        return new HashMap<String, DynamicObject>();
    }

    @Override
    public Map<String, DynamicObject> checkEnableMissDim(DynamicObject scheme) {
        Map<String, DynamicObject> compliteDims = this.checkDimNumbers(scheme);
        HashMap<String, DynamicObject> filterDims = new HashMap<String, DynamicObject>();
        for (Map.Entry<String, DynamicObject> dim : compliteDims.entrySet()) {
            if (!"bcm_userdefinedmembertree".equalsIgnoreCase(dim.getValue().getString("membermodel"))) continue;
            filterDims.put(dim.getKey(), dim.getValue());
        }
        return filterDims;
    }

    @Override
    public String[][] getMissDim(Map<String, DynamicObject> targMissCheckDim) {
        String[][] defaultMapping = new String[targMissCheckDim.size()][2];
        int index = 0;
        for (Map.Entry<String, DynamicObject> entry : targMissCheckDim.entrySet()) {
            String defNumber;
            defaultMapping[index][0] = entry.getKey();
            defaultMapping[index][1] = defNumber = entry.getValue().getString("shortnumber") + "None";
        }
        return defaultMapping;
    }

    @Override
    public String byFrom() {
        return "1";
    }

    @Override
    public String[][] getCombineSeq() {
        return new String[][]{{DimTypesEnum.ACCOUNT.getNumber(), ResManager.loadKDString((String)"\u79d1\u76ee", (String)"IProduct_0", (String)"fi-bcm-business", (Object[])new Object[0])}};
    }
}

