/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.mapping.DefaultMappingVO;
import kd.fi.bcm.business.integration.mapping.DimMappingTypeStrategy;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;

class OneMapping
implements DimMappingTypeStrategy {
    OneMapping() {
    }

    @Override
    public void dimTypeChanged(IFormView formView, IDataModel model) {
        boolean isTrue = true;
        boolean isFalse = false;
        formView.setVisible(Boolean.valueOf(isTrue), new String[]{"tagadvconap", "srcadvconap"});
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject scheme = dataEntity.getDynamicObject("scheme");
        if (scheme != null && IntegrateProductEnum.XExtendProduct.getNumber().equals(((DynamicObject)scheme.get("issrc")).getString("number"))) {
            formView.setVisible(Boolean.valueOf(isTrue), new String[]{"field"});
            formView.setVisible(Boolean.valueOf(isFalse), new String[]{"tagdimdefvalue", "srcdimdefvalue", "srcmemnum", "tagdimension"});
        } else {
            formView.setVisible(Boolean.valueOf(isFalse), new String[]{"tagdimdefvalue", "srcdimdefvalue", "srcmemnum", "field"});
        }
    }

    @Override
    public void fillData(IDataModel model, DynamicObject src) {
        DynamicObjectCollection tagdynCollection = src.getDynamicObjectCollection("isdimmaptargentry");
        DynamicObject scheme = (DynamicObject)model.getValue("scheme");
        if (tagdynCollection != null && scheme != null && IntegrateProductEnum.XExtendProduct.getNumber().equals(scheme.getString("issrc.number"))) {
            model.setValue("field", ((DynamicObject)((DynamicObject)tagdynCollection.get(0)).get("tagdimension")).get("name"), 0);
        }
    }

    @Override
    public boolean validateSave(IFormView formView, IDataModel model) {
        model.clearNoDataRow();
        int srcRowCount = model.getEntryRowCount("isdimmapsrcentry");
        int tagRowCount = model.getEntryRowCount("isdimmaptargentry");
        if (srcRowCount != 1 || tagRowCount != 1) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6570\u636e\u8f93\u5165\u6b63\u786e\uff0c\u5355\u4e00\u7ef4\u5ea6\u6620\u5c04\u53cc\u65b9\u53ea\u5141\u8bb8\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"DimMappingTypeStrategy_19", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection srcDynCollection = dataEntity.getDynamicObjectCollection("isdimmapsrcentry");
        DynamicObjectCollection tagDynCollection = dataEntity.getDynamicObjectCollection("isdimmaptargentry");
        HashSet<Long> targetIds = new HashSet<Long>();
        HashSet<Long> srcIds = new HashSet<Long>();
        for (DynamicObject target : tagDynCollection) {
            DynamicObject targDim = target.getDynamicObject("tagdimension");
            if (targDim == null) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u4fe1\u606f\u7f3a\u5931\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_23", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            long targid = targDim.getLong("id");
            if (targetIds.contains(targid)) {
                formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u5217\u8868\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u76ee\u6807\u7ef4\u5ea6%s\u8bbe\u7f6e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_1", (String)"fi-bcm-business", (Object[])new Object[0]), targDim.getString("name")));
                return false;
            }
            if (this.isXExtendProduct(dataEntity.getDynamicObject("scheme").getLong("id")).booleanValue()) {
                Long dimId;
                Long l = dimId = dataEntity.getPkValue() == null ? Long.valueOf(0L) : (Long)dataEntity.getPkValue();
                if (this.existTargDimSingle(targid, dataEntity.getDynamicObject("scheme").getLong("id"), dimId)) {
                    formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u5217\u8868\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u76ee\u6807\u7ef4\u5ea6%s\u8bbe\u7f6e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_1", (String)"fi-bcm-business", (Object[])new Object[0]), targDim.getString("name")));
                    return false;
                }
            }
            targetIds.add(targid);
        }
        for (DynamicObject src : srcDynCollection) {
            DynamicObject srcDim = src.getDynamicObject("srcdimension");
            if (srcDim == null) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u4fe1\u606f\u7f3a\u5931\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_24", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            long srcid = srcDim.getLong("id");
            if (srcIds.contains(srcid)) {
                formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u5217\u8868\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u6e90\u7ef4\u5ea6%s\u8bbe\u7f6e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_3", (String)"fi-bcm-business", (Object[])new Object[0]), srcDim.getString("name")));
                return false;
            }
            srcIds.add(srcid);
        }
        QFilter[] filters = new QFilter[]{new QFilter("scheme", "=", (Object)dataEntity.getDynamicObject("scheme").getLong("id")), new QFilter("mappedtype", "=", (Object)"1"), new QFilter("isdimmapsrcentry.srcdimension", "in", srcIds), new QFilter("isdimmaptargentry.tagdimension", "in", targetIds), QFilter.of((String)"id != ?", (Object[])new Object[]{dataEntity.getPkValue() == null ? Integer.valueOf(0) : dataEntity.getPkValue()})};
        if (QueryServiceHelper.exists((String)"bcm_isdimmap", (QFilter[])filters)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5217\u8868\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u8bbe\u7f6e\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_4", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        String srcname = this.getDimPro(srcDynCollection, "srcdimension", "name");
        String tagname = this.getDimPro(tagDynCollection, "tagdimension", "name");
        String srcnumber = this.getDimPro(srcDynCollection, "srcdimension", "number");
        String tagnumber = this.getDimPro(tagDynCollection, "tagdimension", "number");
        model.setValue("name", (Object)(tagname + "-" + srcname));
        model.setValue("number", (Object)(tagnumber + "-" + srcnumber));
        return true;
    }

    @Override
    public void closeCallBack(IFormView formView, IDataModel model, ClosedCallBackEvent closedCallBackEvent) {
    }

    @Override
    public List<DefaultMappingVO> generateVO(DynamicObject dataEntity, Boolean isExtendsTable) {
        DynamicObjectCollection srcDynCollection = dataEntity.getDynamicObjectCollection("isdimmapsrcentry");
        DynamicObjectCollection tagDynCollection = dataEntity.getDynamicObjectCollection("isdimmaptargentry");
        ArrayList<DefaultMappingVO> returnData = new ArrayList<DefaultMappingVO>();
        DefaultMappingVO dvo = new DefaultMappingVO();
        String srcname = this.getDimPro(srcDynCollection, "srcdimension", "name");
        String tagname = this.getDimPro(tagDynCollection, "tagdimension", "name");
        dvo.setSourceName(srcname);
        dvo.setTargetName(tagname);
        dvo.setMappingid(dataEntity.getLong("id"));
        dvo.setTargetDef("");
        dvo.setSourceDef("");
        if (isExtendsTable.booleanValue()) {
            dvo.setInheritanceScheme(dataEntity.getLong("inheritancescheme_id"));
            dvo.setDataFilterCondition(dataEntity.getLong("datafiltercondition_id"));
            dvo.setFilterValue(dataEntity.getString("filtervalue"));
            dvo.setReservedField(dataEntity.getString("reservedfield"));
            dvo.setDatatype(dataEntity.getString("datatype"));
        }
        dvo.setMappedtype(dataEntity.getString("mappedtype"));
        dvo.setPubmappingid(dataEntity.getLong("pubmappingid") + "");
        returnData.add(dvo);
        return returnData;
    }

    private String getDimPro(DynamicObjectCollection srcDynCollection, String columnName, String property) {
        String srcname = "";
        int size = srcDynCollection.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject src = (DynamicObject)srcDynCollection.get(i);
            DynamicObject dynamicObject = src.getDynamicObject(columnName);
            if (dynamicObject == null) continue;
            String name = dynamicObject.getString(property);
            srcname = i == 0 ? name : srcname + "+" + name;
        }
        return srcname;
    }
}

