/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.mapping.DefaultMappingVO;
import kd.fi.bcm.business.integration.mapping.DimMappingTypeStrategy;
import kd.fi.bcm.business.integration.mapping.IProduct;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integration.mapping.MappingProperty;
import kd.fi.bcm.business.integration.mapping.MappingPropertyFactory;
import kd.fi.bcm.business.integration.mapping.MappingService;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.business.integration.model.SrcDimCommonModel;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import org.apache.commons.lang3.StringUtils;

class SrcDefMapping
implements DimMappingTypeStrategy {
    SrcDefMapping() {
    }

    @Override
    public void dimTypeChanged(IFormView formView, IDataModel model) {
        boolean isTrue = true;
        boolean isFalse = false;
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject schemeDyn = dataEntity.getDynamicObject("scheme");
        if (schemeDyn != null) {
            Long ngModelId = schemeDyn.getLong("issrcmodel.id");
            DynamicObject ngModel = QueryServiceHelper.queryOne((String)"bcm_isngmodel", (String)"id,modelsource,usertype,datasource,number,apptype,phonenumber,userurl,tdpdatacenterid", (QFilter[])new QFilter("id", "=", (Object)ngModelId).toArray());
            String product = schemeDyn.getString("issrc.number");
            Boolean productDIFlag = IntegrateProductEnum.DIProduct.getNumber().equalsIgnoreCase(product);
            Boolean crossTenantORCrossDataCenterFlag = model != null && ngModel != null && (!"1".equalsIgnoreCase(ngModel.getString("usertype")) || !RequestContext.get().getAccountId().equalsIgnoreCase(ngModel.getString("datasource")));
            if (crossTenantORCrossDataCenterFlag.booleanValue() || productDIFlag.booleanValue() || this.isXExtendProduct(schemeDyn.getLong("id")).booleanValue()) {
                formView.setVisible(Boolean.valueOf(isFalse), new String[]{"srcadvconap", "srcdimdefvalue"});
                formView.setVisible(Boolean.valueOf(isTrue), new String[]{"srcadvconap", "srcmemnum"});
            } else {
                formView.setVisible(Boolean.valueOf(isFalse), new String[]{"srcadvconap", "srcmemnum"});
                formView.setVisible(Boolean.valueOf(isTrue), new String[]{"srcadvconap", "srcdimdefvalue"});
            }
        }
        formView.setVisible(Boolean.valueOf(isFalse), new String[]{"tagadvconap", "tagdimdefvalue"});
        this.setNGDimDef(formView, model);
    }

    private void setNGDimDef(IFormView formView, IDataModel model) {
        MappingContext context;
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject schemeDyn = dataEntity.getDynamicObject("scheme");
        if (schemeDyn != null && ((context = new MappingContext(schemeDyn)).isSrcNg() || context.isSrcFRModel() || context.isSrcCMModel() || context.isSrcBGModel())) {
            MappingProperty property;
            String[][] combinemappings;
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("isdimmapsrcentry");
            QFilter[] filters = null;
            filters = new QFilter[]{new QFilter("scheme", "=", schemeDyn.getPkValue())};
            DynamicObject[] dimmappings = MappingService.queryDimmapping(filters);
            IProduct source = context.getSource();
            Map<String, DynamicObject> checkDimNumbers = source.checkDimNumbers(schemeDyn);
            if (checkDimNumbers.size() > 0) {
                for (DynamicObject dim : dimmappings) {
                    DynamicObjectCollection dimensionCollection = dim.getDynamicObjectCollection("isdimmapsrcentry");
                    dimensionCollection.forEach(dimsion -> {
                        DynamicObject srcDimension = dimsion.getDynamicObject("srcdimension");
                        String number = srcDimension.getString("number");
                        if (checkDimNumbers.containsKey(number)) {
                            checkDimNumbers.remove(number);
                        }
                    });
                }
            }
            if ((combinemappings = (property = MappingPropertyFactory.getInstance(source, context.getTarget())).getCombinemappings()).length > 0) {
                for (String combineItem : combinemappings[0]) {
                    if (!checkDimNumbers.containsKey(combineItem)) continue;
                    checkDimNumbers.remove(combineItem);
                }
            }
            if (checkDimNumbers.size() > 0) {
                checkDimNumbers.forEach((k, v) -> {
                    DynamicObject addNew = dynamicObjectCollection.addNew();
                    addNew.set("srcdimension", v);
                    addNew.set("srcdimtype", (Object)source.getDimEntity());
                    addNew.set("srcbyfrom", (Object)source.byFrom());
                });
                formView.updateView("isdimmapsrcentry");
                model.updateEntryCache(dynamicObjectCollection);
            }
        }
    }

    @Override
    public void fillData(IDataModel model, DynamicObject src) {
        DynamicObjectCollection srcdynCollection = src.getDynamicObjectCollection("isdimmapsrcentry");
        for (int i = 0; i < srcdynCollection.size(); ++i) {
            DynamicObject srcdyn = (DynamicObject)srcdynCollection.get(i);
            DynamicObjectCollection srcDefDynCollection = srcdyn.getDynamicObjectCollection("isdimmapsrcdefval");
            String name = "";
            String id = "";
            for (int j = 0; j < srcDefDynCollection.size(); ++j) {
                DynamicObject srcDefdyn = (DynamicObject)srcDefDynCollection.get(j);
                if (j == 0) {
                    name = srcDefdyn.getString("srcmemname");
                    id = srcDefdyn.getString("srcmemb");
                    continue;
                }
                name = name + "," + srcDefdyn.getString("srcmemname");
                id = id + "," + srcDefdyn.getString("srcmemb");
            }
            model.setValue("srcdimdefvalue", (Object)name, i);
            model.setValue("srcmemnum", (Object)name, i);
        }
    }

    @Override
    public boolean validateSave(IFormView formView, IDataModel model) {
        model.clearNoDataRow();
        int entryRowCount = model.getEntryRowCount("isdimmapsrcentry");
        if (entryRowCount < 1) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5f55\u5165\u7684\u6e90\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u7f3a\u7701\u6210\u5458\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_6", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObject schemeDyn = dataEntity.getDynamicObject("scheme");
            if (schemeDyn != null) {
                Long ngModelId = schemeDyn.getLong("issrcmodel.id");
                DynamicObject ngModel = QueryServiceHelper.queryOne((String)"bcm_isngmodel", (String)"id,modelsource,usertype,datasource,number,apptype,phonenumber,userurl,tdpdatacenterid", (QFilter[])new QFilter("id", "=", (Object)ngModelId).toArray());
                String product = schemeDyn.getString("issrc.number");
                Boolean productDIFlag = IntegrateProductEnum.DIProduct.getNumber().equalsIgnoreCase(product);
                Boolean crossTenantORCrossDataCenterFlag = ngModel != null && (!"1".equalsIgnoreCase(ngModel.getString("usertype")) || !RequestContext.get().getAccountId().equalsIgnoreCase(ngModel.getString("datasource")));
                if (crossTenantORCrossDataCenterFlag.booleanValue() || productDIFlag.booleanValue() || this.isXExtendProduct(schemeDyn.getLong("id")).booleanValue()) {
                    DynamicObjectCollection srcDynCollection = dataEntity.getDynamicObjectCollection("isdimmapsrcentry");
                    DynamicObject dynamicObject = (DynamicObject)srcDynCollection.get(i);
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("isdimmapsrcdefval");
                    dynamicObjectCollection.clear();
                    Object srcmemnum = model.getValue("srcmemnum", i);
                    DynamicObject addNew = dynamicObjectCollection.addNew();
                    addNew.set("srcmemb", (Object)0L);
                    addNew.set("soucememnum", srcmemnum);
                    addNew.set("srcmemname", srcmemnum);
                    model.setValue("srcdimdefvalue", srcmemnum, i);
                    model.updateCache();
                }
            }
            Object tagdim = model.getValue("srcdimension", i);
            Object tagdef = model.getValue("srcdimdefvalue", i);
            if (tagdim != null && tagdef != null && !StringUtils.isEmpty((CharSequence)tagdef.toString())) continue;
            formView.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5f55\u5165\u7684\u6e90\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u7f3a\u7701\u6210\u5458\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_6", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection srcDynCollection = dataEntity.getDynamicObjectCollection("isdimmapsrcentry");
        HashSet<Long> srcIds = new HashSet<Long>();
        for (DynamicObject src : srcDynCollection) {
            DynamicObject srcDim = src.getDynamicObject("srcdimension");
            long srcid = srcDim.getLong("id");
            if (srcIds.contains(srcid)) {
                formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u5217\u8868\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u6e90\u7ef4\u5ea6%s\u8bbe\u7f6e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_3", (String)"fi-bcm-business", (Object[])new Object[0]), srcDim.getString("name")));
                return false;
            }
            srcIds.add(src.getDynamicObject("srcdimension").getLong("id"));
        }
        QFilter[] filters = new QFilter[]{new QFilter("scheme", "=", (Object)dataEntity.getDynamicObject("scheme").getLong("id")), new QFilter("mappedtype", "=", (Object)"3"), new QFilter("isdimmapsrcentry.srcdimension", "in", srcIds), QFilter.of((String)"id != ?", (Object[])new Object[]{dataEntity.getPkValue() == null ? Integer.valueOf(0) : dataEntity.getPkValue()})};
        if (QueryServiceHelper.exists((String)"bcm_isdimmap", (QFilter[])filters)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5217\u8868\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u8bbe\u7f6e\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_4", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void closeCallBack(IFormView formView, IDataModel model, ClosedCallBackEvent closedCallBackEvent) {
        EntryGrid entry = (EntryGrid)formView.getControl("isdimmapsrcentry");
        int row = entry.getEntryState().getFocusRow();
        List<SrcDimCommonModel> selectdimList = null;
        Object returnData = closedCallBackEvent.getReturnData();
        selectdimList = returnData instanceof String ? this.getSelectdimListByStr((String)returnData) : (List<SrcDimCommonModel>)returnData;
        if (selectdimList != null && selectdimList.size() > 0) {
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection srcDynCollection = dataEntity.getDynamicObjectCollection("isdimmapsrcentry");
            DynamicObject dynamicObject = (DynamicObject)srcDynCollection.get(row);
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("isdimmapsrcdefval");
            dynamicObjectCollection.clear();
            String defaultValue = "";
            int index = 0;
            for (SrcDimCommonModel selectDim : selectdimList) {
                DynamicObject addNew = dynamicObjectCollection.addNew();
                addNew.set("srcmemb", (Object)selectDim.getId());
                addNew.set("soucememnum", (Object)selectDim.getNumber());
                String name = selectDim.getName();
                defaultValue = index == 0 ? name : defaultValue + "," + name;
                addNew.set("srcmemname", (Object)name);
                ++index;
            }
            model.setValue("srcdimdefvalue", (Object)defaultValue, row);
            model.updateCache();
        }
    }

    private List<SrcDimCommonModel> getSelectdimListByStr(String name) {
        SrcDimCommonModel sdcm = new SrcDimCommonModel("0", name, name);
        ArrayList<SrcDimCommonModel> sdcms = new ArrayList<SrcDimCommonModel>(16);
        sdcms.add(sdcm);
        return sdcms;
    }

    @Override
    public List<DefaultMappingVO> generateVO(DynamicObject dataEntity, Boolean isExtendsTable) {
        DynamicObjectCollection srcDynCollection = dataEntity.getDynamicObjectCollection("isdimmapsrcentry");
        ArrayList<DefaultMappingVO> returnData = new ArrayList<DefaultMappingVO>();
        for (DynamicObject srcDyn : srcDynCollection) {
            DefaultMappingVO dvo = new DefaultMappingVO();
            String srcname = srcDyn.getDynamicObject("srcdimension").getString("name");
            dvo.setSourceName(srcname);
            dvo.setTargetName("");
            dvo.setMappingid(srcDyn.getLong("id"));
            DynamicObjectCollection srcDynDefCollection = srcDyn.getDynamicObjectCollection("isdimmapsrcdefval");
            String defaultValue = "";
            int index = 0;
            for (DynamicObject srcDyndef : srcDynDefCollection) {
                String name = srcDyndef.getString("srcmemname");
                defaultValue = index == 0 ? name : defaultValue + "," + name;
                ++index;
            }
            dvo.setTargetDef("");
            dvo.setSourceDef(defaultValue);
            returnData.add(dvo);
        }
        return returnData;
    }

    @Override
    public MemAndComVO generateMemAndComVO(DynamicObject mappingDyn) {
        throw new IllegalAccessError();
    }
}

