/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.mapping.DefaultMappingVO;
import kd.fi.bcm.business.integration.mapping.DimMappingTypeStrategy;
import kd.fi.bcm.business.integration.mapping.IProduct;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integration.mapping.MappingProperty;
import kd.fi.bcm.business.integration.mapping.MappingPropertyFactory;
import kd.fi.bcm.business.integration.mapping.MappingService;
import kd.fi.bcm.business.integration.mapping.MemAndComVO;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.lang3.StringUtils;

class TagDefMapping
implements DimMappingTypeStrategy {
    TagDefMapping() {
    }

    @Override
    public void dimTypeChanged(IFormView formView, IDataModel model) {
        boolean isTrue = true;
        boolean isFalse = false;
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject scheme = dataEntity.getDynamicObject("scheme");
        if (scheme != null && IntegrateProductEnum.XExtendProduct.getNumber().equals(((DynamicObject)scheme.get("issrc")).getString("number"))) {
            formView.setVisible(Boolean.valueOf(isTrue), new String[]{"tagdimension"});
        }
        formView.setVisible(Boolean.valueOf(isTrue), new String[]{"tagadvconap", "tagdimdefvalue"});
        formView.setVisible(Boolean.valueOf(isFalse), new String[]{"srcadvconap", "srcdimdefvalue", "field"});
        this.setNGDimDef(formView, model);
    }

    private void setNGDimDef(IFormView formView, IDataModel model) {
        MappingContext context;
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject schemeDyn = dataEntity.getDynamicObject("scheme");
        if (schemeDyn != null && !(context = new MappingContext(schemeDyn)).isSrcNg()) {
            DynamicObject scheme;
            MappingProperty property;
            String[][] combinemappings;
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("isdimmaptargentry");
            if (dynamicObjectCollection.size() > 0) {
                return;
            }
            QFilter[] filters = null;
            filters = new QFilter[]{new QFilter("scheme", "=", schemeDyn.getPkValue())};
            DynamicObject[] dimmappings = MappingService.queryDimmapping(filters);
            IProduct target = context.getTarget();
            Map<String, DynamicObject> checkDimNumbers = target.checkDimNumbers(schemeDyn);
            if (checkDimNumbers.size() > 0) {
                for (DynamicObject dim : dimmappings) {
                    DynamicObjectCollection dimensionCollection = dim.getDynamicObjectCollection("isdimmaptargentry");
                    dimensionCollection.forEach(dimsion -> {
                        DynamicObject srcDimension = dimsion.getDynamicObject("tagdimension");
                        String number = srcDimension.getString("number");
                        if (checkDimNumbers.containsKey(number)) {
                            checkDimNumbers.remove(number);
                        }
                    });
                }
            }
            if ((combinemappings = (property = MappingPropertyFactory.getInstance(context.getSource(), target)).getCombinemappings()).length > 0) {
                for (String combineItem : combinemappings[0]) {
                    if (!checkDimNumbers.containsKey(combineItem)) continue;
                    checkDimNumbers.remove(combineItem);
                }
            }
            if ((scheme = BusinessDataServiceHelper.loadSingle((Object)schemeDyn.getPkValue(), (String)"bcm_isscheme")) != null && IntegrateProductEnum.XExtendProduct.getNumber().equals(scheme.getString("issrc.number"))) {
                Set<String> set = this.getModelDimIds(scheme.getLong("extendsmodel_id"), scheme.getLong("model_id"));
                checkDimNumbers.keySet().removeIf(k -> !set.contains(k));
            }
            if (checkDimNumbers.size() > 0) {
                checkDimNumbers.forEach((k, v) -> {
                    DynamicObject addNew = dynamicObjectCollection.addNew();
                    addNew.set("tagdimension", v);
                    addNew.set("tagdimtype", (Object)target.getDimEntity());
                    addNew.set("tagbyfrom", (Object)target.byFrom());
                });
                formView.updateView("isdimmaptargentry");
                model.updateEntryCache(dynamicObjectCollection);
            }
        }
    }

    private Set<String> getModelDimIds(Long id, Long modelId) {
        DynamicObject[] extModelDim = BusinessDataServiceHelper.load((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)id)});
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject object : extModelDim) {
            ids.add(object.getLong("dimension_id"));
        }
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        List<String> fixedDimension = Arrays.asList("Entity", "Year", "Period", "Scenario", "Process", "Currency", "AuditTrail");
        QFilter fixedQF = new QFilter("number", "in", fixedDimension);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{modelQf, fixedQF});
        for (DynamicObject dim : dims) {
            ids.add(dim.getLong("id"));
        }
        QFilter IdsQf = new QFilter("id", "in", ids);
        DynamicObjectCollection dimNumbers = QueryServiceHelper.query((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter[]{IdsQf});
        HashSet<String> numbers = new HashSet<String>();
        for (DynamicObject dimNumber : dimNumbers) {
            numbers.add(dimNumber.getString("number"));
        }
        return numbers;
    }

    @Override
    public void fillData(IDataModel model, DynamicObject src) {
        DynamicObjectCollection tagdynCollection = src.getDynamicObjectCollection("isdimmaptargentry");
        for (int i = 0; i < tagdynCollection.size(); ++i) {
            DynamicObject tagdyn = (DynamicObject)tagdynCollection.get(i);
            DynamicObjectCollection tagDefDynCollection = tagdyn.getDynamicObjectCollection("isdimmaptargdefval");
            String name = "";
            String id = "";
            for (int j = 0; j < tagDefDynCollection.size(); ++j) {
                DynamicObject tagDefdyn = (DynamicObject)tagDefDynCollection.get(j);
                if (j == 0) {
                    name = tagDefdyn.getString("tagmemname");
                    id = tagDefdyn.getString("tagmemb");
                    continue;
                }
                name = name + "," + tagDefdyn.getString("tagmemname");
                id = id + "," + tagDefdyn.getString("tagmemb");
            }
            model.setValue("tagdimdefvalue", (Object)name, i);
        }
    }

    @Override
    public boolean validateSave(IFormView formView, IDataModel model) {
        model.clearNoDataRow();
        int entryRowCount = model.getEntryRowCount("isdimmaptargentry");
        if (entryRowCount < 1) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5f55\u5165\u7684\u76ee\u6807\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u7f3a\u7701\u6210\u5458\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_5", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        for (int i = 0; i < entryRowCount; ++i) {
            Long modelId;
            Long tagmemb;
            String dimNumber;
            String error;
            Object tagdim = model.getValue("tagdimension", i);
            Object tagdef = model.getValue("tagdimdefvalue", i);
            if (tagdim == null || tagdef == null || StringUtils.isEmpty((CharSequence)tagdef.toString())) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5f55\u5165\u7684\u76ee\u6807\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u7f3a\u7701\u6210\u5458\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_5", (String)"fi-bcm-business", (Object[])new Object[0]));
                return false;
            }
            DynamicObject dataEntity = model.getDataEntity(true);
            Iterator scheme = dataEntity.getDynamicObject("scheme");
            if (scheme == null || !IntegrateProductEnum.XExtendProduct.getNumber().equals(((DynamicObject)scheme.get("issrc")).getString("number")) || !kd.bos.util.StringUtils.isNotEmpty((String)(error = this.getXExtTargDimError(dimNumber = ((DynamicObject)model.getValue("tagdimension", i)).getString("number"), tagmemb = Long.valueOf(((DynamicObject)((DynamicObjectCollection)model.getValue("isdimmaptargdefval", i)).get(0)).getLong("tagmemb")), modelId = Long.valueOf(scheme.getLong("model_id")))))) continue;
            formView.showTipNotification(error);
            return Boolean.FALSE;
        }
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection tagDynCollection = dataEntity.getDynamicObjectCollection("isdimmaptargentry");
        HashSet<Long> targetIds = new HashSet<Long>();
        HashSet<Long> collIds = new HashSet<Long>();
        for (DynamicObject target : tagDynCollection) {
            DynamicObject targDim = target.getDynamicObject("tagdimension");
            long targid = targDim.getLong("id");
            if (targetIds.contains(targid)) {
                formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u5217\u8868\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u76ee\u6807\u7ef4\u5ea6%s\u8bbe\u7f6e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_1", (String)"fi-bcm-business", (Object[])new Object[0]), targDim.getString("name")));
                return false;
            }
            if (this.isXExtendProduct(dataEntity.getDynamicObject("scheme").getLong("id")).booleanValue()) {
                Long dimId;
                Long l = dimId = dataEntity.getPkValue() == null ? Long.valueOf(0L) : (Long)dataEntity.getPkValue();
                if (this.existTargDimSingle(targid, dataEntity.getDynamicObject("scheme").getLong("id"), dimId)) {
                    formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u5217\u8868\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u76ee\u6807\u7ef4\u5ea6%s\u8bbe\u7f6e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_1", (String)"fi-bcm-business", (Object[])new Object[0]), targDim.getString("name")));
                    return false;
                }
            }
            targetIds.add(target.getDynamicObject("tagdimension").getLong("id"));
            if (target.getPkValue() == null) continue;
            collIds.add(target.getLong("id"));
        }
        QFilter[] filters = new QFilter[]{new QFilter("scheme", "=", (Object)dataEntity.getDynamicObject("scheme").getLong("id")), new QFilter("mappedtype", "=", (Object)"2"), new QFilter("isdimmaptargentry.tagdimension", "in", targetIds), QFilter.of((String)"id != ?", (Object[])new Object[]{dataEntity.getPkValue() == null ? Integer.valueOf(0) : dataEntity.getPkValue()})};
        if (QueryServiceHelper.exists((String)"bcm_isdimmap", (QFilter[])filters)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5217\u8868\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u8bbe\u7f6e\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimMappingTypeStrategy_4", (String)"fi-bcm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String getXExtTargDimError(String dimNumber, Long tagmemb, Long modelId) {
        String error = "";
        if ("Process".equals(dimNumber)) {
            error = this.checkXExtProcessTagDim(dimNumber, tagmemb, modelId);
        }
        return error;
    }

    private String checkXExtProcessTagDim(String dim, Long memberId, final Long modelId) {
        HashMap<String, Long> processDimMap = new HashMap<String, Long>(){
            {
                this.put("Process", MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)"EIRpt").getId());
            }
        };
        if (processDimMap.containsKey(dim) && ((Long)processDimMap.get(dim)).equals(memberId)) {
            return "";
        }
        return ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u96c6\u6210\u7ef4\u5ea6\u6620\u5c04\u65f6,\u76ee\u6807\u7f3a\u7701\u6620\u5c04\u5fc5\u987b\u5305\u542b\u8fc7\u7a0b\uff0c\u5e76\u4e14\u9ed8\u8ba4\u503c\u5fc5\u987b\u662f\u62a5\u8868\u672c\u5e01\u3002", (String)"MappingService_19", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    @Override
    public void closeCallBack(IFormView formView, IDataModel model, ClosedCallBackEvent closedCallBackEvent) {
        EntryGrid entry = (EntryGrid)formView.getControl("isdimmaptargentry");
        int row = entry.getEntryState().getFocusRow();
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (listSelectedRows != null && listSelectedRows.size() > 0) {
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection srcDynCollection = dataEntity.getDynamicObjectCollection("isdimmaptargentry");
            DynamicObject dynamicObject = (DynamicObject)srcDynCollection.get(row);
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("isdimmaptargdefval");
            dynamicObjectCollection.clear();
            String defaultValue = "";
            int index = 0;
            for (ListSelectedRow selectDim : listSelectedRows) {
                DynamicObject addNew = dynamicObjectCollection.addNew();
                addNew.set("tagmemb", selectDim.getPrimaryKeyValue());
                addNew.set("targetmemnum", (Object)selectDim.getNumber());
                String name = selectDim.getName();
                if (selectDim.getNumber() == null) {
                    DynamicObject dimension = MemberReader.getDimensionDynById((long)dynamicObject.getLong("tagdimension.id"));
                    String memberModel = dimension.getString("membermodel");
                    Long modelId = dimension.getLong("model.id");
                    IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)memberModel, (Long)LongUtil.toLong((Object)selectDim.getPrimaryKeyValue()));
                    addNew.set("targetmemnum", (Object)member.getNumber());
                    if (selectDim.getName() == null) {
                        name = member.getName();
                    }
                }
                defaultValue = index == 0 ? name : defaultValue + "," + name;
                addNew.set("tagmemname", (Object)name);
                addNew.set("seq", (Object)index);
                ++index;
            }
            model.setValue("tagdimdefvalue", (Object)defaultValue, row);
            model.updateCache();
        }
    }

    @Override
    public List<DefaultMappingVO> generateVO(DynamicObject dataEntity, Boolean isExtendsTable) {
        DynamicObjectCollection tagDynCollection = dataEntity.getDynamicObjectCollection("isdimmaptargentry");
        ArrayList<DefaultMappingVO> returnData = new ArrayList<DefaultMappingVO>();
        for (DynamicObject tagDyn : tagDynCollection) {
            DefaultMappingVO dvo = new DefaultMappingVO();
            String tagname = tagDyn.getDynamicObject("tagdimension").getString("name");
            dvo.setSourceName("");
            dvo.setTargetName(tagname);
            dvo.setMappingid(tagDyn.getLong("id"));
            DynamicObjectCollection tagDynDefCollection = tagDyn.getDynamicObjectCollection("isdimmaptargdefval");
            String defaultValue = "";
            int index = 0;
            for (DynamicObject tagDyndef : tagDynDefCollection) {
                String name = tagDyndef.getString("tagmemname");
                defaultValue = index == 0 ? name : defaultValue + "," + name;
                ++index;
            }
            dvo.setTargetDef(defaultValue);
            dvo.setSourceDef("");
            if (isExtendsTable.booleanValue()) {
                dvo.setInheritanceScheme(dataEntity.getLong("inheritancescheme_id"));
                dvo.setDataFilterCondition(dataEntity.getLong("datafiltercondition_id"));
                dvo.setFilterValue(dataEntity.getString("filtervalue"));
                dvo.setReservedField(dataEntity.getString("reservedfield"));
                dvo.setDatatype(dataEntity.getString("datatype"));
            }
            returnData.add(dvo);
        }
        return returnData;
    }

    @Override
    public MemAndComVO generateMemAndComVO(DynamicObject mappingDyn) {
        throw new IllegalAccessError();
    }
}

