/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.IntegrationParam;
import kd.fi.bcm.business.integration.model.IIntegrationContext;
import kd.fi.bcm.business.integration.model.MappingModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.integration.AdapterEnum;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;

public class Integration2EasContext
implements IIntegrationContext {
    protected static WatchLogger log;
    private static final String SCHEME_FOE_EAS = "S_CM_EAS_800";
    private static final String MODEL_FOE_EAS = "M_CM_EAS_800";
    private String srcSysVersion;
    private int balType;
    private Tuple<Long, String, String> srcsys;
    private Pair<Long, String> model;
    private Pair<Long, String> scheme;
    private Pair<Long, String> period;
    private Pair<Long, String> scene;
    private Pair<Long, String> year;
    private Pair<Long, String> currency;
    private List<String> orgNumbers;
    private List<String> dimAll;
    private List<String> dimUserDefine;
    private Map<String, String> dimShortNumberMapped;
    private List<MappingModel> mappingModel;
    private IntegrationParam param;
    private String solution;
    private AdapterEnum adapter;
    private boolean isFilterZero;
    private boolean isInterExch = false;
    private String exchRootOrg;
    private BigDecimal rate = BigDecimal.ONE;
    private int precision = 2;
    private List<String> srcDefaultDims;

    public Integration2EasContext(Map<String, Object> param) {
        this.param = new IntegrationParam();
        this.param.setCustomParam(param);
        this.scene = Pair.onePair(null, (Object)this.getParamValue(param, "periodType"));
        this.year = Pair.onePair(null, (Object)this.getParamValue(param, "year"));
        this.period = Pair.onePair(null, (Object)this.getParamValue(param, "period"));
        this.orgNumbers = (List)param.get("companyNumbers");
        this.isInterExch = "1".equals(this.getParamValue(param, "isInterExch"));
        this.exchRootOrg = this.getParamValue(param, "exchRootOrg");
        Object rate = param.get("rate");
        int intRate = rate != null ? (rate instanceof String ? Integer.valueOf(rate.toString()) : (Integer)rate) : 1;
        Object decimalDigits = param.get("decimalDigits");
        this.precision = decimalDigits != null ? (decimalDigits instanceof String ? Integer.valueOf(decimalDigits.toString()) : (Integer)decimalDigits) : 2;
        this.rate = BigDecimal.valueOf(intRate);
        this.initScheme();
        this.initModel();
        this.initDim();
        this.initSrcDefaultDims();
    }

    private void initSrcDefaultDims() {
        QFilter schemeIdFilter = new QFilter("scheme", "=", this.scheme.p1);
        QFilter tarqf = new QFilter("entryentity.tagdim", "=", (Object)0L);
        DynamicObjectCollection notHaveSrcDims = QueryServiceHelper.query((String)"bcm_dimmappingwelkin", (String)"entryentity.srcdim.number, entryentity.defaultitemnumber", (QFilter[])new QFilter[]{schemeIdFilter, tarqf});
        this.srcDefaultDims = new ArrayList<String>(5);
        notHaveSrcDims.forEach(d -> this.srcDefaultDims.add(d.getString("entryentity.srcdim.number")));
    }

    private String getParamValue(Map<String, Object> param, String key) {
        Object value = param.get(key);
        return value != null ? value.toString() : null;
    }

    private void initModel() {
        if (this.model == null) {
            QFBuilder builder = new QFBuilder();
            builder.add("shownumber", "=", (Object)MODEL_FOE_EAS);
            DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id, number", (QFilter[])builder.toArray());
            if (model == null) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e0\u7f16\u7801\u4e3a[%s]\u7684\u4f53\u7cfb\u3002", (String)"Integration2EasContext_0", (String)"fi-bcm-business", (Object[])new Object[0]), MODEL_FOE_EAS));
            }
            this.model = Pair.onePair((Object)model.getLong("id"), (Object)model.getString("number"));
        }
    }

    private void initDim() {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, shortnumber, fieldmapped, issysdimension", (QFilter[])new QFBuilder().add("model", "=", this.model.p1).toArray(), (String)"dseq");
        this.dimAll = new ArrayList<String>(10);
        this.dimUserDefine = new ArrayList<String>(10);
        this.dimShortNumberMapped = new HashMap<String, String>(10);
        dims.forEach(e -> {
            this.dimAll.add(e.getString("number"));
            if (!e.getBoolean("issysdimension")) {
                this.dimUserDefine.add(e.getString("number"));
            }
            this.dimShortNumberMapped.put(e.getString("number"), e.getString("shortnumber"));
        });
    }

    private void initScheme() {
        Object obj = this.param.getCustomParam().get("scheme");
        String schemeNumber = null;
        schemeNumber = obj != null ? obj.toString() : SCHEME_FOE_EAS;
        ArrayList<String> selector = new ArrayList<String>(15);
        selector.add("id");
        selector.add("number");
        selector.add("model.id");
        selector.add("model.number");
        selector.add("sourcedatasys.id");
        selector.add("sourcedatasys.number");
        selector.add("sourcedatasys.version");
        selector.add("sourcedatasys.srcsystype.number");
        selector.add("targetdatasys.id");
        selector.add("targetdatasys.number");
        selector.add("targetdatasys.srcsystype.number");
        selector.add("adapter");
        selector.add("isfilterzero");
        QFBuilder builder = new QFBuilder();
        builder.add("number", "=", (Object)schemeNumber);
        DynamicObject dynaObj = QueryServiceHelper.queryOne((String)"bcm_schemeentity", (String)String.join((CharSequence)",", selector), (QFilter[])builder.toArray());
        if (dynaObj == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6620\u5c04\u65b9\u6848\u201c%s\u201d\u3002", (String)"Integration2EasContext_1", (String)"fi-bcm-business", (Object[])new Object[0]), schemeNumber));
        }
        this.srcsys = Tuple.create((Object)dynaObj.getLong("sourcedatasys.id"), (Object)dynaObj.getString("sourcedatasys.number"), (Object)dynaObj.getString("sourcedatasys.srcsystype.number"));
        this.srcSysVersion = dynaObj.getString("sourcedatasys.version");
        this.model = Pair.onePair((Object)dynaObj.getLong("model.id"), (Object)dynaObj.getString("model.number"));
        this.adapter = AdapterEnum.getEnum((Integer)dynaObj.getInt("adapter"));
        this.scheme = Pair.onePair((Object)dynaObj.getLong("id"), (Object)dynaObj.getString("number"));
        this.isFilterZero = dynaObj.getBoolean("isfilterzero");
    }

    @Override
    public Tuple<Long, String, String> getSrcsys() {
        return this.srcsys;
    }

    @Override
    public Pair<Long, String> getModel() {
        return this.model;
    }

    @Override
    public Pair<Long, String> getScheme() {
        return this.scheme;
    }

    @Override
    public Pair<Long, String> getYear() {
        return this.year;
    }

    @Override
    public Pair<Long, String> getPeriod() {
        return this.period;
    }

    @Override
    public Pair<Long, String> getCurrency() {
        return this.currency;
    }

    @Override
    public Pair<Long, String> getScene() {
        return this.scene;
    }

    @Override
    public List<String> getOrgNumbers() {
        return this.orgNumbers;
    }

    @Override
    public List<String> getDimAll() {
        return this.dimAll;
    }

    @Override
    public List<String> getDimUserDefine() {
        return this.dimUserDefine;
    }

    @Override
    public List<MappingModel> getMappingModel() {
        return this.mappingModel;
    }

    @Override
    public Map<String, String> getDimShortNumberMapped() {
        return this.dimShortNumberMapped;
    }

    @Override
    public void setMappingModel(List<MappingModel> models) {
        this.mappingModel = models;
    }

    public void setParams(IntegrationParam param) {
        this.param = param;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    @Override
    public int getBalType() {
        return this.balType;
    }

    @Override
    public String getSrcSysVersion() {
        return this.srcSysVersion;
    }

    @Override
    public IntegrationParam getParam() {
        return this.param;
    }

    @Override
    public String getSolution() {
        return this.solution;
    }

    @Override
    public AdapterEnum getAdapter() {
        return this.adapter;
    }

    @Override
    public boolean getIsFilterZero() {
        return this.isFilterZero;
    }

    @Override
    public boolean isInterExch() {
        return this.isInterExch;
    }

    @Override
    public String getExchRootOrg() {
        return this.exchRootOrg;
    }

    @Override
    public boolean isDataCollect() {
        return false;
    }

    @Override
    public BigDecimal getRate() {
        return this.rate;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setCurrency(Pair<Long, String> currency) {
        this.currency = currency;
    }

    @Override
    public List<String> getSrcDefaultDims() {
        return this.srcDefaultDims;
    }
}

