/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.IntegrationParam;
import kd.fi.bcm.business.integration.model.IIntegrationContext;
import kd.fi.bcm.business.integration.model.MappingModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.integration.AdapterEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class IntegrationContext
implements IIntegrationContext {
    private String srcSysVersion;
    private int balType;
    private AdapterEnum adapter;
    private Tuple<Long, String, String> srcsys;
    private Pair<Long, String> model;
    private Pair<Long, String> scheme;
    private Pair<Long, String> period;
    private Pair<Long, String> scene;
    private Pair<Long, String> year;
    private Pair<Long, String> currency;
    private List<String> orgNumbers;
    private List<String> dimAll;
    private List<String> dimUserDefine;
    private Map<String, String> dimShortNumberMapped;
    private List<MappingModel> mappingModel;
    private IntegrationParam param;
    private String solution;
    private boolean isDataCollect;

    public IntegrationContext(IntegrationParam param) {
        this.scheme = param.getScheme();
        this.period = param.getPeriod();
        this.scene = param.getScene();
        this.year = param.getYear();
        this.currency = param.getCurrency();
        this.model = param.getModel();
        this.orgNumbers = param.getOrgs().stream().map(e -> (String)e.p2).collect(Collectors.toList());
        this.param = param;
        this.initDim();
        this.initScheme();
        this.initAuditTrail();
    }

    private void initAuditTrail() {
        ArrayList<String> selector = new ArrayList<String>(10);
        selector.add("isdatacollect");
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", this.model.p1);
        builder.add("number", "=", (Object)"DataCollection");
        DynamicObject dynaObj = QueryServiceHelper.queryOne((String)"bcm_audittrialmembertree", (String)String.join((CharSequence)",", selector), (QFilter[])builder.toArray());
        this.isDataCollect = dynaObj != null ? dynaObj.getBoolean("isdatacollect") : false;
    }

    private void initScheme() {
        ArrayList<String> selector = new ArrayList<String>(10);
        selector.add("sourcedatasys.id");
        selector.add("sourcedatasys.number");
        selector.add("sourcedatasys.version");
        selector.add("sourcedatasys.srcsystype.number");
        selector.add("adapter");
        DynamicObject dynaObj = QueryServiceHelper.queryOne((String)"bcm_schemeentity", (String)String.join((CharSequence)",", selector), (QFilter[])new QFBuilder().add("id", "=", this.scheme.p1).toArray());
        this.srcsys = Tuple.create((Object)dynaObj.getLong("sourcedatasys.id"), (Object)dynaObj.getString("sourcedatasys.number"), (Object)dynaObj.getString("sourcedatasys.srcsystype.number"));
        this.srcSysVersion = dynaObj.getString("sourcedatasys.version");
        this.balType = 5;
        this.adapter = AdapterEnum.getEnum((Integer)dynaObj.getInt("adapter"));
    }

    private void initDim() {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, shortnumber, fieldmapped, issysdimension", (QFilter[])new QFBuilder().add("model", "=", this.model.p1).toArray(), (String)"dseq");
        this.dimAll = new ArrayList<String>(10);
        this.dimUserDefine = new ArrayList<String>(10);
        this.dimShortNumberMapped = new HashMap<String, String>(10);
        dims.forEach(e -> {
            this.dimAll.add(e.getString("number"));
            if (!e.getBoolean("issysdimension")) {
                this.dimUserDefine.add(e.getString("number"));
            }
            this.dimShortNumberMapped.put(e.getString("number"), e.getString("shortnumber"));
        });
    }

    @Override
    public int getBalType() {
        return this.balType;
    }

    @Override
    public AdapterEnum getAdapter() {
        return this.adapter;
    }

    @Override
    public boolean getIsFilterZero() {
        return false;
    }

    @Override
    public Tuple<Long, String, String> getSrcsys() {
        return this.srcsys;
    }

    @Override
    public Pair<Long, String> getModel() {
        return this.model;
    }

    @Override
    public Pair<Long, String> getScheme() {
        return this.scheme;
    }

    @Override
    public Pair<Long, String> getYear() {
        return this.year;
    }

    @Override
    public Pair<Long, String> getPeriod() {
        return this.period;
    }

    @Override
    public Pair<Long, String> getCurrency() {
        return this.currency;
    }

    @Override
    public Pair<Long, String> getScene() {
        return this.scene;
    }

    @Override
    public List<String> getOrgNumbers() {
        return this.orgNumbers;
    }

    @Override
    public List<String> getDimAll() {
        return this.dimAll;
    }

    @Override
    public List<String> getDimUserDefine() {
        return this.dimUserDefine;
    }

    @Override
    public Map<String, String> getDimShortNumberMapped() {
        return this.dimShortNumberMapped;
    }

    @Override
    public void setMappingModel(List<MappingModel> mappingModel) {
        this.mappingModel = mappingModel;
    }

    public void setParam(IntegrationParam param) {
        this.param = param;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    @Override
    public boolean isDataCollect() {
        return this.isDataCollect;
    }

    public void setDataCollect(boolean isDataCollect) {
        this.isDataCollect = isDataCollect;
    }

    @Override
    public List<MappingModel> getMappingModel() {
        return this.mappingModel;
    }

    @Override
    public String getSrcSysVersion() {
        return this.srcSysVersion;
    }

    @Override
    public IntegrationParam getParam() {
        return this.param;
    }

    @Override
    public String getSolution() {
        return this.solution;
    }
}

