/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.model.IIntegrationContext;
import kd.fi.bcm.business.integration.model.RelationModel;
import kd.fi.bcm.business.integration.util.IntegrationUtil;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.enums.integration.RelationEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class MappingModel {
    private int dc;
    private List<Pair<String, String>> members;
    private Object value;
    private int factor;
    private boolean isfloat;
    private String floatItem;
    private String floatTxtItem;
    private Map<String, RelationModel> relations;
    private String org;
    private String msg;
    private String dataFrom;
    private String dynaItemKey;
    private String txtvalue;
    private String accessFormula;
    private String myCompany;
    private String sequence;
    private List<DynaItem> multiDynaItems;
    private static ThreadLocal<Map<String, Set<String>>> dynaItemCache = ThreadLocal.withInitial(HashMap::new);

    public MappingModel(int dc, List<Pair<String, String>> members, Map<String, RelationModel> relations, int factor) {
        this.dc = dc;
        this.members = members;
        this.relations = relations;
        this.factor = factor;
    }

    public MappingModel(int dc, List<Pair<String, String>> members, Map<String, RelationModel> relations, int factor, boolean isfloat, String floatItem, String floatTxtItem) {
        this.dc = dc;
        this.members = members;
        this.relations = relations;
        this.factor = factor;
        this.isfloat = isfloat;
        this.floatItem = floatItem;
        this.floatTxtItem = floatTxtItem;
    }

    public int getDc() {
        return this.dc;
    }

    public List<Pair<String, String>> getMembers() {
        return this.members;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setRelations(Map<String, RelationModel> relations) {
        this.relations = relations;
    }

    public String getOrg() {
        if (!StringUtils.isEmpty((String)this.org)) {
            return this.org;
        }
        return (String)this.members.get((int)0).p2;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getDataFrom() {
        return this.dataFrom;
    }

    public void setDataFrom(String dataFrom) {
        this.dataFrom = dataFrom;
    }

    public Object getValue() {
        return this.value;
    }

    public int getFactor() {
        return this.factor;
    }

    public String getAccessFormula() {
        return this.accessFormula;
    }

    public void setAccessFormula(String accessFormula) {
        this.accessFormula = accessFormula;
    }

    public boolean getIsfloat() {
        return this.isfloat;
    }

    public void setIsfloat(boolean isfloat) {
        this.isfloat = isfloat;
    }

    public String getFloatItem() {
        return this.floatItem;
    }

    public void setFloatItem(String floatItem) {
        this.floatItem = floatItem;
    }

    public String getfloatTxtItem() {
        return this.floatTxtItem;
    }

    public void setFloatTxtItem(String floatTxtItem) {
        this.floatTxtItem = floatTxtItem;
    }

    public Map<String, RelationModel> getRelations() {
        return this.relations;
    }

    public String getMembersString() {
        List memberList = this.members.stream().map(e -> (String)e.p2).collect(Collectors.toList());
        return String.join((CharSequence)"&", memberList);
    }

    public List<String> getSrcDims(String ... dims) {
        ArrayList<String> srcDims = new ArrayList<String>();
        for (String dim : dims) {
            RelationModel m = this.relations.get(dim);
            if (m == null) continue;
            srcDims.add(m.getSrcDim());
        }
        return srcDims;
    }

    public String getTxtvalue() {
        return this.txtvalue;
    }

    public void setTxtvalue(String txtvalue) {
        this.txtvalue = txtvalue;
    }

    public Map<String, List<String>> getSrcMembers(String dim, String ... members) {
        RelationModel model = this.relations.get(dim);
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String member : members) {
            if (model == null || !member.equals(model.getMember())) continue;
            result.put(member, model.getSrcMembers());
        }
        return result;
    }

    public String getMyCompany() {
        return this.myCompany;
    }

    public void setMyCompany(String myCompany) {
        this.myCompany = myCompany;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getFilter() {
        QFBuilder builder = new QFBuilder();
        this.relations.forEach((k, v) -> IntegrationUtil.addQFilter(builder, v.getSrcDim(), v.getRelation(), v.getSrcMembers()));
        QFilter[] filters = builder.toArray();
        StringBuilder sb = new StringBuilder();
        for (QFilter f : filters) {
            sb.append(String.format("%s and ", f.toString()));
        }
        return sb.substring(0, sb.length() - 5);
    }

    public String toString() {
        return String.format("members=%s\nrelation=%s\nvalue=%s\n", this.getMembersString(), this.getRelationString(), this.value);
    }

    private String getRelationString() {
        StringBuilder sb = new StringBuilder();
        this.relations.forEach((k, v) -> {
            sb.append(v.getSrcDim());
            RelationEnum re = v.getRelation();
            if (RelationEnum.Equal == re) {
                sb.append(':').append(v.getSrcMembers().get(0));
            } else if (RelationEnum.Between == re) {
                sb.append(" between (").append(v.getSrcMembers().get(0)).append(" - ").append(v.getSrcMembers().get(1)).append(')');
            } else if (RelationEnum.In == re) {
                sb.append(" in (").append(String.join((CharSequence)",", v.getSrcMembers())).append(')');
            } else if (RelationEnum.Like == re) {
                sb.append(" like ").append(v.getSrcMembers().get(0));
            }
            sb.append("; ");
        });
        return sb.substring(0, sb.length() - 2);
    }

    public String getDynaItemKey() {
        return this.dynaItemKey;
    }

    public void setDynaItemKey(String dynaItemKey) {
        this.dynaItemKey = dynaItemKey;
    }

    public void addDynaItem(String dynaItemKey, Object value, String floatTxt, String myCompany, String sequence) {
        if (this.multiDynaItems == null) {
            this.multiDynaItems = new ArrayList<DynaItem>();
        }
        DynaItem item = new DynaItem();
        item.dynaItemKey = dynaItemKey;
        item.value = value;
        item.floatTxt = floatTxt;
        item.myCompany = myCompany;
        item.sequence = sequence;
        this.multiDynaItems.add(item);
    }

    public List<DynaItem> getMultiDynaItems() {
        return this.multiDynaItems;
    }

    public boolean isMultiValModel() {
        return this.isfloat || this.isfloat && this.getRelations().get(PresetConstant.PROCESS_DIM).getSrcMembers().get(0).equals("CS") || StringUtils.isNotEmpty((String)this.floatItem) && StringUtils.isEmpty((String)this.getRelations().get(this.floatItem).getMember());
    }

    public boolean isDontCompare(String dim) {
        return StringUtils.isNotEmpty((String)dim) && StringUtils.isEmpty((String)this.getRelations().get(dim).getMember());
    }

    public boolean isMatch(String number, IIntegrationContext ctx, boolean isFloatItem) {
        String pNum = isFloatItem ? this.getRelations().get(this.floatItem).getSrcMembers().get(0) : this.getRelations().get(this.floatTxtItem).getSrcMembers().get(0);
        return this.isMatchedAndIsLeaf(isFloatItem ? this.floatItem : this.floatTxtItem, number, pNum, ctx);
    }

    public boolean isleaf(String dim, String number, IIntegrationContext ctx) {
        return this.isMatchedAndIsLeaf(dim, number, dim, ctx);
    }

    public boolean isMatchedAndIsLeaf(String dim, String number, String pNum, IIntegrationContext ctx) {
        String cacheKey = dim + ":" + pNum;
        this.initLeafNumber(dim, pNum, ctx);
        return dynaItemCache.get().get(cacheKey).contains(number);
    }

    public Set<String> getLeafMembs(String dim, String pNum, IIntegrationContext ctx) {
        String cacheKey = dim + ":" + pNum;
        this.initLeafNumber(dim, pNum, ctx);
        return dynaItemCache.get().get(cacheKey);
    }

    private void initLeafNumber(String dim, String pNum, IIntegrationContext ctx) {
        String cacheKey = dim + ":" + pNum;
        Map<String, Set<String>> map = dynaItemCache.get();
        if (!map.containsKey(cacheKey)) {
            HashSet multiIncludeDynaItemNums = new HashSet();
            DynamicObject member = BusinessDataServiceHelper.loadSingle((String)IntegrationUtil.getDimMembEntityNumByDimNum(dim), (String)"id", (QFilter[])new QFBuilder().add("number", "=", (Object)pNum).add("dimension.number", "=", (Object)dim).add("model.id", "=", ctx.getModel().p1).toArray());
            List<SimpleItem> lst = TreeStructureServiceHelper.getChildByAssign(IntegrationUtil.getDimMembEntityNumByDimNum(dim), member.getLong("id"), ctx.getModel().p1, true);
            lst.forEach(e -> multiIncludeDynaItemNums.add(e.number));
            map.put(cacheKey, multiIncludeDynaItemNums);
        }
    }

    public static class DynaItem {
        private String dynaItemKey;
        private String floatTxt;
        private Object value;
        private String myCompany;
        private String sequence;

        public String getDynaItemKey() {
            return this.dynaItemKey;
        }

        public String getFloatTxt() {
            return this.floatTxt;
        }

        public Object getValue() {
            return this.value;
        }

        public String getMyCompany() {
            return this.myCompany;
        }

        public String getSequence() {
            return this.sequence;
        }
    }
}

