/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integration.util.DataTypeCacheInfo;
import kd.fi.bcm.common.enums.DataTypeEnum;

public class DataTypeUtil {
    private static final String dimDataTypeCache = "dimCacheInfo";
    public static final String USER_DEFINED_DIM = "userdefineddim";

    public static DataTypeEnum getDataTypeThreadCache(long modelId, Map<String, String> dim2Members, HashMap<String, DataTypeCacheInfo> cachemap) {
        DataTypeEnum defaultType = DataTypeEnum.DEFAULT;
        boolean isCache = false;
        if (cachemap == null || cachemap.size() == 0) {
            isCache = true;
            cachemap = DataTypeUtil.getDataTypeThreadCache();
        }
        ArrayList<String> dimNumbers = new ArrayList<String>();
        dimNumbers.addAll(DataTypeUtil.getPreSetDimensions(modelId));
        dimNumbers.addAll(DataTypeUtil.getUserDefinedThreadCache(modelId));
        Map.Entry[] resultMap = new Map.Entry[dimNumbers.size()];
        int index = 0;
        for (String dimNumber : dimNumbers) {
            resultMap[index++] = new AbstractMap.SimpleEntry<String, String>(dimNumber, dim2Members.get(dimNumber));
        }
        DataTypeEnum dataTypeEnum = null;
        for (int i = 0; i < resultMap.length; ++i) {
            String memberNumber;
            String dim = (String)resultMap[i].getKey();
            dataTypeEnum = DataTypeUtil.getDimensionDataType(modelId, dim, memberNumber = (String)resultMap[i].getValue(), cachemap);
            if (dataTypeEnum == defaultType) continue;
            return dataTypeEnum;
        }
        if (isCache) {
            DataTypeUtil.cacheDataTypeInfo2Thread(cachemap);
        }
        return defaultType;
    }

    public static List<String> getPreSetDimensions(long modelId) {
        return DataTypeEnum.getDataTypePerSetDims((Object)modelId);
    }

    private static HashMap<String, DataTypeCacheInfo> getDataTypeThreadCache() {
        Object dimCacheInfo = ThreadCache.get((Object)dimDataTypeCache);
        HashMap<String, DataTypeCacheInfo> cachemap = new HashMap<String, DataTypeCacheInfo>(16);
        if (dimCacheInfo != null) {
            return (HashMap)dimCacheInfo;
        }
        return cachemap;
    }

    private static List<String> getUserDefinedThreadCache(long modelId) {
        return (List)ThreadCache.get((Object)(USER_DEFINED_DIM + modelId), () -> {
            ArrayList<String> userDefined = null;
            boolean realodFromDb = false;
            Object jsonStr = ThreadCache.get((Object)(USER_DEFINED_DIM + modelId));
            try {
                if (jsonStr != null) {
                    userDefined = (ArrayList<String>)jsonStr;
                } else {
                    realodFromDb = true;
                }
            }
            catch (Exception ex) {
                realodFromDb = true;
            }
            if (realodFromDb) {
                userDefined = new ArrayList<String>(10);
                QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                Collection col = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter[]{qFilter}, (String)"dseq").values();
                for (DynamicObject dot : col) {
                    if (!DataTypeUtil.isUserDefinedDim(dot.getString("number"))) continue;
                    userDefined.add(dot.getString("number"));
                }
                ThreadCache.put((Object)(USER_DEFINED_DIM + modelId), userDefined);
            }
            return userDefined;
        });
    }

    private static boolean isUserDefinedDim(String number) {
        return "bcm_userdefinedmembertree".equals(ChkCheckServiceHelper.getDimMembEntityNumByDimNum(number));
    }

    private static DataTypeEnum getDimensionDataType(long modelId, String dimNumber, String memberNumber, HashMap<String, DataTypeCacheInfo> cachemap) {
        if (cachemap.get(dimNumber) == null) {
            DataTypeCacheInfo acctCacheInfo = new DataTypeCacheInfo(modelId, DimensionServiceHelper.getDimMembEntityNumByDimNum(dimNumber), dimNumber);
            cachemap.put(dimNumber, acctCacheInfo);
        }
        return cachemap.get(dimNumber).getMemberDataTypeEnum(dimNumber, memberNumber);
    }

    private static void cacheDataTypeInfo2Thread(HashMap<String, DataTypeCacheInfo> cachemap) {
        ThreadCache.put((Object)dimDataTypeCache, cachemap);
    }
}

