/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.epm.epbs.common.util.EncryptUtils;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.util.ThrowableHelper;

public class DimMappingHelper {
    private static final Log LOG = LogFactory.getLog(DimMappingHelper.class);
    private static final String CUR_APP = "fi-bcm-business";
    private static final int HTTP_CONN_TIMEOUT = 3000;
    private static final int HTTP_READ_TIMEOUT = 10000;
    private static Map<String, String> REST_HEADER = new HashMap<String, String>(8);
    private static volatile String APP_SECU = null;

    public static void synchSrcdimBasedata(String number, String name, String entitynumber, String tracenumber, Long syssource, int srcSysType, int adapter) {
        DynamicObject buildObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_srcdimbasedata");
        buildObj.set("number", (Object)number);
        buildObj.set("name", (Object)name);
        buildObj.set("entitynumber", (Object)entitynumber);
        buildObj.set("syssource", (Object)syssource);
        buildObj.set("systype", (Object)srcSysType);
        buildObj.set("adapter", (Object)adapter);
        buildObj.set("tracenumber", (Object)tracenumber);
        DynamicObject srcdimDynObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_srcdimbasedata");
        SaveServiceHelper.save((IDataEntityType)srcdimDynObj.getDynamicObjectType(), (Object[])new Object[]{buildObj});
    }

    public static String getLoginTokenWithPass(String loginUserMobile, String passWord, DynamicObject tdpdatacenter) {
        String targetDomainContextUrl = null;
        String accountId = null;
        try {
            String appId = tdpdatacenter.getString("appid");
            String appSercet = tdpdatacenter.getString("password");
            appSercet = DimMappingHelper.decrypterPwd(appSercet);
            targetDomainContextUrl = tdpdatacenter.getString("address");
            accountId = tdpdatacenter.getString("datasource");
            String appToken = DimMappingHelper.getAppToken(targetDomainContextUrl, accountId, appId, appSercet);
            return DimMappingHelper.getAccessToken(targetDomainContextUrl, accountId, appToken, loginUserMobile, passWord);
        }
        catch (Exception e) {
            LOG.error(String.format("failed_remote_login: url: %s, accountId: %s, loginMobile: %s", targetDomainContextUrl, accountId, loginUserMobile), (Throwable)e);
            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)DimMappingHelper.loginRemoteFailed()), new Object[0]);
        }
    }

    private static String decrypterPwd(String password) {
        if (password.startsWith("DataPwd_")) {
            password = password.substring(8);
            return EncryptUtils.aesDecrypt((String)password);
        }
        return password;
    }

    private static String getAccessToken(String targetDomainContextUrl, String accountId, String appToken, String loginUserMobile, String passWord) throws IOException {
        HashMap<String, String> requestBody = new HashMap<String, String>(5);
        requestBody.put("user", loginUserMobile);
        requestBody.put("password", passWord);
        requestBody.put("apptoken", appToken);
        requestBody.put("tenantid", "");
        requestBody.put("accountId", accountId);
        requestBody.put("logintype", "2");
        String response = HttpClientUtils.postjson((String)(targetDomainContextUrl + "/api/login.do"), REST_HEADER, (String)JacksonUtils.toJson(requestBody), (int)3000, (int)10000);
        return (String)DimMappingHelper.extractResponseData(response).get("access_token");
    }

    private static String getAppToken(String targetDomainContextUrl, String accountId, String appId, String appSercet) throws IOException {
        HashMap<String, String> requestBody = new HashMap<String, String>(6);
        requestBody.put("appId", appId);
        requestBody.put("appSecuret", appSercet);
        requestBody.put("tenantid", "");
        requestBody.put("accountId", accountId);
        requestBody.put("language", "zh_CN");
        String response = HttpClientUtils.postjson((String)(targetDomainContextUrl + "/api/getAppToken.do"), REST_HEADER, (String)JacksonUtils.toJson(requestBody), (int)3000, (int)10000);
        return (String)DimMappingHelper.extractResponseData(response).get("app_token");
    }

    private static String getAccessToken(String targetDomainContextUrl, String accountId, String appToken, String loginUserMobile) throws IOException {
        HashMap<String, String> requestBody = new HashMap<String, String>(5);
        requestBody.put("user", loginUserMobile);
        requestBody.put("apptoken", appToken);
        requestBody.put("tenantid", "");
        requestBody.put("accountId", accountId);
        requestBody.put("usertype", "Mobile");
        String response = HttpClientUtils.postjson((String)(targetDomainContextUrl + "/api/login.do"), REST_HEADER, (String)JacksonUtils.toJson(requestBody), (int)3000, (int)10000);
        return (String)DimMappingHelper.extractResponseData(response).get("access_token");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getThirdAppPassword() {
        if (!Objects.isNull(APP_SECU)) return APP_SECU;
        Class<DimMappingHelper> clazz = DimMappingHelper.class;
        synchronized (DimMappingHelper.class) {
            if (!Objects.isNull(APP_SECU)) return APP_SECU;
            Properties p = new Properties();
            try (InputStream in = OlapServiceHelper.class.getClassLoader().getResourceAsStream("bcm/cm.properties");){
                p.load(in);
                APP_SECU = "V0ahHDEEDE" + p.getProperty("lynt_cyru");
            }
            catch (IOException e) {
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return APP_SECU;
        }
    }

    public static String loginRemoteFailed() {
        return ResManager.loadKDString((String)"\u767b\u5f55\u8fdc\u7a0b\u73af\u5883\u9274\u6743\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8fdc\u7a0b\u73af\u5883\u7b2c\u4e09\u65b9\u5e94\u7528\u914d\u7f6e\u3001\u7f51\u7edc\u4ee5\u53ca\u767b\u5f55\u8d26\u53f7\u662f\u5426\u6b63\u786e\u3002", (String)"ModelTransferMsg_1", (String)CUR_APP, (Object[])new Object[0]);
    }

    private static Map<String, Object> extractResponseData(String response) {
        Map responseBody = (Map)JacksonUtils.fromJson((String)response, Map.class);
        if ("success".equals(responseBody.get("state"))) {
            return (Map)responseBody.get("data");
        }
        throw new KDBizException((String)responseBody.get("errorMsg"));
    }
}

