/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.model.IIntegrationContext;
import kd.fi.bcm.business.integration.model.RelationModel;
import kd.fi.bcm.common.enums.integration.RelationEnum;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class IntegrationUtil {
    public static List<String> batchQuerySrc(IIntegrationContext ctx, String dim, List<RelationModel> relations) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("ssid", "=", ctx.getSrcsys().p1);
        HashSet<String> equalSet = new HashSet<String>();
        HashSet<String> inSet = new HashSet<String>();
        HashSet<String> betweenSet = new HashSet<String>();
        HashSet<String> likeSet = new HashSet<String>();
        for (RelationModel m : relations) {
            if (!dim.equals(m.getDim())) continue;
            List<String> srcMembers = m.getSrcMembers();
            switch (m.getRelation()) {
                case Equal: {
                    equalSet.addAll(srcMembers);
                    break;
                }
                case In: {
                    inSet.addAll(srcMembers);
                    break;
                }
                case Between: {
                    betweenSet.add(srcMembers.get(0) + ':' + srcMembers.get(1));
                    break;
                }
                case Like: {
                    likeSet.addAll(srcMembers);
                    break;
                }
            }
        }
        int filters = 0;
        inSet.addAll(equalSet);
        if (inSet.size() > 0) {
            qfBuilder.and("number", "in", inSet);
            ++filters;
        }
        String small = null;
        String big = null;
        String tmp = null;
        for (String s : betweenSet) {
            String[] arr = s.split(String.valueOf(':'));
            small = arr[0];
            if (small.compareTo(big = arr[1]) > 0) {
                tmp = small;
                small = big;
                big = tmp;
            }
            qfBuilder.or(new QFilter("number", ">=", (Object)small).and("number", "<=", (Object)big));
            ++filters;
        }
        for (String s : likeSet) {
            qfBuilder.or("number", "like", (Object)(s + "%"));
            ++filters;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (filters == 0) {
            return result;
        }
        QueryServiceHelper.query((String)"ds_orgunit", (String)"soid, number", (QFilter[])qfBuilder.toArray(), null).forEach(e -> {
            String value = e.getString("soid");
            if (!result.contains(value)) {
                result.add(value);
            }
        });
        return result;
    }

    public static void combineFilter(RelationModel m, Map<String, Set<String>> combineMap) {
        if (m == null) {
            return;
        }
        if (combineMap == null) {
            combineMap = new HashMap<String, Set<String>>();
        }
        Set value = combineMap.computeIfAbsent(m.getRelation().getNumber(), k -> new HashSet());
        List<String> srcMembers = m.getSrcMembers();
        switch (m.getRelation()) {
            case Equal: {
                value.addAll(srcMembers);
                break;
            }
            case In: {
                value.addAll(srcMembers);
                break;
            }
            case Between: {
                value.add(srcMembers.get(0) + ':' + srcMembers.get(1));
                break;
            }
            case Like: {
                value.addAll(srcMembers);
                break;
            }
        }
    }

    public static String getDimMembEntityNumByDimNum(String dimNum) {
        switch (dimNum) {
            case "Entity": {
                return "bcm_entitymembertree";
            }
            case "Account": {
                return "bcm_accountmembertree";
            }
            case "Year": {
                return "bcm_fymembertree";
            }
            case "Period": {
                return "bcm_periodmembertree";
            }
            case "Scenario": {
                return "bcm_scenemembertree";
            }
            case "Process": {
                return "bcm_processmembertree";
            }
            case "Currency": {
                return "bcm_currencymembertree";
            }
            case "AuditTrail": {
                return "bcm_audittrialmembertree";
            }
            case "ChangeType": {
                return "bcm_changetypemembertree";
            }
            case "InternalCompany": {
                return "bcm_icmembertree";
            }
            case "MultiGAAP": {
                return "bcm_rulemembertree";
            }
            case "DataType": {
                return "eb_datetypemembertree";
            }
            case "DataSort": {
                return "bcm_datasortmembertree";
            }
            case "MyCompany": {
                return "bcm_mycompanymembertree";
            }
        }
        return "bcm_userdefinedmembertree";
    }

    private static QFBuilder addQFilter(QFBuilder builder, String property, RelationEnum relation, String srcdim, Object value) {
        if (builder == null) {
            builder = new QFBuilder();
        }
        if (srcdim != null) {
            ((List)value).forEach(e -> {
                e = srcdim + ":" + e;
            });
        }
        if (relation == RelationEnum.Equal) {
            builder.add(property, "=", (Object)IntegrationUtil.getItem(value));
        } else if (relation == RelationEnum.In) {
            builder.add(property, "in", new HashSet((List)value));
        } else if (relation == RelationEnum.Between) {
            String big;
            List two = (List)value;
            String small = (String)two.get(0);
            if (small.compareTo(big = (String)two.get(1)) > 0) {
                String temp = small;
                small = big;
                big = temp;
            }
            builder.add(property, "<=", (Object)big);
            builder.add(property, ">=", (Object)small);
        } else if (relation == RelationEnum.Like) {
            builder.add(property, "like", (Object)(IntegrationUtil.getItem(value) + "%"));
        }
        return builder;
    }

    private static String getItem(Object value) {
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof List) {
            return (String)((List)value).get(0);
        }
        return value == null ? "" : value.toString();
    }

    public static QFBuilder addQFilter(QFBuilder builder, String property, RelationEnum relation, Object value) {
        return IntegrationUtil.addQFilter(builder, property, relation, null, value);
    }

    public static void debugSql(WatchLogger log, String table, QFBuilder builder, List<String> selectors) {
        if (!DebugServiceHelper.isDebugModel()) {
            return;
        }
        log.resetWatch();
        try {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)table);
            DataEntityPropertyCollection dataEntityPropertyCollection = dynamicObject.getDataEntityType().getProperties();
            ArrayList<String> wheres = new ArrayList<String>(builder.size());
            block2: for (QFilter filter : builder.toArray()) {
                for (IDataEntityProperty prop : dataEntityPropertyCollection) {
                    String name = prop.getName();
                    String alias = prop.getAlias();
                    if (!filter.getProperty().equalsIgnoreCase(name)) continue;
                    wheres.add(filter.toString().replace(name, alias));
                    continue block2;
                }
            }
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ").append(String.join((CharSequence)", ", selectors)).append('\n');
            sql.append("  FROM ").append(table).append('\n');
            sql.append(" WHERE ").append(String.join((CharSequence)" AND ", wheres)).append('\n');
            log.error(sql.insert(0, "--Integration debugSql--\n").toString());
        }
        catch (Throwable t) {
            log.error("--Integration debugSql--\n" + ThrowableHelper.toString((Throwable)t));
        }
    }
}

