/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.datacollet.DataCollectRowModel;
import kd.fi.bcm.business.serviceHelper.QueryTreenodeHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;

public class IntergrationUtil {
    public static Map<String, String> getAcctByTemplateMap(long templateid, long modelid, long orgid) {
        orgid = TreeStructureServiceHelper.getEntityBaseMemberId(orgid);
        List<String> orgparent = IntergrationUtil.getOrgParentNodeList(String.valueOf(modelid), String.valueOf(orgid));
        orgparent.add("0");
        HashMap<String, String> acctmap = new HashMap<String, String>(16);
        for (String orgnode : orgparent) {
            QFilter qf1 = new QFilter("template", "=", (Object)templateid);
            QFilter qf2 = new QFilter("org", "=", (Object)Long.parseLong(orgnode));
            String selectFields = "id,datafrom,dimkey,membkey,floatarea,floatindex";
            DynamicObjectCollection dcn = QueryServiceHelper.query((String)"bcm_intergration_entity", (String)selectFields, (QFilter[])new QFilter[]{qf1, qf2});
            for (DynamicObject dot : dcn) {
                String datafrom = dot.getString("datafrom");
                if (IntergrationUtil.checkExist(acctmap, dot) == null) continue;
                acctmap.put(IntergrationUtil.checkExist(acctmap, dot), datafrom);
            }
        }
        return acctmap;
    }

    public static Map<String, String> getAcctByOrg(long templateid, long modelid, long orgid0) {
        return (Map)ThreadCache.get((Object)("IntergrationUtil.gabo" + templateid + orgid0), () -> {
            long orgid = TreeStructureServiceHelper.getEntityBaseMemberId(orgid0);
            ArrayList<Long> orgparent = new ArrayList<Long>(4);
            orgparent.add(orgid);
            orgparent.add(0L);
            HashMap<String, String> acctmap = new HashMap<String, String>();
            for (Long orgnode : orgparent) {
                QFilter qf1 = new QFilter("template", "=", (Object)templateid);
                QFilter qf2 = new QFilter("org", "=", (Object)orgnode);
                String selectFields = "id,datafrom,dimkey,membkey,floatarea,floatindex";
                DynamicObjectCollection dcn = QueryServiceHelper.query((String)"bcm_intergration_entity", (String)selectFields, (QFilter[])new QFilter[]{qf1, qf2});
                for (DynamicObject dot : dcn) {
                    String datafrom = dot.getString("datafrom");
                    if (IntergrationUtil.checkExist(acctmap, dot) == null) continue;
                    acctmap.put(IntergrationUtil.checkExist(acctmap, dot), datafrom);
                }
            }
            return acctmap;
        });
    }

    public static Set<String> getAcctByTemplateSet(Set<String> templateIds, String modelid, String orgid) {
        List<String> orgparent = IntergrationUtil.getOrgParentNodeList(modelid, orgid);
        orgparent.add("0");
        HashMap<String, String> acctmap = new HashMap<String, String>(16);
        for (String orgnode : orgparent) {
            QFilter qf1 = new QFilter("template", "in", ConvertUtil.convertListToLong(templateIds));
            QFilter qf2 = new QFilter("org", "=", (Object)ConvertUtil.convertObjToLong(orgnode));
            String selectFields = "id,dimkey,membkey,template";
            DynamicObjectCollection dcn = QueryServiceHelper.query((String)"bcm_intergration_entity", (String)selectFields, (QFilter[])new QFilter[]{qf1, qf2});
            for (DynamicObject dot : dcn) {
                String dimkey = dot.getString("dimkey");
                String membkey = dot.getString("membkey");
                String fid = dot.getString("id");
                StringBuilder sb = new StringBuilder();
                sb.append(dimkey).append('&').append(membkey).append('&').append(dot.getLong("template"));
                if (acctmap.get(sb.toString()) != null) continue;
                acctmap.put(sb.toString(), fid);
            }
        }
        HashSet<String> set = new HashSet<String>(16);
        set.addAll(acctmap.values());
        return set;
    }

    public static Set<String> getAcctByTemplateSet(String templateid, String modelid, String orgid) {
        long orgId = TreeStructureServiceHelper.getEntityBaseMemberId(Long.parseLong(orgid));
        List<String> orgparent = IntergrationUtil.getOrgParentNodeList(modelid, Long.toString(orgId));
        orgparent.add("0");
        HashMap<String, String> acctmap = new HashMap<String, String>(16);
        QFilter qf1 = new QFilter("template", "=", (Object)Long.parseLong(templateid));
        QFilter qf2 = new QFilter("org", "in", ConvertUtil.convertListToLong(orgparent));
        String selectFields = "id,dimkey,membkey,org.id,floatarea,floatindex";
        DynamicObjectCollection allRules = QueryServiceHelper.query((String)"bcm_intergration_entity", (String)selectFields, (QFilter[])new QFilter[]{qf1, qf2});
        Map<String, List<DynamicObject>> org2Rules = IntergrationUtil.classRulesByOrg(allRules);
        for (String orgnode : orgparent) {
            List<DynamicObject> rules = org2Rules.get(orgnode);
            if (rules == null) continue;
            for (DynamicObject dot : rules) {
                IntergrationUtil.addRulesToMap(acctmap, dot);
            }
        }
        HashSet<String> set = new HashSet<String>(16);
        set.addAll(acctmap.values());
        return set;
    }

    public static Set<String> getAcctByTemplateAndOrg(String templateid, String modelid, String orgid) {
        HashMap<String, String> acctmap = new HashMap<String, String>();
        QFilter qf1 = new QFilter("template", "=", (Object)Long.parseLong(templateid));
        QFilter qf2 = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        String selectFields = "id,dimkey,membkey,org.id,floatarea,floatindex";
        DynamicObjectCollection allRules = QueryServiceHelper.query((String)"bcm_intergration_entity", (String)selectFields, (QFilter[])new QFilter[]{qf1, qf2});
        Map<String, List<DynamicObject>> org2Rules = IntergrationUtil.classRulesByOrg(allRules);
        List<DynamicObject> rules = org2Rules.get(orgid);
        if (rules != null) {
            for (DynamicObject dot : rules) {
                IntergrationUtil.addRulesToMap(acctmap, dot);
            }
        }
        return new HashSet<String>(acctmap.values());
    }

    public static Map<String, List<DynamicObject>> classRulesByOrg(DynamicObjectCollection dcn) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(16);
        if (dcn != null) {
            for (DynamicObject dot : dcn) {
                String org = dot.getString("org.id");
                List dynamicObjectList = (List)map.get(org);
                if (null != dynamicObjectList) {
                    dynamicObjectList.add(dot);
                    continue;
                }
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
                list.add(dot);
                map.put(org, list);
            }
        }
        return map;
    }

    public static void addRulesToMap(Map<String, String> acctmap, DynamicObject dot) {
        String key = IntergrationUtil.checkExist(acctmap, dot);
        String fid = dot.getString("id");
        if (key != null) {
            acctmap.put(key, fid);
        }
    }

    public static Set<String> getAcctByOrg(String modelid, Long orgid) {
        return IntergrationUtil.getAcctByTemplateSet(TemplateDistributionOrgUtil.getOrgDisTemplateSet(modelid, orgid), modelid, orgid + "");
    }

    public static List<String> getOrgParentNodeList(String modelid, String orgid) {
        List<Map<String, String>> treeList = (List<Map<String, String>>)ThreadCache.get((Object)("bcm_entitymembertree" + modelid));
        if (treeList == null) {
            treeList = QueryTreenodeHelper.getallnode("bcm_entitymembertree", modelid);
            ThreadCache.put((Object)("bcm_entitymembertree" + modelid), treeList);
        }
        ArrayList<String> orgparent = new ArrayList<String>(10);
        orgparent.add(orgid);
        orgparent.addAll(QueryTreenodeHelper.queryAllParentNodeList(orgid, new ArrayList<String>(10), treeList));
        return orgparent;
    }

    public static Map<Long, List<String>> getOrgParentNodeLists(String modelid, Set<Long> orgids) {
        List<Map<String, String>> treeList = QueryTreenodeHelper.getallnode("bcm_entitymembertree", modelid);
        HashMap<Long, List<String>> orgToParents = new HashMap<Long, List<String>>(orgids.size());
        for (Long id : orgids) {
            ArrayList<String> orgparent = new ArrayList<String>(10);
            orgparent.add(String.valueOf(id));
            orgparent.addAll(QueryTreenodeHelper.queryAllParentNodeList(String.valueOf(id), new ArrayList<String>(10), treeList));
            orgparent.add("0");
            orgToParents.put(id, orgparent);
        }
        return orgToParents;
    }

    public static String getAccountBookMetadataNumber() {
        String str = "select fid from t_meta_formdesign where fnumber = ? ";
        DataSet result = DB.queryDataSet((String)"IntergrationUtil", (DBRoute)DBRoute.meta, (String)str, (Object[])new Object[]{"bd_accountbooks"});
        if (result.hasNext()) {
            return "bd_accountbooks";
        }
        return "gl_accountbook";
    }

    public static Multimap<Long, DynamicObject> getAcctByTemplateSets(List<DataCollectRowModel> dataCollectRows, String modelid, Set<Long> orgids, String selectors) {
        HashMultimap result = HashMultimap.create();
        Map<Long, List<String>> orgparent = IntergrationUtil.getOrgParentNodeLists(modelid, orgids);
        HashSet templateIds = new HashSet(16);
        HashMultimap orgToTmp = HashMultimap.create();
        dataCollectRows.forEach(arg_0 -> IntergrationUtil.lambda$getAcctByTemplateSets$1(templateIds, (Multimap)orgToTmp, arg_0));
        QFilter qf1 = new QFilter("template", "in", templateIds);
        List<String> select = Arrays.asList("org.longnumber", "org.id", "template.id", "dimkey", "membkey", "floatarea", "floatindex");
        StringBuilder sb = new StringBuilder(selectors);
        if (!sb.toString().startsWith("id") && !sb.toString().contains(",id")) {
            sb.insert(0, "id,");
        }
        select.forEach(s -> {
            if (!sb.toString().contains((CharSequence)s)) {
                sb.append(',').append((String)s);
            }
        });
        DynamicObjectCollection dcn = QueryServiceHelper.query((String)"bcm_intergration_entity", (String)sb.toString(), (QFilter[])new QFilter[]{qf1}, (String)"org.longnumber desc");
        HashMultimap orgmap = HashMultimap.create();
        for (DynamicObject obj : dcn) {
            String orgid = obj.getString("org.id");
            orgmap.put((Object)orgid, (Object)obj);
        }
        for (DataCollectRowModel dataCollectRowModel : dataCollectRows) {
            HashMap<String, DynamicObject> acctmap = new HashMap<String, DynamicObject>(16);
            List<String> parents = orgparent.get(dataCollectRowModel.getOrgid());
            for (String oid : parents) {
                Collection cols = orgmap.get((Object)oid);
                for (DynamicObject rule : cols) {
                    if (rule.getLong("template.id") != dataCollectRowModel.getTemplateid()) continue;
                    IntergrationUtil.addRulesObjToMap(acctmap, rule);
                }
            }
            result.putAll((Object)dataCollectRowModel.getOrgid(), acctmap.values());
        }
        return result;
    }

    public static void addRulesObjToMap(Map<String, DynamicObject> acctmap, DynamicObject dot) {
        String key = IntergrationUtil.checkExist(acctmap, dot);
        if (key != null) {
            acctmap.put(key, dot);
        }
    }

    private static String checkExist(Map acctmap, DynamicObject dot) {
        String dimkey = dot.getString("dimkey");
        String membkey = dot.getString("membkey");
        String floatarea = dot.getString("floatarea");
        String floatindex = dot.getString("floatindex");
        StringBuilder sb = new StringBuilder();
        sb.append(dimkey).append('&').append(membkey);
        if (StringUtils.isNotEmpty((String)floatarea) && StringUtils.isNotEmpty((String)floatindex)) {
            if (!acctmap.containsKey(floatarea + "&" + floatindex)) {
                return floatarea + "&" + floatindex;
            }
        } else if (acctmap.get(sb.toString()) == null) {
            return sb.toString();
        }
        return null;
    }

    private static /* synthetic */ void lambda$getAcctByTemplateSets$1(Set templateIds, Multimap orgToTmp, DataCollectRowModel d) {
        templateIds.add(d.getTemplateid());
        orgToTmp.put((Object)d.getOrgid(), (Object)d.getTemplateid());
    }
}

