/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.enums.integration.AdapterEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.enums.integration.PeriodTypeEnum;
import kd.fi.bcm.common.enums.integration.RptSrcTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class SyncServiceHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(SyncServiceHelper.class);

    public static Object syncToDs2(Map<String, Object> syncParam, int type) {
        JSONObject obj = new JSONObject();
        obj.put("action", (Object)"save");
        obj.put("taskId", (Object)"1");
        obj.put("solution", (Object)(syncParam.get("srcsysnumber") + "_" + "EASSYNCQ"));
        obj.put("sync", (Object)"1");
        JSONObject filterObj = new JSONObject();
        JSONObject data = new JSONObject();
        if (type == 1) {
            Object object = syncParam.get("baseDatas");
            if (object instanceof List) {
                List baseDatas = (List)object;
                for (String key : baseDatas) {
                    data.put(key, null);
                }
            } else {
                data.put("t_ds_orgunit", null);
                data.put("t_ds_period", null);
                data.put("t_ds_accountbanks", null);
                data.put("t_ds_industry", null);
                data.put("t_ds_cashflowitem", null);
                data.put("t_ds_customer", null);
                data.put("t_ds_supplier", null);
                data.put("t_ds_bank", null);
                data.put("t_ds_person", null);
                data.put("t_ds_costcenter", null);
                data.put("t_ds_country", null);
                data.put("t_ds_province", null);
                data.put("t_ds_city", null);
                data.put("t_ds_inneraccount", null);
                data.put("t_ds_material", null);
                data.put("t_ds_company", null);
                data.put("t_ds_costitem", null);
                data.put("t_ds_project", null);
                data.put("t_ds_costobject", null);
                data.put("t_ds_rptitem", null);
                data.put("t_ds_account", null);
                data.put("t_ds_accounttable", null);
                data.put("t_ds_asstactgroup", null);
                data.put("t_ds_asstact", null);
                data.put("t_ds_asstacttype", null);
                data.put("t_ds_changetype", null);
                data.put("t_ds_currency", null);
            }
        } else if (type == 2 && syncParam.get("adapter") != null && AdapterEnum.EASGL2IERP == syncParam.get("adapter")) {
            String version;
            String filter = "t1.fperiod='" + syncParam.get("period") + "'";
            Object srcsysversion = syncParam.get("srcsysversion");
            String string = version = srcsysversion != null ? srcsysversion.toString() : "";
            if ("800".equals(version)) {
                data.put("t_ds_accountbalance", (Object)filter);
                data.put("t_ds_assistbalance", (Object)filter);
            } else {
                data.put("t_ds_accountbalance_5f", (Object)filter);
                data.put("t_ds_assistbalance_5f", (Object)filter);
            }
        }
        filterObj.put("filter", (Object)data);
        obj.put("data", (Object)filterObj);
        return DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCSchemaExecutorService", (String)"execute", (Object[])new Object[]{obj.toString()});
    }

    public static Object syncToDs(Map<String, Object> syncParam) {
        if (!syncParam.containsKey("schemes")) {
            return null;
        }
        List schemes = (List)syncParam.get("schemes");
        Object tempFilter = syncParam.get("filter");
        Map filter = tempFilter != null ? (Map)tempFilter : new HashMap();
        ArrayList exeNumbers = new ArrayList();
        schemes.forEach(e -> exeNumbers.add(DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"execute", (Object[])new Object[]{e, filter})));
        return exeNumbers.get(exeNumbers.size() - 1);
    }

    public static List<Map<String, Object>> copyToDsAsync(Map<String, Object> syncParam) {
        if (!syncParam.containsKey("schemes")) {
            return null;
        }
        HashMap<String, String> callback = new HashMap<String, String>();
        callback.put("cloud_id", "fi");
        callback.put("app_id", "bcm");
        callback.put("service_name", "IntegrationMsService");
        callback.put("method_name", "execute");
        List schemes = (List)syncParam.get("schemes");
        Object tempFilter = syncParam.get("filter");
        Map filter = tempFilter != null ? (Map)tempFilter : new HashMap();
        ArrayList<Map<String, Object>> exeNumbers = new ArrayList<Map<String, Object>>(schemes.size());
        for (int i = 0; i < schemes.size(); ++i) {
            Map retMap;
            HashMap<String, String> cb = null;
            if (i == schemes.size() - 1) {
                cb = callback;
            }
            if ((retMap = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"execute", (Object[])new Object[]{schemes.get(i), filter, cb})) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"ISCDataCopyService.execute \u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"SyncServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (!Boolean.TRUE.equals(retMap.get("success"))) {
                throw new KDBizException(retMap.get("msg").toString());
            }
            exeNumbers.add(retMap);
        }
        return exeNumbers;
    }

    public static List<Map<String, Object>> copyToNewDsAsync(Map<String, Object> syncParam, DynamicObject logDyn) {
        if (!syncParam.containsKey("schemes")) {
            return null;
        }
        HashMap<String, String> callback = new HashMap<String, String>();
        callback.put("cloud_id", "fi");
        callback.put("app_id", "bcm");
        callback.put("service_name", "IntegrationMsService");
        callback.put("method_name", "executeScheme");
        List schemes = (List)syncParam.get("schemes");
        Object tempFilter = syncParam.get("filter");
        Map filter = tempFilter != null ? (Map)tempFilter : new HashMap();
        ArrayList<Map<String, Object>> exeNumbers = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < schemes.size(); ++i) {
            Map retMap;
            if (logDyn.getInt("collectstatus") == CollectStatusEnum.ISCFAIL.getValue()) continue;
            HashMap<String, String> cb = null;
            if (i == schemes.size() - 1) {
                cb = callback;
            }
            if ((retMap = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"execute", (Object[])new Object[]{schemes.get(i), filter, cb})) == null) {
                logDyn.set("collectstatus", (Object)CollectStatusEnum.ISCFAIL.getValue());
            } else if (!Boolean.TRUE.equals(retMap.get("success"))) {
                logDyn.set("collectstatus", (Object)CollectStatusEnum.ISCFAIL.getValue());
            }
            if (cb == null) continue;
            exeNumbers.add(retMap);
        }
        return exeNumbers;
    }

    public static List<String> getEASBDCopySchemes() {
        ArrayList<String> schemes = new ArrayList<String>(27);
        schemes.add("T_DS_PERIOD");
        schemes.add("T_DS_ACCOUNTBANKS");
        schemes.add("T_DS_INDUSTRY");
        schemes.add("T_DS_CASHFLOWITEM");
        schemes.add("T_DS_CUSTOMER");
        schemes.add("T_DS_ORGUNIT");
        schemes.add("T_DS_SUPPLIER");
        schemes.add("T_DS_BANK");
        schemes.add("T_DS_PERSON");
        schemes.add("T_DS_COSTCENTER");
        schemes.add("T_DS_COUNTRY");
        schemes.add("T_DS_PROVINCE");
        schemes.add("T_DS_CITY");
        schemes.add("T_DS_INNERACCOUNT");
        schemes.add("T_DS_MATERIAL");
        schemes.add("T_DS_COMPANY");
        schemes.add("T_DS_COSTITEM");
        schemes.add("T_DS_PROJECT");
        schemes.add("T_DS_COSTOBJECT");
        schemes.add("T_DS_RPTITEM");
        schemes.add("T_DS_DATAELEMENT");
        schemes.add("T_DS_ACCOUNT");
        schemes.add("T_DS_ACCOUNTTABLE");
        schemes.add("T_DS_ASSTACTGROUP");
        schemes.add("T_DS_ASSTACT");
        schemes.add("T_DS_ASSTACTTYPE");
        schemes.add("T_DS_CURRENCY");
        return schemes;
    }

    public static void syncPreset2Ds(Map<String, Object> syncParam) {
        QFBuilder builder = new QFBuilder();
        builder.add("ssid", "=", syncParam.get("srcsysid"));
        if (!QueryServiceHelper.exists((String)"ds_fiscalperiod", (QFilter[])builder.toArray())) {
            Long ssid = (Long)syncParam.get("srcsysid");
            try (TXHandle tx = TX.required();){
                try {
                    SyncServiceHelper.syncFiscalPeriod(ssid);
                    SyncServiceHelper.syncFiscalYear(ssid);
                    SyncServiceHelper.syncChangeType(ssid);
                    SyncServiceHelper.syncReportType(ssid);
                    SyncServiceHelper.syncReportPeriod(ssid);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw new KDBizException(e.toString());
                }
            }
        }
        builder.add("number", "=", (Object)RptSrcTypeEnum.SUMREPORT.getNumber());
        if (!QueryServiceHelper.exists((String)"ds_reporttype", (QFilter[])builder.toArray())) {
            Long ssid1 = (Long)syncParam.get("srcsysid");
            ArrayList<DynamicObject> reporttypeList = new ArrayList<DynamicObject>();
            reporttypeList.add(SyncServiceHelper.buildReportTypeDyn(ssid1, GlobalIdUtil.genStringId(), RptSrcTypeEnum.SUMREPORT.getNumber(), RptSrcTypeEnum.SUMREPORT.getName()));
            reporttypeList.add(SyncServiceHelper.buildReportTypeDyn(ssid1, GlobalIdUtil.genStringId(), RptSrcTypeEnum.DYNAMICSUMREPORT.getNumber(), RptSrcTypeEnum.DYNAMICSUMREPORT.getName()));
            DynamicObject reporttype = BusinessDataServiceHelper.newDynamicObject((String)"ds_reporttype");
            SaveServiceHelper.save((IDataEntityType)reporttype.getDynamicObjectType(), (Object[])reporttypeList.toArray(new Object[0]));
        }
    }

    private static void syncReportPeriod(Long ssid) {
        ArrayList<DynamicObject> dynaobjs = new ArrayList<DynamicObject>(PeriodTypeEnum.values().length);
        for (PeriodTypeEnum e : PeriodTypeEnum.values()) {
            DynamicObject dynaobj = BusinessDataServiceHelper.newDynamicObject((String)"ds_reportperiod");
            dynaobj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dynaobj.set("ssid", (Object)ssid);
            dynaobj.set("soid", (Object)GlobalIdUtil.genStringId());
            dynaobj.set("number", (Object)e.getNumber());
            dynaobj.set("name", (Object)e.getName());
            dynaobjs.add(dynaobj);
        }
        DynamicObject dynaobj = BusinessDataServiceHelper.newDynamicObject((String)"ds_reportperiod");
        SaveServiceHelper.save((IDataEntityType)dynaobj.getDynamicObjectType(), (Object[])dynaobjs.toArray(new Object[0]));
    }

    public static void syncFiscalPeriod(Long ssid) {
        ArrayList<DynamicObject> fiscalperiodList = new ArrayList<DynamicObject>(14);
        for (int i = 1; i < 14; ++i) {
            DynamicObject dynaobj = BusinessDataServiceHelper.newDynamicObject((String)"ds_fiscalperiod");
            dynaobj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dynaobj.set("ssid", (Object)ssid);
            dynaobj.set("soid", (Object)GlobalIdUtil.genStringId());
            dynaobj.set("number", (Object)i);
            dynaobj.set("name", (Object)String.format(ResManager.loadKDString((String)"%s\u671f", (String)"SyncServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), i));
            fiscalperiodList.add(dynaobj);
        }
        DynamicObject fiscalPeriod = BusinessDataServiceHelper.newDynamicObject((String)"ds_fiscalperiod");
        SaveServiceHelper.save((IDataEntityType)fiscalPeriod.getDynamicObjectType(), (Object[])fiscalperiodList.toArray(new Object[0]));
    }

    public static void syncFiscalYear(Long ssid) {
        ArrayList<DynamicObject> fiscalyearList = new ArrayList<DynamicObject>(90);
        boolean language = Lang.get().equals((Object)Lang.zh_CN) || Lang.get().equals((Object)Lang.zh_TW);
        String year = ResManager.getLocaleString((String)"\u5e74", (String)"IntegrationUtil_2", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        for (int i = 2010; i < 2100; ++i) {
            DynamicObject dynaobj = BusinessDataServiceHelper.newDynamicObject((String)"ds_fiscalyear");
            dynaobj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dynaobj.set("ssid", (Object)ssid);
            dynaobj.set("soid", (Object)GlobalIdUtil.genStringId());
            dynaobj.set("number", (Object)i);
            dynaobj.set("name", (Object)i);
            if (language) {
                dynaobj.set("name", (Object)(i + year));
            }
            fiscalyearList.add(dynaobj);
        }
        DynamicObject fiscalYear = BusinessDataServiceHelper.newDynamicObject((String)"ds_fiscalyear");
        SaveServiceHelper.save((IDataEntityType)fiscalYear.getDynamicObjectType(), (Object[])fiscalyearList.toArray(new Object[0]));
    }

    public static void syncChangeType(Long ssid) {
        ArrayList<DynamicObject> changetypeList = new ArrayList<DynamicObject>(31);
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "BeginBalanceFor", ResManager.loadKDString((String)"\u521d\u59cb\u4f59\u989d\u539f\u5e01", (String)"SyncServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "YearDebitFor", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u501f\u65b9\u539f\u5e01", (String)"SyncServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "YearCreditFor", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u8d37\u65b9\u539f\u5e01", (String)"SyncServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "DebitFor", ResManager.loadKDString((String)"\u672c\u671f\u501f\u65b9\u53d1\u751f\u539f\u5e01", (String)"SyncServiceHelper_6", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "CreditFor", ResManager.loadKDString((String)"\u672c\u671f\u8d37\u65b9\u53d1\u751f\u539f\u5e01", (String)"SyncServiceHelper_7", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "EndBalanceFor", ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d\u539f\u5e01", (String)"SyncServiceHelper_8", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "BeginBalanceLocal", ResManager.loadKDString((String)"\u521d\u59cb\u4f59\u989d\u672c\u4f4d\u5e01", (String)"SyncServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "YearDebitLocal", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u501f\u65b9\u672c\u4f4d\u5e01", (String)"SyncServiceHelper_10", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "YearCreditLocal", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u8d37\u65b9\u672c\u4f4d\u5e01", (String)"SyncServiceHelper_11", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "DebitLocal", ResManager.loadKDString((String)"\u672c\u671f\u501f\u65b9\u672c\u4f4d\u5e01", (String)"SyncServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "CreditLocal", ResManager.loadKDString((String)"\u672c\u671f\u8d37\u65b9\u672c\u4f4d\u5e01", (String)"SyncServiceHelper_13", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "EndBalanceLocal", ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d\u672c\u4f4d\u5e01", (String)"SyncServiceHelper_14", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "BeginBalanceRpt", ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d\u62a5\u544a\u5e01", (String)"SyncServiceHelper_15", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "YearDebitRpt", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u501f\u65b9\u62a5\u544a\u5e01", (String)"SyncServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "YearCreditRpt", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u8d37\u65b9\u62a5\u544a\u5e01", (String)"SyncServiceHelper_17", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "DebitRpt", ResManager.loadKDString((String)"\u672c\u671f\u501f\u65b9\u62a5\u544a\u5e01", (String)"SyncServiceHelper_18", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "CreditRpt", ResManager.loadKDString((String)"\u672c\u671f\u8d37\u65b9\u62a5\u544a\u5e01", (String)"SyncServiceHelper_19", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "EndBalanceRpt", ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d\u62a5\u544a\u5e01", (String)"SyncServiceHelper_20", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "YearPnLFor", ResManager.loadKDString((String)"\u672c\u5e74\u635f\u76ca\u53d1\u751f\u989d\u539f\u5e01", (String)"SyncServiceHelper_21", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "MonthPnLFor", ResManager.loadKDString((String)"\u672c\u671f\u635f\u76ca\u53d1\u751f\u989d\u539f\u5e01", (String)"SyncServiceHelper_22", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "YearPnLLocal", ResManager.loadKDString((String)"\u672c\u5e74\u635f\u76ca\u53d1\u751f\u989d\u672c\u4f4d\u5e01", (String)"SyncServiceHelper_23", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "MonthPnLLocal", ResManager.loadKDString((String)"\u672c\u671f\u635f\u76ca\u53d1\u751f\u989d\u672c\u4f4d\u5e01", (String)"SyncServiceHelper_24", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "YearPnLRpt", ResManager.loadKDString((String)"\u672c\u5e74\u635f\u76ca\u53d1\u751f\u989d\u62a5\u544a\u5e01", (String)"SyncServiceHelper_25", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "MonthPnLRpt", ResManager.loadKDString((String)"\u672c\u671f\u635f\u76ca\u53d1\u751f\u989d\u62a5\u544a\u5e01", (String)"SyncServiceHelper_26", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "BeginQty", ResManager.loadKDString((String)"\u671f\u521d\u6570\u91cf\u4f59\u989d", (String)"SyncServiceHelper_27", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "YearDebitQty", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u501f\u65b9\u6570\u91cf", (String)"SyncServiceHelper_28", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "YearCreditQty", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u8d37\u65b9\u6570\u91cf", (String)"SyncServiceHelper_29", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "DebitQty", ResManager.loadKDString((String)"\u672c\u671f\u501f\u65b9\u6570\u91cf", (String)"SyncServiceHelper_30", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "CreditQty", ResManager.loadKDString((String)"\u672c\u671f\u8d37\u65b9\u6570\u91cf", (String)"SyncServiceHelper_31", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "EndQty", ResManager.loadKDString((String)"\u671f\u672b\u6570\u91cf\u4f59\u989d", (String)"SyncServiceHelper_32", (String)"fi-bcm-business", (Object[])new Object[0])));
        changetypeList.add(SyncServiceHelper.buildChangeTypeDyn(ssid, GlobalIdUtil.genStringId(), "DetailCount", ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u6b21\u6570", (String)"SyncServiceHelper_33", (String)"fi-bcm-business", (Object[])new Object[0])));
        DynamicObject changetype = BusinessDataServiceHelper.newDynamicObject((String)"ds_changetype");
        SaveServiceHelper.save((IDataEntityType)changetype.getDynamicObjectType(), (Object[])changetypeList.toArray(new Object[0]));
    }

    public static DynamicObject buildChangeTypeDyn(Long ssid, String soid, String number, String name) {
        DynamicObject dynaobj = BusinessDataServiceHelper.newDynamicObject((String)"ds_changetype");
        dynaobj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dynaobj.set("ssid", (Object)ssid);
        dynaobj.set("soid", (Object)soid);
        dynaobj.set("number", (Object)number);
        dynaobj.set("name", (Object)name);
        return dynaobj;
    }

    public static void syncReportType(Long ssid) {
        ArrayList<DynamicObject> reporttypeList = new ArrayList<DynamicObject>(RptSrcTypeEnum.values().length);
        for (RptSrcTypeEnum e : RptSrcTypeEnum.values()) {
            reporttypeList.add(SyncServiceHelper.buildReportTypeDyn(ssid, GlobalIdUtil.genStringId(), e.getNumber(), e.getName()));
        }
        DynamicObject reporttype = BusinessDataServiceHelper.newDynamicObject((String)"ds_reporttype");
        SaveServiceHelper.save((IDataEntityType)reporttype.getDynamicObjectType(), (Object[])reporttypeList.toArray(new Object[0]));
    }

    public static DynamicObject buildReportTypeDyn(Long ssid, String soid, String number, String name) {
        DynamicObject dynaobj = BusinessDataServiceHelper.newDynamicObject((String)"ds_reporttype");
        dynaobj.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dynaobj.set("ssid", (Object)ssid);
        dynaobj.set("soid", (Object)soid);
        dynaobj.set("number", (Object)number);
        dynaobj.set("name", (Object)name);
        return dynaobj;
    }
}

