/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.fel.common.StringUtils;

public class TransFormulaUtil {
    public static String transGLGroup2Acct(String glMemberGroup) {
        if (!TransFormulaUtil.check(glMemberGroup)) {
            return null;
        }
        Map<String, String> memberMap = TransFormulaUtil.getMemberMap(glMemberGroup);
        String entity = memberMap.remove("Entity");
        String bookType = memberMap.remove("AccountBookType");
        Pair<String, String> period = TransFormulaUtil.getGLPeriod(memberMap.remove("Period"));
        String changeType = memberMap.remove("ChangeType");
        String currency = memberMap.remove("Currency");
        if (ResManager.loadKDString((String)"\u7efc\u5408\u672c\u4f4d\u5e01", (String)"TransFormulaUtil_0", (String)"fi-bcm-business", (Object[])new Object[0]).equals(currency)) {
            currency = "";
        }
        Pair<String, String> accountAndComassist = TransFormulaUtil.getAccountAndComassist(memberMap);
        StringBuilder sb = new StringBuilder();
        sb.append("ACCT(\"");
        sb.append(entity);
        sb.append("\",\"");
        sb.append(bookType);
        sb.append("\",\"");
        sb.append((String)accountAndComassist.p1);
        sb.append("\",\"");
        sb.append(changeType);
        sb.append("\",");
        sb.append((String)period.p1);
        if (NumberUtils.isNumber((String)((String)period.p2))) {
            sb.append(",");
            sb.append((String)period.p2);
            sb.append(",\"");
        } else {
            sb.append(",\"");
            sb.append((String)period.p2);
            sb.append("\",\"");
        }
        sb.append(currency);
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)accountAndComassist.p2))) {
            sb.append("\",\"");
            sb.append("\",\"");
            sb.append("\",\"");
            sb.append((String)accountAndComassist.p2);
        }
        sb.append("\")");
        return sb.toString();
    }

    private static Map<String, String> getMemberMap(String glMemberGroup) {
        String[] members = glMemberGroup.split("\uff0c");
        HashMap<String, String> memberMap = new HashMap<String, String>(members.length);
        for (String member : members) {
            String value = member.split("\uff1a")[1];
            String key = member.split("\\|")[0];
            memberMap.put(key, value);
        }
        return memberMap;
    }

    private static Pair<String, String> getAccountAndComassist(Map<String, String> memberMap) {
        String account = memberMap.remove("AccountView");
        StringBuilder sb = new StringBuilder();
        StringBuilder comassistSb = new StringBuilder();
        sb.append(account);
        sb.append("|");
        memberMap.forEach((k, v) -> {
            if (v != null && !"null".equals(v)) {
                String[] temp = k.split("/");
                if (temp.length == 1) {
                    sb.append((String)k).append("|").append((String)v).append("|");
                } else if ("comassist".equals(temp[0])) {
                    comassistSb.append(temp[1]).append("|").append((String)v).append("|");
                } else {
                    sb.append(temp[1]).append("|").append((String)v).append("|");
                }
            }
        });
        String asst = "";
        String comassist = "";
        if (sb.length() > 0) {
            asst = sb.substring(0, sb.length() - 1);
        }
        if (comassistSb.length() > 0) {
            comassist = comassistSb.substring(0, comassistSb.length() - 1);
        }
        return Pair.onePair((Object)asst, (Object)comassist);
    }

    private static Pair<String, String> getGLPeriod(String glPeriod) {
        String year = glPeriod.substring(0, 4);
        String periodNum = glPeriod.substring(4);
        if (periodNum.contains("T") && NumberUtils.isNumber((String)(periodNum = periodNum.replace("T", "")))) {
            int period = Integer.parseInt(periodNum);
            periodNum = period > 12 ? period + "" : period + "T";
        }
        return Pair.onePair((Object)year, (Object)periodNum);
    }

    private static boolean check(String glMemberGroup) {
        String pattern = "[a-zA-Z0-9|\\S:a-zA-Z0-9\uff0c]+";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(glMemberGroup);
        return m.matches();
    }
}

