/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.BCMConstant;

public class ReportRpaDataAPI
implements ISkillRunnable {
    public SkillRunResult pullData(SkillRunContext runContext) {
        SkillRunResult skillResult = runContext.getSkillResult();
        String skillNum = runContext.getSkillNum();
        Date startTime = runContext.getStartTime();
        Date endTime = runContext.getEndTime();
        HashMap<String, String> param1Map = new HashMap<String, String>();
        param1Map.put("name", ResManager.loadKDString((String)"RPA\u6267\u884c\u7684\u7ec4\u7ec7\u603b\u6570", (String)"ReportRpaDataAPI_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        param1Map.put("value", Integer.toString(this.getAllRpaEntityCount()));
        param1Map.put("valueType", "0");
        param1Map.put("number", "rpazzdzzzs");
        HashMap<String, String> param2Map = new HashMap<String, String>();
        param2Map.put("name", ResManager.loadKDString((String)"RPA\u6267\u884c\u6210\u529f\u7684\u7ec4\u7ec7\u603b\u6570", (String)"ReportRpaDataAPI_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        param2Map.put("value", Integer.toString(this.getAllRpaEntitySuccessCount()));
        param2Map.put("valueType", "0");
        param2Map.put("number", "rpazxcgdzzzs");
        HashMap<String, String> param3Map = new HashMap<String, String>();
        param3Map.put("name", ResManager.loadKDString((String)"RPA\u6d41\u7a0b\u88ab\u8c03\u8d77\u7684\u6b21\u6570", (String)"ReportRpaDataAPI_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        param3Map.put("value", Integer.toString(this.getAllRpaCount()));
        param3Map.put("valueType", "0");
        param3Map.put("number", "rpalcbdqdcs");
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        list.add(param1Map);
        list.add(param2Map);
        list.add(param3Map);
        skillResult.setData(list);
        skillResult.setDate(runContext.getStartTime());
        skillResult.setSkillNum(skillNum);
        skillResult.setFailCount(Integer.valueOf(this.getFailedCountByTime(startTime, endTime)));
        skillResult.setTotalCount(Integer.valueOf(this.getAllCountByTime(startTime, endTime)));
        return skillResult;
    }

    private int getAllCountByTime(Date startTime, Date endTime) {
        String selectFields = "count(*) as num";
        QFilter startTimeQFilter = new QFilter("executiondate", ">=", (Object)startTime);
        QFilter endTimeQFilter = new QFilter("executiondate", "<=", (Object)endTime);
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bcm_rpaschemetask", (String)selectFields, (QFilter[])new QFilter[]{startTimeQFilter, endTimeQFilter});
        if (collections != null && collections.size() > 0) {
            Integer num = Integer.parseInt(((DynamicObject)collections.get(0)).get("num").toString());
            return num;
        }
        return 0;
    }

    private int getFailedCountByTime(Date startTime, Date endTime) {
        String selectFields = "count(*) as num";
        QFilter startTimeQFilter = new QFilter("executiondate", ">=", (Object)startTime);
        QFilter endTimeQFilter = new QFilter("executiondate", "<=", (Object)endTime);
        QFilter failedQFilter = new QFilter("status", "=", (Object)"2");
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bcm_rpaschemetask", (String)selectFields, (QFilter[])new QFilter[]{startTimeQFilter, endTimeQFilter, failedQFilter});
        if (collections != null && collections.size() > 0) {
            Integer num = Integer.parseInt(((DynamicObject)collections.get(0)).get("num").toString());
            return num;
        }
        return 0;
    }

    private int getAllRpaEntityCount() {
        String queryData = "select count(*) as num from ( select distinct(fentityid) from T_BCM_RPASCHEMETASK) t";
        DataSet allRpaEntityCount = DB.queryDataSet((String)"select_AllRpaEntityCount", (DBRoute)BCMConstant.DBROUTE, (String)queryData);
        if (allRpaEntityCount != null) {
            String count = allRpaEntityCount.next().getString("num");
            return Integer.parseInt(count);
        }
        return 0;
    }

    private int getAllRpaEntitySuccessCount() {
        String queryData = "select count(*) as num from ( select distinct(fentityid) from T_BCM_RPASCHEMETASK where fstatus ='1') t";
        DataSet allRpaEntityCount = DB.queryDataSet((String)"select_AllRpaEntitySuccessCount", (DBRoute)BCMConstant.DBROUTE, (String)queryData);
        if (allRpaEntityCount != null) {
            long count = allRpaEntityCount.next().getLong("num");
            return (int)count;
        }
        return 0;
    }

    private int getAllRpaCount() {
        String selectFields = "count(*) as num";
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bcm_rpaschemetask", (String)selectFields, (QFilter[])QFilter.of((String)"1 = ?", (Object[])new Object[]{1}).toArray());
        if (collections != null && collections.size() > 0) {
            Integer num = Integer.parseInt(((DynamicObject)collections.get(0)).get("num").toString());
            return num;
        }
        return 0;
    }
}

