/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.bcmdimmap;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integrationnew.bcmdimmap.TransformUtils;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.fel.common.StringUtils;

public class AutoISSchemeSingleDimMapped {
    private static final String FY = "FY";
    private static final String PERIOD = "M_M";
    private static final String tarNode = "reportitemcode,movementitemcode,custom2,custom3,custom4,icpcode";
    private static final String tarNodeStr = "reportitemcode@Account,movementitemcode@Custom1,custom2@Custom2,custom3@Custom3,custom4@Custom4,icpcode@InternalCompany";
    private static final String srcNode = "sourceaccount,sourcec1,sourcec2,sourcec3,sourcec4,sourceicp";
    private static final String srcNodeStr = "sourceaccount@Account,sourcec1@Custom1,sourcec2@Custom2,sourcec3@Custom3,sourcec4@Custom4,sourceicp@InternalCompany";
    private static final String ACCOUNT_ENTITY = "bcm_accountmembertree";
    private static final String CUSTOM_ENTITY = "bcm_userdefinedmembertree";
    private static final String SOURCEICP_ENTITY = "bcm_icmembertree";
    private Map<String, String> tarNodeMap = new HashMap<String, String>();
    private Map<String, String> srcNodeMap = new HashMap<String, String>();
    private static AutoISSchemeSingleDimMapped instance = new AutoISSchemeSingleDimMapped();

    private AutoISSchemeSingleDimMapped() {
    }

    public static AutoISSchemeSingleDimMapped getInstance() {
        return instance;
    }

    private void buildNodeMap() {
        String[] tmparr;
        String[] tarNodeArr = tarNodeStr.split(",");
        String[] srcNodeArr = srcNodeStr.split(",");
        for (String tar : tarNodeArr) {
            tmparr = tar.split("@");
            this.tarNodeMap.put(tmparr[0], tmparr[1]);
        }
        for (String tar : srcNodeArr) {
            tmparr = tar.split("@");
            this.srcNodeMap.put(tmparr[0], tmparr[1]);
        }
    }

    public void autoMapped(Map<String, Object> map) {
        ArrayList<String> errList = new ArrayList<String>();
        Long modelID = (Long)map.get("modelID");
        Long schemeID = (Long)map.get("schemeID");
        List objects = (List)map.get("dimensionList");
        if (schemeID == null || objects == null || modelID == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u7f3a\u5931\uff01", (String)"AutoISSchemeSingleDimMapped_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        DynamicObject[] baseList = (DynamicObject[])map.get("baseList");
        Map<String, Long> srcMapping = null;
        try {
            srcMapping = Stream.of(baseList).collect(Collectors.toMap(v -> v.getString("number"), v -> v.getLong("id")));
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6e90\u7ef4\u5ea6\u552f\u4e00\u6807\u8bc6\u4fe1\u606f\u51fa\u9519\u3002", (String)"AutoISSchemeSingleDimMapped_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        ArrayList<DynamicObject> singleObjects = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> groupObjects = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> jsonObjects = new ArrayList<DynamicObject>();
        for (DynamicObject object : objects) {
            String number = object.getString("number");
            String mappedtype = object.getString("mappedtype");
            String checknumber = number;
            if (StringUtils.isNotEmpty((CharSequence)number)) {
                checknumber = number.split("-")[0];
            }
            if ("Entity".equals(checknumber) && "1".equals(mappedtype)) {
                this.handleSingleDimOrgMap(map, object, singleObjects, srcMapping);
            } else if ("Year".equals(checknumber) && "1".equals(mappedtype)) {
                this.buildYearAndPeriod((Long)object.get("id"), singleObjects, "Year", FY, 4, map, srcMapping);
            } else if ("Period".equals(checknumber) && "1".equals(mappedtype)) {
                this.buildYearAndPeriod((Long)object.get("id"), singleObjects, "Period", PERIOD, 4, map, srcMapping);
            } else if ("Currency".equals(checknumber) && "1".equals(mappedtype)) {
                this.buildCurrency((Long)object.get("id"), singleObjects, map, srcMapping);
            } else if ("4".equals(mappedtype)) {
                this.buildNodeMap();
                this.collectGroupDatas(schemeID, (Long)object.get("id"), (String)map.get("schemeNumber"), modelID, srcMapping, groupObjects, errList, map);
            }
            this.handleSheet(jsonObjects, (Long)object.get("id"));
        }
        SaveServiceHelper.save((DynamicObject[])singleObjects.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])groupObjects.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])jsonObjects.toArray(new DynamicObject[0]));
        if (errList.size() > 0) {
            String errString = TransformUtils.toString(errList, ",");
            map.put("errString", errString);
        }
    }

    public void handleSingleDimOrgMap(Map map, DynamicObject object, List<DynamicObject> dyObjects, Map srcMapping) {
        Long modelID = (Long)map.get("modelID");
        Long schemeID = (Long)map.get("schemeID");
        Long dimmapID = (Long)object.get("id");
        String schemeNumber = map.get("schemeNumber").toString();
        String orgcode = "";
        try {
            orgcode = schemeNumber.split("_")[2];
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u65e0\u6cd5\u751f\u6210\u5173\u8054\u5173\u7cfb\u3002", (String)"AutoISSchemeSingleDimMapped_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("model", "=", (Object)modelID);
        filter.and(new QFilter("number", "=", (Object)orgcode));
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
        if (org == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\u7ec4\u7ec7\u7f16\u7801\u4e3a%s\u7684\u7ec4\u7ec7\uff0c\u8bf7\u5148\u7ef4\u62a4\u3002", (String)"AutoISSchemeSingleDimMapped_3", (String)"fi-bcm-business", (Object[])new Object[0]), orgcode));
        }
        OrmLocaleValue name = (OrmLocaleValue)org.get("name");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("schemeID", schemeID);
        params.put("srcdimID", srcMapping.get("companycode"));
        params.put("memberNumber", orgcode);
        params.put("memberID", org.get("id"));
        params.put("memberName", name.toString());
        params.put("dimmapID", dimmapID);
        QFilter filter3 = new QFilter("schemeid", "in", (Object)schemeID);
        filter3.and(new QFilter("dimmapid", "=", (Object)dimmapID));
        DeleteServiceHelper.delete((String)"bcm_issinglemap", (QFilter[])new QFilter[]{filter3});
        dyObjects.add(this.packDynamicObject(params));
    }

    public DynamicObject packDynamicObject(Map<String, Object> params) {
        Long schemeID = (Long)params.get("schemeID");
        String memberNumber = (String)params.get("memberNumber");
        String memberName = (String)params.get("memberName");
        Long dimmapID = (Long)params.get("dimmapID");
        Long memberID = (Long)params.get("memberID");
        Long srcdimID = (Long)params.get("srcdimID");
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"bcm_issinglemap");
        String srcNumber = this.getSrcNumber(params.get("filterStr"), memberNumber);
        long id = GlobalIdUtil.genGlobalLongId();
        object.set("id", (Object)id);
        object.set("scope", (Object)1);
        object.set("dimmapid", (Object)dimmapID);
        object.set("schemeid", (Object)schemeID);
        object.set("srcmembnumber", (Object)srcNumber);
        object.set("targmembnumber", (Object)memberNumber);
        object.set("targmembname", (Object)memberName);
        object.set("targmembid", (Object)memberID);
        this.setUserAndTime(object);
        DynamicObjectCollection issinglemapentry = object.getDynamicObjectCollection("issinglemapentry");
        DynamicObject singleEntry = issinglemapentry.addNew();
        singleEntry.set("srcdim", (Object)srcdimID);
        singleEntry.set("srcmemnumber", (Object)srcNumber);
        singleEntry.set("seq", (Object)0);
        return object;
    }

    private String getSrcNumber(Object filterStr, String companyNumber) {
        if ("currency".equals(filterStr)) {
            return "EC";
        }
        if (FY.equals(filterStr) || PERIOD.equals(filterStr)) {
            return companyNumber.substring(filterStr.toString().length());
        }
        return companyNumber;
    }

    private void buildCurrency(Long dimmapid, List<DynamicObject> dyObjects, Map<String, Object> paramsMap, Map<String, Long> srcMapping) {
        Long modelID = (Long)paramsMap.get("modelID");
        Long schemeID = (Long)paramsMap.get("schemeID");
        Collection nodes = MemberReader.getAllNodeByDimNum((String)"Currency", (String)MemberReader.findModelNumberById((Object)modelID));
        if (nodes.size() <= 1) {
            return;
        }
        for (IDNumberTreeNode node : nodes) {
            String number = node.getNumber();
            if (TransformUtils.isEmpty(number)) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("schemeID", schemeID);
            params.put("srcdimID", srcMapping.get("currency"));
            params.put("memberNumber", number);
            params.put("memberID", node.getId());
            params.put("dimmapID", dimmapid);
            params.put("filterStr", "currency");
            params.put("memberName", node.getName());
            dyObjects.add(this.packDynamicObject(params));
        }
    }

    private void buildYearAndPeriod(Long dimmapid, List<DynamicObject> dyObjects, String dimNumber, String filterStr, int filterNum, Map<String, Object> paramsMap, Map<String, Long> srcMapping) {
        Long modelID = (Long)paramsMap.get("modelID");
        Long schemeID = (Long)paramsMap.get("schemeID");
        Collection nodes = MemberReader.getAllNodeByDimNum((String)dimNumber, (String)MemberReader.findModelNumberById((Object)modelID));
        if (nodes.size() <= filterNum) {
            return;
        }
        for (IDNumberTreeNode node : nodes) {
            String number = node.getNumber();
            if (TransformUtils.isEmpty(number)) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (!number.startsWith(filterStr)) continue;
            params.put("schemeID", schemeID);
            params.put("srcdimID", srcMapping.get(dimNumber.toLowerCase(Locale.ENGLISH)));
            params.put("memberNumber", number);
            params.put("memberID", node.getId());
            params.put("memberName", node.getName());
            params.put("dimmapID", dimmapid);
            params.put("filterStr", filterStr);
            dyObjects.add(this.packDynamicObject(params));
        }
    }

    private List<DynamicObject> getMemMapDatas(String schemeNumber, Map map) {
        DynamicObject[] objects;
        if (schemeNumber == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u7f3a\u5931\uff01", (String)"AutoISSchemeSingleDimMapped_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        String orgcode = null;
        String locatoinname = null;
        try {
            String[] arr = schemeNumber.split("_");
            orgcode = arr[2];
            locatoinname = arr[3];
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u65e0\u6cd5\u751f\u6210\u5173\u8054\u5173\u7cfb\u3002", (String)"AutoISSchemeSingleDimMapped_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Long ruleID = (Long)map.get("ruleID");
        QFilter filter = new QFilter("companycode", "=", (Object)orgcode);
        filter.and(new QFilter("locationname", "=", (Object)locatoinname));
        filter.and(new QFilter("freportrulesid", "=", (Object)ruleID));
        String compprops = "companycode,locationname";
        String transferprops = "workaccount,sourceaccount,sourcec1,sourcec2,sourcec3,sourcec4,sourceicp,changesign,reportitemcode,movementitemcode,custom2,custom3,custom4,icpcode";
        for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)"bcm_dsmapping", (String)(compprops + "," + transferprops), (QFilter[])new QFilter[]{filter})) {
            String[] properties;
            for (String property : properties = transferprops.split(",")) {
                String key2 = null;
                String value2 = null;
                if (property.equals("sourcec1")) {
                    key2 = "locationname";
                    value2 = (String)object.get(key2);
                }
                String newValue = TransformUtils.transform(property, (String)object.get(property), key2, value2);
                object.set(property, (Object)newValue);
            }
            if (TransformUtils.isEmptyOrNa(object.getString("workaccount"))) continue;
            object.set("reportitemcode", (Object)object.getString("workaccount"));
        }
        return Arrays.asList(objects);
    }

    public Long getRuleID(String companyCode, String yearNum, String periodNum, long modelID) throws ParseException {
        Date[] dates = PeriodUtils.calcStartAndEndDate((long)modelID, (String)yearNum, (String)periodNum);
        Date starPeriod = dates[0];
        Date endPeriod = dates[1];
        QFilter filter = new QFilter("companycode", "=", (Object)companyCode);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bcm_dslgreportrules", (String)"rulestatus,effdate,expdate,reportruleid", (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        Boolean validFlag = false;
        Long maxID = 0L;
        for (DynamicObject e : objects) {
            Date effDate = e.getDate("effdate");
            Date expdate = e.getDate("expdate");
            Date effDate1 = this.getShortDate(effDate);
            Date expDate1 = this.getShortDate(expdate);
            String ruleStatus = e.getString("rulestatus");
            if (ruleStatus == null || !ruleStatus.equals("valid") && !ruleStatus.equals("invalid") || !this.isEffectiveDate(starPeriod, endPeriod, effDate1, expDate1)) continue;
            list.add(e);
            if (!ruleStatus.equals("valid")) continue;
            validFlag = true;
        }
        for (DynamicObject e : list) {
            String ruleStatus = e.getString("ruleStatus");
            Long reportruleid = e.getLong("reportruleid");
            if (validFlag.booleanValue() && ruleStatus.equals("invalid")) continue;
            if (maxID == 0L) {
                maxID = reportruleid;
                continue;
            }
            if (reportruleid <= maxID) continue;
            maxID = reportruleid;
        }
        return maxID;
    }

    public boolean isEffectiveDate(Date starDate, Date endDate, Date effDate, Date expDate) {
        if (starDate == null || endDate == null) {
            throw new IllegalArgumentException();
        }
        if (effDate == null) {
            return true;
        }
        if (expDate == null) {
            return endDate.getTime() == effDate.getTime() || endDate.after(effDate);
        }
        if (starDate.getTime() == expDate.getTime() || endDate.getTime() == effDate.getTime()) {
            return true;
        }
        return starDate.before(expDate) && endDate.after(effDate);
    }

    public Date getShortDate(Date time) throws ParseException {
        if (time == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(time);
        Date newTime = formatter.parse(dateString);
        return newTime;
    }

    private void collectGroupDatas(Long schemeID, Long dimmapid, String schemeNumber, Long modelID, Map srcMapping, List<DynamicObject> dyObjects, List<String> errList, Map map) {
        List<DynamicObject> middatas = this.getMemMapDatas(schemeNumber, map);
        Map dimMapping = this.getDimIDMap(modelID);
        Map idMapping = this.getAllDataDimIDs(dimMapping, middatas, modelID);
        for (DynamicObject object : middatas) {
            DynamicObject groupObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isgroupmap");
            groupObject.set("computeoprt", object.get("changesign"));
            groupObject.set("isdyna", (Object)0);
            groupObject.set("group", (Object)0);
            groupObject.set("srctype", (Object)1);
            groupObject.set("schemeid", (Object)schemeID);
            groupObject.set("dimmapid", (Object)dimmapid);
            groupObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            this.setUserAndTime(groupObject);
            this.handleSrcMem(object, groupObject, dimmapid, srcMapping);
            this.handelTarMem(object, groupObject, dimmapid, modelID, idMapping, dimMapping, errList);
            dyObjects.add(groupObject);
        }
    }

    private void setUserAndTime(DynamicObject object) {
        object.set("creator", (Object)RequestContext.get().getUserId());
        object.set("createtime", (Object)TimeServiceHelper.now());
        object.set("modifier", (Object)RequestContext.get().getUserId());
        object.set("modifytime", (Object)TimeServiceHelper.now());
    }

    private void handleSheet(List<DynamicObject> dyObjects, Long dimmapid) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_ismapjson");
        obj.set("dimmapid", (Object)dimmapid);
        obj.set("type", (Object)1);
        obj.set("spreadjson", null);
        obj.set("data", null);
        dyObjects.add(obj);
    }

    private void handelTarMem(DynamicObject fromObject, DynamicObject groupObject, Long dimmapid, Long modelID, Map mapping, Map dimMapping, List<String> errList) {
        String[] tarNodeArr;
        DynamicObjectCollection isgrouptargmapentry = groupObject.getDynamicObjectCollection("isgrouptargmapentry");
        for (String property : tarNodeArr = tarNode.split(",")) {
            String tarproperty = this.tarNodeMap.get(property);
            Map idmapping = (Map)mapping.get(property);
            fromObject.set(property, (Object)TransformUtils.subString(TransformUtils.removeIllegalConform(fromObject.getString(property))));
            if ("*".equals(fromObject.get(property)) || "IGNORE".equalsIgnoreCase((String)fromObject.get(property))) {
                DynamicObject entry = isgrouptargmapentry.addNew();
                entry.set("tardimension", dimMapping.get(tarproperty));
                entry.set("tarmembnumber", fromObject.get(property));
                continue;
            }
            if (idmapping != null && idmapping.get(((String)fromObject.get(property)).toLowerCase(Locale.ENGLISH)) != null) {
                String value = (String)idmapping.get(((String)fromObject.get(property)).toLowerCase(Locale.ENGLISH));
                DynamicObject entry = isgrouptargmapentry.addNew();
                entry.set("tardimension", dimMapping.get(tarproperty));
                entry.set("tarmembnumber", (Object)value.split("@")[1]);
                entry.set("tarmember", (Object)value.split("@")[0]);
                continue;
            }
            String errString = tarproperty + String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"AutoISSchemeSingleDimMapped_5", (String)"fi-bcm-business", (Object[])new Object[0]), fromObject.get(property));
            errList.add(errString);
        }
    }

    private void handleSrcMem(DynamicObject fromObject, DynamicObject groupObject, Long dimmapid, Map srcMapping) {
        String[] srcNodeArr;
        DynamicObjectCollection isgroupsrcmapentry = groupObject.getDynamicObjectCollection("isgroupsrcmapentry");
        for (String property : srcNodeArr = srcNode.split(",")) {
            Map<String, Object> analysisResult = TransformUtils.analysisScope(property, "", fromObject.get(property));
            if (analysisResult.get("items") == null) continue;
            List items = (List)analysisResult.get("items");
            Integer priority = (Integer)analysisResult.get("priority");
            int seq = 0;
            for (String num : items) {
                DynamicObject entry = isgroupsrcmapentry.addNew();
                entry.set("srcdimension", srcMapping.get(property));
                entry.set("srcmembnumber", (Object)num.trim());
                entry.set("isdynadim", (Object)0);
                entry.set("seq", (Object)seq);
                entry.set("scope", analysisResult.get("scope"));
                entry.set("priority", (Object)priority);
                ++seq;
            }
        }
    }

    private DynamicObject getJsonObject(Long dimmapid) {
        QFilter qf = new QFilter("dimmapid", "=", (Object)dimmapid);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bcm_ismapjson", (String)"spreadjson,data", (QFilter[])new QFilter[]{qf});
        if (obj == null) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_ismapjson");
            obj.set("dimmapid", (Object)dimmapid);
            obj.set("type", (Object)1);
        }
        return obj;
    }

    private Map getDimIDMap(Long modelID) {
        String memberfroms = "bcm_accountmembertree,bcm_userdefinedmembertree,bcm_icmembertree";
        QFilter qf = new QFilter("model", "=", (Object)modelID);
        qf.and(new QFilter("memberform", "in", (Object)memberfroms.split(",")));
        DynamicObject[] objList = BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"id,number", (QFilter[])new QFilter[]{qf});
        if (objList == null || objList.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u672a\u7ef4\u62a4\uff0c\u8bf7\u786e\u8ba4\uff01", (String)"AutoISSchemeSingleDimMapped_7", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Map<String, Long> idMapping = null;
        try {
            idMapping = Stream.of(objList).collect(Collectors.toMap(v -> v.getString("number"), v -> v.getLong("id")));
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ef4\u5ea6\u6e90ID\u51fa\u9519\u3002", (String)"AutoISSchemeSingleDimMapped_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return idMapping;
    }

    private Map getAllDataDimIDs(Map mapping, List<DynamicObject> datas, Long modelID) {
        HashMap<String, ArrayList<String>> dimMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, Map<String, String>> valMap = new HashMap<String, Map<String, String>>();
        String[] arr = tarNode.split(",");
        for (DynamicObject data : datas) {
            for (String property : arr) {
                String value = TransformUtils.subString(TransformUtils.removeIllegalConform(data.getString(property)));
                ArrayList<String> list = (ArrayList<String>)dimMap.get(property);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(value);
                dimMap.put(property, list);
            }
        }
        for (String property : arr) {
            List list = (List)dimMap.get(property);
            String entity = this.getDimEntity(property);
            String dim = this.tarNodeMap.get(property);
            Long dimID = (Long)mapping.get(dim);
            QFilter qf = new QFilter("model", "=", (Object)modelID);
            qf.and(new QFilter("dimension", "=", (Object)dimID));
            qf.and(new QFilter("number", "in", (Object)list));
            qf.and(new QFilter("storagetype", "!=", (Object)"3"));
            DynamicObject[] objList = BusinessDataServiceHelper.load((String)entity, (String)"id,number", (QFilter[])new QFilter[]{qf});
            if (objList == null || objList.length <= 0) continue;
            Map<String, String> idMapping = null;
            try {
                idMapping = Stream.of(objList).collect(Collectors.toMap(v -> v.getString("number").toLowerCase(Locale.ENGLISH), v -> v.get("id") + "@" + v.getString("number")));
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ef4\u5ea6\u6570\u636e\u6807\u8bc6ID\u51fa\u9519\u3002", (String)"AutoISSchemeSingleDimMapped_9", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            valMap.put(property, idMapping);
        }
        return valMap;
    }

    private String getDimEntity(String key) {
        if (key.equals("reportitemcode")) {
            return ACCOUNT_ENTITY;
        }
        if (key.equals("movementitemcode") || key.startsWith("custom")) {
            return CUSTOM_ENTITY;
        }
        if (key.equals("icpcode")) {
            return SOURCEICP_ENTITY;
        }
        return null;
    }

    public Map<String, String> getSrcNodeMap() {
        return this.srcNodeMap;
    }
}

