/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.bcmdimmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.bcm.business.integrationnew.bcmdimmap.SchemeUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.HWModelTypeEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class BcmISDimMapUtil {
    private static Log log = LogFactory.getLog(BcmISDimMapUtil.class);
    protected static final Map<String, String> mapF = new HashMap<String, String>(16);
    protected static Map<String, String> mapF2 = new HashMap<String, String>(16);
    protected static final Map<String, String> mapF4 = new HashMap<String, String>(16);
    protected static final Map<String, String> mapJ = new HashMap<String, String>(16);
    protected static final Map<String, String> mapJ2 = new HashMap<String, String>(16);
    protected static final Map<String, String> mapJ4 = new HashMap<String, String>(16);

    public Map getMapF() {
        return mapF;
    }

    public Map getMapF2() {
        return mapF2;
    }

    public List<DynamicObject> isDimMap(Long modelId, Long schemeId, String modelType, Object[] bcmIsbaseentlist) {
        this.checkDefinedDim(modelId);
        this.checkDefaultDim(modelId);
        List<Object> list = new ArrayList(10);
        if (HWModelTypeEnum.LG.getNumber().equals(modelType)) {
            list = this.lgIsDimMap(modelId, schemeId, bcmIsbaseentlist);
        } else if (HWModelTypeEnum.FIN.getNumber().equals(modelType)) {
            list = this.finIsDimMap(modelId, schemeId, bcmIsbaseentlist);
        }
        return list;
    }

    private List<DynamicObject> lgIsDimMap(Long modelId, Long schemeId, Object[] bcmIsbaseentlist) {
        List<DynamicObject> bcmIsdimmapList0 = this.addIsDimMap(modelId, schemeId, mapF, bcmIsbaseentlist);
        HashMap<String, String> mapF2copy = new HashMap<String, String>(mapF2);
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)modelId))) {
            mapF2copy.remove("ChangeType");
        }
        List<DynamicObject> bcmIsdimmapList1 = this.addIsDimMap(modelId, schemeId, mapF2copy, null);
        DynamicObject comb = this.addIsDimMapComb(modelId, schemeId, mapF4, bcmIsbaseentlist);
        bcmIsdimmapList0.addAll(bcmIsdimmapList1);
        bcmIsdimmapList0.add(comb);
        return bcmIsdimmapList0;
    }

    private List<DynamicObject> finIsDimMap(Long modelId, Long schemeId, Object[] bcmIsbaseentlist) {
        List<DynamicObject> bcmIsdimmapList0 = this.addIsDimMap(modelId, schemeId, mapJ, bcmIsbaseentlist);
        List<DynamicObject> bcmIsdimmapList1 = this.addIsDimMap(modelId, schemeId, mapJ2, null);
        DynamicObject comb = this.addIsDimMapComb(modelId, schemeId, mapJ4, bcmIsbaseentlist);
        bcmIsdimmapList0.addAll(bcmIsdimmapList1);
        bcmIsdimmapList0.add(comb);
        return bcmIsdimmapList0;
    }

    private List<DynamicObject> addIsDimMap(Long modelId, Long schemeId, Map<String, String> map, Object[] bcmIsbaseentlist) {
        ArrayList<DynamicObject> bcmIsdimmapList = new ArrayList<DynamicObject>(10);
        DynamicObject bcmIsdimmap = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String[] array = entry.getValue().split("\\|");
            bcmIsdimmap = this.addDynamicObject(schemeId, array[1], Integer.valueOf(array[2]));
            if ("1".equals(array[1])) {
                this.addItem(bcmIsdimmap, modelId, key, array, null, null, bcmIsbaseentlist);
            } else if ("2".equals(array[1])) {
                DynamicObject bcmDimension = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model");
                this.addItem(bcmIsdimmap, modelId, key, array, map, String.valueOf(bcmDimension.get("number")), null);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bcmIsdimmap});
                bcmIsdimmapList.add(bcmIsdimmap);
                break;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bcmIsdimmap});
            bcmIsdimmapList.add(bcmIsdimmap);
        }
        return bcmIsdimmapList;
    }

    private DynamicObject addIsDimMapComb(Long modelId, Long schemeId, Map<String, String> map, Object[] bcmIsbaseentlist) {
        DynamicObject bcmIsdimmap = this.addDynamicObject(schemeId, "4", 100000);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String tagNumber = entry.getKey();
            String[] array = entry.getValue().split("\\|");
            this.addItem(bcmIsdimmap, modelId, tagNumber, array, null, null, bcmIsbaseentlist);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bcmIsdimmap});
        return bcmIsdimmap;
    }

    private DynamicObject addDynamicObject(Long schemeId, String mappedtype, Integer sequence) {
        DynamicObject bcmIsdimmap = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdimmap");
        bcmIsdimmap.set("scheme", (Object)schemeId);
        bcmIsdimmap.set("mappedtype", (Object)mappedtype);
        if ("2".equals(mappedtype)) {
            bcmIsdimmap.set("sequence", (Object)99);
        } else {
            bcmIsdimmap.set("sequence", (Object)sequence);
        }
        long currentUserId = UserServiceHelper.getCurrentUserId();
        Date date = new Date();
        bcmIsdimmap.set("creator_id", (Object)currentUserId);
        bcmIsdimmap.set("createtime", (Object)date);
        bcmIsdimmap.set("modifier_id", (Object)currentUserId);
        bcmIsdimmap.set("modifytime", (Object)date);
        return bcmIsdimmap;
    }

    private void addItem(DynamicObject bcmIsdimmap, Long modelId, String tarNumber, String[] array, Map<String, String> map, String modelNum, Object[] bcmIsbaseentlist) {
        Map<String, String> rMap = this.addIsDimMapTargEntry(bcmIsdimmap, modelId, tarNumber, array, map, modelNum);
        if ("2".equals(array[1])) {
            return;
        }
        rMap = this.addIsDimMapSrcEntry(bcmIsdimmap, rMap.get("number"), rMap.get("name"), array, bcmIsbaseentlist);
        if ("1".equals(array[1])) {
            bcmIsdimmap.set("number", (Object)rMap.get("number"));
            bcmIsdimmap.set("name", (Object)rMap.get("name"));
        }
        if ("4".equals(array[1])) {
            bcmIsdimmap.set("name", (Object)ResManager.loadKDString((String)"\u79d1\u76ee\u7ec4\u5408\u6620\u5c04", (String)"BcmISDimMapUtil_13", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private Map<String, String> addIsDimMapTargEntry(DynamicObject bcmIsdimMap, Long modelId, String tarNumber, String[] array, Map<String, String> map, String modelNum) {
        HashMap<String, String> rMap = new HashMap<String, String>(16);
        String name = null;
        String number = null;
        DynamicObject[] bcmDimensionList = BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"id,number,name,shortnumber,issysdimension,membermodel,dseq", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).toArray());
        DynamicObjectCollection isdimmaptargentry = bcmIsdimMap.getDynamicObjectCollection("isdimmaptargentry");
        if (null != map) {
            this.constructDefinCustom(bcmDimensionList, isdimmaptargentry);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String tarValue = entry.getKey();
                String[] arr = entry.getValue().split("\\|");
                for (DynamicObject dynamicObject : bcmDimensionList) {
                    String dimNumber = dynamicObject.getString("number");
                    Object id = dynamicObject.getPkValue();
                    if (!dimNumber.equals(tarValue)) continue;
                    DynamicObject dynamicObjectTarg = isdimmaptargentry.addNew();
                    dynamicObjectTarg.set("seq", (Object)arr[2]);
                    dynamicObjectTarg.set("tagdimtype", (Object)"bcm_dimension");
                    dynamicObjectTarg.set("tagdimension_id", id);
                    dynamicObjectTarg.set("tagbyfrom", (Object)1);
                    DynamicObjectCollection isdimmaptargdefval = dynamicObjectTarg.getDynamicObjectCollection("isdimmaptargdefval");
                    DynamicObject isdimmaptargdefvalSrc = isdimmaptargdefval.addNew();
                    IDNumberTreeNode tagMem = MemberReader.findMemberByNumber((String)modelNum, (String)dimNumber, (String)arr[3]);
                    isdimmaptargdefvalSrc.set("tagmemb", (Object)tagMem.getId());
                    isdimmaptargdefvalSrc.set("tagmemname", (Object)arr[4]);
                    isdimmaptargdefvalSrc.set("targetmemnum", (Object)arr[3]);
                }
            }
            return rMap;
        }
        for (DynamicObject dynamicObject : bcmDimensionList) {
            String dimNumber = dynamicObject.getString("number");
            Object id = dynamicObject.getPkValue();
            if (!dimNumber.equals(tarNumber)) continue;
            DynamicObject dynamicObjectTarg = isdimmaptargentry.addNew();
            number = dimNumber + "-";
            name = dynamicObject.get("name") + "-";
            dynamicObjectTarg.set("seq", (Object)array[2]);
            dynamicObjectTarg.set("tagdimtype", (Object)"bcm_dimension");
            dynamicObjectTarg.set("tagdimension_id", id);
            dynamicObjectTarg.set("tagbyfrom", (Object)1);
        }
        rMap.put("number", number);
        rMap.put("name", name);
        return rMap;
    }

    private void constructDefinCustom(DynamicObject[] bcmDimensionList, DynamicObjectCollection isdimmaptargentry) {
        List dimList = Stream.of(bcmDimensionList).filter(x -> !x.getBoolean("issysdimension") && this.excludeCustoms(x.getString("number"))).collect(Collectors.toList());
        if (dimList.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dimList) {
            Object id = dynamicObject.getPkValue();
            DynamicObject dynamicObjectTarg = isdimmaptargentry.addNew();
            dynamicObjectTarg.set("seq", (Object)dynamicObject.getString("dseq"));
            dynamicObjectTarg.set("tagdimtype", (Object)"bcm_dimension");
            dynamicObjectTarg.set("tagdimension_id", id);
            dynamicObjectTarg.set("tagbyfrom", (Object)1);
            DynamicObjectCollection isdimmaptargdefval = dynamicObjectTarg.getDynamicObjectCollection("isdimmaptargdefval");
            DynamicObject isdimmaptargdefvalSrc = isdimmaptargdefval.addNew();
            DynamicObject[] obj = BusinessDataServiceHelper.load((String)"bcm_userdefinedmembertree", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("dimension", "=", id), new QFilter("parent", ">", (Object)0), new QFilter("level", "=", (Object)2)});
            if (obj.length == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u7ef4\u5ea6%s\u65e0\u6210\u5458\u3002", (String)"BcmISDimMapUtil_5", (String)"fi-bcm-business", (Object[])new Object[0]), dynamicObject.getString("name")));
            }
            DynamicObject tagMem = obj[0];
            isdimmaptargdefvalSrc.set("tagmemb", tagMem.getPkValue());
            isdimmaptargdefvalSrc.set("tagmemname", (Object)tagMem.getString("name"));
            isdimmaptargdefvalSrc.set("targetmemnum", (Object)tagMem.getString("number"));
        }
    }

    private boolean excludeCustoms(String dimNumber) {
        boolean isOutNumber = true;
        if ("Custom1".equals(dimNumber) || "Custom2".equals(dimNumber) || "Custom3".equals(dimNumber) || "Custom4".equals(dimNumber)) {
            isOutNumber = false;
        }
        return isOutNumber;
    }

    private Map<String, String> addIsDimMapSrcEntry(DynamicObject bcmIsdimmap, String number, String name, String[] array, Object[] bcmIsbaseentlist) {
        DynamicObjectCollection isdimmapsrcentry = bcmIsdimmap.getDynamicObjectCollection("isdimmapsrcentry");
        StringBuilder nameSb = new StringBuilder(name);
        StringBuilder numSb = new StringBuilder(number);
        for (Object object : bcmIsbaseentlist) {
            DynamicObject dynamicObject = (DynamicObject)object;
            String srcNumber = dynamicObject.getString("number");
            if (!srcNumber.equals(array[0])) continue;
            numSb.append(srcNumber);
            nameSb.append(dynamicObject.get("name"));
            Object id = dynamicObject.getPkValue();
            DynamicObject dynamicObjectTarg = isdimmapsrcentry.addNew();
            dynamicObjectTarg.set("seq", (Object)array[2]);
            dynamicObjectTarg.set("srcdimtype", (Object)"bcm_isbaseentlist");
            dynamicObjectTarg.set("srcdimension_id", id);
            dynamicObjectTarg.set("srcbyfrom", (Object)2);
        }
        HashMap<String, String> rMap = new HashMap<String, String>(16);
        rMap.put("number", numSb.toString());
        rMap.put("name", nameSb.toString());
        return rMap;
    }

    private void checkDefinedDim(Long modelId) {
        DynamicObject[] dimList = BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"number", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).toArray());
        if (dimList.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String key : mapF.keySet()) {
                boolean isNumber = false;
                for (DynamicObject dynamicObject : dimList) {
                    if (!key.equals(dynamicObject.getString("number"))) continue;
                    isNumber = true;
                }
                if (isNumber) continue;
                sb.append(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a%s\u7684\u7ef4\u5ea6\u3002", (String)"BcmISDimMapUtil_7", (String)"fi-bcm-business", (Object[])new Object[0]), key));
            }
            if (sb.length() > 0) {
                throw new KDBizException(sb.toString());
            }
        }
    }

    private void checkDefaultDim(Long modelId) {
        HashMap<String, String> mapF2copy = new HashMap<String, String>(mapF2);
        if (!MemberReader.isExistChangeTypeDimension((long)modelId)) {
            mapF2copy.remove("ChangeType");
        }
        if (!MemberReader.isExistAuditTrailDimension((long)modelId)) {
            mapF2copy.remove("AuditTrail");
        }
        for (Map.Entry entry : mapF2copy.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("View")) continue;
            String value = (String)entry.getValue();
            Object[] split = value.split("\\|");
            String tagNumber = split[3];
            String entityName = split[5];
            DynamicObject[] obj = BusinessDataServiceHelper.load((String)entityName, (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)tagNumber), new QFilter("model", "=", (Object)modelId)});
            if (obj.length == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a%s\u7684\u6210\u5458\u3002", (String)"BcmISDimMapUtil_8", (String)"fi-bcm-business", (Object[])new Object[0]), tagNumber));
            }
            String tagName = obj[0].getString("name");
            Arrays.fill(split, 4, 5, tagName);
            mapF2.put(key, this.array2String((String[])split));
        }
    }

    private String array2String(String[] str) {
        StringBuilder sb = new StringBuilder();
        if (str != null && str.length > 0) {
            for (int i = 0; i < str.length; ++i) {
                if (i < str.length - 1) {
                    sb.append(str[i]);
                    sb.append("|");
                    continue;
                }
                sb.append(str[i]);
            }
            return sb.toString();
        }
        return null;
    }

    public void setDimMapTargDef(Long modelId, long dimensionId, long memberId) {
        String info = "modelId = " + modelId + "dimensionId = " + dimensionId + "memberId = " + memberId;
        log.info("start setDimMapTargDef " + info);
        try {
            Set<Long> schemeIds = this.getSchemeId(modelId);
            for (Long schemeId : schemeIds) {
                DynamicObject bcmIsdimmap = this.addDynamicObject(schemeId, "2", null);
                DynamicObjectCollection isdimmaptargentry = bcmIsdimmap.getDynamicObjectCollection("isdimmaptargentry");
                DynamicObjectCollection bcmDimensionList = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name,shortnumber,issysdimension,membermodel,dseq", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).and("id", "=", (Object)dimensionId).toArray());
                if (bcmDimensionList == null || bcmDimensionList.size() <= 0 || this.checkExistDimMapTargDef(schemeId, dimensionId, memberId)) continue;
                Long id = ((DynamicObject)bcmDimensionList.get(0)).getLong("id");
                DynamicObject dynamicObjectTarg = isdimmaptargentry.addNew();
                dynamicObjectTarg.set("seq", (Object)((DynamicObject)bcmDimensionList.get(0)).getString("dseq"));
                dynamicObjectTarg.set("tagdimtype", (Object)"bcm_dimension");
                dynamicObjectTarg.set("tagdimension_id", (Object)id);
                dynamicObjectTarg.set("tagbyfrom", (Object)1);
                DynamicObjectCollection isdimmaptargdefval = dynamicObjectTarg.getDynamicObjectCollection("isdimmaptargdefval");
                DynamicObject isdimmaptargdefvalSrc = isdimmaptargdefval.addNew();
                DynamicObjectCollection obj = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("dimension", "=", (Object)id), new QFilter("id", "=", (Object)memberId)});
                if (obj == null || obj.size() <= 0) continue;
                DynamicObject tagMem = (DynamicObject)obj.get(0);
                isdimmaptargdefvalSrc.set("tagmemb", (Object)tagMem.getLong("id"));
                isdimmaptargdefvalSrc.set("tagmemname", (Object)tagMem.getString("name"));
                isdimmaptargdefvalSrc.set("targetmemnum", (Object)tagMem.getString("number"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bcmIsdimmap});
            }
        }
        catch (Exception e) {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            AppLogInfo logInfo = OperationLogUtil.buildLogInfo(new OpNameMultiLangEnumBridge("setDimMapTargDef", "", "", "setDimMapTargDef"), new OPDescMultiLangEnumBridge("\u9884\u5236\u65b0\u589e\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u540e\u96c6\u6210\u65b9\u6848\u7684\u76ee\u6807\u7f3a\u7701\u503c\u5931\u8d25,%s", "BcmISDimMapUtil_15", "fi-bcm-business", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{info})), modelId, "bcm_isdimmap");
            logService.addLog(logInfo);
            log.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }

    private boolean checkExistDimMapTargDef(long schemeId, long dimensionId, long memberId) {
        QFilter qFilterScheme = new QFilter("scheme", "=", (Object)schemeId);
        ArrayList<String> mapType = new ArrayList<String>(10);
        mapType.add(DimMappTypeEnum.SINGLE.getCode());
        mapType.add(DimMappTypeEnum.TARGET_DEFAULT.getCode());
        qFilterScheme.and("mappedtype", "in", mapType);
        DynamicObjectCollection docScheme = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id,isdimmaptargentry.tagdimension", (QFilter[])new QFilter[]{qFilterScheme});
        for (DynamicObject dynamicObject : docScheme) {
            if (dynamicObject == null || !Objects.nonNull(dynamicObject.getLong("isdimmaptargentry.tagdimension")) || dimensionId != dynamicObject.getLong("isdimmaptargentry.tagdimension")) continue;
            return true;
        }
        return false;
    }

    public List<String> getNotInProduct() {
        ArrayList<String> notInList = new ArrayList<String>(4);
        notInList.add(IntegrateProductEnum.JQProduct.getNumber());
        notInList.add(IntegrateProductEnum.EXCELIMPORTProduct.getNumber());
        notInList.add(IntegrateProductEnum.NGProduct.getNumber());
        notInList.add(IntegrateProductEnum.XExtendProduct.getNumber());
        notInList.add(IntegrateProductEnum.JQONLINEProduct.getNumber());
        notInList.addAll(SchemeUtil.getDIProduct());
        return notInList;
    }

    private Set<Long> getSchemeId(Long modelId) {
        HashSet<Long> productSet = new HashSet<Long>();
        QFilter notIntProduct = new QFilter("number", "not in", this.getNotInProduct());
        DynamicObjectCollection docProduct = QueryServiceHelper.query((String)"bcm_isproduct", (String)"id", (QFilter[])new QFilter[]{notIntProduct});
        for (DynamicObject dynamicObject : docProduct) {
            productSet.add(dynamicObject.getLong("id"));
        }
        QFilter id = new QFilter("model", "=", (Object)modelId);
        QFilter isSrcId = new QFilter("issrc", "in", productSet);
        DynamicObjectCollection docScheme = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id", (QFilter[])new QFilter[]{id, isSrcId});
        HashSet<Long> schemeSet = new HashSet<Long>();
        for (DynamicObject dynamicObject : docScheme) {
            schemeSet.add(dynamicObject.getLong("id"));
        }
        return schemeSet;
    }

    static {
        mapF.put("Entity", "companycode|1|1");
        mapF.put("Year", "year|1|2");
        mapF.put("Period", "period|1|3");
        mapF.put("Currency", "currency|1|4");
        mapF.put("Account", "sourceaccount|1|5");
        mapF.put("Custom1", "sourcec1|1|6");
        mapF.put("Custom2", "sourcec2|1|7");
        mapF.put("Custom3", "sourcec3|1|8");
        mapF.put("Custom4", "sourcec4|1|9");
        mapF.put("InternalCompany", "sourceicp|1|10");
        String irpt = ResManager.getLocaleString((String)"\u62a5\u8868", (String)"BcmISDimMapUtil_9", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        String actual = ResManager.getLocaleString((String)"\u5b9e\u9645\u6570", (String)"BcmISDimMapUtil_10", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        String ytd = ResManager.getLocaleString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"BcmISDimMapUtil_11", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        String integra = ResManager.getLocaleString((String)"\u63a5\u53e3\u96c6\u6210\u6570\u636e", (String)"BcmISDimMapUtil_12", (String)"fi-bcm-business").getLocaleValue_zh_CN();
        mapF2.put("Process", "null|2|1|IRpt|" + irpt + "|" + "bcm_processmembertree");
        mapF2.put("Scenario", "null|2|2|Actual|" + actual + "|" + "bcm_scenemembertree");
        mapF2.put("ChangeType", "null|2|3|YTD|" + ytd + "|" + "bcm_changetypemembertree");
        mapF2.put("AuditTrail", "null|2|4|Integration|" + integra + "|" + "bcm_audittrialmembertree");
        mapF2.put("View", "null|2|5|YTD|YTD");
        mapF4.put("Account", "sourceaccount|4|1");
        mapF4.put("Custom1", "sourcec1|4|2");
        mapF4.put("Custom2", "sourcec2|4|3");
        mapF4.put("Custom3", "sourcec3|4|4");
        mapF4.put("Custom4", "sourcec4|4|5");
        mapF4.put("InternalCompany", "sourceicp|4|6");
    }
}

