/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.bcmdimmap;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.util.HWModelParamUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.util.PeriodUtils;

public class SchemeUtil {
    private static final Log log = LogFactory.getLog(SchemeUtil.class);
    public static final String DI_PRODUCT = "DI%";

    public static DynamicObject[] newScheme(Map<String, Object> params) {
        String companyCode = (String)params.get("companyCode");
        String locationName = (String)params.get("locationName");
        Long modelID = (Long)params.get("modelID");
        Long catalogID = (Long)params.get("catalogID");
        if (StringUtils.isBlank((CharSequence)companyCode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u96c6\u6210\u65b9\u6848\u5931\u8d25\uff0c\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"SchemeUtil_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)locationName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u96c6\u6210\u65b9\u6848\u5931\u8d25\uff0c\u6e90\u4f4d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"SchemeUtil_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)modelID)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u96c6\u6210\u65b9\u6848\u5931\u8d25\uff0c\u4f53\u7cfb\u4e3a\u7a7a\u3002", (String)"SchemeUtil_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)catalogID)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u96c6\u6210\u65b9\u6848\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u65b9\u6848\u5206\u7ec4\u3002", (String)"SchemeUtil_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        params.put("number", "SFM_L_" + companyCode + "_" + locationName);
        Long srcID = HWModelParamUtil.getModelSrc(modelID);
        if (srcID == null || srcID == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u96c6\u6210\u65b9\u6848\u5931\u8d25\uff0c\u96c6\u6210\u6e90\u4e3a\u7a7a\u3002", (String)"SchemeUtil_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        params.put("srcID", srcID);
        Long targID = HWModelParamUtil.getModelTarget(modelID);
        if (targID == null || targID == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u96c6\u6210\u65b9\u6848\u5931\u8d25\uff0c\u96c6\u6210\u76ee\u6807\u4e3a\u7a7a\u3002", (String)"SchemeUtil_5", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        params.put("targID", targID);
        Long isschemeID = HWModelParamUtil.getModelScheme(modelID);
        if (isschemeID == null || isschemeID == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u96c6\u6210\u65b9\u6848\u5931\u8d25\uff0c\u96c6\u6210\u4e91\u65b9\u6848\u4e3a\u7a7a\u3002", (String)"SchemeUtil_6", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        params.put("isschemeID", isschemeID);
        DynamicObject[] middle = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"bcm_dslgmddata")});
        if (middle == null || middle.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u96c6\u6210\u65b9\u6848\u5931\u8d25\uff0c\u96c6\u6210\u4e91\u65b9\u6848\u4e3a\u7a7a\u3002", (String)"SchemeUtil_6", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        params.put("middleID", middle[0].get("id"));
        DynamicObject bcmScheme = SchemeUtil.createScheme(params);
        return (DynamicObject[])SaveServiceHelper.save((IDataEntityType)bcmScheme.getDataEntityType(), (Object[])new DynamicObject[]{bcmScheme});
    }

    private static DynamicObject createScheme(Map<String, Object> params) {
        Long modelID = (Long)params.get("modelID");
        QFilter filter = new QFilter("number", "=", params.get("number"));
        filter.and("model.id", "=", (Object)modelID);
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"bcm_isscheme", (QFilter[])new QFilter[]{filter}, null, (int)-1);
        if (idList.size() > 0) {
            SchemeUtil.delete(idList);
            SchemeUtil.updateAutoLog(idList);
        }
        Date[] startAndEndDate = PeriodUtils.calcStartAndEndDate((long)modelID, (String)((String)params.get("yearNum")), (String)((String)params.get("periodNum")));
        DynamicObject bcmScheme = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isscheme");
        bcmScheme.set("model", (Object)modelID);
        bcmScheme.set("templatecatalog", params.get("catalogID"));
        bcmScheme.set("number", params.get("number"));
        bcmScheme.set("name", params.get("number"));
        bcmScheme.set("issrc", params.get("srcID"));
        bcmScheme.set("istarg", params.get("targID"));
        bcmScheme.set("isscheme", params.get("isschemeID"));
        bcmScheme.set("middlelib", params.get("middleID"));
        bcmScheme.set("versionnumber", (Object)1);
        bcmScheme.set("effectivedate", (Object)startAndEndDate[0]);
        bcmScheme.set("expiringdate", (Object)startAndEndDate[1]);
        bcmScheme.set("description", (Object)ResManager.loadKDString((String)"\u6620\u5c04\u8bb0\u5f55\u4ecet_bcm_dsmapping\u751f\u6210\u3002", (String)"SchemeUtil_7", (String)"fi-bcm-business", (Object[])new Object[0]));
        bcmScheme.set("modifier", params.get("uid"));
        bcmScheme.set("creator", params.get("uid"));
        bcmScheme.set("modifytime", (Object)TimeServiceHelper.now());
        bcmScheme.set("createtime", (Object)TimeServiceHelper.now());
        bcmScheme.set("enable", (Object)1);
        bcmScheme.set("status", (Object)1);
        bcmScheme.set("location", params.get("locationName"));
        return bcmScheme;
    }

    public static void assign(String modelId, String schemeId, String companyCode) {
        String modelNumb = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumb, (String)"Entity", (String)companyCode);
        if (node.getId() == -1L) {
            log.info("companyCode =  " + companyCode + " \uff0c\u7ef4\u5ea6\u7ba1\u7406\u7ec4\u7ec7\u4e0b\u65e0\u8be5\u516c\u53f8\u7f16\u7801\uff0c\u4e0d\u8fdb\u884c\u5206\u914d\uff1b");
            return;
        }
        ArrayList<DynamicObject> dyObjectList = new ArrayList<DynamicObject>();
        DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isschemeassignentity");
        distribute.set("entity", (Object)node.getId());
        distribute.set("range", (Object)"10");
        distribute.set("scheme", (Object)schemeId);
        distribute.set("model", (Object)modelId);
        distribute.set("textname", (Object)node.getName());
        dyObjectList.add(distribute);
        DynamicObject[] newdoc = dyObjectList.toArray(new DynamicObject[dyObjectList.size()]);
        SaveServiceHelper.save((DynamicObject[])newdoc);
    }

    public static void delete(List<Object> idList) {
        QFilter filter = new QFilter("id", "in", idList);
        DeleteServiceHelper.delete((String)"bcm_isscheme", (QFilter[])new QFilter[]{filter});
        filter = new QFilter("scheme", "in", idList);
        DynamicObjectCollection maps = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> mapids = new ArrayList<Long>();
        if (maps != null) {
            for (DynamicObject map : maps) {
                mapids.add(map.getLong("id"));
            }
        }
        QFilter dimmapfilter = new QFilter("dimmapid", "in", mapids);
        DeleteServiceHelper.delete((String)"bcm_ismapjson", (QFilter[])new QFilter[]{dimmapfilter});
        DeleteServiceHelper.delete((String)"bcm_schemeassignentity", (QFilter[])new QFilter[]{filter});
        DeleteServiceHelper.delete((String)"bcm_isdimmap", (QFilter[])new QFilter[]{filter});
        DeleteServiceHelper.delete((String)"bcm_isbaseentlist", (QFilter[])new QFilter[]{filter});
        QFilter schemefilter = new QFilter("schemeid", "in", idList);
        DeleteServiceHelper.delete((String)"bcm_issinglemap", (QFilter[])new QFilter[]{schemefilter});
        DeleteServiceHelper.delete((String)"bcm_isgroupmap", (QFilter[])new QFilter[]{schemefilter});
    }

    private static void updateAutoLog(List<Object> idList) {
        DynamicObject[] logList;
        QFilter filter = new QFilter("schemeid", "in", idList);
        for (DynamicObject obj : logList = BusinessDataServiceHelper.load((String)"bcm_isdimmap_autolog", (String)"id,deal", (QFilter[])new QFilter[]{filter})) {
            obj.set("deal", (Object)"2");
        }
        SaveServiceHelper.save((DynamicObject[])logList);
    }

    public static List<String> getDIProduct() {
        QFilter filter = new QFilter("number", "like", (Object)DI_PRODUCT);
        return QueryServiceHelper.query((String)"bcm_isproduct", (String)"number", (QFilter[])filter.toArray()).stream().map(dyn -> dyn.getString("number")).collect(Collectors.toList());
    }

    public static List<String> getDIExtProduct() {
        ArrayList<String> diList = new ArrayList<String>(2);
        diList.add(IntegrateProductEnum.DIMIDEXProduct.getNumber());
        diList.add(IntegrateProductEnum.DIISCEXProduct.getNumber());
        diList.add(IntegrateProductEnum.DICMEXTProduct.getNumber());
        return diList;
    }
}

