/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.bcmdimmap;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;

public class TransformUtils {
    private static final String CHANGESIGN_NAME = "changesign";
    public static final String WORK_ACCOUNT_NAME = "workaccount";
    private static final String CUSTOM2_NAME = "custom2";
    private static final String CUSTOM3_NAME = "custom3";
    private static final String CUSTOM4_NAME = "custom4";
    private static final String SICP_CODE_NAME = "icpcode";
    private static final String MOVEMENT_ITEM_CODE_NAME = "movementitemcode";
    public static final String REPORTITEMCODE_NAME = "reportitemcode";
    private static final String SOURCE_ACCOUNT_NAME = "sourceaccount";
    public static final String SOURCE_C1_NAME = "sourcec1";
    private static final String SOURCE_C2_NAME = "sourcec2";
    private static final String SOURCE_C3_NAME = "sourcec3";
    private static final String SOURCE_C4_NAME = "sourcec4";
    private static final String SOURCE_ICP_NAME = "sourceicp";
    public static final String location_NAME = "location";
    private static final String C1NONE_VALUE = "C1None";
    private static final String C2NONE_VALUE = "C2None";
    private static final String C3NONE_VALUE = "C3None";
    private static final String C4NONE_VALUE = "C4None";
    private static final String ICNONE_VALUE = "ICNone";
    private static final String NA_VALUE = "NA";
    private static final String PR_VALUE = "PR";
    private static final String AN_VALUE = "AN";
    private static final String STAR_VALUE = "*";

    public static String transform(String key1, String value1, String key2, String value2) {
        key1 = TransformUtils.toLowerCase(key1);
        key2 = TransformUtils.toLowerCase(key2);
        if (REPORTITEMCODE_NAME.equals(key1)) {
            return TransformUtils.reportitemcodeTransform(key1, value1, key2, value2);
        }
        if (SOURCE_C1_NAME.equals(key1)) {
            return TransformUtils.sourceC1Transform(key1, value1, value2);
        }
        return TransformUtils.transform(key1, value1);
    }

    public static String reportitemcodeTransform(String key, String value, String workAccounKey, String workAccounValue) {
        if (TransformUtils.isEmptyOrNa(workAccounValue)) {
            return TransformUtils.transform(key, value);
        }
        return TransformUtils.transform(workAccounKey, workAccounValue);
    }

    public static String sourceC1Transform(String key, String value, String locationValue) {
        String result = TransformUtils.transform(key, value);
        if (TransformUtils.isEmptyOrNaOrStar(result)) {
            result = STAR_VALUE;
        }
        return result;
    }

    public static String transform(String key, String value) {
        StringBuilder result = new StringBuilder();
        List<String> list = Arrays.asList(WORK_ACCOUNT_NAME, CUSTOM2_NAME, CUSTOM3_NAME, CUSTOM4_NAME, SICP_CODE_NAME, MOVEMENT_ITEM_CODE_NAME, REPORTITEMCODE_NAME, SOURCE_ACCOUNT_NAME, SOURCE_C1_NAME, SOURCE_C2_NAME, SOURCE_C3_NAME, SOURCE_C4_NAME, SOURCE_ICP_NAME);
        if (list.contains(key) && value.contains(",")) {
            String[] strs = value.split(",");
            result.append("in(");
            for (int i = 0; i < strs.length; ++i) {
                String str = strs[i].trim();
                if (i != strs.length - 1) {
                    result.append(str).append(",");
                    continue;
                }
                result.append(str);
            }
            result.append(")");
            return result.toString();
        }
        String regex = "^\\*+$";
        if (list.contains(key) && Pattern.matches(regex, value)) {
            return STAR_VALUE;
        }
        if (list.contains(key) && value.contains(">")) {
            String[] strs = value.split(">");
            result.append("between(").append(strs[0].trim()).append(",").append(strs[1].trim()).append(")");
            return result.toString();
        }
        regex = ".*\\*$";
        if (list.contains(key) && Pattern.matches(regex, value)) {
            result.append("like(");
            result.append(value.replace(STAR_VALUE, "%)"));
            return result.toString();
        }
        if (CHANGESIGN_NAME.equals(key)) {
            if (TransformUtils.isEmptyOrNa(value)) {
                return null;
            }
            if ("CS01".equalsIgnoreCase(value) || "FALSE".equalsIgnoreCase(value)) {
                return "1";
            }
            if ("CS02".equalsIgnoreCase(value) || "TRUE".equalsIgnoreCase(value)) {
                return "-1";
            }
            return value;
        }
        List<String> list1 = Arrays.asList(SOURCE_ACCOUNT_NAME, SOURCE_C2_NAME, SOURCE_C3_NAME, SOURCE_C4_NAME, SOURCE_ICP_NAME);
        if (list1.contains(key) && TransformUtils.isEmptyOrNa(value)) {
            return STAR_VALUE;
        }
        if (MOVEMENT_ITEM_CODE_NAME.equals(key) && TransformUtils.isEmptyOrNa(value)) {
            return C1NONE_VALUE;
        }
        if (CUSTOM2_NAME.equals(key) && TransformUtils.isEmptyOrNa(value)) {
            return C2NONE_VALUE;
        }
        if (CUSTOM3_NAME.equals(key) && TransformUtils.isEmptyOrNa(value)) {
            return C3NONE_VALUE;
        }
        if (CUSTOM4_NAME.equals(key) && TransformUtils.isEmptyOrNa(value)) {
            return C4NONE_VALUE;
        }
        if (SICP_CODE_NAME.equals(key) && TransformUtils.isEmptyOrNa(value)) {
            return ICNONE_VALUE;
        }
        if (result.length() == 0) {
            return value;
        }
        return result.toString();
    }

    public static boolean isEmptyOrNa(String value) {
        boolean flag = false;
        if (TransformUtils.isEmpty(value) || NA_VALUE.equals(value)) {
            flag = true;
        }
        return flag;
    }

    public static boolean isEmptyOrNaOrStar(String value) {
        boolean flag = false;
        if (TransformUtils.isEmpty(value) || NA_VALUE.equals(value) || STAR_VALUE.equals(value)) {
            flag = true;
        }
        return flag;
    }

    public static boolean isEmpty(String value) {
        boolean flag = false;
        if (value == null || value.trim().length() == 0) {
            flag = true;
        }
        return flag;
    }

    public static String toLowerCase(String key) {
        if (TransformUtils.isEmpty(key)) {
            return key;
        }
        return key.toLowerCase(Locale.ENGLISH);
    }

    public static Map<String, Object> analysisScope(String key, String accountNum, Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (value != null && StringUtils.isNotEmpty((String)((String)value))) {
            String str = ((String)value).toUpperCase(Locale.ENGLISH).trim();
            Pattern pattern = Pattern.compile("(?<=\\()[^\\)]+");
            Matcher matcher = pattern.matcher((String)value);
            String content = "";
            while (matcher.find()) {
                content = matcher.group();
            }
            if (str.contains("BETWEEN(")) {
                result.put("scope", MapScopeEnum.RANGE.getIndex());
                result.put("items", Arrays.asList(content.split(",")));
                result.put("priority", TransformUtils.getPriority(key, accountNum, 999));
                return result;
            }
            if (str.contains("LIKE(")) {
                result.put("scope", MapScopeEnum.LIKE.getIndex());
                String contentnew = content.replace("%", "");
                result.put("items", Collections.singletonList(contentnew));
                result.put("priority", TransformUtils.getPriority(key, accountNum, contentnew.length()));
                return result;
            }
            if (str.contains("IN(")) {
                result.put("scope", MapScopeEnum.INCLUDE.getIndex());
                result.put("items", Arrays.asList(content.split(",")));
                result.put("priority", TransformUtils.getPriority(key, accountNum, 999));
                return result;
            }
            result.put("scope", MapScopeEnum.EQUALS.getIndex());
            result.put("items", Collections.singletonList(value));
            if (STAR_VALUE.equals(value)) {
                result.put("priority", TransformUtils.getPriority(key, accountNum, -1));
            } else {
                result.put("priority", TransformUtils.getPriority(key, accountNum, 999));
            }
            return result;
        }
        return result;
    }

    public static Integer getPriority(String key, String accountNum, Integer priority) {
        if (TransformUtils.isSrcAccount(key, accountNum)) {
            return priority;
        }
        return -2;
    }

    public static boolean isSrcAccount(String key, String accountNum) {
        return SOURCE_ACCOUNT_NAME.equals(key) || "account".equalsIgnoreCase(key) || "AccountView".equalsIgnoreCase(key) || key.equalsIgnoreCase(accountNum);
    }

    public static String toString(List<String> list, String tag) {
        if (list != null) {
            StringBuilder sb = new StringBuilder(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                sb.append(tag);
                sb.append(list.get(i));
            }
            return sb.toString();
        }
        return null;
    }

    public static String removeIllegalConform(String str) {
        if (null == str) {
            return str;
        }
        if (str.contains(" ") || str.contains("(") || str.contains(")") || str.contains("\uff08") || str.contains("\uff09")) {
            return str.replaceAll("[\\s | \\( | \\\uff08 | \\) | \\\uff09]", "");
        }
        return str;
    }

    public static String subString(String str) {
        if (null != str && str.length() > 50) {
            return str.substring(0, 50);
        }
        return str;
    }
}

