/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.ctx;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.data.MemberMsgCache;
import kd.fi.bcm.business.dimension.data.MemberNumToIdCache;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.MappedModelBuilder;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedMembItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.service.AbstractIntegrateService;
import kd.fi.bcm.business.integrationnew.service.IServiceMappedGroupSupplier;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.util.TemplateUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.QFBuilder;

public class IntegrateContext
implements IIntegrateContext,
Cloneable {
    private List<MappedGroup> combineMappedGroups;
    private List<MappedGroup> formulaMappedGroups;
    private Pair<Long, String> model;
    private Pair<Long, String> scheme;
    private Pair<Long, String> currency;
    private Pair<Long, String> scene;
    private Pair<Long, String> fy;
    private Pair<Long, String> period;
    private Pair<Long, String> org;
    private Map<Long, MappedDimItem> mappedDimItems;
    private Map<String, Object> customParams;
    private MappedModelBuilder builder;
    private Map<MappedRow, ValueList> result;
    private DimMappedRelation mappedRelation;
    private MemberNumToIdCache idCache;
    private MemberMsgCache memsCache;
    private Pair<Long, String> mapCurrency;
    private Pair<Long, String> mapFy;
    private Pair<Long, String> mapPeriod;
    private Pair<Long, String> mapOrg;
    private Set<Long> templateIds = new HashSet<Long>();
    private Set<Long> allVersionTemplateIds = new HashSet<Long>();
    private IServiceMappedGroupSupplier supplier;
    private List<MappedGroup> supplierGroups;
    private Map<String, Set<String>> nonLeafMembMap = new ConcurrentHashMap<String, Set<String>>();
    Class<? extends AbstractIntegrateService> serviceClass;

    public IntegrateContext(Pair<Long, String> model, Pair<Long, String> scheme, Pair<Long, String> currency, Pair<Long, String> scene, Pair<Long, String> fy, Pair<Long, String> period, Pair<Long, String> org, Class<? extends AbstractIntegrateService> serviceClass) {
        this.model = model;
        this.currency = currency;
        this.scheme = scheme;
        this.scene = scene;
        this.fy = fy;
        this.period = period;
        this.org = org;
        this.serviceClass = serviceClass;
        this.initEnv();
    }

    public IntegrateContext(Pair<Long, String> model, Pair<Long, String> scheme, Pair<Long, String> currency, Pair<Long, String> scene, Pair<Long, String> fy, Pair<Long, String> period, Pair<Long, String> org, Set<Long> templateIds, Class<? extends AbstractIntegrateService> serviceClass) {
        this.model = model;
        this.currency = currency;
        this.scheme = scheme;
        this.scene = scene;
        this.fy = fy;
        this.period = period;
        this.org = org;
        this.templateIds = templateIds;
        this.serviceClass = serviceClass;
        this.initEnv();
    }

    @Override
    public void setServiceMappedGroupSupplier(IServiceMappedGroupSupplier supplier) {
        this.supplier = supplier;
    }

    private void initEnv() {
        this.builder = new MappedModelBuilder(this);
        this.customParams = new HashMap<String, Object>();
        this.result = new HashMap<MappedRow, ValueList>();
    }

    @Override
    public List<MappedGroup> getCombineMappedGroup() {
        if (this.combineMappedGroups != null) {
            return this.combineMappedGroups;
        }
        this.combineMappedGroups = this.builder.buildCombineMappedGroup();
        return this.combineMappedGroups;
    }

    @Override
    public List<MappedGroup> getFormulaMappedGroup() {
        if (this.formulaMappedGroups != null) {
            return this.formulaMappedGroups;
        }
        this.formulaMappedGroups = this.builder.buildFormulaMappedGroup();
        return this.formulaMappedGroups;
    }

    @Override
    public MappedDimItem getMappedDimItemById(Long dimId) {
        if (this.mappedDimItems == null) {
            this.mappedDimItems = this.builder.buildMappedDimModel();
        }
        return this.mappedDimItems.get(dimId);
    }

    @Override
    public Pair<Long, String> getSchema() {
        return this.scheme;
    }

    @Override
    public Pair<Long, String> getCurrency() {
        return this.currency;
    }

    @Override
    public Pair<Long, String> getFy() {
        return this.fy;
    }

    @Override
    public Pair<Long, String> getPeriod() {
        return this.period;
    }

    @Override
    public Pair<Long, String> getOrg() {
        return this.org;
    }

    @Override
    public Pair<Long, String> getScene() {
        return this.scene;
    }

    @Override
    public Pair<Long, String> getModel() {
        return this.model;
    }

    @Override
    public <T> T getCustomParam(String key) {
        return (T)this.customParams.get(key);
    }

    @Override
    public <T> void putCustomParam(String key, T val) {
        this.customParams.put(key, val);
    }

    @Override
    public void mapRow2Value(MappedRow row, ValueList value) {
        this.result.put(row, value);
    }

    @Override
    public Map<MappedRow, ValueList> getResult() {
        return this.result;
    }

    @Override
    public Map<Object, DimMappedRelation.DimAndDefValRela> getSourceDefaultValsMap() {
        return this.getMappedRelation().getSourceDefaultValsMap();
    }

    @Override
    public Map<Object, DimMappedRelation.DimAndDefValRela> getTargetDefaultValsMap() {
        return this.getMappedRelation().getTargetDefaultValsMap();
    }

    @Override
    public DimMappedRelation getMappedRelation() {
        if (this.mappedRelation == null) {
            this.mappedRelation = this.builder.buildDimMappedRelation();
        }
        return this.mappedRelation;
    }

    @Override
    public MemberNumToIdCache getIdsCache() {
        if (this.idCache == null) {
            this.idCache = new MemberNumToIdCache((Long)this.model.p1);
        }
        return this.idCache;
    }

    @Override
    public MemberMsgCache getMemsCache() {
        if (this.memsCache == null) {
            this.memsCache = new MemberMsgCache((Long)this.model.p1);
        }
        return this.memsCache;
    }

    public Object clone() throws CloneNotSupportedException {
        IntegrateContext context = (IntegrateContext)super.clone();
        context.customParams = new HashMap<String, Object>(this.customParams);
        this.result = new HashMap<MappedRow, ValueList>();
        return context;
    }

    public void setOrg(Pair<Long, String> org) {
        this.org = org;
    }

    public void setCurrency(Pair<Long, String> currency) {
        this.currency = currency;
    }

    @Override
    public void setMapOrg(Pair<Long, String> mapOrg) {
        this.mapOrg = mapOrg;
    }

    @Override
    public Pair<Long, String> getMapOrg() {
        if (this.mapOrg == null) {
            this.mapOrg = IntegrationUtil.getCommonSingleMappedMembInfo(this, "bcm_entitymembertree", (String)this.org.p2);
        }
        return this.mapOrg;
    }

    @Override
    public void setMapCurrency(Pair<Long, String> mapCurrency) {
        this.mapCurrency = mapCurrency;
    }

    @Override
    public Pair<Long, String> getMapCurrency() {
        if (this.mapCurrency == null) {
            this.mapCurrency = IntegrationUtil.getCommonSingleMappedMembInfo(this, "bcm_currencymembertree", (String)this.currency.p2);
        }
        return this.mapCurrency;
    }

    @Override
    public void setMapFy(Pair<Long, String> mapFy) {
        this.mapFy = mapFy;
    }

    @Override
    public Pair<Long, String> getMapFy() {
        if (this.mapFy == null) {
            this.mapFy = IntegrationUtil.getCommonSingleMappedMembInfo(this, "bcm_fymembertree", (String)this.fy.p2);
        }
        return this.mapFy;
    }

    @Override
    public void setMapPeriod(Pair<Long, String> mapPeriod) {
        this.mapPeriod = mapPeriod;
    }

    @Override
    public Pair<Long, String> getMapPeriod() {
        if (this.mapPeriod == null) {
            this.mapPeriod = IntegrationUtil.getCommonSingleMappedMembInfo(this, "bcm_periodmembertree", (String)this.period.p2);
        }
        return this.mapPeriod;
    }

    @Override
    public List<MappedGroup> getServiceMappedGroup() {
        if (this.supplierGroups != null) {
            return this.supplierGroups;
        }
        if (this.supplier == null) {
            throw new KDBizException("not init IServiceMappedGroupSupplier!");
        }
        this.supplierGroups = this.supplier.getServiceMappedGroup();
        return this.supplierGroups;
    }

    @Override
    public boolean isNonLeafMemb(MappedMembItem item) {
        Set set = this.nonLeafMembMap.computeIfAbsent(item.getMappedDim().getEntityNumb(), k -> {
            QFBuilder qf = new QFBuilder();
            qf.add("isleaf", "=", (Object)"0");
            if (item.getMappedDim().getEntityNumb().startsWith("bcm_userdefinedmembertree")) {
                qf.add("dimension.number", "=", (Object)item.getMappedDim().getNumber());
            }
            HashSet<String> nums = new HashSet<String>();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)item.getMappedDim().getEntityNumb(), (String)"number", (QFilter[])qf.toArray(), null);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    nums.add(row.getString("number"));
                }
            }
            return nums;
        });
        return set.contains(item.getNumber());
    }

    @Override
    public Set<Long> getTemplateIds() {
        return this.templateIds;
    }

    @Override
    public Set<Long> getAllVersionTemplateIds() {
        if (this.allVersionTemplateIds.isEmpty() && !this.templateIds.isEmpty()) {
            Collection<Long> allVersionTemplateIds = TemplateUtils.getAllVersionTemplateIds(this.templateIds);
            this.allVersionTemplateIds = Sets.newHashSet(allVersionTemplateIds);
        }
        return this.allVersionTemplateIds;
    }

    @Override
    public Class<? extends AbstractIntegrateService> getServiceClass() {
        return this.serviceClass;
    }
}

