/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.filter;

import java.util.Set;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.filter.IFilter;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.strategy.PermControlStrategy;
import kd.fi.bcm.common.enums.RangeEnum;

public class CQFilter
implements IFilter<String> {
    @Override
    public boolean isMatched(MappedSourceItem item, String compare, IIntegrateContext ctx) {
        if (item.getScopeSourceItems() == null) {
            return this.isMatchedSingleItem(item, compare, ctx);
        }
        return item.getScopeSourceItems().stream().anyMatch(scope -> {
            RangeEnum range = RangeEnum.getRangeByVal((int)scope.getScope());
            return this.isMatchedSingleItem((MappedSourceItem)scope, compare, ctx);
        });
    }

    private boolean isMatchedSingleItem(MappedSourceItem item, String compare, IIntegrateContext ctx) {
        RangeEnum range = RangeEnum.getRangeByVal((int)item.getScope());
        Set<Long> ids = ctx.getIdsCache().getIds(item.getMappedDim().getNumber(), compare);
        if (ids == null) {
            return false;
        }
        return ids.stream().anyMatch(id -> PermControlStrategy.getStrategy(range).isMatchPermission(new MembRangeItem(item.getMappedDim().getEntityNumb(), Long.valueOf(item.getId().toString()), item.getNumber(), range, item.isCustom(), ctx.getModel().p1), id));
    }
}

