/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.filter;

import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.filter.BetweenFilter;
import kd.fi.bcm.business.integrationnew.filter.CQFilter;
import kd.fi.bcm.business.integrationnew.filter.EqualsFilter;
import kd.fi.bcm.business.integrationnew.filter.IFilter;
import kd.fi.bcm.business.integrationnew.filter.IncludeFilter;
import kd.fi.bcm.business.integrationnew.filter.LikeFilter;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;

public class FilterFactory {
    private static final EqualsFilter equals = new EqualsFilter();
    private static final LikeFilter like = new LikeFilter();
    private static final BetweenFilter bwt = new BetweenFilter();
    private static final IncludeFilter include = new IncludeFilter();
    private static final CQFilter cq = new CQFilter();

    public static IFilter<String> getFilter(MappedSourceItem srcItem, IIntegrateContext ctx) {
        int scope = srcItem.getScope();
        MapScopeEnum sc = MapScopeEnum.getEnumByindex((int)scope);
        if (sc == null) {
            return FilterEnum.CQ.supply();
        }
        switch (sc) {
            case EQUALS: {
                return FilterEnum.Equals.supply();
            }
            case LIKE: {
                return FilterEnum.Like.supply();
            }
            case RANGE: {
                return FilterEnum.Betweet.supply();
            }
            case INCLUDE: {
                return FilterEnum.Include.supply();
            }
        }
        return FilterEnum.CQ.supply();
    }

    static enum FilterEnum {
        Equals{

            @Override
            IFilter<String> supply() {
                return equals;
            }
        }
        ,
        Like{

            @Override
            IFilter<String> supply() {
                return like;
            }
        }
        ,
        Betweet{

            @Override
            IFilter<String> supply() {
                return bwt;
            }
        }
        ,
        Include{

            @Override
            IFilter<String> supply() {
                return include;
            }
        }
        ,
        CQ{

            @Override
            IFilter<String> supply() {
                return cq;
            }
        };


        abstract IFilter<String> supply();
    }
}

