/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDefaultVal;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedTargetItem;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.spread.formula.EncoderService;

public class MappedModelBuilder {
    private IIntegrateContext _ctx;
    Map<String, Map<Integer, MappedGroup>> groupTypesAll = null;

    public MappedModelBuilder(IIntegrateContext ctx) {
        this._ctx = ctx;
    }

    public List<MappedGroup> buildCombineMappedGroup() {
        Map<String, Map<Integer, MappedGroup>> groupTypes = this.groupTypesAll == null ? this.transDyna2Model() : this.groupTypesAll;
        Map<Integer, MappedGroup> combineGroupMap = groupTypes.get("1");
        return combineGroupMap != null ? new ArrayList<MappedGroup>(combineGroupMap.values()) : new ArrayList(0);
    }

    public List<MappedGroup> buildFormulaMappedGroup() {
        Map<String, Map<Integer, MappedGroup>> groupTypes = this.groupTypesAll == null ? this.transDyna2Model() : this.groupTypesAll;
        Map<Integer, MappedGroup> formulaGroupMap = groupTypes.get("2");
        return formulaGroupMap != null ? new ArrayList<MappedGroup>(formulaGroupMap.values()) : new ArrayList(0);
    }

    public DimMappedRelation buildDimMappedRelation() {
        return (DimMappedRelation)GlobalCacheServiceHelper.getOrLoadNode((String)(this.getCacheKey() + "|DimMappedRelation"), () -> {
            DynamicObject[] mappeds = IntegrationUtil.queryDefaultAndMemMapping((Long)this._ctx.getSchema().p1);
            if (mappeds == null || mappeds.length == 0) {
                this.throwException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5173\u7cfb\u672a\u627e\u5230\u3002", (String)"MappedModelBuilder_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            this.setExAttr(mappeds);
            DimMappedRelation relation = new DimMappedRelation();
            block6: for (DynamicObject dyna : mappeds) {
                int mappedType = dyna.getInt("mappedtype");
                switch (mappedType) {
                    case 1: {
                        this.transSingleMapped(dyna, relation);
                        continue block6;
                    }
                    case 2: {
                        this.transDefValMapped(dyna, relation, false);
                        continue block6;
                    }
                    case 3: {
                        this.transDefValMapped(dyna, relation, true);
                        continue block6;
                    }
                    case 4: {
                        this.transMultiDimMapped(dyna, relation);
                        continue block6;
                    }
                    default: {
                        this.throwException(ResManager.loadKDString((String)"\u672a\u77e5\u7ef4\u5ea6\u6620\u5c04\u7c7b\u578b\u201c%d\u201d\u3002", (String)"MappedModelBuilder_1", (String)"fi-bcm-business", (Object[])new Object[0]), mappedType);
                    }
                }
            }
            return relation;
        });
    }

    private void setExAttr(DynamicObject[] mappeds) {
        if (!"XEXTEND".equals((String)this._ctx.getCustomParam("issrc"))) {
            return;
        }
        HashMap<Long, Map> exAttrMap = new HashMap<Long, Map>(16);
        for (DynamicObject dynamicObject : mappeds) {
            DynamicObjectCollection isdimmapsrcentry;
            DynamicObject datafiltercondition;
            Map map = exAttrMap.computeIfAbsent(dynamicObject.getLong("id"), key -> new HashMap(16));
            Long inheritanceschemeId = dynamicObject.getLong("inheritancescheme_id");
            if (inheritanceschemeId != null && inheritanceschemeId > 0L) {
                map.put("inheritancescheme", inheritanceschemeId);
                map.put("number", dynamicObject.getString("number"));
            }
            if ((datafiltercondition = dynamicObject.getDynamicObject("datafiltercondition")) != null) {
                map.put("datafiltercondition", datafiltercondition.getString("number"));
                map.put("filtervalue", dynamicObject.getString("filtervalue"));
            }
            if ((isdimmapsrcentry = dynamicObject.getDynamicObjectCollection("isdimmapsrcentry")) == null || isdimmapsrcentry.size() == 0) continue;
            map.put("filternumber", ((DynamicObject)isdimmapsrcentry.get(0)).getDynamicObject("srcdimension").getString("number"));
            map.put("reservedfield", dynamicObject.getString("reservedfield"));
        }
        this._ctx.putCustomParam("exAttrMap", exAttrMap);
    }

    private void transSingleMapped(DynamicObject dyna, DimMappedRelation relation) {
        DynamicObjectCollection srcEntry = dyna.getDynamicObjectCollection("isdimmapsrcentry");
        DynamicObjectCollection targEntry = dyna.getDynamicObjectCollection("isdimmaptargentry");
        DynamicObject targEntry0 = (DynamicObject)targEntry.get(0);
        if ("bcm_structofextend".equals(targEntry0.getString("tagdimtype"))) {
            return;
        }
        DimMappedRelation.DimAndDefValRela src = new DimMappedRelation.DimAndDefValRela(this._ctx.getMappedDimItemById(((DynamicObject)srcEntry.get(0)).getLong("srcdimension.id")));
        DimMappedRelation.DimAndDefValRela targ = new DimMappedRelation.DimAndDefValRela(this._ctx.getMappedDimItemById(targEntry0.getLong("tagdimension.id")));
        DimMappedRelation.SingleDimRelationPair pair = new DimMappedRelation.SingleDimRelationPair(dyna.getLong("id"), 1);
        pair.setSourceDimItem(src);
        pair.setTargetDimItem(targ);
        pair.setDimMappedId(dyna.getLong("id"));
        relation.addSingleDimRelation(pair);
    }

    private void transDefValMapped(DynamicObject dyna, DimMappedRelation relation, boolean isDefSrcVal) {
        DynamicObjectCollection entry = dyna.getDynamicObjectCollection(isDefSrcVal ? "isdimmapsrcentry" : "isdimmaptargentry");
        for (DynamicObject def : entry) {
            MappedDimItem dim = this._ctx.getMappedDimItemById(def.getLong(isDefSrcVal ? "srcdimension.id" : "tagdimension.id"));
            DimMappedRelation.DimAndDefValRela defval = new DimMappedRelation.DimAndDefValRela(dim);
            DynamicObjectCollection entries = def.getDynamicObjectCollection(isDefSrcVal ? "isdimmapsrcdefval" : "isdimmaptargdefval");
            for (DynamicObject val : entries) {
                defval.addMappedDefaultVal(new MappedDefaultVal(val.getLong(isDefSrcVal ? "srcmemb" : "tagmemb"), val.getString(isDefSrcVal ? "soucememnum" : "targetmemnum"), dim));
            }
            DimMappedRelation.SingleDimRelationPair pair = new DimMappedRelation.SingleDimRelationPair(def.getLong("id"), isDefSrcVal ? 3 : 2);
            if (isDefSrcVal) {
                pair.setSourceDimItem(defval);
            } else {
                pair.setTargetDimItem(defval);
            }
            relation.addSingleDimRelation(pair);
        }
    }

    private void transMultiDimMapped(DynamicObject dyna, DimMappedRelation relation) {
        DynamicObjectCollection srcEntry = dyna.getDynamicObjectCollection("isdimmapsrcentry");
        DynamicObjectCollection targEntry = dyna.getDynamicObjectCollection("isdimmaptargentry");
        for (DynamicObject item : srcEntry) {
            relation.getMultiDimRelaionPair().getSourceDimMap().put(item.getLong("srcdimension.id"), this._ctx.getMappedDimItemById(item.getLong("srcdimension.id")));
        }
        for (DynamicObject item : targEntry) {
            relation.getMultiDimRelaionPair().getTargetDimMap().put(item.getLong("tagdimension.id"), this._ctx.getMappedDimItemById(item.getLong("tagdimension.id")));
        }
    }

    private void throwException(String msg, Object ... params) {
        throw new KDBizException(String.format(msg, params));
    }

    private void throwException(String msg) {
        throw new KDBizException(msg);
    }

    public Map<Long, MappedDimItem> buildMappedDimModel() {
        return (Map)GlobalCacheServiceHelper.getOrLoadNode((String)(this.getCacheKey() + "|basedatalist"), () -> {
            HashMap<Long, MappedDimItem> dimMapped = new HashMap<Long, MappedDimItem>();
            try (DataSet ds = IntegrationUtil.queryISBaseDataList((Long)this._ctx.getSchema().p1);){
                this.packMappedDimModel(dimMapped, ds, "entitynumber");
            }
            ds = IntegrationUtil.queryDimensionList((Long)this._ctx.getModel().p1);
            var3_3 = null;
            try {
                this.packMappedDimModel(dimMapped, ds, "membermodel");
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var3_3 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            return dimMapped;
        });
    }

    private void packMappedDimModel(Map<Long, MappedDimItem> dimMapped, DataSet ds, String entityField) {
        while (ds.hasNext()) {
            String number;
            Row r = ds.next();
            Long id = r.getLong("id");
            String mappedKey = number = r.getString("number");
            String entityNumber = r.getString(entityField);
            dimMapped.put(id, new MappedDimItem(id, number, mappedKey, entityNumber));
        }
    }

    private Map<String, Map<Integer, MappedGroup>> transDyna2Model() {
        DynamicObjectCollection coll = IntegrationUtil.queryCombine((Long)this._ctx.getSchema().p1, (Long)this._ctx.getOrg().p1, this._ctx.getAllVersionTemplateIds(), (Long)this._ctx.getPeriod().p1);
        HashMap<String, Map<Integer, MappedGroup>> map = new HashMap<String, Map<Integer, MappedGroup>>();
        if (coll.size() > 0) {
            MappedGroup group = null;
            EncoderService coder = new EncoderService();
            for (DynamicObject dyna : coll) {
                DynamicObjectCollection entry;
                MappedRow row;
                String srctype = dyna.getString("srctype");
                Integer groupNum = dyna.getInt("group");
                boolean isFloat = dyna.getBoolean("isdyna");
                boolean isFromFormula = dyna.getInt("srctype") == 2;
                Long templateId = dyna.getLong("templateid_id");
                int oprt = dyna.getInt("computeoprt");
                this._ctx.getTemplateIds().add(templateId);
                Map tmpMap = map.computeIfAbsent(srctype, key -> new HashMap());
                group = tmpMap.computeIfAbsent(groupNum, g -> new MappedGroup());
                if (isFromFormula) {
                    row = new MappedRow(((DynamicObject)dyna.getDynamicObjectCollection("isgroupsrcexprentry").get(0)).getString("expressions"), coder.getCode());
                } else {
                    row = new MappedRow(isFloat, oprt == -1);
                    entry = dyna.getDynamicObjectCollection("isgroupsrcmapentry");
                    for (DynamicObject tmp : entry) {
                        row.addMappedSourceItem(this.buildSourceMapped(tmp));
                    }
                }
                row.setId(dyna.getLong("id"));
                entry = dyna.getDynamicObjectCollection("isgrouptargmapentry");
                for (DynamicObject tmp : entry) {
                    row.addMappedTargetItem(this.buildTargetMapped(tmp));
                }
                block3: for (MappedSourceItem src : row.getSrcMapped().values()) {
                    if (!src.isFollowValue()) continue;
                    for (MappedTargetItem targ : row.getTargMapped().values()) {
                        DimMappedRelation.SingleDimRelationPair dimRela = this._ctx.getMappedRelation().getSingleDimRelaBySrcAndTargDim(src.getMappedDim(), targ.getMappedDim());
                        if (dimRela == null) continue;
                        row.mapSrcDim2Relation(src.getMappedDim(), dimRela);
                        continue block3;
                    }
                }
                group.addMappedRow(row);
            }
        }
        this.groupTypesAll = map;
        return map;
    }

    private MappedSourceItem buildSourceMapped(DynamicObject dyna) {
        String membNum = dyna.getString("srcmembnumber");
        long membId = dyna.getLong("srcmember");
        long dimId = dyna.getLong("srcdimension");
        long prop = dyna.getLong("srcpropertyid");
        int seq = dyna.getInt("seq");
        int scope = dyna.getInt("scope");
        int priority = dyna.getInt("priority");
        boolean isFloatDim = dyna.getBoolean("isdynadim");
        boolean isFloatText = dyna.getBoolean("istext");
        MappedSourceItem item = new MappedSourceItem(membId, membNum, this._ctx.getMappedDimItemById(dimId), seq, scope, isFloatDim, isFloatText);
        item.setPropId(prop);
        item.setPriority(priority);
        DimMappedRelation relation = this._ctx.getMappedRelation();
        if (membNum.toLowerCase(Locale.ENGLISH).endsWith("defaultall") || relation.getSingeDimRelationByDimId(dimId) != null && relation.getSingeDimRelationByDimId(dimId).getMappedType() == 1 && !relation.getMultiDimRelaionPair().getTargetDimMap().containsKey(relation.getSingeDimRelationByDimId(dimId).getTargetDimItem().getDimItem().getId())) {
            item.setFollowValueFlag(true);
        }
        return item;
    }

    private MappedTargetItem buildTargetMapped(DynamicObject dyna) {
        String membNum = dyna.getString("tarmembnumber");
        long membId = dyna.getLong("tarmember");
        long dimId = dyna.getLong("tardimension");
        return new MappedTargetItem(membId, membNum, this._ctx.getMappedDimItemById(dimId));
    }

    private String getCacheKey() {
        return (String)this._ctx.getSchema().p2 + "|" + (String)this._ctx.getModel().p2;
    }

    public Map<Long, List<DynamicObject>> buildSingleMap() {
        String selectField = "dseq,dimmapid,scope,targmembid,targmembnumber,targmembname,srcmembnumber,srcmembname,issinglemapentry.seq,issinglemapentry.srcdim,issinglemapentry.srcmembid,issinglemapentry.srcmemnumber";
        return (Map)GlobalCacheServiceHelper.getOrLoadNode((String)(this.getCacheKey() + "|singleMap"), () -> {
            DynamicObject[] col;
            HashMap<Long, List> singleMap = new HashMap<Long, List>(16);
            QFilter filter = new QFilter("schemeid", "=", this._ctx.getSchema().p1);
            for (DynamicObject dot : col = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)selectField, (QFilter[])new QFilter[]{filter}, (String)"issinglemapentry.seq")) {
                Long id = dot.getLong("dimmapid");
                singleMap.computeIfAbsent(id, k -> new ArrayList(10));
                List objs = (List)singleMap.get(id);
                objs.add(dot);
            }
            return singleMap;
        });
    }
}

