/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.model.mapped;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDefaultVal;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;

public class DimMappedRelation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Object, SingleDimRelationPair> singleDimMappedRela = new HashMap<Object, SingleDimRelationPair>();
    private HashMap<String, List<SingleDimRelationPair>> tarDim2Pairs = new HashMap();
    private Table<MappedDimItem, MappedDimItem, SingleDimRelationPair> mapPair = HashBasedTable.create();
    private MultiDimRelaionPair multiDimRelaPair = new MultiDimRelaionPair();
    private Map<String, SingleDimRelationPair> dimRelMap = new HashMap<String, SingleDimRelationPair>();

    public void addSingleDimRelation(SingleDimRelationPair singleDimRelaPair) {
        if (singleDimRelaPair.sourceDimItem != null) {
            this.singleDimMappedRela.put(singleDimRelaPair.sourceDimItem.dimItem.getId(), singleDimRelaPair);
        }
        if (singleDimRelaPair.targetDimItem != null) {
            this.singleDimMappedRela.put(singleDimRelaPair.targetDimItem.dimItem.getId(), singleDimRelaPair);
            List tarDim2Pair = this.tarDim2Pairs.getOrDefault(singleDimRelaPair.targetDimItem.dimItem.getNumber(), new ArrayList());
            tarDim2Pair.add(singleDimRelaPair);
            this.tarDim2Pairs.put(singleDimRelaPair.targetDimItem.dimItem.getNumber(), tarDim2Pair);
        }
        if (singleDimRelaPair.sourceDimItem != null && singleDimRelaPair.targetDimItem != null) {
            this.mapPair.put((Object)singleDimRelaPair.sourceDimItem.dimItem, (Object)singleDimRelaPair.targetDimItem.dimItem, (Object)singleDimRelaPair);
        }
    }

    public SingleDimRelationPair getSingeDimRelationByDimId(Object id) {
        if (!this.singleDimMappedRela.containsKey(id)) {
            return null;
        }
        return this.singleDimMappedRela.get(id);
    }

    public SingleDimRelationPair getSingleDimRelaBySrcAndTargDim(MappedDimItem src, MappedDimItem targ) {
        return (SingleDimRelationPair)this.mapPair.get((Object)src, (Object)targ);
    }

    public SingleDimRelationPair getSingleDimRelaBySrcAndTargDim(String srcNUm, String targNum) {
        return this.dimRelMap.computeIfAbsent(srcNUm + "_" + targNum, k -> {
            Iterator<Object> it = this.mapPair.rowKeySet().iterator();
            MappedDimItem smp = null;
            while (it.hasNext() && !(smp = (MappedDimItem)it.next()).getNumber().equals(srcNUm)) {
                smp = null;
            }
            if (smp != null) {
                Map re = this.mapPair.row((Object)smp);
                it = re.keySet().iterator();
                MappedDimItem tmp = null;
                while (it.hasNext() && !(tmp = (MappedDimItem)it.next()).getNumber().equals(targNum)) {
                    tmp = null;
                }
                if (tmp != null) {
                    return (SingleDimRelationPair)this.mapPair.get((Object)smp, (Object)tmp);
                }
            }
            return null;
        });
    }

    public MultiDimRelaionPair getMultiDimRelaionPair() {
        return this.multiDimRelaPair;
    }

    public Table<MappedDimItem, MappedDimItem, SingleDimRelationPair> getSingleMappedRelationPair() {
        return this.mapPair;
    }

    public Map<Object, DimAndDefValRela> getSourceDefaultValsMap() {
        HashMap<Object, DimAndDefValRela> source = new HashMap<Object, DimAndDefValRela>();
        this.singleDimMappedRela.entrySet().forEach(e -> {
            if (((SingleDimRelationPair)e.getValue()).mappedType == 3) {
                source.put(e.getKey(), ((SingleDimRelationPair)e.getValue()).sourceDimItem);
            }
        });
        return source;
    }

    public Map<Object, DimAndDefValRela> getTargetDefaultValsMap() {
        HashMap<Object, DimAndDefValRela> source = new HashMap<Object, DimAndDefValRela>();
        this.singleDimMappedRela.entrySet().forEach(e -> {
            if (((SingleDimRelationPair)e.getValue()).mappedType == 2) {
                source.put(e.getKey(), ((SingleDimRelationPair)e.getValue()).targetDimItem);
            }
        });
        return source;
    }

    public HashMap<String, List<SingleDimRelationPair>> getTarDim2Pairs() {
        return this.tarDim2Pairs;
    }

    public static class DimAndDefValRela
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private MappedDimItem dimItem;
        private List<MappedDefaultVal> defVals = new ArrayList<MappedDefaultVal>(1);

        public DimAndDefValRela(MappedDimItem dimItem) {
            this.dimItem = dimItem;
        }

        public void addMappedDefaultVal(MappedDefaultVal v) {
            this.defVals.add(v);
        }

        public MappedDimItem getDimItem() {
            return this.dimItem;
        }

        public List<MappedDefaultVal> getDefVals() {
            return this.defVals;
        }
    }

    public static class MultiDimRelaionPair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<Long, MappedDimItem> sourceDimMap = new HashMap<Long, MappedDimItem>();
        private Map<Long, MappedDimItem> targetDimMap = new HashMap<Long, MappedDimItem>();

        public Map<Long, MappedDimItem> getSourceDimMap() {
            return this.sourceDimMap;
        }

        public void setSourceDimMap(Map<Long, MappedDimItem> sourceDimMap) {
            this.sourceDimMap = sourceDimMap;
        }

        public Map<Long, MappedDimItem> getTargetDimMap() {
            return this.targetDimMap;
        }

        public void setTargetDimMap(Map<Long, MappedDimItem> targetDimMap) {
            this.targetDimMap = targetDimMap;
        }
    }

    public static class SingleDimRelationPair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private DimAndDefValRela sourceDimItem;
        private DimAndDefValRela targetDimItem;
        private long dimMappedId = 0L;
        private int mappedType = 1;

        public DimAndDefValRela getSourceDimItem() {
            return this.sourceDimItem;
        }

        public DimAndDefValRela getTargetDimItem() {
            return this.targetDimItem;
        }

        public long getDimMappedId() {
            return this.dimMappedId;
        }

        public int getMappedType() {
            return this.mappedType;
        }

        public void setSourceDimItem(DimAndDefValRela sourceDimItem) {
            this.sourceDimItem = sourceDimItem;
        }

        public void setTargetDimItem(DimAndDefValRela targetDimItem) {
            this.targetDimItem = targetDimItem;
        }

        public void setDimMappedId(long dimMappedId) {
            this.dimMappedId = dimMappedId;
        }

        public void setMappedType(int mappedType) {
            this.mappedType = mappedType;
        }

        public SingleDimRelationPair(long mappingId, int mappedType) {
            this.mappedType = mappedType;
        }
    }
}

