/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.model.mapped;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedItemPair;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedTargetItem;

public class MappedRow
implements Iterable<MappedItemPair>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private List<MappedItemPair> pairs = new ArrayList<MappedItemPair>();
    private boolean isFloat = false;
    private boolean isNegate = false;
    private String expression = null;
    private boolean isFromFormula = false;
    private String uuid;
    private Map<String, MappedSourceItem> srcMap = new HashMap<String, MappedSourceItem>();
    private Map<String, MappedTargetItem> targMap = new HashMap<String, MappedTargetItem>();
    private Map<MappedDimItem, DimMappedRelation.SingleDimRelationPair> srcMapRela = new HashMap<MappedDimItem, DimMappedRelation.SingleDimRelationPair>();

    public MappedRow(boolean isFloat, boolean isNegate) {
        this.isFloat = isFloat;
        this.isNegate = isNegate;
    }

    public MappedRow(String expression, String uuid) {
        this(false, false);
        this.expression = expression;
        this.isFromFormula = true;
        this.uuid = uuid;
    }

    public void addPair(MappedItemPair pair) {
        this.pairs.add(pair);
    }

    public void addMappedSourceItem(MappedSourceItem src) {
        if (this.srcMap.containsKey(src.getMappedDim().getMappedKey())) {
            this.srcMap.get(src.getMappedDim().getMappedKey()).mergeSourceItem(src);
        } else {
            this.srcMap.put(src.getMappedDim().getMappedKey(), src);
        }
    }

    public void mapSrcDim2Relation(MappedDimItem srcDim, DimMappedRelation.SingleDimRelationPair rela) {
        this.srcMapRela.put(srcDim, rela);
    }

    public DimMappedRelation.SingleDimRelationPair getDimRelationBySrcDim(MappedDimItem srcDim) {
        return this.srcMapRela.get(srcDim);
    }

    public void addMappedTargetItem(MappedTargetItem targ) {
        this.targMap.put(targ.getMappedDim().getMappedKey(), targ);
    }

    public Iterator<Map.Entry<String, MappedSourceItem>> srcMappediterator() {
        return this.srcMap.entrySet().iterator();
    }

    public Map<String, MappedTargetItem> getTargMapped() {
        return this.targMap;
    }

    public Map<String, MappedSourceItem> getSrcMapped() {
        return this.srcMap;
    }

    public Iterator<Map.Entry<String, MappedTargetItem>> targMappediterator() {
        return this.targMap.entrySet().iterator();
    }

    @Override
    public Iterator<MappedItemPair> iterator() {
        return this.pairs.iterator();
    }

    public boolean isFloat() {
        return this.isFloat;
    }

    public boolean isNegate() {
        return this.isNegate;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isFromFormula() {
        return this.isFromFormula;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }
}

