/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.mq.consumer;

import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.integrationnew.service.IntegrateDispatcher2;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.mq.MQMessage;
import kd.fi.bcm.common.mq.consumer.IConsumer;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class IntegrationConsumer
implements IConsumer {
    private static final Log LOG = LogFactory.getLog(IntegrationConsumer.class);

    public void onMessage(MQMessage message, String messageId, boolean resend, MessageAcker acker) {
        Map messageBody = message.getSendMessage();
        Boolean isEntryIntergate = (Boolean)messageBody.get("isEntryIntergate");
        String intEntityStr = (String)messageBody.get("intEntity");
        LOG.info("DataTraceFrom consume message: " + messageId + " intEntity: " + intEntityStr);
        IntegrateEntity intEntity = (IntegrateEntity)ObjectSerialUtil.deSerializedBytes((String)intEntityStr);
        while (this.checkIsTooMuch()) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                LOG.error("DataTraceFrom consume error", (Throwable)e);
            }
        }
        IntegrateDispatcher2.submitTaskConsume(intEntity, isEntryIntergate);
    }

    private boolean checkIsTooMuch() {
        String configSize = ConfigServiceHelper.getStringParamNoModel("IntegrationLineSize");
        if (StringUtils.isEmpty((CharSequence)configSize) || Integer.parseInt(configSize) < 0) {
            return false;
        }
        ThreadPoolExecutor integrateTreadPool = ThreadPoolService.getTreadPoolByName("bcm_Integrate-detail");
        ThreadPoolExecutor glIntegrateTreadPool = ThreadPoolService.getTreadPoolByName("bcm_glIntegrate");
        return integrateTreadPool.getPoolSize() + glIntegrateTreadPool.getPoolSize() > Integer.parseInt(configSize);
    }
}

