/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.output;

import com.google.common.collect.HashMultimap;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.service.DataTrace2FromService;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;

public abstract class AbstractOutput
implements IOutput {
    protected IIntegrateContext _ctx;
    protected Map<String, Pair<Long, String>> srcMapTargMemb = new HashMap<String, Pair<Long, String>>();
    protected boolean isOpenTrace;
    protected boolean isDistinguish0AndNull;
    protected boolean multiCurrency;
    protected DataTrace2FromService dtfs;
    protected static final String LOCK_DIM = "lockDim";

    public AbstractOutput(IIntegrateContext ctx) {
        this._ctx = ctx;
        this.isOpenTrace = ConfigServiceHelper.getGlobalBoolParam(ConfigEnum.IS_OPEN_DATATRACE.getNumber());
        long schemeId = (Long)ctx.getSchema().p1;
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
        String srcNum = scheme.getString("issrc.number");
        this.isOpenTrace = this.isOpenTrace && (srcNum.equals("NGACC") || srcNum.equals("MIDLIB"));
        this.dtfs = new DataTrace2FromService((Long)ctx.getModel().p1, GlobalIdUtil.genGlobalLongId());
        this.multiCurrency = srcNum.equals("NGACC") && IntegrationUtil.getDefinedToCurrencyMap(this._ctx) != 0L;
        this.isDistinguish0AndNull = ConfigServiceHelper.getBoolParam((Long)this._ctx.getModel().p1, "isDistinguish0AndNull");
    }

    protected void beforeOutput() {
        this.collectMappedMembRela();
        this._ctx.putCustomParam(LOCK_DIM, IntegrationUtil.getLockDim((Long)this._ctx.getModel().p1));
    }

    private void collectMappedMembRela() {
        HashMultimap map = HashMultimap.create();
        this._ctx.getResult().entrySet().forEach(entry -> ((ValueList)entry.getValue()).getValueList().forEach(m -> m.getMembItems().entrySet().forEach(e -> map.put((Object)((MappedRow)entry.getKey()).getDimRelationBySrcDim((MappedDimItem)e.getKey()).getDimMappedId(), e.getValue()))));
        if (!map.isEmpty()) {
            map.asMap().entrySet().forEach(e -> {
                QFBuilder qf = new QFBuilder();
                qf.add("dimmapid", "=", e.getKey());
                qf.add("issinglemapentry.srcmemnumber", "in", e.getValue());
                try (DataSet ds = IntegrationUtil.queryMemberMapped(qf, null);){
                    while (ds.hasNext()) {
                        Row r = ds.next();
                        this.srcMapTargMemb.put(this.packDimAndMembKey((Long)e.getKey(), r.getString("issinglemapentry.srcmemnumber")), (Pair<Long, String>)Pair.onePair((Object)r.getLong("targmembid"), (Object)r.getString("targmembnumber")));
                    }
                }
            });
        }
    }

    protected String getTargMembNumbBySourceItem(Long mapDimId, String memb) {
        Pair<Long, String> pair = this.srcMapTargMemb.get(this.packDimAndMembKey(mapDimId, memb));
        if (pair != null) {
            return (String)pair.p2;
        }
        return null;
    }

    protected String packDimAndMembKey(Long mapDimId, String memb) {
        return mapDimId.toString() + "|" + memb;
    }

    @Override
    public void output() {
        this.beforeOutput();
        for (MappedGroup group : this._ctx.getCombineMappedGroup()) {
            this.handleGroupResult(group, this._ctx.getResult());
        }
        for (MappedGroup group : this._ctx.getFormulaMappedGroup()) {
            this.handleGroupResult(group, this._ctx.getResult());
        }
        this.doOutput();
        this.afterOutput();
    }

    protected abstract void handleGroupResult(MappedGroup var1, Map<MappedRow, ValueList> var2);

    protected abstract void doOutput();

    protected void afterOutput() {
    }
}

