/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.output;

import com.alibaba.fastjson.JSONObject;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.exception.InValidateParamIntegrateException;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.value.IValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.AbstractOutput;
import kd.fi.bcm.business.integrationnew.provider.my2eas.OlapDataBulider;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.integration.AdapterEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class EasOutPut
extends AbstractOutput {
    private List<Map<String, Object>> table;
    private Map<MappedRow, ValueList> result;
    private OlapDataBulider qb;
    private BloomFilter<String> dynaRowExistsFilter;
    private boolean isFloat;

    public EasOutPut(IIntegrateContext ctx, boolean isFloat) {
        super(ctx);
        this.setFloat(isFloat);
    }

    @Override
    protected void handleGroupResult(MappedGroup group, Map<MappedRow, ValueList> resultSet) {
    }

    public final void setFloat(boolean aFloat) {
        this.isFloat = aFloat;
    }

    @Override
    protected void doOutput() {
        this.table = new ArrayList<Map<String, Object>>();
        this.result = this._ctx.getResult();
        if (this.result.size() == 0) {
            return;
        }
        this.qb = new OlapDataBulider(this._ctx);
        this.qb.fixSrcMapTargMemb();
        this.toJson();
        HashMap<String, AdapterEnum> filter = new HashMap<String, AdapterEnum>();
        if (this._ctx.getCustomParam("filter") != null) {
            filter.putAll((Map)this._ctx.getCustomParam("filter"));
        }
        filter.put("adapter", AdapterEnum.IERP2EASCSL);
        JSONObject data = new JSONObject();
        data.put("data", this.table);
        data.put("filter", filter);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("action", (Object)"save");
        jsonObj.put("taskId", this._ctx.getCustomParam("taskId"));
        jsonObj.put("solution", this._ctx.getCustomParam("solution"));
        jsonObj.put("data", (Object)data);
        DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCSchemaExecutorService", (String)"execute", (Object[])new Object[]{jsonObj.toJSONString()});
    }

    private void toJson() {
        for (MappedGroup group : this._ctx.getCombineMappedGroup()) {
            if (group.iterator().next().isFloat()) {
                if (!this.isFloat) continue;
                this.packDynaRptRowInfo(group);
                continue;
            }
            if (this.isFloat) continue;
            this.packFixedRptRowInfo(group);
        }
    }

    private void packFixedRptRowInfo(MappedGroup group) {
        MappedRow sample = group.iterator().next();
        BigDecimal value = this.addValue(group);
        Map<String, Object> row = this.lookingEasNumber(sample);
        row.put("fdynaitemkey", null);
        row.put("ftext", null);
        row.put("fdatatype", 1);
        row.put("famount", value);
        row.put("fdynaItemname", null);
        this.table.add(row);
    }

    private void packDynaRptRowInfo(MappedGroup group) {
        for (MappedRow mapRow : group) {
            ValueList vs = this.result.get(mapRow);
            if (vs == null) continue;
            for (IValueItem v : vs.getValueList()) {
                this.packDynaRptRowBodyInfo(mapRow, v);
                this.genNewDynaRptFloatTxtRowInfo(mapRow, v);
            }
        }
    }

    private void genNewDynaRptFloatTxtRowInfo(MappedRow mapRow, IValueItem v) {
        String text = (String)v.getProperty("text");
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        Map<String, Object> row = this.packDynaRptRowCommondBodyInfo(mapRow, v);
        row.put("fdatatype", 3);
        if (this.checkDynaRecordExists(row)) {
            return;
        }
        String textDim = (String)v.getProperty("textDim");
        String textname = (String)this._ctx.getMemsCache().getMsg(textDim, text, "name");
        row.put("ftext", textname);
        row.put("famount", null);
        this.table.add(row);
    }

    private void packDynaRptRowBodyInfo(MappedRow mapRow, IValueItem v) {
        Map<String, Object> row = this.packDynaRptRowCommondBodyInfo(mapRow, v);
        int datatype = v.getValue() instanceof Number ? 1 : 3;
        row.put("fdatatype", datatype);
        row.put("ftext", v.getValue() instanceof Number ? null : (Object)v.getValue());
        row.put("famount", v.getValue() instanceof Number ? (Object)v.getValue() : null);
        if (!this.checkDynaRecordExists(row)) {
            this.table.add(row);
        }
    }

    private Map<String, Object> packDynaRptRowCommondBodyInfo(MappedRow mapRow, IValueItem v) {
        Map<String, Object> row = this.lookingEasNumber(mapRow);
        String floatDim = (String)v.getProperty("floatDim");
        String floatDimMem = (String)v.getProperty("float");
        String floatDimMemname = (String)this._ctx.getMemsCache().getMsg(floatDim, floatDimMem, "name");
        row.put("fdynaitemkey", floatDim);
        row.put("fdynaitemname", floatDimMemname);
        return row;
    }

    private BigDecimal addValue(MappedGroup group) {
        BigDecimal value = new BigDecimal(0);
        for (MappedRow row : group) {
            ValueList vs = this.result.get(row);
            if (vs == null) continue;
            for (IValueItem v : vs.getValueList()) {
                value = value.add(new BigDecimal(v.getValue().toString()));
            }
        }
        return value;
    }

    private Map<String, Object> lookingEasNumber(MappedRow sample) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EasCol.fcompany.col, ((Pair)this.qb.getSrcMapTargMemb().get((Object)DimEntityNumEnum.ENTITY.getNumber(), (Object)this._ctx.getOrg().p2)).p2);
        map.put(EasCol.fyear.col, ((Pair)this.qb.getSrcMapTargMemb().get((Object)DimEntityNumEnum.YEAR.getNumber(), (Object)this._ctx.getFy().p2)).p2);
        map.put(EasCol.fperiod.col, ((Pair)this.qb.getSrcMapTargMemb().get((Object)DimEntityNumEnum.PERIOD.getNumber(), (Object)this._ctx.getPeriod().p2)).p2);
        map.put(EasCol.fcurrency.col, ((Pair)this.qb.getSrcMapTargMemb().get((Object)DimEntityNumEnum.CURRENCY.getNumber(), (Object)this._ctx.getCurrency().p2)).p2);
        this._ctx.getTargetDefaultValsMap().values().forEach(td -> td.getDefVals().forEach(tdv -> map.put(this.getEasCol(tdv.getMappedDim()), tdv.getNumber())));
        sample.getSrcMapped().values().forEach(sv -> {
            DimMappedRelation.SingleDimRelationPair p;
            if (StringUtils.isNotEmpty((CharSequence)sv.getNumber()) && (p = this._ctx.getMappedRelation().getSingeDimRelationByDimId(sv.getMappedDim().getId())) != null) {
                MappedDimItem easDimItem = p.getTargetDimItem().getDimItem();
                Pair pv = (Pair)this.qb.getSrcMapTargMemb().get((Object)sv.getMappedDim().getNumber(), (Object)sv.getNumber());
                if (pv != null) {
                    String number = (String)pv.p2;
                    map.put(this.getEasCol(easDimItem), number);
                }
            }
        });
        sample.getTargMapped().values().forEach(t -> {
            if (StringUtils.isNotEmpty((CharSequence)t.getNumber())) {
                map.put(this.getEasCol(t.getMappedDim()), t.getNumber());
            }
        });
        for (EasCol col : EasCol.values()) {
            if (map.containsKey(col.col)) continue;
            throw new InValidateParamIntegrateException(ResManager.loadKDString((String)"\u6620\u5c04\u7ef4\u5ea6\u4e0d\u5b8c\u6574\u3002", (String)"EasOutPut_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        map.put("headpk", GlobalIdUtil.genStringId());
        map.put("fisInterexch", 0);
        map.put("fownnumber", null);
        map.put("fownname", null);
        return map;
    }

    private String getEasCol(MappedDimItem dim) {
        return EasCol.getEasCol(dim.getEntityNumb()).col;
    }

    private boolean checkDynaRecordExists(Map<String, Object> row) {
        String hashStr;
        boolean isExists;
        if (this.dynaRowExistsFilter == null) {
            this.dynaRowExistsFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charset.defaultCharset()), (int)1000000, (double)0.001f);
        }
        if (!(isExists = this.dynaRowExistsFilter.mightContain((Object)(hashStr = "" + row.get("fcompany") + row.get("fcurrency") + row.get("frptitem") + row.get("fyear") + row.get("fperiod") + row.get("fperiodtype") + row.get("frptsrctype") + row.get("fdataelement") + row.get("fisInterexch") + row.get("fdynaitemkey") + row.get("fdynaitemname") + row.get("fdatatype") + row.get("fownnumber") + row.get("fownname") + row.get("ftext") + row.get("famount"))))) {
            this.dynaRowExistsFilter.put((Object)hashStr);
        }
        return isExists;
    }

    static enum EasCol {
        fcompany("fcompany", "ds_orgunit"),
        fcurrency("fcurrency", "ds_currency"),
        fyear("fyear", "ds_fiscalyear"),
        fperiod("fperiod", "ds_fiscalperiod"),
        frptitem("frptitem", "ds_rptitem"),
        fperiodtype("fperiodtype", "ds_reportperiod"),
        frptsrctype("frptsrctype", "ds_reporttype"),
        fdataelement("fdataelement", "ds_dataelement");

        private String col;
        private String entity;

        private EasCol(String col, String entity) {
            this.col = col;
            this.entity = entity;
        }

        public static EasCol getEasCol(String entity) {
            for (EasCol c : EasCol.values()) {
                if (!c.entity.equals(entity)) continue;
                return c;
            }
            throw new InValidateParamIntegrateException("can't find " + entity + " col in eas");
        }
    }
}

