/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.output;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.fi.bcm.business.dimension.data.DimensionMsgCache;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDefaultVal;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedTargetItem;
import kd.fi.bcm.business.integrationnew.model.value.IValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.OlapOutput;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class FormulaOutPut
extends OlapOutput {
    private DimensionMsgCache d;
    private List<String> errors;
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(FormulaOutPut.class);
    private static boolean IS_SINGLGESCENE = false;

    public FormulaOutPut(IIntegrateContext ctx) {
        super(ctx);
        this.d = new DimensionMsgCache((Long)this._ctx.getModel().p1);
        this.errors = new ArrayList<String>(10);
        IS_SINGLGESCENE = IntegrationUtil.intSingleScene(ctx, IntegrateProductEnum.NGACC_CProduct.getNumber(), IntegrateProductEnum.NGACCProduct.getNumber(), IntegrateProductEnum.EASACCProduct.getNumber());
    }

    @Override
    protected void handleGroupResult(MappedGroup group, Map<MappedRow, ValueList> resultSet) {
    }

    @Override
    protected void doOutput() {
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this._ctx.getCustomParam("errMsg")))) {
            this.errors.add((String)this._ctx.getCustomParam("errMsg"));
        }
        if (this._ctx.getResult().isEmpty()) {
            this._ctx.putCustomParam("InsertOlapCount", 0);
            if (this.errors.size() > 0) {
                this._ctx.putCustomParam("complete", "complete");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u91c7\u96c6\u6210\u529f\uff0c\u5b58\u5728\u9519\u8bef\u516c\u5f0f\uff1a%s\u3002", (String)"FormulaOutPut_0", (String)"fi-bcm-business", (Object[])new Object[0]), this.errors));
            }
            return;
        }
        MappedRow sample = this._ctx.getFormulaMappedGroup().get(0).iterator().next();
        ArrayList<String> groupDim = new ArrayList<String>(10);
        sample.getTargMapped().values().forEach(t -> groupDim.add(t.getMappedDim().getNumber()));
        List<SaveCommandInfo> infos = this.getSaveCommandInfo(groupDim);
        CellSet cellSets = this.packCellSet(groupDim, infos);
        log.info(String.format("\u96c6\u6210\u516c\u5f0f\u53d6\u6570 - infos:%n%s", infos));
        log.info(String.format("\u96c6\u6210\u516c\u5f0f\u53d6\u6570 - cellSets:%n%s", cellSets));
        int insertOlapCount = 0;
        for (SaveCommandInfo info : infos) {
            OlapCommandUtil.addSourceMeasure((String)((String)this._ctx.getModel().p2), (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.I1);
            insertOlapCount = cellSets.getCount() + insertOlapCount;
            OlapServiceHelper.saveData(info, cellSets, (String)this._ctx.getModel().p2, false);
        }
        if (this.isOpenTrace) {
            this.dtfs.saveCellDataPremanent();
        }
        if (this._ctx.getResult() != null && !this._ctx.getResult().isEmpty()) {
            this.executeBizRule();
        }
        this._ctx.putCustomParam("InsertOlapCount", insertOlapCount);
        if (this.errors.size() > 0) {
            this._ctx.putCustomParam("complete", "complete");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u91c7\u96c6\u6210\u529f\uff0c\u5b58\u5728\u9519\u8bef\u516c\u5f0f\uff1a%s\u3002", (String)"FormulaOutPut_0", (String)"fi-bcm-business", (Object[])new Object[0]), this.errors));
        }
    }

    private CellSet packCellSet(List<String> groupDim, List<SaveCommandInfo> infos) {
        Map<MappedRow, ValueList> result = this._ctx.getResult();
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(16);
        CellSet cellSets = new CellSet(groupDim.toArray(new String[0]), new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        for (MappedGroup mg : this._ctx.getFormulaMappedGroup()) {
            for (MappedRow row : mg) {
                String[] key = this.getKey(groupDim, row);
                BigDecimal amont = new BigDecimal(0);
                StringBuilder sb = new StringBuilder();
                ValueList vl = result.get(row);
                if (null == vl) continue;
                for (IValueItem v : vl.getValueList()) {
                    if (v.getProperty("error") != null) {
                        this.errors.add(row.getExpression() + ":" + v.getProperty("error") + ";");
                        continue;
                    }
                    if (v.getProperty("fitNumber") != null) {
                        List fitdimnum = (List)v.getProperty("fitDim");
                        List fitmemnum = (List)v.getProperty("fitNumber");
                        String[] speckey = (String[])key.clone();
                        for (int i = 0; i < fitdimnum.size(); ++i) {
                            int index = groupDim.indexOf(fitdimnum.get(i));
                            if (index < 0) continue;
                            speckey[index] = (String)fitmemnum.get(i);
                        }
                        amont = (BigDecimal)v.getValue();
                        amont = this.getValue(resultMap, speckey, amont);
                        String lockDim = (String)this._ctx.getCustomParam("lockDim");
                        Map<String, String> warnRpt = IntegrationUtil.getWarnRptFromCtx(this._ctx);
                        boolean islock = IntegrationUtil.checkLock(infos.get(0), groupDim, speckey, lockDim, warnRpt, (Long)this._ctx.getModel().p1, (String)this._ctx.getScene().p2, (String)this._ctx.getOrg().p2, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2, (String)this._ctx.getCurrency().p2);
                        if (islock) continue;
                        if (!this.isDistinguish0AndNull && BigDecimal.ZERO.compareTo(amont) == 0) {
                            cellSets.set(speckey, FacTabFieldDefEnum.FIELD_MONEY.getField(), null);
                        } else {
                            cellSets.set(speckey, FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)amont);
                        }
                        if (!this.isOpenTrace) continue;
                        DataTraceFrom dataTraceFrom = v.getDataTraceFrom();
                        this.addDataTraceInfo(dataTraceFrom, infos, groupDim, speckey);
                        continue;
                    }
                    if (((Boolean)v.getProperty("isNumber")).booleanValue()) {
                        amont = amont.add(new BigDecimal(v.getValue().toString()));
                        amont = this.getValue(resultMap, key, amont);
                        String lockDim = (String)this._ctx.getCustomParam("lockDim");
                        Map<String, String> warnRpt = IntegrationUtil.getWarnRptFromCtx(this._ctx);
                        boolean islock = IntegrationUtil.checkLock(infos.get(0), groupDim, key, lockDim, warnRpt, (Long)this._ctx.getModel().p1, (String)this._ctx.getScene().p2, (String)this._ctx.getOrg().p2, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2, (String)this._ctx.getCurrency().p2);
                        if (islock) continue;
                        if (!this.isDistinguish0AndNull && BigDecimal.ZERO.compareTo(amont) == 0) {
                            cellSets.set(key, FacTabFieldDefEnum.FIELD_MONEY.getField(), null);
                        } else {
                            cellSets.set(key, FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)amont);
                        }
                        if (!this.isOpenTrace) continue;
                        DataTraceFrom dataTraceFrom = v.getDataTraceFrom();
                        this.addDataTraceInfo(dataTraceFrom, infos, groupDim, key);
                        continue;
                    }
                    sb.append(v.getValue() == null ? "" : v.getValue().toString());
                }
            }
        }
        return cellSets;
    }

    private void addDataTraceInfo(DataTraceFrom dataTraceFrom, List<SaveCommandInfo> infos, List<String> groupDim, String[] key) {
        if (dataTraceFrom == null) {
            return;
        }
        for (SaveCommandInfo info : infos) {
            HashMap<String, String> temp = new HashMap<String, String>(info.getFixedDimensions().size() + groupDim.size());
            info.getFixedDimensions().forEach(e -> temp.put(e.getName(), e.getValue()));
            for (int i = 0; i < groupDim.size(); ++i) {
                temp.put(groupDim.get(i), key[i]);
            }
            this.dtfs.saveCellDataTemp(temp, dataTraceFrom, 2);
        }
    }

    private BigDecimal getValue(Map<String, BigDecimal> resultmap, String[] key, BigDecimal amont) {
        String stringKey = Arrays.toString(key);
        BigDecimal value = resultmap.get(stringKey);
        if (null != value) {
            amont = amont.add(value);
        }
        resultmap.put(stringKey, amont);
        return amont;
    }

    private String[] getKey(List<String> groupDim, MappedRow row) {
        String[] key = new String[groupDim.size()];
        int i = 0;
        for (Map.Entry<String, MappedTargetItem> entry : row.getTargMapped().entrySet()) {
            String dim = entry.getKey();
            i = groupDim.indexOf(dim);
            if (i < 0) continue;
            key[i] = entry.getValue().getNumber();
            if (!DimTypesEnum.MYCOMPANY.getNumber().equals(dim) || !"MyCompany".equals(entry.getValue().getNumber())) continue;
            key[i] = (String)this._ctx.getOrg().p2;
        }
        return key;
    }

    private List<SaveCommandInfo> getSaveCommandInfo(List<String> groupDim) {
        SaveCommandInfo info = new SaveCommandInfo();
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        info.addfixedDimension(new String[]{DimTypesEnum.ENTITY.getNumber(), (String)this._ctx.getOrg().p2});
        info.addfixedDimension(new String[]{DimTypesEnum.YEAR.getNumber(), (String)this._ctx.getFy().p2});
        info.addfixedDimension(new String[]{DimTypesEnum.PERIOD.getNumber(), (String)this._ctx.getPeriod().p2});
        info.addfixedDimension(new String[]{DimTypesEnum.CURRENCY.getNumber(), (String)this._ctx.getCurrency().p2});
        info.setDimensions(groupDim);
        ArrayList<SaveCommandInfo> infos = new ArrayList<SaveCommandInfo>(10);
        infos.add(info);
        for (DimensionMsgCache.Dimension dim : this.d.getAllDimensionMsg()) {
            if (groupDim.contains(dim.getNumber()) || DimTypesEnum.ENTITY.getNumber().equals(dim.getNumber()) || DimTypesEnum.YEAR.getNumber().equals(dim.getNumber()) || DimTypesEnum.PERIOD.getNumber().equals(dim.getNumber()) || DimTypesEnum.CURRENCY.getNumber().equals(dim.getNumber())) continue;
            DimMappedRelation.DimAndDefValRela de = this._ctx.getTargetDefaultValsMap().get(dim.getId());
            List<MappedDefaultVal> defVals = de.getDefVals();
            defVals = IntegrationUtil.getDefValue(defVals, dim.getNumber(), IS_SINGLGESCENE, this._ctx);
            for (SaveCommandInfo i : infos) {
                i.addfixedDimension(new String[]{de.getDimItem().getNumber(), defVals.get(0).getNumber()});
            }
            if (defVals.size() <= 1) continue;
            ArrayList<SaveCommandInfo> copys = new ArrayList<SaveCommandInfo>(10);
            for (int i = 1; i < defVals.size(); ++i) {
                for (SaveCommandInfo in : infos) {
                    SaveCommandInfo incopy = this.copySaveCommandInfo(in, de.getDimItem().getNumber());
                    incopy.addfixedDimension(new String[]{de.getDimItem().getNumber(), defVals.get(i).getNumber()});
                    copys.add(incopy);
                }
            }
            infos.addAll(copys);
        }
        return infos;
    }

    private SaveCommandInfo copySaveCommandInfo(SaveCommandInfo info, String withoutDim) {
        SaveCommandInfo copy = new SaveCommandInfo();
        copy.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        copy.setDimensions(info.getDimensions());
        info.getFixedDimensions().forEach(f -> {
            if (!f.getName().equals(withoutDim)) {
                copy.addfixedDimension(new String[]{f.getName(), f.getValue()});
            }
        });
        return copy;
    }
}

