/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integrationnew.output;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.computing.BizRuleExecStarter;
import kd.fi.bcm.business.integration.util.DataTypeUtil;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.model.DataTraceFromItem;
import kd.fi.bcm.business.integrationnew.model.mapped.DimMappedRelation;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDefaultVal;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedDimItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedGroup;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedRow;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedSourceItem;
import kd.fi.bcm.business.integrationnew.model.mapped.MappedTargetItem;
import kd.fi.bcm.business.integrationnew.model.value.IValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.AbstractOutput;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.RateEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class MiddleLibOutPut
extends AbstractOutput {
    private static final String all_dims = "all_dims";
    private static final String default_number = "default_number";
    private static final String back_number = "back_number";
    private static final String all_dims_idnumber = "all_dims_idnumber";
    private static final String single_Dim_Mapping = "singleDimMapping";
    private static final String InterCompany = "InterCompany";
    private static final String Model = "Model";
    private static final String Amount = "Amount";
    private static final String IS_NEW = "isnew";
    private static boolean IS_SINGLGESCENE = false;
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(MiddleLibOutPut.class);

    public MiddleLibOutPut(IIntegrateContext ctx) {
        super(ctx);
        IS_SINGLGESCENE = IntegrationUtil.intSingleScene(ctx, IntegrateProductEnum.MIDLIBProduct.getNumber(), IntegrateProductEnum.EASACCProduct.getNumber());
    }

    @Override
    protected void handleGroupResult(MappedGroup group, Map<MappedRow, ValueList> resultSet) {
    }

    @Override
    protected void doOutput() {
        Map<MappedRow, ValueList> resultSet = this._ctx.getResult();
        try {
            log.info(String.format("Debug Info - saveResult:\n%s", JSONUtils.toString(resultSet)));
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
        String measure = FacTabFieldDefEnum.FIELD_MONEY.getField();
        SaveCommandInfo info = new SaveCommandInfo();
        info.setMeasures(new String[]{measure});
        OlapCommandUtil.addSourceMeasure((String)((String)this._ctx.getModel().p2), (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.I1);
        String[] allDims = this.getAllDims();
        HashMap<String, Integer> dimLocation = new HashMap<String, Integer>(allDims.length);
        for (int i = 0; i < allDims.length; ++i) {
            dimLocation.put(allDims[i], i);
        }
        Map<Object, DimMappedRelation.DimAndDefValRela> targetDefaultValsMap = this._ctx.getTargetDefaultValsMap();
        Map<String, DimMappedRelation.DimAndDefValRela> tarNumbDefaultValueMap = targetDefaultValsMap.values().stream().collect(Collectors.toMap(v -> v.getDimItem().getNumber(), v -> v));
        if (resultSet != null) {
            this.preHandle(resultSet, allDims);
            HashMap<String, DataTraceFrom> dataTraceKey = new HashMap<String, DataTraceFrom>(8);
            Map<String, Object> olapSaveData = this.generateOlapData(allDims, tarNumbDefaultValueMap, resultSet, dimLocation, dataTraceKey);
            info.setDimensions(allDims);
            CellSet cellSets = new CellSet(allDims, new String[]{measure});
            HashMap exchangeRateMap = new HashMap(16);
            ArrayList resultExchangeRateList = new ArrayList(10);
            boolean isRateIntegration = this.getIsRateIntegration();
            Recorder existData = new Recorder((Object)false);
            if (isRateIntegration) {
                existData.setRecord((Object)true);
                olapSaveData.forEach((k, v) -> {
                    String[] saveDimNums = k.split("&");
                    if (!this.buildSaveParam(allDims, exchangeRateMap, saveDimNums, v, resultExchangeRateList)) {
                        return;
                    }
                    String lockDim = (String)this._ctx.getCustomParam("lockDim");
                    Map<String, String> warnRpt = IntegrationUtil.getWarnRptFromCtx(this._ctx);
                    boolean islock = IntegrationUtil.checkLock(info, Arrays.asList(allDims), saveDimNums, lockDim, warnRpt, (Long)this._ctx.getModel().p1, (String)this._ctx.getScene().p2, (String)this._ctx.getOrg().p2, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2, (String)this._ctx.getCurrency().p2);
                    if (!islock) {
                        cellSets.set(saveDimNums, measure, v);
                        this.saveDataTraceForm((String)k, allDims, (Map<String, DataTraceFrom>)dataTraceKey);
                    }
                });
            } else {
                olapSaveData.forEach((k, v) -> {
                    String[] saveDimNums = k.split("&");
                    String lockDim = (String)this._ctx.getCustomParam("lockDim");
                    Map<String, String> warnRpt = IntegrationUtil.getWarnRptFromCtx(this._ctx);
                    boolean islock = IntegrationUtil.checkLock(info, Arrays.asList(allDims), saveDimNums, lockDim, warnRpt, (Long)this._ctx.getModel().p1, (String)this._ctx.getScene().p2, (String)this._ctx.getOrg().p2, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2, (String)this._ctx.getCurrency().p2);
                    if (!islock) {
                        cellSets.set(saveDimNums, measure, v);
                        existData.setRecord((Object)true);
                        this.saveDataTraceForm((String)k, allDims, (Map<String, DataTraceFrom>)dataTraceKey);
                    }
                });
            }
            int insertOlapCount = 0;
            try (TXHandle tx = TX.required();){
                try {
                    if (((Boolean)existData.getRecord()).booleanValue()) {
                        insertOlapCount = cellSets.getCount();
                        OlapServiceHelper.saveData(info, cellSets, (String)this._ctx.getModel().p2, true, false);
                    }
                    if (isRateIntegration) {
                        SaveServiceHelper.save((DynamicObject[])resultExchangeRateList.toArray(new DynamicObject[0]));
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    log.error("error" + e.getMessage());
                    throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
                }
            }
            try {
                log.info(String.format("Debug Info - cellSets:\n%s", cellSets.toString()));
                this._ctx.putCustomParam("InsertOlapCount", insertOlapCount);
            }
            catch (Exception e) {
                throw new KDException(BosErrorCode.systemError, new Object[]{e});
            }
            if (!resultSet.isEmpty()) {
                this.executeBizRule();
            }
            if (this.isOpenTrace) {
                this.dtfs.saveCellDataPremanent();
            }
            this._ctx.putCustomParam(all_dims, null);
            this._ctx.putCustomParam(default_number, null);
            this._ctx.putCustomParam(back_number, null);
            this._ctx.putCustomParam(all_dims_idnumber, null);
            this._ctx.putCustomParam(single_Dim_Mapping, null);
        }
    }

    private void saveDataTraceForm(String k, String[] allDims, Map<String, DataTraceFrom> dataTraceKey) {
        if (this.isOpenTrace) {
            String[] members = k.split("&");
            HashMap<String, String> dimNumberNumMap = new HashMap<String, String>(16);
            for (int i = 0; i < allDims.length; ++i) {
                dimNumberNumMap.put(allDims[i], members[i]);
            }
            DataTraceFrom dtf = dataTraceKey.get(k);
            if (dtf != null) {
                this.dtfs.saveCellDataTemp(dimNumberNumMap, dtf, 1);
            }
        }
    }

    private boolean getIsRateIntegration() {
        List<Long> rateOrgIdList = IntegrationUtil.getRateOrgIdList((Long)this._ctx.getModel().p1);
        return rateOrgIdList.contains(this._ctx.getOrg().p1);
    }

    private boolean removeFromMutualAndTriangle(DynamicObject dynamicObject) {
        long fromId = dynamicObject.getLong("fromid");
        String triangle = dynamicObject.getString("triangle");
        if (fromId != 0L || StringUtils.isNotEmpty((String)triangle)) {
            String msg = (String)this._ctx.getCustomParam("checkresult");
            msg = msg == null ? "" : msg;
            StringBuilder sb = new StringBuilder();
            sb.append(msg);
            IDNumberTreeNode srcCurrency = MemberReader.findProcessMemberById((String)((String)this._ctx.getModel().p2), (Long)dynamicObject.getLong("source.id"));
            sb.append(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u96c6\u6210\u539f\u5e01\u4e3a%1$s\uff0c\u76ee\u6807\u5e01\u4e3a%2$s\u7684\u6570\u636e\uff0c\u8be5\u6570\u636e\u7531\u4e92\u7b97\u6216\u4e09\u89d2\u8ba1\u7b97\u5f97\u51fa\u3002", (String)"MiddleLibOutPut_1", (String)"fi-bcm-business", (Object[])new Object[0]), srcCurrency.getNumber(), this._ctx.getCurrency().p2));
            this._ctx.putCustomParam("checkresult", sb.toString());
            return true;
        }
        return false;
    }

    private boolean buildSaveParam(String[] allDims, Map<Long, DynamicObject> exchangeRateMap, String[] key, Object v, List<DynamicObject> resultExchangeRateList) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        for (int i = 0; i < allDims.length; ++i) {
            IDNumberTreeNode member = MemberReader.findMemberByNumber((String)((String)this._ctx.getModel().p2), (String)allDims[i], (String)key[i]);
            param.put(allDims[i], member.getId());
            if (!allDims[i].equals(DimEntityNumEnum.ACCOUNT.getNumber())) continue;
            param.put(allDims[i], member.getNumber());
        }
        param.put(Amount, v);
        param.put(Model, this._ctx.getModel().p1);
        return this.packExchangeRateDyObj(param, exchangeRateMap, resultExchangeRateList);
    }

    private boolean packExchangeRateDyObj(Map<String, Object> param, Map<Long, DynamicObject> exchangeRateMap, List<DynamicObject> resultExchangeRateList) {
        this.getHistoryExchangeRateData(exchangeRateMap, param);
        DynamicObject dynamicObject = exchangeRateMap.get(Long.valueOf(param.get(DimEntityNumEnum.PROCESS.getNumber()).toString()));
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_exchagerate");
            param.put(IS_NEW, "1");
            exchangeRateMap.put(Long.valueOf(param.get(DimEntityNumEnum.PROCESS.getNumber()).toString()), dynamicObject);
        }
        return this.buildExchangeRateObj(dynamicObject, param, resultExchangeRateList);
    }

    private void getHistoryExchangeRateData(Map<Long, DynamicObject> exchangeRateMap, Map<String, Object> param) {
        DynamicObject[] dynamicObjects;
        if (exchangeRateMap.size() != 0) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"bcm_exchagerate", (String)this.getPropertySelector(), (QFilter[])this.getQFilter(param))) {
            exchangeRateMap.put(dynamicObject.getLong("source.id"), dynamicObject);
        }
    }

    private String getPropertySelector() {
        return "source.id,average,periodend,modifytime,fromid,triangle,precision";
    }

    private boolean buildExchangeRateObj(DynamicObject exchangeRateObj, Map<String, Object> param, List<DynamicObject> resultExchangeRateList) {
        if ("1".equals(param.get(IS_NEW))) {
            exchangeRateObj.set("entity", param.get(DimEntityNumEnum.ENTITY.getNumber()));
            exchangeRateObj.set("source", param.get(DimEntityNumEnum.PROCESS.getNumber()));
            exchangeRateObj.set("target", param.get(DimEntityNumEnum.CURRENCY.getNumber()));
            exchangeRateObj.set("model", param.get(Model));
            exchangeRateObj.set("scene", param.get(DimEntityNumEnum.SCENARIO.getNumber()));
            exchangeRateObj.set("fy", param.get(DimEntityNumEnum.YEAR.getNumber()));
            exchangeRateObj.set("period", param.get(DimEntityNumEnum.PERIOD.getNumber()));
        }
        if (this.removeFromMutualAndTriangle(exchangeRateObj)) {
            return false;
        }
        if (param.get(DimEntityNumEnum.ACCOUNT.getNumber()).equals(RateEnum.AverageRate.getValue())) {
            exchangeRateObj.set("average", param.get(Amount));
        } else if (param.get(DimEntityNumEnum.ACCOUNT.getNumber()).equals(RateEnum.ClosingRate.getValue())) {
            exchangeRateObj.set("periodend", param.get(Amount));
        }
        exchangeRateObj.set("modifytime", (Object)TimeServiceHelper.now());
        exchangeRateObj.set("precision", (Object)15);
        if (!resultExchangeRateList.contains(exchangeRateObj)) {
            resultExchangeRateList.add(exchangeRateObj);
        }
        return true;
    }

    private QFilter[] getQFilter(Map<String, Object> param) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("entity", "=", param.get(DimEntityNumEnum.ENTITY.getNumber()));
        qfBuilder.add("target", "=", param.get(DimEntityNumEnum.CURRENCY.getNumber()));
        qfBuilder.add("scene", "=", param.get(DimEntityNumEnum.SCENARIO.getNumber()));
        qfBuilder.add("fy", "=", param.get(DimEntityNumEnum.YEAR.getNumber()));
        qfBuilder.add("period", "=", param.get(DimEntityNumEnum.PERIOD.getNumber()));
        qfBuilder.add("model", "=", param.get(Model));
        return qfBuilder.toArray();
    }

    protected void executeBizRule() {
        Set<Long> templateIds = this._ctx.getAllVersionTemplateIds();
        if (templateIds != null && templateIds.size() > 0) {
            Pair scence = (Pair)this._ctx.getCustomParam("scene");
            BizRuleExecParam p = new BizRuleExecParam((String)this._ctx.getModel().p2);
            p.getCommonParam().addCommonParamPair(PresetConstant.ENTITY_DIM, (Long)this._ctx.getOrg().p1, (String)this._ctx.getOrg().p2);
            p.getCommonParam().addCommonParamPair(PresetConstant.FY_DIM, (Long)this._ctx.getFy().p1, (String)this._ctx.getFy().p2);
            p.getCommonParam().addCommonParamPair(PresetConstant.PERIOD_DIM, (Long)this._ctx.getPeriod().p1, (String)this._ctx.getPeriod().p2);
            p.getCommonParam().addCommonParamPair(PresetConstant.CURRENCY_DIM, (Long)this._ctx.getCurrency().p1, (String)this._ctx.getCurrency().p2);
            p.getCommonParam().addCommonParamPair(PresetConstant.SCENE_DIM, (Long)scence.p1, (String)scence.p2);
            p.getCommonParam().addCommonParamPair(PresetConstant.PROCESS_DIM, MemberReader.findMemberByNumber((String)((String)this._ctx.getModel().p2), (String)PresetConstant.PROCESS_DIM, (String)"IRpt").getId(), "IRpt");
            BizRuleExecStarter.execBizRule(BizRuleExecStarter.getRuleByTmp(new ArrayList<Long>(templateIds)), p, true, false);
        }
    }

    private Map<String, Object> generateOlapData(String[] allDims, Map<String, DimMappedRelation.DimAndDefValRela> tarNumbDefaultValueMap, Map<MappedRow, ValueList> resultSet, Map<String, Integer> dimLocation, Map<String, DataTraceFrom> dataTraceKey) {
        ArrayListMultimap finalResult = ArrayListMultimap.create();
        int currencyIndex = this.getCurrencyIndex(allDims);
        resultSet.forEach((k, v) -> {
            String[] result = new String[allDims.length];
            this.commonHandleData(allDims, (MappedRow)k, result);
            Map<List<String>, List<Object>> tempMap = this.backHandleData((MappedRow)k, (ValueList)v, result, dimLocation, currencyIndex);
            this.handleMyCompany((MappedRow)k, tempMap, dimLocation);
            int indexDim = IntegrationUtil.getIndexDim(allDims, "Scenario");
            this.defaultHandleData(tarNumbDefaultValueMap, (ArrayListMultimap<String, Object>)finalResult, tempMap, indexDim);
        });
        HashMap<String, Object> _finalResult = new HashMap<String, Object>(16);
        Map<String, DataTypeEnum> typeEnumMap = this.getDataTypeEnumMap(finalResult.keySet(), allDims, (Long)this._ctx.getModel().p1);
        finalResult.forEach((k, v) -> {
            DataTypeEnum type = (DataTypeEnum)typeEnumMap.get(k);
            DataTraceFrom dtf = new DataTraceFrom();
            ArrayList<DataTraceFromItem> df = new ArrayList<DataTraceFromItem>(8);
            if (DataTypeEnum.CURRENCY == type || DataTypeEnum.DEFAULT == type || DataTypeEnum.UNCURRENCY == type || DataTypeEnum.PROPORTION == type) {
                ArrayList bList = new ArrayList(10);
                if (this.isOpenTrace) {
                    ((Iterable)v).forEach(value -> bList.add((BigDecimal)((Pair)((Pair)value).p1).p1));
                    this.setDataTraceFromItem(v, df, true);
                } else {
                    ((Iterable)v).forEach(value -> bList.add((BigDecimal)((Pair)value).p1));
                }
                if (bList.size() != 0) {
                    BigDecimal vBig = BigDecimal.ZERO;
                    if (_finalResult.get(k) != null) {
                        if (dataTraceKey.get(k) != null) {
                            df.addAll(((DataTraceFrom)dataTraceKey.get(k)).getDf());
                        }
                        vBig = (BigDecimal)_finalResult.get(k);
                    }
                    _finalResult.put((String)k, bList.stream().reduce(vBig, BigDecimal::add));
                }
            } else {
                Recorder recorder = new Recorder((Object)"");
                if (this.isOpenTrace) {
                    ((Iterable)v).forEach(value -> {
                        if (ObjectUtils.isNotEmpty((Object)((Pair)((Pair)value).p1).p2)) {
                            recorder.setRecord((Object)((String)((Pair)((Pair)value).p1).p2));
                        }
                    });
                    this.setDataTraceFromItem(v, df, false);
                } else {
                    ((Iterable)v).forEach(value -> {
                        if (ObjectUtils.isNotEmpty((Object)((Pair)value).p2)) {
                            recorder.setRecord((Object)((String)((Pair)value).p2));
                        }
                    });
                }
                if (StringUtils.isNotEmpty((String)((String)recorder.getRecord()))) {
                    _finalResult.put((String)k, recorder.getRecord());
                }
            }
            if (this.isOpenTrace) {
                dtf.setM(_finalResult.get(k).toString());
                dtf.setD("MiddleLib");
                dtf.setDf(df);
                dataTraceKey.put((String)k, dtf);
            }
        });
        return _finalResult;
    }

    private int getCurrencyIndex(String[] allDims) {
        this.multiCurrency = (Boolean)this._ctx.getCustomParam("openMultiCurrency");
        if (this.multiCurrency) {
            for (int i = 0; i < allDims.length; ++i) {
                if (!"Currency".equals(allDims[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private void setDataTraceFromItem(Object v, List<DataTraceFromItem> df, Boolean flag) {
        ((Iterable)v).forEach(value -> {
            if (((Pair)value).p2 != null && ((Pair)value).p2 instanceof ArrayList) {
                DataTraceFromItem newdtfi = new DataTraceFromItem();
                DataTraceFromItem dtfi = (DataTraceFromItem)((ArrayList)((Pair)value).p2).get(0);
                Pair pair = (Pair)ObjectSerialUtil.deSerializedBytes((String)dtfi.getV());
                if (flag.booleanValue()) {
                    newdtfi.setV(pair.p1.toString());
                } else {
                    newdtfi.setV(pair.p2.toString());
                }
                newdtfi.setOprt(dtfi.getOprt());
                newdtfi.setD(dtfi.getD());
                df.add(newdtfi);
            }
        });
    }

    private Map<String, DataTypeEnum> getDataTypeEnumMap(Set<String> membersStr, String[] allDims, long modelId) {
        HashMap<String, DataTypeEnum> typeMap = new HashMap<String, DataTypeEnum>(membersStr.size());
        HashMap cachemap = new HashMap(16);
        membersStr.forEach(s -> {
            Map<String, String> dim2Members = this.getDim2MembersMap((String)s, allDims);
            typeMap.put((String)s, DataTypeUtil.getDataTypeThreadCache(modelId, dim2Members, cachemap));
        });
        return typeMap;
    }

    private Map<String, String> getDim2MembersMap(String memberStr, String[] allDims) {
        HashMap<String, String> dim2Members = new HashMap<String, String>(allDims.length);
        String[] members = memberStr.split("&");
        for (int i = 0; i < allDims.length; ++i) {
            dim2Members.put(allDims[i], members[i]);
        }
        return dim2Members;
    }

    private Map<String[], Object> handleMyCompany(MappedRow k, Map<List<String>, List<Object>> tempMap, Map<String, Integer> dimLocation) {
        MappedTargetItem mappedTargetItem = k.getTargMapped().get("MyCompany");
        HashMap<String[], Object> result = new HashMap<String[], Object>(tempMap.size());
        if (mappedTargetItem != null && "MyCompany".equals(mappedTargetItem.getNumber())) {
            tempMap.forEach((tk, tv) -> tk.set((Integer)dimLocation.get("MyCompany"), this._ctx.getOrg().p2));
        }
        return result;
    }

    private void defaultHandleData(Map<String, DimMappedRelation.DimAndDefValRela> tarNumbDefaultValueMap, ArrayListMultimap<String, Object> finalResult, Map<List<String>, List<Object>> tempMap, int indexDim) {
        tempMap.forEach((tk, tv) -> {
            Map defaultNumber = (Map)this._ctx.getCustomParam(default_number);
            ArrayList<List> lResult = new ArrayList<List>(10);
            lResult.add((List)tk);
            defaultNumber.forEach((dk, dv) -> {
                DimMappedRelation.DimAndDefValRela dimAndDefValRela = (DimMappedRelation.DimAndDefValRela)tarNumbDefaultValueMap.get(dv);
                if (dimAndDefValRela == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f3a\u7701\u503c\u4e0d\u5b58\u5728\uff1a %s\u3002", (String)"MiddleLibOutPut_4", (String)"fi-bcm-business", (Object[])new Object[0]), dv));
                }
                ArrayList<List<String>> temp = new ArrayList<List<String>>(10);
                List<MappedDefaultVal> defVals = dimAndDefValRela.getDefVals();
                if ((defVals = IntegrationUtil.getDefValue(defVals, dv, IS_SINGLGESCENE, this._ctx)).size() == 1) {
                    for (List tr : lResult) {
                        tr.set((int)dk, defVals.get(0).getNumber());
                    }
                    return;
                }
                for (MappedDefaultVal defVal : defVals) {
                    for (List tr : lResult) {
                        List<String> copyOf = Arrays.asList(tr.toArray(new String[0]));
                        copyOf.set((int)dk, defVal.getNumber());
                        temp.add(copyOf);
                    }
                }
                lResult.clear();
                lResult.addAll(temp);
            });
            lResult.forEach(lv -> {
                if (!IS_SINGLGESCENE || this._ctx.getScene() == null || ((String)this._ctx.getScene().p2).equals(lv.get(indexDim))) {
                    finalResult.put((Object)String.join((CharSequence)"&", lv), tv);
                }
            });
        });
    }

    private Map<List<String>, List<Object>> backHandleData(MappedRow k, ValueList v, String[] result, Map<String, Integer> dimLocation, int currencyIndex) {
        HashMap<List<String>, List<Object>> tempMap = new HashMap<List<String>, List<Object>>(16);
        v.getValueList().forEach(vItem -> {
            List<String> copyOf = Arrays.asList(result);
            this.setRightCur(copyOf, currencyIndex, (IValueItem)vItem);
            boolean[] flag = new boolean[]{true};
            k.srcMappediterator().forEachRemaining(srcDimEntry -> {
                MappedSourceItem srcDimItemp = (MappedSourceItem)srcDimEntry.getValue();
                if (flag[0] && srcDimItemp.isFollowValue()) {
                    DimMappedRelation.SingleDimRelationPair singleDimRelationPair = k.getDimRelationBySrcDim(srcDimItemp.getMappedDim());
                    String dimNumber = singleDimRelationPair.getTargetDimItem().getDimItem().getNumber();
                    String backNumber = this.getTargMembNumbBySourceItem(singleDimRelationPair.getDimMappedId(), vItem.getMembByMappedDimItem(srcDimItemp.getMappedDim()));
                    if (backNumber == null) {
                        flag[0] = false;
                    } else {
                        Map numberParentMapping;
                        MappedTargetItem mappedTargetItem = k.getTargMapped().get(dimNumber);
                        if (mappedTargetItem != null && ("ICEntity".equals(mappedTargetItem.getNumber()) || "ICOEntity".equals(mappedTargetItem.getNumber())) && (numberParentMapping = (Map)this._ctx.getCustomParam(InterCompany)) != null) {
                            flag[0] = ((String)numberParentMapping.get(backNumber)).equals(mappedTargetItem.getNumber());
                        }
                        copyOf.set((Integer)dimLocation.get(dimNumber), backNumber);
                    }
                }
            });
            k.targMappediterator().forEachRemaining(e -> {
                MappedTargetItem tarDimItemp = (MappedTargetItem)e.getValue();
                String dimNumber = tarDimItemp.getMappedDim().getNumber();
                if (vItem.getProperty(dimNumber) != null) {
                    copyOf.set((Integer)dimLocation.get(dimNumber), (String)vItem.getProperty(dimNumber));
                }
            });
            ArrayList newList = new ArrayList(10);
            CollectionUtils.addAll(newList, (Object[])new Object[copyOf.size()]);
            Collections.copy(newList, copyOf);
            if (flag[0]) {
                List value = tempMap.getOrDefault(newList, new ArrayList(3));
                if (this.isOpenTrace) {
                    value.add(Pair.onePair(vItem.getValue(), vItem.getDataTraceFrom().getDf()));
                } else {
                    value.add(vItem.getValue());
                }
                tempMap.put(newList, value);
            }
        });
        return tempMap;
    }

    private void setRightCur(List<String> copyOf, int currencyIndex, IValueItem vItem) {
        DataTraceFrom dataTraceFrom;
        List<DataTraceFromItem> df;
        if (currencyIndex > -1 && (df = (dataTraceFrom = vItem.getDataTraceFrom()).getDf()) != null && df.size() > 0) {
            String d = df.get(0).getD();
            String[] split = d.split(",");
            if (split.length > 5 && "OC".equals(split[5])) {
                copyOf.set(currencyIndex, "OC");
            } else if (split.length > 5 && !"OC".equals(split[5])) {
                copyOf.set(currencyIndex, (String)this._ctx.getCurrency().p2);
            }
        }
    }

    private void commonHandleData(String[] allDims, MappedRow k, String[] result) {
        Map<String, MappedTargetItem> targMapped = k.getTargMapped();
        for (int i = 0; i < allDims.length; ++i) {
            String dim = allDims[i];
            if (SysDimensionEnum.Entity.getNumber().equals(dim)) {
                result[i] = (String)this._ctx.getOrg().p2;
                continue;
            }
            if (SysDimensionEnum.Currency.getNumber().equals(dim)) {
                result[i] = (String)this._ctx.getCurrency().p2;
                continue;
            }
            if (SysDimensionEnum.Period.getNumber().equals(dim)) {
                result[i] = (String)this._ctx.getPeriod().p2;
                continue;
            }
            if (SysDimensionEnum.Year.getNumber().equals(dim)) {
                result[i] = (String)this._ctx.getFy().p2;
                continue;
            }
            MappedTargetItem mappedTargetItem = targMapped.get(dim);
            if (mappedTargetItem == null) continue;
            result[i] = mappedTargetItem.getNumber();
        }
    }

    private void preHandle(Map<MappedRow, ValueList> resultSet, String[] allDims) {
        ArrayListMultimap targetDim = ArrayListMultimap.create();
        HashMap defaultNumber = new HashMap(16);
        HashBasedTable interCompany = HashBasedTable.create();
        resultSet.forEach((arg_0, arg_1) -> this.lambda$preHandle$22(targetDim, (Table)interCompany, defaultNumber, allDims, arg_0, arg_1));
        Collection companys = interCompany.values();
        if (companys != null && companys.size() > 0) {
            DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.business.integrationnew.output.OlapOutput.preHandle(Map<MappedRow, ValueList>, String[])", (String)SysDimensionEnum.InternalCompany.getMemberTreefrom(), (String)"id, number, parent.number", (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{this._ctx.getModel().p1}).and(new QFilter("number", "in", (Object)companys)).toArray(), null);
            HashMap numberParentMapping = new HashMap(16);
            queryDataSet.forEach(row -> numberParentMapping.put(row.getString("number"), row.getString("parent.number")));
            this._ctx.putCustomParam(InterCompany, numberParentMapping);
        }
        this._ctx.putCustomParam(default_number, defaultNumber);
    }

    private String[] getAllDims() {
        String[] allDims = (String[])this._ctx.getCustomParam(all_dims);
        if (allDims == null) {
            QFilter modelFilter = new QFilter("model", "=", this._ctx.getModel().p1);
            DynamicObjectCollection userDefines = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, name, fieldmapped", (QFilter[])modelFilter.toArray());
            Map<String, Long> temp = userDefines.stream().collect(Collectors.toMap(v -> v.getString("number"), v -> v.getLong("id")));
            allDims = temp.keySet().toArray(new String[0]);
            this._ctx.putCustomParam(all_dims, allDims);
            this._ctx.putCustomParam(all_dims_idnumber, temp);
        }
        return allDims;
    }

    private /* synthetic */ void lambda$preHandle$22(ArrayListMultimap targetDim, Table interCompany, Map defaultNumber, String[] allDims, MappedRow k, ValueList v) {
        Map<String, MappedTargetItem> targMapped = k.getTargMapped();
        v.getValueList().forEach(vl -> {
            k.srcMappediterator().forEachRemaining(ks -> {
                MappedDimItem mappedDimTemp = ((MappedSourceItem)ks.getValue()).getMappedDim();
                String membByMappedDimItem = vl.getMembByMappedDimItem(mappedDimTemp);
                if (((MappedSourceItem)ks.getValue()).isFollowValue()) {
                    String backNumber;
                    MappedTargetItem mappedTargetItem;
                    String targetNumber;
                    targetDim.put((Object)mappedDimTemp, (Object)membByMappedDimItem);
                    DimMappedRelation.SingleDimRelationPair singleDimRelationPair = k.getDimRelationBySrcDim(mappedDimTemp);
                    DimMappedRelation.DimAndDefValRela targetDimItem = singleDimRelationPair.getTargetDimItem();
                    String dimNumber = targetDimItem.getDimItem().getNumber();
                    if ("InternalCompany".equals(dimNumber) && ("ICEntity".equals(targetNumber = (mappedTargetItem = (MappedTargetItem)targMapped.get(dimNumber)).getNumber()) || "ICOEntity".equals(targetNumber)) && (backNumber = this.getTargMembNumbBySourceItem(singleDimRelationPair.getDimMappedId(), membByMappedDimItem)) != null) {
                        interCompany.put((Object)targetNumber, (Object)membByMappedDimItem, (Object)backNumber);
                    }
                }
            });
            if (defaultNumber.size() <= 0) {
                for (int i = 0; i < allDims.length; ++i) {
                    String defaultDim;
                    boolean isContains;
                    String dim = allDims[i];
                    boolean bl = isContains = SysDimensionEnum.Entity.getNumber().equals(dim) || SysDimensionEnum.Currency.getNumber().equals(dim) || SysDimensionEnum.Period.getNumber().equals(dim) || SysDimensionEnum.Year.getNumber().equals(dim) || targMapped.get(dim) != null || targetDim.keySet().stream().anyMatch(targDim -> dim.equalsIgnoreCase(targDim.getNumber()));
                    if (isContains || (defaultDim = (String)defaultNumber.get(i)) != null) continue;
                    defaultNumber.put(i, dim);
                }
            }
        });
    }
}

